/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class GridCircularBuffer<T> {
    private final long sizeMask;
    private final Item<T>[] arr;
    private final AtomicLong idxGen = new AtomicLong();

    public GridCircularBuffer(int size) {
        A.ensure(size > 0, "Size should be greater than 0: " + size);
        A.ensure((size & size - 1) == 0, "Size should be power of two: " + size);
        this.sizeMask = size - 1;
        this.arr = new Item[size];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = new Item();
        }
    }

    public Collection<T> items() {
        Item<T> t2;
        T item;
        ArrayList<T> res = new ArrayList<T>(this.arr.length);
        Item<T>[] itemArray = this.arr;
        int n = itemArray.length;
        for (int i = 0; i < n && (item = (t2 = itemArray[i]).item()) != null; ++i) {
            res.add(item);
        }
        return res;
    }

    public void forEach(IgniteInClosure<T> c) {
        Item<T> t2;
        T item;
        Item<T>[] itemArray = this.arr;
        int n = itemArray.length;
        for (int i = 0; i < n && (item = (t2 = itemArray[i]).item()) != null; ++i) {
            c.apply(item);
        }
    }

    public T2<T, Long> get(long idx) {
        int idx0 = (int)(idx & this.sizeMask);
        return this.arr[idx0].get();
    }

    @Nullable
    public T add(T t2) throws InterruptedException {
        long idx = this.idxGen.getAndIncrement();
        int idx0 = (int)(idx & this.sizeMask);
        return this.arr[idx0].update(idx, t2, this.arr.length);
    }

    @Nullable
    public T add(T t2, @Nullable IgniteInClosureX<T> c) throws InterruptedException, IgniteCheckedException {
        long idx = this.idxGen.getAndIncrement();
        int idx0 = (int)(idx & this.sizeMask);
        return this.arr[idx0].update(idx, t2, this.arr.length, c);
    }

    public String toString() {
        return S.toString(GridCircularBuffer.class, this);
    }

    private static class Item<V> {
        private long idx;
        @GridToStringInclude
        private V item;

        Item() {
        }

        synchronized V item() {
            return this.item;
        }

        @Nullable
        synchronized V update(long newIdx, V newItem, long maxIdxDiff) throws InterruptedException {
            assert (newIdx >= 0L);
            while (newIdx - this.idx > maxIdxDiff) {
                this.wait();
            }
            V old = this.item;
            this.idx = newIdx;
            this.item = newItem;
            this.notifyAll();
            return old;
        }

        @Nullable
        synchronized V update(long newIdx, V newItem, long maxIdxDiff, @Nullable IgniteInClosureX<V> c) throws InterruptedException, IgniteCheckedException {
            assert (newIdx >= 0L);
            while (newIdx - this.idx > maxIdxDiff) {
                this.wait();
            }
            this.idx = newIdx;
            if (c != null && this.item != null) {
                c.applyx(this.item);
            }
            V old = this.item;
            this.item = newItem;
            this.notifyAll();
            return old;
        }

        synchronized T2<V, Long> get() {
            return new T2<V, Long>(this.item, this.idx);
        }

        public synchronized String toString() {
            return S.toString(Item.class, this, "hash=" + System.identityHashCode(this));
        }
    }
}

