/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.optimizer.affinity;

import java.math.BigDecimal;
import java.util.UUID;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionParameterType;
import org.jetbrains.annotations.NotNull;

public class PartitionDataTypeUtils {
    private static final BigDecimal MAX_LONG_DECIMAL = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG_DECIMAL = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal MAX_INTEGER_DECIMAL = new BigDecimal(Integer.MAX_VALUE);
    private static final BigDecimal MIN_INTEGER_DECIMAL = new BigDecimal(Integer.MIN_VALUE);
    private static final BigDecimal MAX_SHORT_DECIMAL = new BigDecimal(Short.MAX_VALUE);
    private static final BigDecimal MIN_SHORT_DECIMAL = new BigDecimal(Short.MIN_VALUE);
    private static final BigDecimal MAX_BYTE_DECIMAL = new BigDecimal(127);
    private static final BigDecimal MIN_BYTE_DECIMAL = new BigDecimal(-128);
    public static final Object CONVERTATION_FAILURE = new Object();

    public static Object convert(Object arg, PartitionParameterType targetType) {
        assert (targetType != null);
        if (arg == null) {
            return null;
        }
        PartitionParameterType argType = PartitionDataTypeUtils.typeFromClass(arg.getClass());
        if (argType == null) {
            return CONVERTATION_FAILURE;
        }
        if (argType == targetType) {
            return arg;
        }
        try {
            switch (targetType) {
                case BOOLEAN: {
                    return PartitionDataTypeUtils.getBoolean(arg, argType);
                }
                case BYTE: {
                    return PartitionDataTypeUtils.getIntegerNumeric(arg, argType, -128L, 127L, MIN_BYTE_DECIMAL, MAX_BYTE_DECIMAL, PartitionParameterType.BYTE);
                }
                case SHORT: {
                    return PartitionDataTypeUtils.getIntegerNumeric(arg, argType, -32768L, 32767L, MIN_SHORT_DECIMAL, MAX_SHORT_DECIMAL, PartitionParameterType.SHORT);
                }
                case INT: {
                    return PartitionDataTypeUtils.getIntegerNumeric(arg, argType, Integer.MIN_VALUE, Integer.MAX_VALUE, MIN_INTEGER_DECIMAL, MAX_INTEGER_DECIMAL, PartitionParameterType.INT);
                }
                case LONG: {
                    return PartitionDataTypeUtils.getIntegerNumeric(arg, argType, Long.MIN_VALUE, Long.MAX_VALUE, MIN_LONG_DECIMAL, MAX_LONG_DECIMAL, PartitionParameterType.LONG);
                }
                case FLOAT: {
                    return PartitionDataTypeUtils.getFloat(arg, argType);
                }
                case DOUBLE: {
                    return PartitionDataTypeUtils.getDouble(arg, argType);
                }
                case DECIMAL: {
                    return PartitionDataTypeUtils.getDecimal(arg, argType);
                }
                case STRING: {
                    return PartitionDataTypeUtils.getString(arg, argType);
                }
                case UUID: {
                    return PartitionDataTypeUtils.getUUID(arg, argType);
                }
            }
            return CONVERTATION_FAILURE;
        }
        catch (NumberFormatException e) {
            return CONVERTATION_FAILURE;
        }
    }

    @NotNull
    private static Object getUUID(Object arg, PartitionParameterType argType) {
        switch (argType) {
            case STRING: {
                return PartitionDataTypeUtils.stringToUUID((String)arg);
            }
        }
        return CONVERTATION_FAILURE;
    }

    private static Object getString(Object arg, PartitionParameterType argType) {
        switch (argType) {
            case BOOLEAN: {
                return (Boolean)arg != false ? "TRUE" : "FALSE";
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return String.valueOf(arg);
            }
            case DECIMAL: {
                String p = ((BigDecimal)arg).toPlainString();
                return p.length() < 40 ? p : arg.toString();
            }
            case UUID: {
                return arg.toString();
            }
        }
        return CONVERTATION_FAILURE;
    }

    @NotNull
    private static Object getFloat(Object arg, PartitionParameterType argType) {
        switch (argType) {
            case BOOLEAN: {
                return Float.valueOf(arg.equals(Boolean.TRUE) ? 1.0f : 0.0f);
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DOUBLE: 
            case DECIMAL: {
                return Float.valueOf(((Number)arg).floatValue());
            }
            case STRING: {
                return Float.valueOf(Float.parseFloat(((String)arg).trim()));
            }
        }
        return CONVERTATION_FAILURE;
    }

    @NotNull
    private static Object getDouble(Object arg, PartitionParameterType argType) {
        switch (argType) {
            case BOOLEAN: {
                return arg.equals(Boolean.TRUE) ? 1.0 : 0.0;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DECIMAL: {
                return ((Number)arg).doubleValue();
            }
            case STRING: {
                return Double.parseDouble(((String)arg).trim());
            }
        }
        return CONVERTATION_FAILURE;
    }

    @NotNull
    private static Object getDecimal(Object arg, PartitionParameterType argType) {
        switch (argType) {
            case BOOLEAN: {
                return arg.equals(Boolean.TRUE) ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return BigDecimal.valueOf(((Number)arg).longValue());
            }
            case DOUBLE: {
                double d = (Double)arg;
                if (Double.isInfinite(d) || Double.isNaN(d)) {
                    return CONVERTATION_FAILURE;
                }
                return BigDecimal.valueOf(d);
            }
            case FLOAT: {
                float f = ((Float)arg).floatValue();
                if (Float.isInfinite(f) || Float.isNaN(f)) {
                    return CONVERTATION_FAILURE;
                }
                return new BigDecimal(Float.toString(f));
            }
            case STRING: {
                return new BigDecimal(((String)arg).trim());
            }
        }
        return CONVERTATION_FAILURE;
    }

    @NotNull
    private static Object getIntegerNumeric(Object arg, PartitionParameterType argType, long minVal, long maxVal, BigDecimal minValDecimal, BigDecimal maxValDecimal, PartitionParameterType targetType) {
        long res;
        assert (targetType == PartitionParameterType.BYTE || targetType == PartitionParameterType.SHORT || targetType == PartitionParameterType.INT || targetType == PartitionParameterType.LONG);
        switch (argType) {
            case BOOLEAN: {
                res = arg.equals(Boolean.TRUE) ? 1L : 0L;
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                res = ((Number)arg).longValue();
                if (res <= maxVal && res >= minVal) break;
                return CONVERTATION_FAILURE;
            }
            case DECIMAL: {
                BigDecimal d = (BigDecimal)arg;
                if (d.compareTo(maxValDecimal) > 0 || d.compareTo(minValDecimal) < 0) {
                    return CONVERTATION_FAILURE;
                }
                res = d.setScale(0, 4).longValue();
                break;
            }
            case DOUBLE: {
                Double d = (Double)arg;
                if (d > (double)maxVal || d < (double)minVal) {
                    return CONVERTATION_FAILURE;
                }
                res = Math.round(d);
                break;
            }
            case FLOAT: {
                Float f = (Float)arg;
                if (f.floatValue() > (float)maxVal || f.floatValue() < (float)minVal) {
                    return CONVERTATION_FAILURE;
                }
                res = Math.round(f.floatValue());
                break;
            }
            case STRING: {
                res = Long.parseLong(((String)arg).trim());
                if (res <= maxVal && res >= minVal) break;
                return CONVERTATION_FAILURE;
            }
            default: {
                return CONVERTATION_FAILURE;
            }
        }
        switch (targetType) {
            case BYTE: {
                return (byte)res;
            }
            case SHORT: {
                return (short)res;
            }
            case INT: {
                return (int)res;
            }
            case LONG: {
                return res;
            }
        }
        return CONVERTATION_FAILURE;
    }

    @NotNull
    private static Object getBoolean(Object arg, PartitionParameterType argType) {
        switch (argType) {
            case BYTE: {
                return (Byte)arg != 0;
            }
            case SHORT: {
                return (Short)arg != 0;
            }
            case INT: {
                return (Integer)arg != 0;
            }
            case LONG: {
                return (Long)arg != 0L;
            }
            case DECIMAL: {
                return !arg.equals(BigDecimal.ZERO);
            }
            case DOUBLE: {
                return Math.signum((Double)arg) != 0.0;
            }
            case FLOAT: {
                return Math.signum(((Float)arg).floatValue()) != 0.0f;
            }
            case STRING: {
                String sVal = (String)arg;
                if ("true".equalsIgnoreCase(sVal) || "t".equalsIgnoreCase(sVal) || "yes".equalsIgnoreCase(sVal) || "y".equalsIgnoreCase(sVal) || "1".equals(sVal)) {
                    return Boolean.TRUE;
                }
                if (!"false".equalsIgnoreCase(sVal) && !"f".equalsIgnoreCase(sVal) && !"no".equalsIgnoreCase(sVal) && !"n".equalsIgnoreCase(sVal) && !"0".equals(sVal)) break;
                return Boolean.FALSE;
            }
        }
        return CONVERTATION_FAILURE;
    }

    private static PartitionParameterType typeFromClass(Class<?> c) {
        assert (c != null);
        if (String.class == c) {
            return PartitionParameterType.STRING;
        }
        if (Integer.class == c) {
            return PartitionParameterType.INT;
        }
        if (Long.class == c) {
            return PartitionParameterType.LONG;
        }
        if (Boolean.class == c) {
            return PartitionParameterType.BOOLEAN;
        }
        if (Double.class == c) {
            return PartitionParameterType.DOUBLE;
        }
        if (Byte.class == c) {
            return PartitionParameterType.BYTE;
        }
        if (Short.class == c) {
            return PartitionParameterType.SHORT;
        }
        if (Float.class == c) {
            return PartitionParameterType.FLOAT;
        }
        if (UUID.class == c) {
            return PartitionParameterType.UUID;
        }
        if (BigDecimal.class == c) {
            return PartitionParameterType.DECIMAL;
        }
        return null;
    }

    public static Object stringToUUID(String s2) {
        long low = 0L;
        long high = 0L;
        int j = 0;
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            char c = s2.charAt(i);
            if (c >= '0' && c <= '9') {
                low = low << 4 | (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                low = low << 4 | (long)(c - 97 + 10);
            } else {
                if (c == '-') continue;
                if (c >= 'A' && c <= 'F') {
                    low = low << 4 | (long)(c - 65 + 10);
                } else {
                    if (c <= ' ') continue;
                    return CONVERTATION_FAILURE;
                }
            }
            if (j++ != 15) continue;
            high = low;
            low = 0L;
        }
        return new UUID(high, low);
    }

    private PartitionDataTypeUtils() {
    }
}

