/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema.management;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.managers.systemview.walker.SqlIndexViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SqlSchemaViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SqlTableColumnViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SqlTableViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SqlViewColumnViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.SqlViewViewWalker;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.query.ColumnInformation;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.QuerySysIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.TableInformation;
import org.apache.ignite.internal.processors.query.schema.AbstractSchemaChangeListener;
import org.apache.ignite.internal.processors.query.schema.SchemaChangeListener;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptor;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptorFactory;
import org.apache.ignite.internal.processors.query.schema.management.SchemaDescriptor;
import org.apache.ignite.internal.processors.query.schema.management.SortedIndexDescriptorFactory;
import org.apache.ignite.internal.processors.query.schema.management.TableDescriptor;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.sql.SqlIndexView;
import org.apache.ignite.spi.systemview.view.sql.SqlSchemaView;
import org.apache.ignite.spi.systemview.view.sql.SqlTableColumnView;
import org.apache.ignite.spi.systemview.view.sql.SqlTableView;
import org.apache.ignite.spi.systemview.view.sql.SqlViewColumnView;
import org.apache.ignite.spi.systemview.view.sql.SqlViewView;
import org.jetbrains.annotations.Nullable;

public class SchemaManager {
    public static final String SQL_SCHEMA_VIEW = "schemas";
    public static final String SQL_SCHEMA_VIEW_DESC = "SQL schemas";
    public static final String SQL_TBLS_VIEW = "tables";
    public static final String SQL_TBLS_VIEW_DESC = "SQL tables";
    public static final String SQL_VIEWS_VIEW = "views";
    public static final String SQL_VIEWS_VIEW_DESC = "SQL views";
    public static final String SQL_IDXS_VIEW = "indexes";
    public static final String SQL_IDXS_VIEW_DESC = "SQL indexes";
    public static final String SQL_TBL_COLS_VIEW = MetricUtils.metricName("table", "columns");
    public static final String SQL_TBL_COLS_VIEW_DESC = "SQL table columns";
    public static final String SQL_VIEW_COLS_VIEW = MetricUtils.metricName("view", "columns");
    public static final String SQL_VIEW_COLS_VIEW_DESC = "SQL view columns";
    private static final Map<QueryIndexType, IndexDescriptorFactory> IDX_DESC_FACTORY = new EnumMap<QueryIndexType, IndexDescriptorFactory>(QueryIndexType.class);
    private final Map<QueryIndexType, IndexDescriptorFactory> idxDescFactory = new EnumMap<QueryIndexType, IndexDescriptorFactory>(QueryIndexType.class);
    private volatile SchemaChangeListener lsnr;
    private final ConcurrentMap<String, SchemaDescriptor> schemas = new ConcurrentHashMap<String, SchemaDescriptor>();
    private final Map<String, String> cacheName2schema = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<T2<String, String>, TableDescriptor> id2tbl = new ConcurrentHashMap<T2<String, String>, TableDescriptor>();
    private final Set<SystemView<?>> sysViews = new GridConcurrentHashSet();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final GridKernalContext ctx;
    private final IgniteLogger log;

    public SchemaManager(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(SchemaManager.class);
    }

    public static void registerIndexDescriptorFactory(QueryIndexType type, IndexDescriptorFactory factory) {
        IDX_DESC_FACTORY.put(type, factory);
    }

    public static void unregisterIndexDescriptorFactory(QueryIndexType type) {
        IDX_DESC_FACTORY.remove((Object)type);
    }

    public void start(String[] schemaNames) throws IgniteCheckedException {
        this.lsnr = this.schemaChangeListener(this.ctx);
        this.idxDescFactory.putAll(IDX_DESC_FACTORY);
        if (!this.idxDescFactory.containsKey((Object)QueryIndexType.SORTED)) {
            this.idxDescFactory.put(QueryIndexType.SORTED, new SortedIndexDescriptorFactory(this.log));
        }
        this.ctx.systemView().registerView(SQL_SCHEMA_VIEW, SQL_SCHEMA_VIEW_DESC, new SqlSchemaViewWalker(), this.schemas.values(), SqlSchemaView::new);
        this.ctx.systemView().registerView(SQL_TBLS_VIEW, SQL_TBLS_VIEW_DESC, new SqlTableViewWalker(), this.id2tbl.values(), SqlTableView::new);
        this.ctx.systemView().registerView(SQL_VIEWS_VIEW, SQL_VIEWS_VIEW_DESC, new SqlViewViewWalker(), this.sysViews, SqlViewView::new);
        this.ctx.systemView().registerInnerCollectionView(SQL_IDXS_VIEW, SQL_IDXS_VIEW_DESC, new SqlIndexViewWalker(), this.id2tbl.values(), t2 -> t2.indexes().values(), SqlIndexView::new);
        this.ctx.systemView().registerInnerCollectionView(SQL_TBL_COLS_VIEW, SQL_TBL_COLS_VIEW_DESC, new SqlTableColumnViewWalker(), this.id2tbl.values(), this::tableColumns, SqlTableColumnView::new);
        this.ctx.systemView().registerInnerCollectionView(SQL_VIEW_COLS_VIEW, SQL_VIEW_COLS_VIEW_DESC, new SqlViewColumnViewWalker(), this.sysViews, v -> MetricUtils.systemViewAttributes(v).entrySet(), SqlViewColumnView::new);
        this.lock.writeLock().lock();
        try {
            this.createSchema("PUBLIC", true);
            this.createPredefinedSchemas(schemaNames);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private Collection<GridQueryProperty> tableColumns(TableDescriptor tblDesc) {
        GridQueryTypeDescriptor typeDesc = tblDesc.type();
        Collection<GridQueryProperty> props = typeDesc.properties().values();
        if (!tblDesc.type().properties().containsKey("_KEY")) {
            props = F.concat(false, new QueryUtils.KeyOrValProperty(true, "_KEY", typeDesc.keyClass()), props);
        }
        if (!tblDesc.type().properties().containsKey("_VAL")) {
            props = F.concat(false, new QueryUtils.KeyOrValProperty(false, "_VAL", typeDesc.valueClass()), props);
        }
        return props;
    }

    public void stop() {
        this.schemas.clear();
        this.cacheName2schema.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSystemView(String schema, SystemView<?> view) {
        boolean disabled = IgniteSystemProperties.getBoolean("IGNITE_SQL_DISABLE_SYSTEM_VIEWS");
        if (disabled) {
            if (this.log.isInfoEnabled()) {
                this.log.info("SQL system views will not be created because they are disabled (see IGNITE_SQL_DISABLE_SYSTEM_VIEWS system property)");
            }
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.createSchema(schema, true);
            this.sysViews.add(view);
            this.lsnr.onSystemViewCreated(schema, view);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void createPredefinedSchemas(String[] schemaNames) {
        assert (this.lock.isWriteLockedByCurrentThread());
        if (F.isEmpty(schemaNames)) {
            return;
        }
        LinkedHashSet<String> schemaNames0 = new LinkedHashSet<String>();
        for (String schemaName : schemaNames) {
            if (F.isEmpty(schemaName)) continue;
            schemaName = QueryUtils.normalizeSchemaName(null, schemaName);
            schemaNames0.add(schemaName);
        }
        for (String schemaName : schemaNames0) {
            this.createSchema(schemaName, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheCreated(String cacheName, String schemaName, Class<?>[] sqlFuncs) throws IgniteCheckedException {
        this.lock.writeLock().lock();
        try {
            this.createSchema(schemaName, false);
            this.cacheName2schema.put(cacheName, schemaName);
            this.createSqlFunctions(schemaName, sqlFuncs);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheTypeCreated(GridCacheContextInfo<?, ?> cacheInfo, GridQueryTypeDescriptor type, boolean isSql) throws IgniteCheckedException {
        SchemaManager.validateTypeDescriptor(type);
        this.lock.writeLock().lock();
        try {
            String schemaName = this.schemaName(cacheInfo.name());
            SchemaDescriptor schema = this.schema(schemaName);
            TableDescriptor tbl = new TableDescriptor(cacheInfo, type, isSql);
            schema.add(tbl);
            T2<String, String> tableId = new T2<String, String>(schemaName, type.tableName());
            if (this.id2tbl.putIfAbsent(tableId, tbl) != null) {
                throw new IllegalStateException("Table already exists: " + schemaName + '.' + type.tableName());
            }
            this.lsnr.onSqlTypeCreated(schemaName, type, cacheInfo);
            this.createPkIndex(tbl);
            this.createAffinityIndex(tbl);
            for (GridQueryIndexDescriptor idxDesc : tbl.type().indexes().values()) {
                this.createIndex0(idxDesc, tbl, null);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static void validateTypeDescriptor(GridQueryTypeDescriptor type) throws IgniteCheckedException {
        assert (type != null);
        HashSet<String> names = new HashSet<String>(type.fields().keySet());
        if (names.size() < type.fields().size()) {
            throw new IgniteCheckedException("Found duplicated properties with the same name [keyType=" + type.keyClass().getName() + ", valueType=" + type.valueClass().getName() + "]");
        }
        String ptrn = "Name ''{0}'' is reserved and cannot be used as a field name [type=" + type.name() + "]";
        for (String name : names) {
            if (!name.equalsIgnoreCase("_KEY") && !name.equalsIgnoreCase("_VAL")) continue;
            throw new IgniteCheckedException(MessageFormat.format(ptrn, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheDestroyed(String cacheName, boolean rmvIdx, boolean clearIdx) {
        this.lock.writeLock().lock();
        try {
            String schemaName = this.schemaName(cacheName);
            SchemaDescriptor schema = (SchemaDescriptor)this.schemas.get(schemaName);
            this.cacheName2schema.remove(cacheName);
            for (TableDescriptor tbl : schema.tables()) {
                if (!F.eq(tbl.cacheInfo().name(), cacheName)) continue;
                ArrayList<IndexDescriptor> idxs = new ArrayList<IndexDescriptor>(tbl.indexes().values());
                for (IndexDescriptor idx : idxs) {
                    if (idx.isProxy()) continue;
                    this.dropIndex(tbl, idx.name(), !clearIdx);
                }
                this.lsnr.onSqlTypeDropped(schemaName, tbl.type(), rmvIdx);
                schema.drop(tbl);
                T2<String, String> tableId = new T2<String, String>(tbl.type().schemaName(), tbl.type().tableName());
                this.id2tbl.remove(tableId, tbl);
            }
            if (schema.decrementUsageCount()) {
                this.schemas.remove(schemaName);
                this.lsnr.onSchemaDropped(schemaName);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void createSchema(String schemaName, boolean predefined) {
        SchemaDescriptor schema;
        SchemaDescriptor oldSchema;
        assert (this.lock.isWriteLockedByCurrentThread());
        if (!predefined) {
            predefined = F.eq("PUBLIC", schemaName);
        }
        if ((oldSchema = this.schemas.putIfAbsent(schemaName, schema = new SchemaDescriptor(schemaName, predefined))) == null) {
            this.lsnr.onSchemaCreated(schemaName);
        } else {
            schema = oldSchema;
        }
        schema.incrementUsageCount();
    }

    private void createSqlFunctions(String schema, Class<?>[] clss) throws IgniteCheckedException {
        assert (this.lock.isWriteLockedByCurrentThread());
        if (F.isEmpty(clss)) {
            return;
        }
        for (Class<?> cls : clss) {
            for (Method m4 : cls.getDeclaredMethods()) {
                QuerySqlFunction ann = m4.getAnnotation(QuerySqlFunction.class);
                if (ann == null) continue;
                int modifiers = m4.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                    throw new IgniteCheckedException("Method " + m4.getName() + " must be public static.");
                }
                String alias = ann.alias().isEmpty() ? m4.getName() : ann.alias();
                this.lsnr.onFunctionCreated(schema, alias, ann.deterministic(), m4);
            }
        }
    }

    public String schemaName(String cacheName) {
        String res = this.cacheName2schema.get(cacheName);
        if (res == null) {
            res = "";
        }
        return res;
    }

    public Set<String> schemaNames() {
        return new HashSet<String>(this.schemas.keySet());
    }

    private SchemaDescriptor schema(String schemaName) {
        return (SchemaDescriptor)this.schemas.get(schemaName);
    }

    private void createPkIndex(TableDescriptor tbl) throws IgniteCheckedException {
        assert (this.lock.isWriteLockedByCurrentThread());
        QuerySysIndexDescriptorImpl idxDesc = new QuerySysIndexDescriptorImpl("_key_PK", Collections.emptyList(), tbl.type().primaryKeyInlineSize());
        this.createIndex0(idxDesc, tbl, null);
    }

    private void createAffinityIndex(TableDescriptor tbl) throws IgniteCheckedException {
        assert (this.lock.isWriteLockedByCurrentThread());
        if (tbl.affinityKey() != null && !tbl.affinityKey().equals("_KEY")) {
            boolean affIdxFound = false;
            for (GridQueryIndexDescriptor idxDesc : tbl.type().indexes().values()) {
                if (idxDesc.type() != QueryIndexType.SORTED) continue;
                affIdxFound |= F.eq(tbl.affinityKey(), F.first(idxDesc.fields()));
            }
            if (!affIdxFound) {
                QuerySysIndexDescriptorImpl idxDesc = new QuerySysIndexDescriptorImpl("AFFINITY_KEY", Collections.singleton(tbl.affinityKey()), tbl.type().affinityFieldInlineSize());
                this.createIndex0(idxDesc, tbl, null);
            }
        }
    }

    private void createIndex0(GridQueryIndexDescriptor idxDesc, TableDescriptor tbl, @Nullable SchemaIndexCacheVisitor cacheVisitor) throws IgniteCheckedException {
        assert (cacheVisitor == null || !this.lock.isWriteLockedByCurrentThread());
        IndexDescriptorFactory factory = this.idxDescFactory.get((Object)idxDesc.type());
        if (factory == null) {
            throw new IllegalStateException("Not found factory for index type: " + (Object)((Object)idxDesc.type()));
        }
        IndexDescriptor desc = factory.create(this.ctx, idxDesc, tbl, cacheVisitor);
        this.addIndex(tbl, desc);
    }

    private void createProxyIndex(IndexDescriptor idxDesc, TableDescriptor tbl) {
        assert (this.lock.isWriteLockedByCurrentThread());
        GridQueryTypeDescriptor typeDesc = tbl.type();
        if (F.isEmpty(typeDesc.keyFieldName()) && F.isEmpty(typeDesc.valueFieldName())) {
            return;
        }
        String keyAlias = typeDesc.keyFieldAlias();
        String valAlias = typeDesc.valueFieldAlias();
        LinkedHashMap<String, IndexKeyDefinition> proxyKeyDefs = new LinkedHashMap<String, IndexKeyDefinition>(idxDesc.keyDefinitions().size());
        boolean modified = false;
        for (Map.Entry<String, IndexKeyDefinition> keyDef : idxDesc.keyDefinitions().entrySet()) {
            String oldFieldName;
            String newFieldName = oldFieldName = keyDef.getKey();
            if (F.eq(oldFieldName, "_KEY") && !F.isEmpty(keyAlias)) {
                newFieldName = keyAlias;
            } else if (F.eq(oldFieldName, "_VAL") && !F.isEmpty(valAlias)) {
                newFieldName = valAlias;
            } else if (F.eq(oldFieldName, keyAlias)) {
                newFieldName = "_KEY";
            } else if (F.eq(oldFieldName, valAlias)) {
                newFieldName = "_VAL";
            }
            modified |= !F.eq(oldFieldName, newFieldName);
            proxyKeyDefs.put(newFieldName, keyDef.getValue());
        }
        if (!modified) {
            return;
        }
        String proxyName = SchemaManager.generateProxyIdxName(idxDesc.name());
        IndexDescriptor proxyDesc = new IndexDescriptor(proxyName, proxyKeyDefs, idxDesc);
        tbl.addIndex(proxyName, proxyDesc);
        this.lsnr.onIndexCreated(tbl.type().schemaName(), tbl.type().tableName(), proxyName, proxyDesc);
    }

    public static String generateProxyIdxName(String idxName) {
        return idxName + "_proxy";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(String schemaName, String tblName, QueryIndexDescriptorImpl idxDesc, boolean ifNotExists, SchemaIndexCacheVisitor cacheVisitor) throws IgniteCheckedException {
        TableDescriptor tbl;
        this.lock.readLock().lock();
        try {
            tbl = this.table(schemaName, tblName);
            if (tbl == null) {
                throw new SchemaOperationException(2, tblName);
            }
            if (tbl.indexes().containsKey(idxDesc.name())) {
                if (ifNotExists) {
                    return;
                }
                throw new SchemaOperationException(7, idxDesc.name());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.createIndex0(idxDesc, tbl, cacheVisitor);
    }

    public void addIndex(TableDescriptor tbl, IndexDescriptor idxDesc) throws IgniteCheckedException {
        this.lock.writeLock().lock();
        try {
            if (this.table(tbl.type().schemaName(), tbl.type().tableName()) == null) {
                this.ctx.indexProcessor().removeIndex(new IndexName(tbl.cacheInfo().name(), tbl.type().schemaName(), tbl.type().tableName(), idxDesc.name()), false);
                throw new SchemaOperationException(2, tbl.type().tableName());
            }
            tbl.addIndex(idxDesc.name(), idxDesc);
            this.lsnr.onIndexCreated(tbl.type().schemaName(), tbl.type().tableName(), idxDesc.name(), idxDesc);
            this.createProxyIndex(idxDesc, tbl);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(String schemaName, String idxName, boolean ifExists) throws IgniteCheckedException {
        this.lock.writeLock().lock();
        try {
            IndexDescriptor idxDesc = this.index(schemaName, idxName);
            if (idxDesc == null) {
                if (ifExists) {
                    return;
                }
                throw new SchemaOperationException(6, idxName);
            }
            this.dropIndex(idxDesc.table(), idxName, false);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void dropIndex(TableDescriptor tbl, String idxName, boolean softDelete) {
        assert (this.lock.isWriteLockedByCurrentThread());
        String schemaName = tbl.type().schemaName();
        String cacheName = tbl.type().cacheName();
        String tableName = tbl.type().tableName();
        IndexDescriptor idxDesc = tbl.dropIndex(idxName);
        assert (idxDesc != null);
        if (!idxDesc.isProxy()) {
            this.ctx.indexProcessor().removeIndex(new IndexName(cacheName, schemaName, tableName, idxName), softDelete);
        }
        this.lsnr.onIndexDropped(schemaName, tableName, idxName);
        for (IndexDescriptor proxyDesc : tbl.indexes().values()) {
            if (proxyDesc.targetIdx() != idxDesc) continue;
            tbl.dropIndex(proxyDesc.name());
            this.lsnr.onIndexDropped(schemaName, tableName, proxyDesc.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(String schemaName, String tblName, List<QueryField> cols, boolean ifTblExists, boolean ifColNotExists) throws IgniteCheckedException {
        assert (!ifColNotExists || cols.size() == 1);
        this.lock.writeLock().lock();
        try {
            TableDescriptor tbl = this.table(schemaName, tblName);
            if (tbl == null) {
                if (!ifTblExists) {
                    throw new IgniteCheckedException("Table not found in schema manager [schemaName=" + schemaName + ", tblName=" + tblName + ']');
                }
                return;
            }
            this.lsnr.onColumnsAdded(schemaName, tbl.type(), tbl.cacheInfo(), cols);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropColumn(String schemaName, String tblName, List<String> cols, boolean ifTblExists, boolean ifColExists) throws IgniteCheckedException {
        assert (!ifColExists || cols.size() == 1);
        this.lock.writeLock().lock();
        try {
            TableDescriptor tbl = this.table(schemaName, tblName);
            if (tbl == null) {
                if (!ifTblExists) {
                    throw new IgniteCheckedException("Table not found in schema manager [schemaName=" + schemaName + ",tblName=" + tblName + ']');
                }
                return;
            }
            this.lsnr.onColumnsDropped(schemaName, tbl.type(), tbl.cacheInfo(), cols);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initCacheContext(GridCacheContext<?, ?> cctx) {
        this.lock.writeLock().lock();
        try {
            GridCacheContextInfo<?, ?> cacheInfo = this.cacheInfo(cctx.name());
            if (cacheInfo != null) {
                assert (!cacheInfo.isCacheContextInited()) : cacheInfo.name();
                assert (cacheInfo.name().equals(cctx.name())) : cacheInfo.name() + " != " + cctx.name();
                cacheInfo.initCacheContext(cctx);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearCacheContext(GridCacheContext<?, ?> cctx) {
        this.lock.writeLock().lock();
        try {
            GridCacheContextInfo<?, ?> cacheInfo = this.cacheInfo(cctx.name());
            if (cacheInfo != null && cacheInfo.isCacheContextInited()) {
                cacheInfo.clearCacheContext();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markIndexRebuild(String cacheName, boolean mark) {
        this.lock.writeLock().lock();
        try {
            for (TableDescriptor tbl : this.tablesForCache(cacheName)) {
                tbl.markIndexRebuildInProgress(mark);
                if (mark) {
                    this.lsnr.onIndexRebuildStarted(tbl.type().schemaName(), tbl.type().tableName());
                    continue;
                }
                this.lsnr.onIndexRebuildFinished(tbl.type().schemaName(), tbl.type().tableName());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridQueryTypeDescriptor typeDescriptorForType(String schemaName, String cacheName, String type) {
        this.lock.readLock().lock();
        try {
            SchemaDescriptor schema = this.schema(schemaName);
            if (schema == null) {
                GridQueryTypeDescriptor gridQueryTypeDescriptor = null;
                return gridQueryTypeDescriptor;
            }
            TableDescriptor tbl = schema.tableByTypeName(cacheName, type);
            GridQueryTypeDescriptor gridQueryTypeDescriptor = tbl == null ? null : tbl.type();
            return gridQueryTypeDescriptor;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TableDescriptor> tablesForCache(String cacheName) {
        this.lock.readLock().lock();
        try {
            SchemaDescriptor schema = this.schema(this.schemaName(cacheName));
            if (schema == null) {
                Set<TableDescriptor> set = Collections.emptySet();
                return set;
            }
            ArrayList<TableDescriptor> tbls = new ArrayList<TableDescriptor>();
            for (TableDescriptor tbl : schema.tables()) {
                if (!F.eq(tbl.cacheInfo().name(), cacheName)) continue;
                tbls.add(tbl);
            }
            ArrayList<TableDescriptor> arrayList = tbls;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridCacheContextInfo<?, ?> cacheInfo(String cacheName) {
        this.lock.readLock().lock();
        try {
            SchemaDescriptor schema = this.schema(this.schemaName(cacheName));
            if (schema == null) {
                GridCacheContextInfo<?, ?> gridCacheContextInfo = null;
                return gridCacheContextInfo;
            }
            for (TableDescriptor tbl : schema.tables()) {
                if (!F.eq(tbl.cacheInfo().name(), cacheName)) continue;
                GridCacheContextInfo<?, ?> gridCacheContextInfo = tbl.cacheInfo();
                return gridCacheContextInfo;
            }
            Iterator<TableDescriptor> iterator = null;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TableDescriptor table(String schemaName, String tblName) {
        this.lock.readLock().lock();
        try {
            TableDescriptor tableDescriptor = (TableDescriptor)this.id2tbl.get(new T2<String, String>(schemaName, tblName));
            return tableDescriptor;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IndexDescriptor index(String schemaName, String idxName) {
        this.lock.readLock().lock();
        try {
            SchemaDescriptor schema = this.schema(schemaName);
            if (schema == null) {
                IndexDescriptor indexDescriptor = null;
                return indexDescriptor;
            }
            for (TableDescriptor tbl : schema.tables()) {
                IndexDescriptor idx = tbl.indexes().get(idxName);
                if (idx == null) continue;
                IndexDescriptor indexDescriptor = idx;
                return indexDescriptor;
            }
            Iterator<TableDescriptor> iterator = null;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<IndexDescriptor> allIndexes() {
        return this.id2tbl.values().stream().flatMap(t2 -> t2.indexes().values().stream()).collect(Collectors.toList());
    }

    public Collection<TableInformation> tablesInformation(String schemaNamePtrn, String tblNamePtrn, String ... tblTypes) {
        boolean allTypes;
        ArrayList<TableInformation> infos;
        HashSet<String> types;
        block5: {
            block4: {
                types = F.isEmpty(tblTypes) ? Collections.emptySet() : new HashSet<String>(Arrays.asList(tblTypes));
                infos = new ArrayList<TableInformation>();
                allTypes = F.isEmpty(tblTypes);
                if (allTypes) break block4;
                if (!types.contains("TABLE")) break block5;
            }
            this.id2tbl.values().stream().filter(t2 -> QueryUtils.matches(t2.type().schemaName(), schemaNamePtrn)).filter(t2 -> QueryUtils.matches(t2.type().tableName(), tblNamePtrn)).map(t2 -> {
                int cacheGrpId = t2.cacheInfo().groupId();
                CacheGroupDescriptor cacheGrpDesc = this.ctx.cache().cacheGroupDescriptors().get(cacheGrpId);
                if (cacheGrpDesc == null) {
                    return null;
                }
                GridQueryTypeDescriptor type = t2.type();
                return new TableInformation(t2.type().schemaName(), t2.type().tableName(), "TABLE", cacheGrpId, cacheGrpDesc.cacheOrGroupName(), t2.cacheInfo().cacheId(), t2.cacheInfo().name(), type.affinityKey(), type.keyFieldAlias(), type.valueFieldAlias(), type.keyTypeName(), type.valueTypeName());
            }).filter(Objects::nonNull).forEach(infos::add);
        }
        if ((allTypes || types.contains("VIEW")) && QueryUtils.matches(QueryUtils.SCHEMA_SYS, schemaNamePtrn)) {
            this.sysViews.stream().filter(t2 -> QueryUtils.matches(MetricUtils.toSqlName(t2.name()), tblNamePtrn)).map(v -> new TableInformation(QueryUtils.SCHEMA_SYS, MetricUtils.toSqlName(v.name()), "VIEW")).forEach(infos::add);
        }
        return infos;
    }

    public Collection<ColumnInformation> columnsInformation(String schemaNamePtrn, String tblNamePtrn, String colNamePtrn) {
        ArrayList<ColumnInformation> infos = new ArrayList<ColumnInformation>();
        this.id2tbl.values().stream().filter(t2 -> QueryUtils.matches(t2.type().schemaName(), schemaNamePtrn)).filter(t2 -> QueryUtils.matches(t2.type().tableName(), tblNamePtrn)).forEach(tbl -> {
            AtomicInteger cnt = new AtomicInteger(1);
            GridQueryTypeDescriptor d = tbl.type();
            if (F.isEmpty(d.fields())) {
                if (QueryUtils.matches("_KEY", colNamePtrn)) {
                    infos.add(new ColumnInformation(cnt.getAndIncrement(), d.schemaName(), d.tableName(), "_KEY", d.keyClass(), false, null, -1, -1, false));
                }
                if (QueryUtils.matches("_VAL", colNamePtrn)) {
                    infos.add(new ColumnInformation(cnt.getAndIncrement(), d.schemaName(), d.tableName(), "_VAL", d.valueClass(), false, null, -1, -1, false));
                }
            } else {
                d.fields().keySet().stream().filter(field -> QueryUtils.matches(field, colNamePtrn)).forEach(field -> {
                    GridQueryProperty prop = d.property((String)field);
                    infos.add(new ColumnInformation(cnt.getAndIncrement(), d.schemaName(), d.tableName(), (String)field, prop.type(), !prop.notNull(), prop.defaultValue(), prop.precision(), prop.scale(), field.equals(d.affinityKey())));
                });
            }
        });
        if (QueryUtils.matches(QueryUtils.SCHEMA_SYS, schemaNamePtrn)) {
            this.sysViews.stream().filter(v -> QueryUtils.matches(MetricUtils.toSqlName(v.name()), tblNamePtrn)).flatMap(view -> {
                AtomicInteger cnt = new AtomicInteger(1);
                return MetricUtils.systemViewAttributes(view).entrySet().stream().filter(c -> QueryUtils.matches(MetricUtils.toSqlName((String)c.getKey()), colNamePtrn)).map(c -> new ColumnInformation(cnt.getAndIncrement(), QueryUtils.SCHEMA_SYS, MetricUtils.toSqlName(view.name()), MetricUtils.toSqlName((String)c.getKey()), (Class)c.getValue(), true, null, -1, -1, false));
            }).forEach(infos::add);
        }
        return infos;
    }

    private SchemaChangeListener schemaChangeListener(GridKernalContext ctx) {
        ArrayList<SchemaChangeListener> subscribers = new ArrayList<SchemaChangeListener>(ctx.internalSubscriptionProcessor().getSchemaChangeSubscribers());
        if (F.isEmpty(subscribers)) {
            return new NoOpSchemaChangeListener();
        }
        return new CompoundSchemaChangeListener(ctx, subscribers);
    }

    private static final class CompoundSchemaChangeListener
    implements SchemaChangeListener {
        private final List<SchemaChangeListener> lsnrs;
        private final IgniteLogger log;

        private CompoundSchemaChangeListener(GridKernalContext ctx, List<SchemaChangeListener> lsnrs) {
            this.lsnrs = lsnrs;
            this.log = ctx.log(CompoundSchemaChangeListener.class);
        }

        @Override
        public void onSchemaCreated(String schemaName) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onSchemaCreated(schemaName)));
        }

        @Override
        public void onSchemaDropped(String schemaName) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onSchemaDropped(schemaName)));
        }

        @Override
        public void onSqlTypeCreated(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onSqlTypeCreated(schemaName, typeDesc, cacheInfo)));
        }

        @Override
        public void onColumnsAdded(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo, List<QueryField> cols) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onColumnsAdded(schemaName, typeDesc, cacheInfo, cols)));
        }

        @Override
        public void onColumnsDropped(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo, List<String> cols) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onColumnsDropped(schemaName, typeDesc, cacheInfo, cols)));
        }

        @Override
        public void onSqlTypeDropped(String schemaName, GridQueryTypeDescriptor typeDescriptor, boolean destroy) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onSqlTypeDropped(schemaName, typeDescriptor, destroy)));
        }

        @Override
        public void onIndexCreated(String schemaName, String tblName, String idxName, IndexDescriptor idxDesc) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onIndexCreated(schemaName, tblName, idxName, idxDesc)));
        }

        @Override
        public void onIndexDropped(String schemaName, String tblName, String idxName) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onIndexDropped(schemaName, tblName, idxName)));
        }

        @Override
        public void onIndexRebuildStarted(String schemaName, String tblName) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onIndexRebuildStarted(schemaName, tblName)));
        }

        @Override
        public void onIndexRebuildFinished(String schemaName, String tblName) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onIndexRebuildFinished(schemaName, tblName)));
        }

        @Override
        public void onFunctionCreated(String schemaName, String name, boolean deterministic, Method method) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onFunctionCreated(schemaName, name, deterministic, method)));
        }

        @Override
        public void onSystemViewCreated(String schemaName, SystemView<?> sysView) {
            this.lsnrs.forEach(lsnr -> this.executeSafe(() -> lsnr.onSystemViewCreated(schemaName, sysView)));
        }

        private void executeSafe(Runnable r) {
            try {
                r.run();
            }
            catch (Exception e) {
                this.log.warning("Failed to notify listener (will ignore): " + e.getMessage(), e);
            }
        }
    }

    private static final class NoOpSchemaChangeListener
    extends AbstractSchemaChangeListener {
        private NoOpSchemaChangeListener() {
        }
    }
}

