/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.events;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventAdapter;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformEventFilterListener;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.events.PlatformLocalEventListener;
import org.apache.ignite.internal.processors.platform.utils.PlatformFutureUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteFuture;

public class PlatformEvents
extends PlatformAbstractTarget {
    private static final int OP_REMOTE_QUERY = 1;
    private static final int OP_REMOTE_LISTEN = 2;
    private static final int OP_STOP_REMOTE_LISTEN = 3;
    private static final int OP_WAIT_FOR_LOCAL = 4;
    private static final int OP_LOCAL_QUERY = 5;
    private static final int OP_RECORD_LOCAL = 6;
    private static final int OP_ENABLE_LOCAL = 8;
    private static final int OP_DISABLE_LOCAL = 9;
    private static final int OP_GET_ENABLED_EVENTS = 10;
    private static final int OP_WITH_ASYNC = 11;
    private static final int OP_IS_ENABLED = 12;
    private static final int OP_LOCAL_LISTEN = 13;
    private static final int OP_STOP_LOCAL_LISTEN = 14;
    private static final int OP_REMOTE_QUERY_ASYNC = 15;
    private static final int OP_WAIT_FOR_LOCAL_ASYNC = 16;
    private final IgniteEvents events;
    private final EventResultWriter eventResWriter;
    private final EventCollectionResultWriter eventColResWriter;

    public PlatformEvents(PlatformContext platformCtx, IgniteEvents events) {
        super(platformCtx);
        assert (events != null);
        this.events = events;
        this.eventResWriter = new EventResultWriter(platformCtx);
        this.eventColResWriter = new EventCollectionResultWriter(platformCtx);
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 6: {
                return 1L;
            }
            case 8: {
                this.events.enableLocal(this.readEventTypes(reader));
                return 1L;
            }
            case 9: {
                this.events.disableLocal(this.readEventTypes(reader));
                return 1L;
            }
            case 3: {
                this.events.stopRemoteListen(reader.readUuid());
                return 1L;
            }
            case 13: {
                this.events.localListen(this.localFilter(reader.readLong()), reader.readInt());
                return 1L;
            }
            case 15: {
                this.readAndListenFuture(reader, this.startRemoteQueryAsync(reader, this.events), this.eventColResWriter);
                return 1L;
            }
            case 16: {
                this.readAndListenFuture(reader, this.startWaitForLocalAsync(reader, this.events), this.eventResWriter);
                return 1L;
            }
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 5: {
                Collection result = this.events.localQuery(F.alwaysTrue(), this.readEventTypes(reader));
                writer.writeInt(result.size());
                for (EventAdapter e : result) {
                    this.platformCtx.writeEvent(writer, e);
                }
                break;
            }
            case 4: {
                EventAdapter result = this.startWaitForLocal(reader, this.events);
                this.platformCtx.writeEvent(writer, result);
                break;
            }
            case 2: {
                UUID listenId;
                int bufSize = reader.readInt();
                long interval = reader.readLong();
                boolean autoUnsubscribe = reader.readBoolean();
                boolean hasLocFilter = reader.readBoolean();
                PlatformEventFilterListener locFilter = hasLocFilter ? this.localFilter(reader.readLong()) : null;
                boolean hasRmtFilter = reader.readBoolean();
                if (hasRmtFilter) {
                    PlatformEventFilterListener rmtFilter = this.platformCtx.createRemoteEventFilter(reader.readObjectDetached(), this.readEventTypes(reader));
                    listenId = this.events.remoteListen(bufSize, interval, autoUnsubscribe, locFilter, rmtFilter, new int[0]);
                } else {
                    listenId = this.events.remoteListen(bufSize, interval, autoUnsubscribe, locFilter, null, this.readEventTypes(reader));
                }
                writer.writeUuid(listenId);
                break;
            }
            case 1: {
                Collection<Event> result = this.startRemoteQuery(reader, this.events);
                this.eventColResWriter.write(writer, result, null);
                break;
            }
            case 14: {
                int id = reader.readInt();
                int[] types = reader.readIntArray();
                PlatformLocalEventListener lsnr = new PlatformLocalEventListener(id);
                boolean res = this.events.stopLocalListen(lsnr, types);
                writer.writeBoolean(res);
                break;
            }
            default: {
                super.processInStreamOutStream(type, reader, writer);
            }
        }
    }

    private EventAdapter startWaitForLocal(BinaryRawReaderEx reader, IgniteEvents events) {
        Long filterHnd = (Long)reader.readObject();
        PlatformEventFilterListener filter = filterHnd != null ? this.localFilter(filterHnd) : null;
        int[] eventTypes = this.readEventTypes(reader);
        return (EventAdapter)events.waitForLocal(filter, eventTypes);
    }

    private IgniteFuture<EventAdapter> startWaitForLocalAsync(BinaryRawReaderEx reader, IgniteEvents events) {
        Long filterHnd = (Long)reader.readObject();
        PlatformEventFilterListener filter = filterHnd != null ? this.localFilter(filterHnd) : null;
        int[] eventTypes = this.readEventTypes(reader);
        return events.waitForLocalAsync(filter, eventTypes);
    }

    private Collection<Event> startRemoteQuery(BinaryRawReaderEx reader, IgniteEvents events) {
        Object pred = reader.readObjectDetached();
        long timeout = reader.readLong();
        int[] types = this.readEventTypes(reader);
        PlatformEventFilterListener filter = this.platformCtx.createRemoteEventFilter(pred, types);
        return events.remoteQuery(filter, timeout, new int[0]);
    }

    private IgniteFuture<List<Event>> startRemoteQueryAsync(BinaryRawReaderEx reader, IgniteEvents events) {
        Object pred = reader.readObjectDetached();
        long timeout = reader.readLong();
        int[] types = this.readEventTypes(reader);
        PlatformEventFilterListener filter = this.platformCtx.createRemoteEventFilter(pred, types);
        return events.remoteQueryAsync(filter, timeout, new int[0]);
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 10: {
                this.writeEventTypes(this.events.enabledEvents(), writer);
                break;
            }
            default: {
                super.processOutStream(type, writer);
            }
        }
    }

    @Override
    public PlatformTarget processOutObject(int type) throws IgniteCheckedException {
        switch (type) {
            case 11: {
                if (this.events.isAsync()) {
                    return this;
                }
                return new PlatformEvents(this.platformCtx, this.events.withAsync());
            }
        }
        return super.processOutObject(type);
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 12: {
                return this.events.isEnabled((int)val) ? 1L : 0L;
            }
            case 14: {
                return this.events.stopLocalListen(this.localFilter(val), new int[0]) ? 1L : 0L;
            }
        }
        return super.processInLongOutLong(type, val);
    }

    private int[] readEventTypes(BinaryRawReaderEx reader) {
        return reader.readIntArray();
    }

    private void writeEventTypes(int[] types, BinaryRawWriterEx writer) {
        if (types == null) {
            writer.writeIntArray(null);
            return;
        }
        int[] resultTypes = new int[types.length];
        int idx = 0;
        for (int t2 : types) {
            if (!this.platformCtx.isEventTypeSupported(t2)) continue;
            resultTypes[idx++] = t2;
        }
        writer.writeIntArray(Arrays.copyOf(resultTypes, idx));
    }

    private PlatformEventFilterListener localFilter(long hnd) {
        return this.platformCtx.createLocalEventFilter(hnd);
    }

    private static class EventCollectionResultWriter
    implements PlatformFutureUtils.Writer {
        private final PlatformContext platformCtx;

        public EventCollectionResultWriter(PlatformContext platformCtx) {
            assert (platformCtx != null);
            this.platformCtx = platformCtx;
        }

        @Override
        public void write(BinaryRawWriterEx writer, Object obj, Throwable err) {
            Collection evts = (Collection)obj;
            if (obj != null) {
                writer.writeInt(evts.size());
                for (Event e : evts) {
                    this.platformCtx.writeEvent(writer, e);
                }
            } else {
                writer.writeInt(-1);
            }
        }

        @Override
        public boolean canWrite(Object obj, Throwable err) {
            return obj instanceof Collection && err == null;
        }
    }

    private static class EventResultWriter
    implements PlatformFutureUtils.Writer {
        private final PlatformContext platformCtx;

        public EventResultWriter(PlatformContext platformCtx) {
            assert (platformCtx != null);
            this.platformCtx = platformCtx;
        }

        @Override
        public void write(BinaryRawWriterEx writer, Object obj, Throwable err) {
            this.platformCtx.writeEvent(writer, (EventAdapter)obj);
        }

        @Override
        public boolean canWrite(Object obj, Throwable err) {
            return obj instanceof EventAdapter && err == null;
        }
    }
}

