/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache.expiry;

import java.util.concurrent.TimeUnit;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;

public class PlatformExpiryPolicy
implements ExpiryPolicy {
    private static final long DUR_UNCHANGED = -2L;
    private static final long DUR_ETERNAL = -1L;
    private static final long DUR_ZERO = 0L;
    private final Duration create;
    private final Duration update;
    private final Duration access;

    public PlatformExpiryPolicy(long create, long update, long access) {
        this.create = PlatformExpiryPolicy.convert(create);
        this.update = PlatformExpiryPolicy.convert(update);
        this.access = PlatformExpiryPolicy.convert(access);
    }

    @Override
    public Duration getExpiryForCreation() {
        return this.create;
    }

    @Override
    public Duration getExpiryForUpdate() {
        return this.update;
    }

    @Override
    public Duration getExpiryForAccess() {
        return this.access;
    }

    private static Duration convert(long dur) {
        if (dur == -2L) {
            return null;
        }
        if (dur == -1L) {
            return Duration.ETERNAL;
        }
        if (dur == 0L) {
            return Duration.ZERO;
        }
        assert (dur > 0L);
        return new Duration(TimeUnit.MILLISECONDS, dur);
    }

    public static long convertDuration(Duration dur) {
        if (dur == null) {
            return -2L;
        }
        if (dur.isEternal()) {
            return -1L;
        }
        if (dur.isZero()) {
            return 0L;
        }
        return dur.getTimeUnit().toMillis(dur.getDurationAmount());
    }
}

