/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import javax.cache.Cache;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CachePartialUpdateException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryMetrics;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteDeploymentCheckedException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformNativeException;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheEntryFilter;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheEntryProcessor;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheExtension;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheIterator;
import org.apache.ignite.internal.processors.platform.cache.PlatformCachePartialUpdateException;
import org.apache.ignite.internal.processors.platform.cache.expiry.PlatformExpiryPolicy;
import org.apache.ignite.internal.processors.platform.cache.query.PlatformContinuousQuery;
import org.apache.ignite.internal.processors.platform.cache.query.PlatformContinuousQueryProxy;
import org.apache.ignite.internal.processors.platform.cache.query.PlatformFieldsQueryCursor;
import org.apache.ignite.internal.processors.platform.cache.query.PlatformQueryCursor;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformConfigurationUtils;
import org.apache.ignite.internal.processors.platform.utils.PlatformFutureUtils;
import org.apache.ignite.internal.processors.platform.utils.PlatformListenable;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.processors.platform.utils.PlatformWriterClosure;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.GridConcurrentFactory;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.transactions.TransactionDeadlockException;
import org.apache.ignite.transactions.TransactionTimeoutException;
import org.jetbrains.annotations.Nullable;

public class PlatformCache
extends PlatformAbstractTarget {
    public static final int OP_CLEAR = 1;
    public static final int OP_CLEAR_ALL = 2;
    public static final int OP_CONTAINS_KEY = 3;
    public static final int OP_CONTAINS_KEYS = 4;
    public static final int OP_GET = 5;
    public static final int OP_GET_ALL = 6;
    public static final int OP_GET_AND_PUT = 7;
    public static final int OP_GET_AND_PUT_IF_ABSENT = 8;
    public static final int OP_GET_AND_REMOVE = 9;
    public static final int OP_GET_AND_REPLACE = 10;
    public static final int OP_GET_NAME = 11;
    public static final int OP_INVOKE = 12;
    public static final int OP_INVOKE_ALL = 13;
    public static final int OP_IS_LOCAL_LOCKED = 14;
    public static final int OP_LOAD_CACHE = 15;
    public static final int OP_LOC_EVICT = 16;
    public static final int OP_LOC_LOAD_CACHE = 17;
    public static final int OP_LOCAL_CLEAR = 20;
    public static final int OP_LOCAL_CLEAR_ALL = 21;
    public static final int OP_LOCK = 22;
    public static final int OP_LOCK_ALL = 23;
    public static final int OP_LOCAL_METRICS = 24;
    private static final int OP_PEEK = 25;
    private static final int OP_PUT = 26;
    private static final int OP_PUT_ALL = 27;
    public static final int OP_PUT_IF_ABSENT = 28;
    public static final int OP_QRY_CONTINUOUS = 29;
    public static final int OP_QRY_SCAN = 30;
    public static final int OP_QRY_SQL = 31;
    public static final int OP_QRY_SQL_FIELDS = 32;
    public static final int OP_QRY_TXT = 33;
    public static final int OP_REMOVE_ALL = 34;
    public static final int OP_REMOVE_BOOL = 35;
    public static final int OP_REMOVE_OBJ = 36;
    public static final int OP_REPLACE_2 = 37;
    public static final int OP_REPLACE_3 = 38;
    public static final int OP_GET_CONFIG = 39;
    public static final int OP_LOAD_ALL = 40;
    public static final int OP_CLEAR_CACHE = 41;
    public static final int OP_WITH_PARTITION_RECOVER = 42;
    public static final int OP_REMOVE_ALL2 = 43;
    public static final int OP_WITH_KEEP_BINARY = 44;
    public static final int OP_WITH_EXPIRY_POLICY = 45;
    public static final int OP_WITH_NO_RETRIES = 46;
    public static final int OP_WITH_SKIP_STORE = 47;
    public static final int OP_SIZE = 48;
    public static final int OP_ITERATOR = 49;
    public static final int OP_LOC_ITERATOR = 50;
    public static final int OP_ENTER_LOCK = 51;
    public static final int OP_EXIT_LOCK = 52;
    public static final int OP_TRY_ENTER_LOCK = 53;
    public static final int OP_CLOSE_LOCK = 54;
    public static final int OP_REBALANCE = 55;
    public static final int OP_SIZE_LOC = 56;
    public static final int OP_PUT_ASYNC = 57;
    public static final int OP_CLEAR_CACHE_ASYNC = 58;
    public static final int OP_CLEAR_ALL_ASYNC = 59;
    public static final int OP_REMOVE_ALL2_ASYNC = 60;
    public static final int OP_SIZE_ASYNC = 61;
    public static final int OP_CLEAR_ASYNC = 62;
    public static final int OP_LOAD_CACHE_ASYNC = 63;
    public static final int OP_LOC_LOAD_CACHE_ASYNC = 64;
    public static final int OP_PUT_ALL_ASYNC = 65;
    public static final int OP_REMOVE_ALL_ASYNC = 66;
    public static final int OP_GET_ASYNC = 67;
    public static final int OP_CONTAINS_KEY_ASYNC = 68;
    public static final int OP_CONTAINS_KEYS_ASYNC = 69;
    public static final int OP_REMOVE_BOOL_ASYNC = 70;
    public static final int OP_REMOVE_OBJ_ASYNC = 71;
    public static final int OP_GET_ALL_ASYNC = 72;
    public static final int OP_GET_AND_PUT_ASYNC = 73;
    public static final int OP_GET_AND_PUT_IF_ABSENT_ASYNC = 74;
    public static final int OP_GET_AND_REMOVE_ASYNC = 75;
    public static final int OP_GET_AND_REPLACE_ASYNC = 76;
    public static final int OP_REPLACE_2_ASYNC = 77;
    public static final int OP_REPLACE_3_ASYNC = 78;
    public static final int OP_INVOKE_ASYNC = 79;
    public static final int OP_INVOKE_ALL_ASYNC = 80;
    public static final int OP_PUT_IF_ABSENT_ASYNC = 81;
    public static final int OP_EXTENSION = 82;
    public static final int OP_GLOBAL_METRICS = 83;
    public static final int OP_GET_LOST_PARTITIONS = 84;
    public static final int OP_QUERY_METRICS = 85;
    public static final int OP_RESET_QUERY_METRICS = 86;
    public static final int OP_PRELOAD_PARTITION = 87;
    public static final int OP_PRELOAD_PARTITION_ASYNC = 88;
    public static final int OP_LOCAL_PRELOAD_PARTITION = 89;
    public static final int OP_SIZE_LONG = 90;
    public static final int OP_SIZE_LONG_ASYNC = 91;
    public static final int OP_SIZE_LONG_LOC = 92;
    public static final int OP_ENABLE_STATISTICS = 93;
    public static final int OP_CLEAR_STATISTICS = 94;
    private static final int OP_PUT_WITH_PLATFORM_CACHE = 95;
    private static final int OP_RESERVE_PARTITION = 96;
    private static final int OP_RELEASE_PARTITION = 97;
    public static final int OP_INVOKE_JAVA = 98;
    public static final int OP_PERSISTENCE_ENABLED = 99;
    private final IgniteCacheProxy cache;
    private final IgniteCache rawCache;
    private final boolean keepBinary;
    private static final PlatformFutureUtils.Writer WRITER_GET_ALL = new GetAllWriter();
    private static final PlatformFutureUtils.Writer WRITER_INVOKE = new EntryProcessorInvokeWriter();
    private static final PlatformFutureUtils.Writer WRITER_INVOKE_ALL = new EntryProcessorInvokeAllWriter();
    private final ConcurrentMap<Long, Lock> lockMap = GridConcurrentFactory.newMap();
    private static final AtomicLong LOCK_ID_GEN = new AtomicLong();
    private final PlatformCacheExtension[] exts;

    public PlatformCache(PlatformContext platformCtx, IgniteCache cache, boolean keepBinary) {
        this(platformCtx, cache, keepBinary, new PlatformCacheExtension[0]);
    }

    public PlatformCache(PlatformContext platformCtx, IgniteCache cache, boolean keepBinary, PlatformCacheExtension[] exts) {
        super(platformCtx);
        assert (cache != null);
        assert (exts != null);
        this.rawCache = cache;
        IgniteCache binCache = cache.withKeepBinary();
        this.cache = (IgniteCacheProxy)binCache;
        this.keepBinary = keepBinary;
        this.exts = exts;
    }

    public IgniteCache rawCache() {
        return this.rawCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader, PlatformMemory mem) throws IgniteCheckedException {
        try {
            switch (type) {
                case 26: {
                    this.cache.put(reader.readObjectDetached(), reader.readObjectDetached());
                    return 1L;
                }
                case 5: {
                    return this.writeResult(mem, this.cache.get(reader.readObjectDetached()));
                }
                case 35: {
                    return this.cache.remove(reader.readObjectDetached(), reader.readObjectDetached()) ? 1L : 0L;
                }
                case 34: {
                    this.cache.removeAll(PlatformUtils.readSet(reader));
                    return 1L;
                }
                case 27: {
                    this.cache.putAll(PlatformUtils.readMap(reader));
                    return 1L;
                }
                case 16: {
                    this.cache.localEvict(PlatformUtils.readCollection(reader));
                    return 1L;
                }
                case 3: {
                    return this.cache.containsKey(reader.readObjectDetached()) ? 1L : 0L;
                }
                case 4: {
                    return this.cache.containsKeys(PlatformUtils.readSet(reader)) ? 1L : 0L;
                }
                case 38: {
                    return this.cache.replace(reader.readObjectDetached(), reader.readObjectDetached(), reader.readObjectDetached()) ? 1L : 0L;
                }
                case 17: {
                    this.loadCache0(reader, true);
                    return 1L;
                }
                case 15: {
                    this.loadCache0(reader, false);
                    return 1L;
                }
                case 1: {
                    this.cache.clear(reader.readObjectDetached());
                    return 1L;
                }
                case 2: {
                    this.cache.clearAll(PlatformUtils.readSet(reader));
                    return 1L;
                }
                case 20: {
                    this.cache.localClear(reader.readObjectDetached());
                    return 1L;
                }
                case 21: {
                    this.cache.localClearAll(PlatformUtils.readSet(reader));
                    return 1L;
                }
                case 28: {
                    return this.cache.putIfAbsent(reader.readObjectDetached(), reader.readObjectDetached()) ? 1L : 0L;
                }
                case 37: {
                    return this.cache.replace(reader.readObjectDetached(), reader.readObjectDetached()) ? 1L : 0L;
                }
                case 36: {
                    return this.cache.remove(reader.readObjectDetached()) ? 1L : 0L;
                }
                case 14: {
                    return this.cache.isLocalLocked(reader.readObjectDetached(), reader.readBoolean()) ? 1L : 0L;
                }
                case 40: {
                    boolean replaceExisting = reader.readBoolean();
                    Set keys = PlatformUtils.readSet(reader);
                    long futId = reader.readLong();
                    int futTyp = reader.readInt();
                    CompletionListenable fut = new CompletionListenable();
                    PlatformFutureUtils.listen(this.platformCtx, fut, futId, futTyp, null, (PlatformTarget)this);
                    this.cache.loadAll(keys, replaceExisting, fut);
                    return 1L;
                }
                case 7: {
                    return this.writeResult(mem, this.cache.getAndPut(reader.readObjectDetached(), reader.readObjectDetached()));
                }
                case 10: {
                    return this.writeResult(mem, this.cache.getAndReplace(reader.readObjectDetached(), reader.readObjectDetached()));
                }
                case 9: {
                    return this.writeResult(mem, this.cache.getAndRemove(reader.readObjectDetached()));
                }
                case 8: {
                    return this.writeResult(mem, this.cache.getAndPutIfAbsent(reader.readObjectDetached(), reader.readObjectDetached()));
                }
                case 25: {
                    Object key = reader.readObjectDetached();
                    CachePeekMode[] modes = PlatformUtils.decodeCachePeekModes(reader.readInt());
                    return this.writeResult(mem, this.cache.localPeek(key, modes));
                }
                case 53: {
                    try {
                        long id = reader.readLong();
                        long timeout = reader.readLong();
                        boolean res = timeout == -1L ? this.lock(id).tryLock() : this.lock(id).tryLock(timeout, TimeUnit.MILLISECONDS);
                        return res ? 1L : 0L;
                    }
                    catch (InterruptedException e) {
                        throw new IgniteCheckedException(e);
                    }
                }
                case 6: {
                    Set keys = PlatformUtils.readSet(reader);
                    Map entries = this.cache.getAll(keys);
                    return this.writeResult(mem, entries, new PlatformWriterClosure<Map>(){

                        @Override
                        public void write(BinaryRawWriterEx writer, Map val) {
                            PlatformUtils.writeNullableMap(writer, val);
                        }
                    });
                }
                case 57: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.putAsync(reader.readObjectDetached(), reader.readObjectDetached()));
                    return 1L;
                }
                case 58: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.clearAsync());
                    return 1L;
                }
                case 59: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.clearAllAsync(PlatformUtils.readSet(reader)));
                    return 1L;
                }
                case 60: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.removeAllAsync());
                    return 1L;
                }
                case 61: {
                    CachePeekMode[] modes = PlatformUtils.decodeCachePeekModes(reader.readInt());
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.sizeAsync(modes));
                    return 1L;
                }
                case 91: {
                    CachePeekMode[] modes = PlatformUtils.decodeCachePeekModes(reader.readInt());
                    Integer part = reader.readBoolean() ? Integer.valueOf(reader.readInt()) : null;
                    this.readAndListenFuture((BinaryRawReader)reader, part != null ? this.cache.sizeLongAsync(part, modes) : this.cache.sizeLongAsync(modes));
                    return 1L;
                }
                case 62: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.clearAsync(reader.readObjectDetached()));
                    return 1L;
                }
                case 63: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.loadCacheAsync0(reader, false));
                    return 1L;
                }
                case 64: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.loadCacheAsync0(reader, true));
                    return 1L;
                }
                case 65: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.putAllAsync(PlatformUtils.readMap(reader)));
                    return 1L;
                }
                case 66: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.removeAllAsync(PlatformUtils.readSet(reader)));
                    return 1L;
                }
                case 55: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.rebalance());
                    return 1L;
                }
                case 67: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.getAsync(reader.readObjectDetached()));
                    return 1L;
                }
                case 68: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.containsKeyAsync(reader.readObjectDetached()));
                    return 1L;
                }
                case 69: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.containsKeysAsync(PlatformUtils.readSet(reader)));
                    return 1L;
                }
                case 71: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.removeAsync(reader.readObjectDetached()));
                    return 1L;
                }
                case 70: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.removeAsync(reader.readObjectDetached(), reader.readObjectDetached()));
                    return 1L;
                }
                case 72: {
                    Set keys = PlatformUtils.readSet(reader);
                    this.readAndListenFuture(reader, this.cache.getAllAsync(keys), WRITER_GET_ALL);
                    return 1L;
                }
                case 73: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.getAndPutAsync(reader.readObjectDetached(), reader.readObjectDetached()));
                    return 1L;
                }
                case 74: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.getAndPutIfAbsentAsync(reader.readObjectDetached(), reader.readObjectDetached()));
                    return 1L;
                }
                case 75: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.getAndRemoveAsync(reader.readObjectDetached()));
                    return 1L;
                }
                case 76: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.getAndReplaceAsync(reader.readObjectDetached(), reader.readObjectDetached()));
                    return 1L;
                }
                case 77: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.replaceAsync(reader.readObjectDetached(), reader.readObjectDetached()));
                    return 1L;
                }
                case 78: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.replaceAsync(reader.readObjectDetached(), reader.readObjectDetached(), reader.readObjectDetached()));
                    return 1L;
                }
                case 79: {
                    Object key = reader.readObjectDetached();
                    long ptr = reader.readLong();
                    PlatformCacheEntryProcessor proc = this.platformCtx.createCacheEntryProcessor(reader.readObjectDetached(), ptr);
                    this.readAndListenFuture(reader, this.cache.invokeAsync(key, proc, new Object[0]), WRITER_INVOKE);
                    return 1L;
                }
                case 80: {
                    Set keys = PlatformUtils.readSet(reader);
                    long ptr = reader.readLong();
                    PlatformCacheEntryProcessor proc = this.platformCtx.createCacheEntryProcessor(reader.readObjectDetached(), ptr);
                    this.readAndListenFuture(reader, this.cache.invokeAllAsync(keys, proc, new Object[0]), WRITER_INVOKE_ALL);
                    return 1L;
                }
                case 81: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.putIfAbsentAsync(reader.readObjectDetached(), reader.readObjectDetached()));
                    return 1L;
                }
                case 12: {
                    Object key = reader.readObjectDetached();
                    long ptr = reader.readLong();
                    PlatformCacheEntryProcessor proc = this.platformCtx.createCacheEntryProcessor(reader.readObjectDetached(), ptr);
                    return this.writeResult(mem, this.cache.invoke(key, proc, new Object[0]));
                }
                case 13: {
                    Set keys = PlatformUtils.readSet(reader);
                    long ptr = reader.readLong();
                    PlatformCacheEntryProcessor proc = this.platformCtx.createCacheEntryProcessor(reader.readObjectDetached(), ptr);
                    Map results = this.cache.invokeAll(keys, proc, new Object[0]);
                    return this.writeResult(mem, results, new PlatformWriterClosure<Map>(){

                        @Override
                        public void write(BinaryRawWriterEx writer, Map val) {
                            PlatformCache.writeInvokeAllResult(writer, val);
                        }
                    });
                }
                case 98: {
                    String procName = reader.readString();
                    Object key = reader.readObjectDetached();
                    Object arg = reader.readObjectDetached();
                    GridDeployment dep = this.cache.context().kernalContext().deploy().getDeployment(procName);
                    if (dep == null) {
                        throw new IgniteDeploymentCheckedException("Unknown CacheEntryProcessor name or failed to auto-deploy entry processor (was entry processor (re|un)deployed?): " + procName);
                    }
                    IgniteBiTuple<Class<?>, Throwable> procCls = dep.deployedClass(procName, new String[0]);
                    if (procCls.get1() == null) {
                        throw new IgniteDeploymentCheckedException("Unknown CacheEntryProcessor name or failed to auto-deploy entry processor (was entry processor (re|un)deployed?) [procName=" + procName + ", dep=" + dep + ']', procCls.get2());
                    }
                    if (!CacheEntryProcessor.class.isAssignableFrom(procCls.get1())) {
                        throw new IgniteCheckedException("Failed to auto-deploy entry processor (deployed class is not an entry processor) [procName=" + procName + ", depCls=" + procCls + ']');
                    }
                    CacheEntryProcessor proc = (CacheEntryProcessor)PlatformUtils.createJavaObject(procName);
                    return this.writeResult(mem, this.cache.invoke(key, proc, arg));
                }
                case 22: {
                    long id = this.registerLock(this.cache.lock(reader.readObjectDetached()));
                    return this.writeResult(mem, id, new PlatformWriterClosure<Long>(){

                        @Override
                        public void write(BinaryRawWriterEx writer, Long val) {
                            writer.writeLong(val);
                        }
                    });
                }
                case 23: {
                    long id = this.registerLock(this.cache.lockAll(PlatformUtils.readCollection(reader)));
                    return this.writeResult(mem, id, new PlatformWriterClosure<Long>(){

                        @Override
                        public void write(BinaryRawWriterEx writer, Long val) {
                            writer.writeLong(val);
                        }
                    });
                }
                case 82: {
                    PlatformCacheExtension ext = this.extension(reader.readInt());
                    return ext.processInOutStreamLong(this, reader.readInt(), reader, mem);
                }
                case 88: {
                    this.readAndListenFuture((BinaryRawReader)reader, this.cache.preloadPartitionAsync(reader.readInt()));
                    return 1L;
                }
                case 89: {
                    return this.cache.localPreloadPartition(reader.readInt()) ? 1L : 0L;
                }
                case 90: 
                case 92: {
                    Integer part;
                    CachePeekMode[] modes = PlatformUtils.decodeCachePeekModes(reader.readInt());
                    Integer n = part = reader.readBoolean() ? Integer.valueOf(reader.readInt()) : null;
                    if (type == 90) {
                        return part != null ? this.cache.sizeLong(part, modes) : this.cache.sizeLong(modes);
                    }
                    return part != null ? this.cache.localSizeLong(part, modes) : this.cache.localSizeLong(modes);
                }
                case 95: {
                    this.platformCtx.enableThreadLocalForPlatformCacheUpdate();
                    try {
                        this.cache.put(reader.readObjectDetached(), reader.readObjectDetached());
                    }
                    finally {
                        this.platformCtx.disableThreadLocalForPlatformCacheUpdate();
                    }
                    return 1L;
                }
            }
        }
        catch (Exception e) {
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            Exception err = this.convertException(e);
            PlatformUtils.writeError(err, writer);
            PlatformUtils.writeErrorData(err, writer);
            out.synchronize();
            return -1L;
        }
        return super.processInStreamOutLong(type, reader, mem);
    }

    public long writeResult(PlatformMemory mem, Object obj) {
        return this.writeResult(mem, obj, null);
    }

    public long writeResult(PlatformMemory mem, Object obj, PlatformWriterClosure clo) {
        if (obj == null) {
            return 0L;
        }
        PlatformOutputStream out = mem.output();
        BinaryRawWriterEx writer = this.platformCtx.writer(out);
        if (clo == null) {
            writer.writeObjectDetached(obj);
        } else {
            clo.write(writer, obj);
        }
        out.synchronize();
        return 1L;
    }

    private void loadCache0(BinaryRawReaderEx reader, boolean loc) {
        PlatformCacheEntryFilter filter = this.createPlatformCacheEntryFilter(reader);
        Object[] args = this.readLoadCacheArgs(reader);
        if (loc) {
            this.cache.localLoadCache(filter, args);
        } else {
            this.cache.loadCache(filter, args);
        }
    }

    private IgniteFuture<Void> loadCacheAsync0(BinaryRawReaderEx reader, boolean loc) {
        PlatformCacheEntryFilter filter = this.createPlatformCacheEntryFilter(reader);
        Object[] args = this.readLoadCacheArgs(reader);
        if (loc) {
            return this.cache.localLoadCacheAsync(filter, args);
        }
        return this.cache.loadCacheAsync(filter, args);
    }

    @Nullable
    private PlatformCacheEntryFilter createPlatformCacheEntryFilter(BinaryRawReaderEx reader) {
        PlatformCacheEntryFilter filter = null;
        Object pred = reader.readObjectDetached();
        if (pred != null) {
            filter = this.platformCtx.createCacheEntryFilter(pred, 0L);
        }
        return filter;
    }

    @Nullable
    private Object[] readLoadCacheArgs(BinaryRawReaderEx reader) {
        Object[] args = null;
        int argCnt = reader.readInt();
        if (argCnt > 0) {
            args = new Object[argCnt];
            for (int i = 0; i < argCnt; ++i) {
                args[i] = reader.readObjectDetached();
            }
        }
        return args;
    }

    @Override
    public PlatformTarget processInStreamOutObject(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 31: {
                return this.runQuery(this.readSqlQuery(reader));
            }
            case 32: {
                return this.runFieldsQuery(this.readFieldsQuery(reader));
            }
            case 33: {
                return this.runQuery(this.readTextQuery(reader));
            }
            case 30: {
                return this.runQuery(this.readScanQuery(reader));
            }
            case 29: {
                long ptr = reader.readLong();
                boolean loc = reader.readBoolean();
                boolean includeExpired = reader.readBoolean();
                boolean hasFilter = reader.readBoolean();
                Object filter = reader.readObjectDetached();
                int bufSize = reader.readInt();
                long timeInterval = reader.readLong();
                boolean autoUnsubscribe = reader.readBoolean();
                Query initQry = this.readInitialQuery(reader);
                PlatformContinuousQuery qry = this.platformCtx.createContinuousQuery(ptr, hasFilter, filter);
                qry.start(this.cache, loc, bufSize, timeInterval, autoUnsubscribe, initQry, includeExpired);
                return new PlatformContinuousQueryProxy(this.platformCtx, qry);
            }
            case 45: {
                long create = reader.readLong();
                long update = reader.readLong();
                long access = reader.readLong();
                IgniteCache cache0 = this.rawCache.withExpiryPolicy(new PlatformExpiryPolicy(create, update, access));
                return this.copy(cache0, this.keepBinary);
            }
            case 50: {
                int peekModes = reader.readInt();
                CachePeekMode[] peekModes0 = PlatformUtils.decodeCachePeekModes(peekModes);
                Iterator<Cache.Entry> iter = this.cache.localEntries(peekModes0).iterator();
                return new PlatformCacheIterator(this.platformCtx, iter);
            }
        }
        return super.processInStreamOutObject(type, reader);
    }

    @Nullable
    public static Object[] readQueryArgs(BinaryRawReaderEx reader) {
        int cnt = reader.readInt();
        if (cnt > 0) {
            Object[] args = new Object[cnt];
            for (int i = 0; i < cnt; ++i) {
                args[i] = reader.readObjectDetached();
            }
            return args;
        }
        return null;
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 11: {
                writer.writeObject(this.cache.getName());
                break;
            }
            case 24: {
                CacheMetrics metrics = this.cache.localMetrics();
                PlatformCache.writeCacheMetrics(writer, metrics);
                break;
            }
            case 83: {
                CacheMetrics metrics = this.cache.metrics();
                PlatformCache.writeCacheMetrics(writer, metrics);
                break;
            }
            case 39: {
                CacheConfiguration ccfg = this.cache.getConfiguration(CacheConfiguration.class);
                PlatformConfigurationUtils.writeCacheConfiguration(writer, ccfg);
                break;
            }
            case 84: {
                Collection<Integer> parts = this.cache.lostPartitions();
                writer.writeInt(parts.size());
                for (int p : parts) {
                    writer.writeInt(p);
                }
                break;
            }
            case 85: {
                QueryMetrics metrics = this.cache.queryMetrics();
                PlatformCache.writeQueryMetrics(writer, metrics);
                break;
            }
            default: {
                super.processOutStream(type, writer);
            }
        }
    }

    @Override
    public PlatformTarget processOutObject(int type) throws IgniteCheckedException {
        switch (type) {
            case 42: {
                return this.copy(this.rawCache.withPartitionRecover(), this.keepBinary);
            }
            case 44: {
                if (this.keepBinary) {
                    return this;
                }
                return this.copy(this.rawCache.withKeepBinary(), true);
            }
            case 46: {
                CacheOperationContext opCtx = this.cache.context().operationContextPerCall();
                if (opCtx != null && opCtx.noRetries()) {
                    return this;
                }
                return this.copy(this.rawCache.withNoRetries(), this.keepBinary);
            }
            case 47: {
                CacheOperationContext opCtx = this.cache.context().operationContextPerCall();
                if (opCtx != null && opCtx.skipStore()) {
                    return this;
                }
                return this.copy(this.rawCache.withSkipStore(), this.keepBinary);
            }
            case 49: {
                Iterator<Cache.Entry> iter = this.cache.iterator();
                return new PlatformCacheIterator(this.platformCtx, iter);
            }
        }
        return super.processOutObject(type);
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 48: {
                CachePeekMode[] modes = PlatformUtils.decodeCachePeekModes((int)val);
                return this.cache.size(modes);
            }
            case 56: {
                CachePeekMode[] modes = PlatformUtils.decodeCachePeekModes((int)val);
                return this.cache.localSize(modes);
            }
            case 51: {
                try {
                    this.lock(val).lockInterruptibly();
                    return 1L;
                }
                catch (InterruptedException e) {
                    throw new IgniteCheckedException("Failed to enter cache lock.", e);
                }
            }
            case 52: {
                this.lock(val).unlock();
                return 1L;
            }
            case 54: {
                Lock lock = (Lock)this.lockMap.remove(val);
                assert (lock != null) : "Failed to unregister lock: " + val;
                return 1L;
            }
            case 55: {
                PlatformFutureUtils.listen(this.platformCtx, this.cache.rebalance().chain(new C1<IgniteFuture, Object>(){

                    @Override
                    public Object apply(IgniteFuture fut) {
                        return null;
                    }
                }), val, 9, (PlatformTarget)this);
                return 1L;
            }
            case 41: {
                this.cache.clear();
                return 1L;
            }
            case 43: {
                this.cache.removeAll();
                return 1L;
            }
            case 86: {
                this.cache.resetQueryMetrics();
                return 1L;
            }
            case 87: {
                this.cache.preloadPartition((int)val);
                return 1L;
            }
            case 93: {
                this.cache.enableStatistics(val == 1L);
                return 1L;
            }
            case 94: {
                this.cache.clearStatistics();
                return 1L;
            }
            case 96: {
                GridDhtLocalPartition locPart = this.getLocalPartition((int)val);
                return locPart != null && locPart.reserve() ? 1L : 0L;
            }
            case 97: {
                GridDhtLocalPartition locPart = this.getLocalPartition((int)val);
                if (locPart != null) {
                    locPart.release();
                    return 1L;
                }
                return 0L;
            }
            case 99: {
                return this.cache.context().group().persistenceEnabled() ? 1L : 0L;
            }
        }
        return super.processInLongOutLong(type, val);
    }

    @Override
    public Exception convertException(Exception e) {
        if (e instanceof CachePartialUpdateException) {
            return new PlatformCachePartialUpdateException((CachePartialUpdateCheckedException)e.getCause(), this.platformCtx, this.keepBinary);
        }
        if (e instanceof CachePartialUpdateCheckedException) {
            return new PlatformCachePartialUpdateException((CachePartialUpdateCheckedException)e, this.platformCtx, this.keepBinary);
        }
        if (e.getCause() instanceof EntryProcessorException) {
            return (Exception)e.getCause();
        }
        TransactionDeadlockException deadlockException = X.cause(e, TransactionDeadlockException.class);
        if (deadlockException != null) {
            return deadlockException;
        }
        TransactionTimeoutException timeoutException = X.cause(e, TransactionTimeoutException.class);
        if (timeoutException != null) {
            return timeoutException;
        }
        return super.convertException(e);
    }

    private static void writeInvokeAllResult(BinaryRawWriterEx writer, Map<Object, EntryProcessorResult> results) {
        if (results == null) {
            writer.writeInt(-1);
            return;
        }
        writer.writeInt(results.size());
        for (Map.Entry<Object, EntryProcessorResult> entry : results.entrySet()) {
            writer.writeObjectDetached(entry.getKey());
            EntryProcessorResult procRes = entry.getValue();
            try {
                Object res = procRes.get();
                writer.writeBoolean(false);
                writer.writeObjectDetached(res);
            }
            catch (Exception ex) {
                writer.writeBoolean(true);
                PlatformUtils.writeError(ex, writer);
            }
        }
    }

    private static void writeError(BinaryRawWriterEx writer, Exception ex) {
        if (ex.getCause() instanceof PlatformNativeException) {
            writer.writeObjectDetached(((PlatformNativeException)ex.getCause()).cause());
        } else {
            writer.writeObjectDetached(ex.getClass().getName());
            writer.writeObjectDetached(ex.getMessage());
            writer.writeObjectDetached(X.getFullStackTrace(ex));
        }
    }

    private Lock lock(long id) {
        Lock lock = (Lock)this.lockMap.get(id);
        assert (lock != null) : "Lock not found for ID: " + id;
        return lock;
    }

    private long registerLock(Lock lock) {
        long id = LOCK_ID_GEN.incrementAndGet();
        this.lockMap.put(id, lock);
        return id;
    }

    private PlatformQueryCursor runQuery(Query qry) throws IgniteCheckedException {
        try {
            QueryCursorEx cursor = (QueryCursorEx)this.cache.query(qry);
            return new PlatformQueryCursor(this.platformCtx, cursor, qry.getPageSize() > 0 ? qry.getPageSize() : 1024);
        }
        catch (Exception err) {
            throw PlatformUtils.unwrapQueryException(err);
        }
    }

    private PlatformFieldsQueryCursor runFieldsQuery(Query qry) throws IgniteCheckedException {
        try {
            QueryCursorEx cursor = (QueryCursorEx)this.cache.query(qry);
            return new PlatformFieldsQueryCursor(this.platformCtx, cursor, qry.getPageSize() > 0 ? qry.getPageSize() : 1024);
        }
        catch (Exception err) {
            throw PlatformUtils.unwrapQueryException(err);
        }
    }

    private Query readInitialQuery(BinaryRawReaderEx reader) throws IgniteCheckedException {
        int typ = reader.readInt();
        switch (typ) {
            case -1: {
                return null;
            }
            case 30: {
                return this.readScanQuery(reader);
            }
            case 31: {
                return this.readSqlQuery(reader);
            }
            case 33: {
                return this.readTextQuery(reader);
            }
            case 32: {
                return this.readFieldsQuery(reader);
            }
        }
        throw new IgniteCheckedException("Unsupported query type: " + typ);
    }

    private Query readSqlQuery(BinaryRawReaderEx reader) {
        boolean loc = reader.readBoolean();
        String sql = reader.readString();
        String typ = reader.readString();
        int pageSize = reader.readInt();
        Object[] args = PlatformCache.readQueryArgs(reader);
        boolean distrJoins = reader.readBoolean();
        int timeout = reader.readInt();
        boolean replicated = reader.readBoolean();
        return ((SqlQuery)((SqlQuery)new SqlQuery(typ, sql).setPageSize(pageSize)).setArgs(args).setLocal(loc)).setDistributedJoins(distrJoins).setTimeout(timeout, TimeUnit.MILLISECONDS).setReplicatedOnly(replicated);
    }

    private Query readFieldsQuery(BinaryRawReaderEx reader) {
        boolean loc = reader.readBoolean();
        String sql = reader.readString();
        int pageSize = reader.readInt();
        Object[] args = PlatformCache.readQueryArgs(reader);
        boolean distrJoins = reader.readBoolean();
        boolean enforceJoinOrder = reader.readBoolean();
        boolean lazy = reader.readBoolean();
        int timeout = reader.readInt();
        boolean replicated = reader.readBoolean();
        boolean collocated = reader.readBoolean();
        String schema = reader.readString();
        int[] partitions = reader.readIntArray();
        int updateBatchSize = reader.readInt();
        SqlFieldsQuery qry = QueryUtils.withQueryTimeout(new SqlFieldsQuery(sql), timeout, TimeUnit.MILLISECONDS).setPageSize(pageSize).setArgs(args).setLocal(loc).setDistributedJoins(distrJoins).setEnforceJoinOrder(enforceJoinOrder).setLazy(lazy).setReplicatedOnly(replicated).setCollocated(collocated).setSchema(schema).setPartitions(partitions).setUpdateBatchSize(updateBatchSize);
        return qry;
    }

    private Query readTextQuery(BinaryRawReader reader) {
        boolean loc = reader.readBoolean();
        String txt = reader.readString();
        String typ = reader.readString();
        int pageSize = reader.readInt();
        return ((TextQuery)new TextQuery(typ, txt).setPageSize(pageSize)).setLocal(loc);
    }

    private Query readScanQuery(BinaryRawReaderEx reader) {
        boolean loc = reader.readBoolean();
        int pageSize = reader.readInt();
        boolean hasPart = reader.readBoolean();
        Integer part = hasPart ? Integer.valueOf(reader.readInt()) : null;
        Query qry = new ScanQuery().setPageSize(pageSize);
        ((ScanQuery)qry).setPartition(part);
        Object pred = reader.readObjectDetached();
        if (pred != null) {
            ((ScanQuery)qry).setFilter(this.platformCtx.createCacheEntryFilter(pred, 0L));
        }
        ((ScanQuery)qry).setLocal(loc);
        return qry;
    }

    private PlatformCache copy(IgniteCache cache, boolean keepBinary) {
        return new PlatformCache(this.platformCtx, cache, keepBinary, this.exts);
    }

    private PlatformCacheExtension extension(int id) {
        PlatformCacheExtension ext;
        if (this.exts != null && id < this.exts.length && (ext = this.exts[id]) != null) {
            return ext;
        }
        throw new IgniteException("Platform cache extension is not registered [id=" + id + ']');
    }

    public static void writeCacheMetrics(BinaryRawWriter writer, CacheMetrics metrics) {
        assert (writer != null);
        assert (metrics != null);
        writer.writeLong(metrics.getCacheHits());
        writer.writeFloat(metrics.getCacheHitPercentage());
        writer.writeLong(metrics.getCacheMisses());
        writer.writeFloat(metrics.getCacheMissPercentage());
        writer.writeLong(metrics.getCacheGets());
        writer.writeLong(metrics.getCachePuts());
        writer.writeLong(metrics.getCacheRemovals());
        writer.writeLong(metrics.getCacheEvictions());
        writer.writeFloat(metrics.getAverageGetTime());
        writer.writeFloat(metrics.getAveragePutTime());
        writer.writeFloat(metrics.getAverageRemoveTime());
        writer.writeFloat(metrics.getAverageTxCommitTime());
        writer.writeFloat(metrics.getAverageTxRollbackTime());
        writer.writeLong(metrics.getCacheTxCommits());
        writer.writeLong(metrics.getCacheTxRollbacks());
        writer.writeString(metrics.name());
        writer.writeLong(metrics.getOffHeapGets());
        writer.writeLong(metrics.getOffHeapPuts());
        writer.writeLong(metrics.getOffHeapRemovals());
        writer.writeLong(metrics.getOffHeapEvictions());
        writer.writeLong(metrics.getOffHeapHits());
        writer.writeFloat(metrics.getOffHeapHitPercentage());
        writer.writeLong(metrics.getOffHeapMisses());
        writer.writeFloat(metrics.getOffHeapMissPercentage());
        writer.writeLong(metrics.getOffHeapEntriesCount());
        writer.writeLong(metrics.getOffHeapPrimaryEntriesCount());
        writer.writeLong(metrics.getOffHeapBackupEntriesCount());
        writer.writeLong(metrics.getOffHeapAllocatedSize());
        writer.writeInt(metrics.getSize());
        writer.writeInt(metrics.getKeySize());
        writer.writeBoolean(metrics.isEmpty());
        writer.writeInt(metrics.getDhtEvictQueueCurrentSize());
        writer.writeInt(metrics.getTxThreadMapSize());
        writer.writeInt(metrics.getTxXidMapSize());
        writer.writeInt(metrics.getTxCommitQueueSize());
        writer.writeInt(metrics.getTxPrepareQueueSize());
        writer.writeInt(metrics.getTxStartVersionCountsSize());
        writer.writeInt(metrics.getTxCommittedVersionsSize());
        writer.writeInt(metrics.getTxRolledbackVersionsSize());
        writer.writeInt(metrics.getTxDhtThreadMapSize());
        writer.writeInt(metrics.getTxDhtXidMapSize());
        writer.writeInt(metrics.getTxDhtCommitQueueSize());
        writer.writeInt(metrics.getTxDhtPrepareQueueSize());
        writer.writeInt(metrics.getTxDhtStartVersionCountsSize());
        writer.writeInt(metrics.getTxDhtCommittedVersionsSize());
        writer.writeInt(metrics.getTxDhtRolledbackVersionsSize());
        writer.writeBoolean(metrics.isWriteBehindEnabled());
        writer.writeInt(metrics.getWriteBehindFlushSize());
        writer.writeInt(metrics.getWriteBehindFlushThreadCount());
        writer.writeLong(metrics.getWriteBehindFlushFrequency());
        writer.writeInt(metrics.getWriteBehindStoreBatchSize());
        writer.writeInt(metrics.getWriteBehindTotalCriticalOverflowCount());
        writer.writeInt(metrics.getWriteBehindCriticalOverflowCount());
        writer.writeInt(metrics.getWriteBehindErrorRetryCount());
        writer.writeInt(metrics.getWriteBehindBufferSize());
        writer.writeString(metrics.getKeyType());
        writer.writeString(metrics.getValueType());
        writer.writeBoolean(metrics.isStoreByValue());
        writer.writeBoolean(metrics.isStatisticsEnabled());
        writer.writeBoolean(metrics.isManagementEnabled());
        writer.writeBoolean(metrics.isReadThrough());
        writer.writeBoolean(metrics.isWriteThrough());
        writer.writeBoolean(metrics.isValidForReading());
        writer.writeBoolean(metrics.isValidForWriting());
        writer.writeInt(metrics.getTotalPartitionsCount());
        writer.writeInt(metrics.getRebalancingPartitionsCount());
        writer.writeLong(metrics.getKeysToRebalanceLeft());
        writer.writeLong(metrics.getRebalancingKeysRate());
        writer.writeLong(metrics.getRebalancingBytesRate());
        writer.writeLong(metrics.getHeapEntriesCount());
        writer.writeLong(metrics.getEstimatedRebalancingFinishTime());
        writer.writeLong(metrics.getRebalancingStartTime());
        writer.writeLong(metrics.getRebalanceClearingPartitionsLeft());
        writer.writeLong(metrics.getCacheSize());
        writer.writeLong(metrics.getRebalancedKeys());
        writer.writeLong(metrics.getEstimatedRebalancingKeys());
        writer.writeLong(metrics.getEntryProcessorPuts());
        writer.writeFloat(metrics.getEntryProcessorAverageInvocationTime());
        writer.writeLong(metrics.getEntryProcessorInvocations());
        writer.writeFloat(metrics.getEntryProcessorMaxInvocationTime());
        writer.writeFloat(metrics.getEntryProcessorMinInvocationTime());
        writer.writeLong(metrics.getEntryProcessorReadOnlyInvocations());
        writer.writeFloat(metrics.getEntryProcessorHitPercentage());
        writer.writeLong(metrics.getEntryProcessorHits());
        writer.writeLong(metrics.getEntryProcessorMisses());
        writer.writeFloat(metrics.getEntryProcessorMissPercentage());
        writer.writeLong(metrics.getEntryProcessorRemovals());
    }

    public static void writeQueryMetrics(BinaryRawWriter writer, QueryMetrics metrics) {
        assert (writer != null);
        assert (metrics != null);
        writer.writeLong(metrics.minimumTime());
        writer.writeLong(metrics.maximumTime());
        writer.writeDouble(metrics.averageTime());
        writer.writeInt(metrics.executions());
        writer.writeInt(metrics.fails());
    }

    private GridDhtLocalPartition getLocalPartition(int part) throws IgniteCheckedException {
        GridCacheContext cctx = this.cache.context();
        if (part < 0 || part >= cctx.affinity().partitions()) {
            throw new IgniteCheckedException("Invalid partition number: " + part);
        }
        GridDhtPartitionTopology top = cctx.topology();
        AffinityTopologyVersion ver = top.readyTopologyVersion();
        return top.localPartition(part, ver, false);
    }

    private static class CompletionListenable
    implements PlatformListenable,
    CompletionListener {
        private IgniteBiInClosure<Object, Throwable> lsnr;

        private CompletionListenable() {
        }

        @Override
        public void onCompletion() {
            assert (this.lsnr != null);
            this.lsnr.apply(null, null);
        }

        @Override
        public void onException(Exception e) {
            this.lsnr.apply(null, e);
        }

        @Override
        public void listen(IgniteBiInClosure<Object, Throwable> lsnr) {
            this.lsnr = lsnr;
        }

        @Override
        public boolean cancel() throws IgniteCheckedException {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }

    private static class EntryProcessorInvokeAllWriter
    implements PlatformFutureUtils.Writer {
        private EntryProcessorInvokeAllWriter() {
        }

        @Override
        public void write(BinaryRawWriterEx writer, Object obj, Throwable err) {
            PlatformCache.writeInvokeAllResult(writer, (Map)obj);
        }

        @Override
        public boolean canWrite(Object obj, Throwable err) {
            return obj != null && err == null;
        }
    }

    private static class EntryProcessorInvokeWriter
    implements PlatformFutureUtils.Writer {
        private EntryProcessorInvokeWriter() {
        }

        @Override
        public void write(BinaryRawWriterEx writer, Object obj, Throwable err) {
            if (err == null) {
                writer.writeBoolean(false);
                writer.writeObjectDetached(obj);
            } else {
                writer.writeBoolean(true);
                PlatformUtils.writeError(err, writer);
            }
        }

        @Override
        public boolean canWrite(Object obj, Throwable err) {
            return true;
        }
    }

    private static class GetAllWriter
    implements PlatformFutureUtils.Writer {
        private GetAllWriter() {
        }

        @Override
        public void write(BinaryRawWriterEx writer, Object obj, Throwable err) {
            assert (obj instanceof Map);
            PlatformUtils.writeNullableMap(writer, (Map)obj);
        }

        @Override
        public boolean canWrite(Object obj, Throwable err) {
            return err == null;
        }
    }
}

