/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.spi.metric.HistogramMetric;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

public class MetricUtils {
    public static final String SEPARATOR = ".";
    public static final String INF = "_inf";
    public static final char HISTOGRAM_NAME_DIVIDER = '_';

    public static String metricName(String ... names) {
        assert (names != null);
        assert (MetricUtils.ensureAllNamesNotEmpty(names));
        if (names.length == 1) {
            return names[0];
        }
        return String.join((CharSequence)SEPARATOR, names);
    }

    public static T2<String, String> fromFullName(String name) {
        return new T2<String, String>(name.substring(0, name.lastIndexOf(SEPARATOR)), name.substring(name.lastIndexOf(SEPARATOR) + 1));
    }

    public static String cacheMetricsRegistryName(String cacheName, boolean isNear) {
        if (isNear) {
            return MetricUtils.metricName("cache", cacheName, "near");
        }
        return MetricUtils.metricName("cache", cacheName);
    }

    public static String cacheGroupMetricsRegistryName(String cacheOrGroupName) {
        return MetricUtils.metricName("cacheGroups", cacheOrGroupName);
    }

    public static boolean compareAndSet(AtomicLongMetric m4, long expect, long update) {
        return AtomicLongMetric.updater.compareAndSet(m4, expect, update);
    }

    public static void setIfLess(AtomicLongMetric m4, long update) {
        long v = m4.value();
        while (v > update && !AtomicLongMetric.updater.compareAndSet(m4, v, update)) {
            v = m4.value();
        }
    }

    public static void setIfGreater(AtomicLongMetric m4, long update) {
        long v = m4.value();
        while (v < update && !AtomicLongMetric.updater.compareAndSet(m4, v, update)) {
            v = m4.value();
        }
    }

    private static boolean ensureAllNamesNotEmpty(String ... names) {
        for (int i = 0; i < names.length; ++i) {
            assert (names[i] != null && !names[i].isEmpty()) : i + " element is empty [" + String.join((CharSequence)".", names) + "]";
        }
        return true;
    }

    public static String[] histogramBucketNames(HistogramMetric metric) {
        String name = metric.name();
        long[] bounds = metric.bounds();
        String[] names = new String[bounds.length + 1];
        long min2 = 0L;
        for (int i = 0; i < bounds.length; ++i) {
            names[i] = name + '_' + min2 + '_' + bounds[i];
            min2 = bounds[i];
        }
        names[bounds.length] = name + '_' + min2 + INF;
        return names;
    }

    public static String toSqlName(String name) {
        return name.replaceAll("([A-Z])", "_$1").replaceAll("\\.", "_").toUpperCase();
    }

    public static Map<String, Class<?>> systemViewAttributes(SystemView<?> sysView) {
        final LinkedHashMap attrs = new LinkedHashMap(sysView.walker().count());
        sysView.walker().visitAll(new SystemViewRowAttributeWalker.AttributeVisitor(){

            @Override
            public <T> void accept(int idx, String name, Class<T> clazz) {
                attrs.put(name, clazz);
            }
        });
        return attrs;
    }
}

