/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.GridBoundedLinkedHashMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;

public class GridCacheAnnotationHelper<A extends Annotation> {
    private static final int DFLT_CLASS_CACHE_SIZE = 1000;
    private final GridBoundedLinkedHashMap<Class<?>, List<Field>> fieldCache;
    private final GridBoundedLinkedHashMap<Class<?>, List<Method>> mtdCache;
    private final Class<A> annCls;
    private final Object mux = new Object();

    public GridCacheAnnotationHelper(Class<A> annCls) {
        this(annCls, 1000);
    }

    public GridCacheAnnotationHelper(Class<A> annCls, int capacity) {
        assert (annCls != null) : "Annotated class mustn't be null.";
        assert (capacity > 0) : "Capacity must be more then zero.";
        this.annCls = annCls;
        this.fieldCache = new GridBoundedLinkedHashMap(capacity);
        this.mtdCache = new GridBoundedLinkedHashMap(capacity);
    }

    public Object annotatedValue(Object target) throws IgniteCheckedException {
        IgniteBiTuple<Object, Boolean> res = this.annotatedValue(target, new HashSet<Object>(), false);
        assert (res != null);
        return res.get1();
    }

    private IgniteBiTuple<Object, Boolean> annotatedValue(Object target, Set<Object> visited, boolean annFound) throws IgniteCheckedException {
        assert (target != null);
        if (visited.contains(target)) {
            return F.t(null, annFound);
        }
        visited.add(target);
        Object val = null;
        Class<?> cls = target.getClass();
        while (!cls.equals(Object.class)) {
            for (Field f : this.fieldsWithAnnotation(cls)) {
                Object fieldVal;
                f.setAccessible(true);
                try {
                    fieldVal = f.get(target);
                }
                catch (IllegalAccessException e) {
                    throw new IgniteCheckedException("Failed to get annotated field value [cls=" + cls.getName() + ", ann=" + this.annCls.getSimpleName() + ']', e);
                }
                if (this.needsRecursion(f)) {
                    if (fieldVal == null) continue;
                    IgniteBiTuple<Object, Boolean> tup = this.annotatedValue(fieldVal, visited, annFound);
                    if (!annFound && tup.get2().booleanValue()) {
                        val = tup.get1();
                    }
                    annFound = tup.get2();
                    continue;
                }
                if (annFound) {
                    throw new IgniteCheckedException("Multiple annotations has been found [cls=" + cls.getName() + ", ann=" + this.annCls.getSimpleName() + ']');
                }
                val = fieldVal;
                annFound = true;
            }
            for (Method m4 : this.methodsWithAnnotation(cls)) {
                if (annFound) {
                    throw new IgniteCheckedException("Multiple annotations has been found [cls=" + cls.getName() + ", ann=" + this.annCls.getSimpleName() + ']');
                }
                m4.setAccessible(true);
                try {
                    val = m4.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    throw new IgniteCheckedException("Failed to get annotated method value [cls=" + cls.getName() + ", ann=" + this.annCls.getSimpleName() + ']', e);
                }
                annFound = true;
            }
            cls = cls.getSuperclass();
        }
        return F.t(val, annFound);
    }

    private boolean needsRecursion(Field f) {
        assert (f != null);
        return f.getName().startsWith("this$") || f.getName().startsWith("val$") || Callable.class.isAssignableFrom(f.getType()) || Runnable.class.isAssignableFrom(f.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Field> fieldsWithAnnotation(Class<?> cls) {
        Object object = this.mux;
        synchronized (object) {
            ArrayList<Field> fields = (ArrayList<Field>)this.fieldCache.get(cls);
            if (fields == null) {
                fields = new ArrayList<Field>();
                for (Field field : cls.getDeclaredFields()) {
                    A ann = field.getAnnotation(this.annCls);
                    if (ann == null && !this.needsRecursion(field)) continue;
                    fields.add(field);
                }
                if (!fields.isEmpty()) {
                    this.fieldCache.put(cls, fields);
                }
            }
            return fields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Method> methodsWithAnnotation(Class<?> cls) {
        Object object = this.mux;
        synchronized (object) {
            ArrayList<Method> mtds = (ArrayList<Method>)this.mtdCache.get(cls);
            if (mtds == null) {
                mtds = new ArrayList<Method>();
                for (Method mtd : cls.getDeclaredMethods()) {
                    A ann = mtd.getAnnotation(this.annCls);
                    if (ann == null) continue;
                    mtds.add(mtd);
                }
                if (!mtds.isEmpty()) {
                    this.mtdCache.put(cls, mtds);
                }
            }
            return mtds;
        }
    }
}

