/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.tree.AbstractDataInnerIO;
import org.apache.ignite.internal.processors.cache.tree.AbstractDataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.CacheDataRowStore;
import org.apache.ignite.internal.processors.cache.tree.CacheIdAwareDataInnerIO;
import org.apache.ignite.internal.processors.cache.tree.CacheIdAwareDataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.DataInnerIO;
import org.apache.ignite.internal.processors.cache.tree.DataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.DataRow;
import org.apache.ignite.internal.processors.cache.tree.RowLinkIO;
import org.apache.ignite.internal.processors.cache.tree.SearchRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccCacheIdAwareDataInnerIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccCacheIdAwareDataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataInnerIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccDataPageClosure;
import org.apache.ignite.internal.util.GridArrays;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.lang.GridCursor;

public class CacheDataTree
extends BPlusTree<CacheSearchRow, CacheDataRow> {
    private static final CacheDataRow[] EMPTY_ROWS = new CacheDataRow[0];
    private static Boolean lastFindWithDataPageScan;
    private static final ThreadLocal<Boolean> dataPageScanEnabled;
    private final CacheDataRowStore rowStore;
    private final CacheGroupContext grp;

    public CacheDataTree(CacheGroupContext grp, String name, ReuseList reuseList, CacheDataRowStore rowStore, long metaPageId, boolean initNew, PageLockTrackerManager pageLockTrackerManager, byte pageFlag) throws IgniteCheckedException {
        super(name, grp.groupId(), grp.name(), grp.dataRegion().pageMemory(), grp.dataRegion().config().isPersistenceEnabled() ? grp.shared().wal() : null, grp.offheap().globalRemoveId(), metaPageId, reuseList, CacheDataTree.innerIO(grp), CacheDataTree.leafIO(grp), pageFlag, grp.shared().kernalContext().failure(), pageLockTrackerManager);
        assert (rowStore != null);
        this.rowStore = rowStore;
        this.grp = grp;
        assert (!grp.dataRegion().config().isPersistenceEnabled() || grp.shared().database().checkpointLockIsHeldByThread());
        this.initTree(initNew);
    }

    public static void setDataPageScanEnabled(boolean enabled) {
        dataPageScanEnabled.set(enabled);
    }

    public static boolean isDataPageScanEnabled() {
        return dataPageScanEnabled.get();
    }

    public static Boolean isLastFindWithDataPageScan() {
        Boolean res = lastFindWithDataPageScan;
        lastFindWithDataPageScan = null;
        return res;
    }

    @Override
    public GridCursor<CacheDataRow> find(CacheSearchRow lower, CacheSearchRow upper, BPlusTree.TreeRowClosure<CacheSearchRow, CacheDataRow> c, Object x) throws IgniteCheckedException {
        if (lower == null && upper == null && this.grp.persistenceEnabled() && dataPageScanEnabled.get().booleanValue() && (c == null || c instanceof MvccDataPageClosure)) {
            return this.scanDataPages(CacheDataTree.asRowData(x), (MvccDataPageClosure)((Object)c));
        }
        lastFindWithDataPageScan = Boolean.FALSE;
        return super.find(lower, upper, c, x);
    }

    private GridCursor<CacheDataRow> scanDataPages(final CacheDataRowAdapter.RowData rowData, final MvccDataPageClosure c) throws IgniteCheckedException {
        lastFindWithDataPageScan = Boolean.TRUE;
        this.checkDestroyed();
        assert (rowData != null);
        assert (this.grp.persistenceEnabled());
        int partId = this.rowStore.getPartitionId();
        final GridCacheSharedContext<?, ?> shared = this.grp.shared();
        GridCacheDatabaseSharedManager db = (GridCacheDatabaseSharedManager)shared.database();
        final PageStore pageStore = db.getPageStore(this.grpId, partId);
        final boolean mvccEnabled = this.grp.mvccEnabled();
        final int pageSize = this.pageSize();
        final long startPageId = ((PageMemoryEx)this.pageMem).partitionMetaPageId(this.grp.groupId(), partId);
        final class DataPageScanCursor
        implements GridCursor<CacheDataRow> {
            int pagesCnt;
            int curPage;
            CacheDataRow[] rows;
            int curRow;

            DataPageScanCursor() {
                this.pagesCnt = pageStore.pages();
                this.curPage = -1;
                this.rows = EMPTY_ROWS;
                this.curRow = -1;
            }

            @Override
            public boolean next() throws IgniteCheckedException {
                if (this.rows == null) {
                    return false;
                }
                if (++this.curRow < this.rows.length && this.rows[this.curRow] != null) {
                    return true;
                }
                return this.readNextDataPage();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean readNextDataPage() throws IgniteCheckedException {
                CacheDataTree.this.checkDestroyed();
                while (true) {
                    if (++this.curPage >= this.pagesCnt) {
                        int newPagesCnt = pageStore.pages();
                        if (newPagesCnt <= this.pagesCnt) {
                            this.rows = null;
                            return false;
                        }
                        this.pagesCnt = newPagesCnt;
                    }
                    long pageId = startPageId + (long)this.curPage;
                    long page = CacheDataTree.this.pageMem.acquirePage(CacheDataTree.this.grpId, pageId);
                    try {
                        block20: {
                            int rowsCnt;
                            DataPageIO io;
                            long pageAddr;
                            boolean skipVer;
                            block19: {
                                block18: {
                                    skipVer = CacheDataRowStore.getSkipVersion();
                                    pageAddr = ((PageMemoryEx)CacheDataTree.this.pageMem).readLock(page, pageId, true, false);
                                    if (PageIO.getType(pageAddr) == 1) break block18;
                                    CacheDataTree.this.pageMem.readUnlock(CacheDataTree.this.grpId, pageId, page);
                                    continue;
                                }
                                io = (DataPageIO)PageIO.getPageIO(1, PageIO.getVersion(pageAddr));
                                rowsCnt = io.getRowsCount(pageAddr);
                                if (rowsCnt != 0) break block19;
                                CacheDataTree.this.pageMem.readUnlock(CacheDataTree.this.grpId, pageId, page);
                                continue;
                            }
                            try {
                                if (rowsCnt > this.rows.length) {
                                    this.rows = new CacheDataRow[rowsCnt];
                                } else {
                                    GridArrays.clearTail(this.rows, rowsCnt);
                                }
                                int r = 0;
                                for (int i = 0; i < rowsCnt; ++i) {
                                    if (c != null && !c.applyMvcc(io, pageAddr, i, pageSize)) continue;
                                    DataRow row = mvccEnabled ? new MvccDataRow() : new DataRow();
                                    row.initFromDataPage(io, pageAddr, i, CacheDataTree.this.grp, shared, CacheDataTree.this.pageMem, rowData, skipVer);
                                    this.rows[r++] = row;
                                }
                                if (r != 0) break block20;
                            }
                            catch (Throwable throwable) {
                                CacheDataTree.this.pageMem.readUnlock(CacheDataTree.this.grpId, pageId, page);
                                throw throwable;
                            }
                            CacheDataTree.this.pageMem.readUnlock(CacheDataTree.this.grpId, pageId, page);
                            continue;
                        }
                        this.curRow = 0;
                        boolean bl = true;
                        CacheDataTree.this.pageMem.readUnlock(CacheDataTree.this.grpId, pageId, page);
                        return bl;
                    }
                    finally {
                        CacheDataTree.this.pageMem.releasePage(CacheDataTree.this.grpId, pageId, page);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public CacheDataRow get() {
                return this.rows[this.curRow];
            }
        }
        return new DataPageScanCursor();
    }

    private static CacheDataRowAdapter.RowData asRowData(Object flags) {
        return flags != null ? (CacheDataRowAdapter.RowData)((Object)flags) : CacheDataRowAdapter.RowData.FULL;
    }

    private static IOVersions<? extends AbstractDataInnerIO> innerIO(CacheGroupContext grp) {
        if (grp.mvccEnabled()) {
            return grp.sharedGroup() ? MvccCacheIdAwareDataInnerIO.VERSIONS : MvccDataInnerIO.VERSIONS;
        }
        return grp.sharedGroup() ? CacheIdAwareDataInnerIO.VERSIONS : DataInnerIO.VERSIONS;
    }

    private static IOVersions<? extends AbstractDataLeafIO> leafIO(CacheGroupContext grp) {
        if (grp.mvccEnabled()) {
            return grp.sharedGroup() ? MvccCacheIdAwareDataLeafIO.VERSIONS : MvccDataLeafIO.VERSIONS;
        }
        return grp.sharedGroup() ? CacheIdAwareDataLeafIO.VERSIONS : DataLeafIO.VERSIONS;
    }

    public CacheDataRowStore rowStore() {
        return this.rowStore;
    }

    @Override
    protected int compare(BPlusIO<CacheSearchRow> iox, long pageAddr, int idx, CacheSearchRow row) throws IgniteCheckedException {
        int cmp;
        assert (!this.grp.mvccEnabled() || row.mvccCoordinatorVersion() != 0L || row.getClass() == SearchRow.class && row.key() == null) : row;
        RowLinkIO io = (RowLinkIO)((Object)iox);
        if (this.grp.sharedGroup()) {
            assert (row.cacheId() != 0) : "Cache ID is not provided: " + row;
            int cacheId = io.getCacheId(pageAddr, idx);
            cmp = Integer.compare(cacheId, row.cacheId());
            if (cmp != 0) {
                return cmp;
            }
            if (row.key() == null) {
                assert (row.getClass() == SearchRow.class) : row;
                return cmp;
            }
        }
        if ((cmp = Integer.compare(io.getHash(pageAddr, idx), row.hash())) != 0) {
            return cmp;
        }
        long link = io.getLink(pageAddr, idx);
        assert (row.key() != null) : row;
        cmp = this.compareKeys(row.key(), link);
        if (cmp != 0 || !this.grp.mvccEnabled()) {
            return cmp;
        }
        long crd = io.getMvccCoordinatorVersion(pageAddr, idx);
        long cntr = io.getMvccCounter(pageAddr, idx);
        int opCntr = io.getMvccOperationCounter(pageAddr, idx);
        assert (MvccUtils.mvccVersionIsValid(crd, cntr, opCntr));
        return -MvccUtils.compare(crd, cntr, opCntr, row);
    }

    @Override
    public CacheDataRow getRow(BPlusIO<CacheSearchRow> io, long pageAddr, int idx, Object flags) {
        RowLinkIO rowIo = (RowLinkIO)((Object)io);
        long link = rowIo.getLink(pageAddr, idx);
        int hash = rowIo.getHash(pageAddr, idx);
        int cacheId = this.grp.sharedGroup() ? rowIo.getCacheId(pageAddr, idx) : 0;
        CacheDataRowAdapter.RowData x = CacheDataTree.asRowData(flags);
        if (this.grp.mvccEnabled()) {
            long mvccCrdVer = rowIo.getMvccCoordinatorVersion(pageAddr, idx);
            long mvccCntr = rowIo.getMvccCounter(pageAddr, idx);
            int mvccOpCntr = rowIo.getMvccOperationCounter(pageAddr, idx);
            return this.rowStore.mvccRow(cacheId, hash, link, x, mvccCrdVer, mvccCntr, mvccOpCntr);
        }
        return this.rowStore.dataRow(cacheId, hash, link, x);
    }

    @Override
    protected IoStatisticsHolder statisticsHolder() {
        return this.grp.statisticsHolderIdx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int compareKeys(KeyCacheObject key, long link) throws IgniteCheckedException {
        block23: {
            bytes = key.valueBytes(this.grp.cacheObjectContext());
            pageId = PageIdUtils.pageId(link);
            page = this.acquirePage(pageId);
            pageAddr = this.readLock(pageId, page);
            if (!CacheDataTree.$assertionsDisabled && pageAddr == 0L) {
                throw new AssertionError(link);
            }
            io = DataPageIO.VERSIONS.forPage(pageAddr);
            data = io.readPayload(pageAddr, PageIdUtils.itemId(link), this.pageSize());
            if (data.nextLink() != 0L) ** GOTO lbl26
            addr = pageAddr + (long)data.offset();
            if (this.grp.mvccEnabled()) {
                addr += 40L;
            }
            if (this.grp.storeCacheIdInDataPage()) {
                addr += 4L;
            }
            if ((lenCmp = Integer.compare(len = PageUtils.getInt(addr, 0), bytes.length)) != 0) {
                var17_17 = lenCmp;
                return var17_17;
            }
            addr += 5L;
            words = len / 8;
            ** GOTO lbl36
            {
                finally {
                    this.releasePage(pageId, page);
                }
lbl26:
                // 1 sources

                other = this.grp.mvccEnabled() != false ? new MvccDataRow(link) : new CacheDataRowAdapter(link);
                other.initFromLink(this.grp, CacheDataRowAdapter.RowData.KEY_ONLY);
                bytes1 = other.key().valueBytes(this.grp.cacheObjectContext());
                bytes2 = key.valueBytes(this.grp.cacheObjectContext());
                lenCmp = Integer.compare(bytes1.length, bytes2.length);
                if (lenCmp != 0) {
                    return lenCmp;
                }
                len = bytes1.length;
                words = len / 8;
                break block23;
lbl36:
                // 2 sources

                for (i = 0; i < words; ++i) {
                    off = i * 8;
                    b1 = PageUtils.getLong(addr, off);
                    cmp = Long.compare(b1, b2 = GridUnsafe.getLong(bytes, GridUnsafe.BYTE_ARR_OFF + (long)off));
                    if (cmp == 0) continue;
                    var25_28 = cmp;
                    return var25_28;
                }
                for (i = words * 8; i < len; ++i) {
                    b1 = PageUtils.getByte(addr, i);
                    if (b1 == (b2 = bytes[i])) continue;
                    ** break block24
                }
                var18_21 = 0;
                return var18_21;
                ** finally { 
lbl50:
                // 1 sources

                this.readUnlock(pageId, page, pageAddr);
lbl-1000:
                // 1 sources

                {
                    var21_29 = b1 > b2 ? 1 : -1;
                }
            }
            return var21_29;
        }
        for (i = 0; i < words; ++i) {
            off = GridUnsafe.BYTE_ARR_INT_OFF + i * 8;
            b1 = GridUnsafe.getLong(bytes1, off);
            cmp = Long.compare(b1, b2 = GridUnsafe.getLong(bytes2, off));
            if (cmp == 0) continue;
            return cmp;
        }
        i = words * 8;
        while (i < len) {
            b1 = bytes1[i];
            b2 = bytes2[i];
            if (b1 != b2) {
                if (b1 <= b2) return -1;
                return 1;
            }
            ++i;
        }
        return 0;
    }

    static {
        dataPageScanEnabled = ThreadLocal.withInitial(() -> false);
    }
}

