/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.reducer;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.query.reducer.CacheQueryReducer;
import org.apache.ignite.internal.processors.cache.query.reducer.NodePage;
import org.apache.ignite.internal.processors.cache.query.reducer.NodePageStream;

public class UnsortedCacheQueryReducer<R>
extends CacheQueryReducer<R> {
    private static final long serialVersionUID = 0L;
    private NodePage<R> page;
    private final CompletableFuture<NodePage<R>>[] futs;

    public UnsortedCacheQueryReducer(Map<UUID, NodePageStream<R>> pageStreams) {
        super(pageStreams);
        this.futs = new CompletableFuture[pageStreams.size()];
    }

    @Override
    public boolean hasNextX() throws IgniteCheckedException {
        while (this.page == null || !this.page.hasNext()) {
            int pendingNodesCnt = 0;
            for (NodePageStream s2 : this.pageStreams.values()) {
                if (s2.closed()) continue;
                CompletableFuture f = s2.headPage();
                if (f.isDone()) {
                    this.page = (NodePage)UnsortedCacheQueryReducer.get(f);
                    if (!this.page.hasNext()) continue;
                    return true;
                }
                this.futs[pendingNodesCnt++] = f;
            }
            if (pendingNodesCnt == 0) {
                return false;
            }
            CompletableFuture<NodePage<R>>[] pendingFuts = Arrays.copyOf(this.futs, pendingNodesCnt);
            Arrays.fill(this.futs, 0, pendingNodesCnt, null);
            this.page = (NodePage)UnsortedCacheQueryReducer.get(CompletableFuture.anyOf(pendingFuts));
        }
        return true;
    }

    @Override
    public R nextX() throws IgniteCheckedException {
        return this.page.next();
    }
}

