/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.ContinuousQueryWithTransformer;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryDeployableObject;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryHandlerV2;
import org.apache.ignite.internal.processors.continuous.GridContinuousHandler;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteAsyncCallback;
import org.apache.ignite.lang.IgniteClosure;
import org.jetbrains.annotations.Nullable;

public class CacheContinuousQueryHandlerV3<K, V>
extends CacheContinuousQueryHandlerV2<K, V> {
    private static final long serialVersionUID = 0L;
    private Factory<? extends IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, ?>> rmtTransFactory;
    private CacheContinuousQueryDeployableObject rmtTransFactoryDep;
    private transient IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, ?> rmtTrans;
    private transient ContinuousQueryWithTransformer.EventListener<?> locTransLsnr;

    public CacheContinuousQueryHandlerV3() {
    }

    public CacheContinuousQueryHandlerV3(String cacheName, Object topic, ContinuousQueryWithTransformer.EventListener<?> locTransLsnr, @Nullable Factory<? extends CacheEntryEventFilter<K, V>> rmtFilterFactory, Factory<? extends IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, ?>> rmtTransFactory, boolean oldValRequired, boolean sync, boolean ignoreExpired, boolean ignoreClsNotFound) {
        super(cacheName, topic, null, rmtFilterFactory, oldValRequired, sync, ignoreExpired, ignoreClsNotFound, null);
        assert (rmtTransFactory != null);
        this.locTransLsnr = locTransLsnr;
        this.rmtTransFactory = rmtTransFactory;
    }

    @Override
    public IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, ?> getTransformer0() {
        if (this.rmtTrans == null && this.rmtTransFactory != null) {
            this.rmtTrans = this.rmtTransFactory.create();
        }
        return this.rmtTrans;
    }

    @Override
    public ContinuousQueryWithTransformer.EventListener<?> localTransformedEventListener() {
        return this.locTransLsnr;
    }

    @Override
    protected CacheEntryEventFilter getEventFilter0() {
        if (this.rmtFilterFactory == null) {
            return null;
        }
        return super.getEventFilter0();
    }

    @Override
    public GridContinuousHandler.RegisterStatus register(UUID nodeId, UUID routineId, GridKernalContext ctx) throws IgniteCheckedException {
        if (this.locTransLsnr != null) {
            ctx.resource().injectGeneric(this.locTransLsnr);
            this.asyncCb = U.hasAnnotation(this.locTransLsnr, IgniteAsyncCallback.class);
        }
        return super.register(nodeId, routineId, ctx);
    }

    @Override
    public void p2pMarshal(GridKernalContext ctx) throws IgniteCheckedException {
        super.p2pMarshal(ctx);
        if (this.rmtTransFactory != null && !U.isGrid(this.rmtTransFactory.getClass())) {
            this.rmtTransFactoryDep = new CacheContinuousQueryDeployableObject(this.rmtTransFactory, ctx);
        }
    }

    @Override
    public void p2pUnmarshal(UUID nodeId, GridKernalContext ctx) throws IgniteCheckedException {
        if (this.rmtTransFactoryDep != null) {
            this.rmtTransFactory = (Factory)this.p2pUnmarshal(this.rmtTransFactoryDep, nodeId, ctx);
        }
        super.p2pUnmarshal(nodeId, ctx);
    }

    @Override
    public boolean isMarshalled() {
        return super.isMarshalled() && (this.rmtTransFactory == null || U.isGrid(this.rmtTransFactory.getClass()) || this.rmtTransFactoryDep != null);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        boolean b = this.rmtTransFactoryDep != null;
        out.writeBoolean(b);
        if (b) {
            out.writeObject(this.rmtTransFactoryDep);
        } else {
            out.writeObject(this.rmtTransFactory);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        boolean b = in.readBoolean();
        if (b) {
            this.rmtTransFactoryDep = (CacheContinuousQueryDeployableObject)in.readObject();
            if (this.p2pUnmarshalFut.isDone()) {
                this.p2pUnmarshalFut = new GridFutureAdapter();
            }
        } else {
            this.rmtTransFactory = (Factory)in.readObject();
        }
    }
}

