/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractSnapshotFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotSender;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class SnapshotResponseRemoteFutureTask
extends AbstractSnapshotFutureTask<Void> {
    private final String snpPath;

    public SnapshotResponseRemoteFutureTask(GridCacheSharedContext<?, ?> cctx, UUID srcNodeId, UUID reqId, String snpName, String snpPath, File tmpWorkDir, FileIOFactory ioFactory, SnapshotSender snpSndr, Map<Integer, Set<Integer>> parts) {
        super(cctx, srcNodeId, reqId, snpName, tmpWorkDir, ioFactory, snpSndr, parts);
        this.snpPath = snpPath;
    }

    @Override
    public boolean start() {
        if (F.isEmpty(this.parts)) {
            return false;
        }
        try {
            List<SnapshotMetadata> metas = this.cctx.snapshotMgr().readSnapshotMetadatas(this.snpName, this.snpPath);
            Function<GroupPartitionId, SnapshotMetadata> findMeta = pair -> {
                for (SnapshotMetadata meta : metas) {
                    Set<Integer> locParts;
                    Map<Integer, Set<Integer>> parts0 = meta.partitions();
                    if (F.isEmpty(parts0) || (locParts = parts0.get(pair.getGroupId())) == null || !locParts.contains(pair.getPartitionId())) continue;
                    return meta;
                }
                return null;
            };
            HashMap partsToSend = new HashMap();
            this.parts.forEach((grpId, parts) -> parts.forEach(part -> {
                SnapshotMetadata cfr_ignored_0 = (SnapshotMetadata)partsToSend.computeIfAbsent(new GroupPartitionId((int)grpId, (int)part), findMeta);
            }));
            if (partsToSend.containsValue(null)) {
                Collection<GroupPartitionId> missed = F.viewReadOnly(partsToSend.entrySet(), Map.Entry::getKey, e -> e.getValue() == null);
                throw new IgniteException("Snapshot partitions missed on local node [snpName=" + this.snpName + ", missed=" + missed + ']');
            }
            this.snpSndr.init(partsToSend.size());
            File snpDir = this.cctx.snapshotMgr().snapshotLocalDir(this.snpName, this.snpPath);
            CompletableFuture.runAsync(() -> partsToSend.forEach((gp, meta) -> {
                if (this.err.get() != null) {
                    return;
                }
                File cacheDir = FilePageStoreManager.cacheDirectory(new File(snpDir, IgniteSnapshotManager.databaseRelativePath(meta.folderName())), gp.getGroupId());
                if (cacheDir == null) {
                    throw new IgniteException("Cache directory not found [snpName=" + this.snpName + ", meta=" + meta + ", pair=" + gp + ']');
                }
                File snpPart = FilePageStoreManager.getPartitionFile(cacheDir.getParentFile(), cacheDir.getName(), gp.getPartitionId());
                if (!snpPart.exists()) {
                    throw new IgniteException("Snapshot partition file not found [cacheDir=" + cacheDir + ", pair=" + gp + ']');
                }
                this.snpSndr.sendPart(snpPart, cacheDir.getName(), (GroupPartitionId)gp, snpPart.length());
            }), this.snpSndr.executor()).whenComplete((r, t2) -> {
                Throwable th;
                if (t2 != null) {
                    this.err.compareAndSet(null, t2);
                }
                if ((th = (Throwable)this.err.get()) == null && this.log.isInfoEnabled()) {
                    this.log.info("Snapshot partitions have been sent to the remote node [snpName=" + this.snpName + ", rmtNodeId=" + this.srcNodeId + ']');
                }
                this.close(th);
            });
            return true;
        }
        catch (Throwable t3) {
            if (this.err.compareAndSet(null, t3)) {
                this.close(t3);
            }
            return false;
        }
    }

    @Override
    public void acceptException(Throwable th) {
        if (this.err.compareAndSet(null, th)) {
            this.close(th);
        }
    }

    private void close(@Nullable Throwable th) {
        if (th == null) {
            this.snpSndr.close(null);
            this.onDone((Void)null);
        } else {
            this.snpSndr.close(th);
            this.onDone(th);
        }
    }
}

