/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.cache.CacheException;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.management.MBeanServer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheExistsException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.configuration.WarmUpConfiguration;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteTransactionsEx;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.cache.transform.CacheObjectTransformerManager;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.DetachedClusterNode;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.managers.systemview.walker.CacheGroupIoViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.CachePagesListViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.PartitionStateViewWalker;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.CacheAffinitySharedManager;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnricher;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.CacheConfigurationOverride;
import org.apache.ignite.internal.processors.cache.CacheConfigurationSplitter;
import org.apache.ignite.internal.processors.cache.CacheConfigurationSplitterImpl;
import org.apache.ignite.internal.processors.cache.CacheConfigurationSplitterOldFormat;
import org.apache.ignite.internal.processors.cache.CacheConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.CacheDiagnosticManager;
import org.apache.ignite.internal.processors.cache.CacheEvictionManager;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheJoinNodeDiscoveryData;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheOffheapEvictionManager;
import org.apache.ignite.internal.processors.cache.CachePartitionExchangeWorkerTask;
import org.apache.ignite.internal.processors.cache.CacheStatisticsClearMessage;
import org.apache.ignite.internal.processors.cache.CacheStatisticsModeChangeMessage;
import org.apache.ignite.internal.processors.cache.CacheStatisticsModeChangeTask;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.ClientCacheChangeDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.ClientCacheChangeDummyDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.ClientCacheUpdateTimeout;
import org.apache.ignite.internal.processors.cache.ClusterCachesInfo;
import org.apache.ignite.internal.processors.cache.ClusterCachesReconnectResult;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeFailureMessage;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.GridCacheDeploymentManager;
import org.apache.ignite.internal.processors.cache.GridCacheEventManager;
import org.apache.ignite.internal.processors.cache.GridCacheEvictionManager;
import org.apache.ignite.internal.processors.cache.GridCacheIoManager;
import org.apache.ignite.internal.processors.cache.GridCacheLoaderWriterStore;
import org.apache.ignite.internal.processors.cache.GridCacheLoaderWriterStoreFactory;
import org.apache.ignite.internal.processors.cache.GridCacheManager;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedTtlCleanupManager;
import org.apache.ignite.internal.processors.cache.GridCacheTtlManager;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.GridLocalConfigManager;
import org.apache.ignite.internal.processors.cache.GridNoStorageCacheMap;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.LocalJoinCachesContext;
import org.apache.ignite.internal.processors.cache.StartCacheInfo;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.TxTimeoutOnPartitionMapExchangeChangeMessage;
import org.apache.ignite.internal.processors.cache.TxTimeoutOnPartitionMapExchangeChangeTask;
import org.apache.ignite.internal.processors.cache.ValidationOnNodeJoinUtils;
import org.apache.ignite.internal.processors.cache.WalStateAbstractMessage;
import org.apache.ignite.internal.processors.cache.WalStateFinishMessage;
import org.apache.ignite.internal.processors.cache.WalStateManager;
import org.apache.ignite.internal.processors.cache.WalStateNodeLeaveExchangeTask;
import org.apache.ignite.internal.processors.cache.WalStateProposeMessage;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.datastructures.CacheDataStructuresManager;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.IgniteClusterReadOnlyException;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtColocatedCache;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.FinishPreloadingTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.StopCachesOnClientReconnectExchangeTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.PartitionDefferedDeleteQueueCleanupTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.PartitionsEvictManager;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTransactionalCache;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrManager;
import org.apache.ignite.internal.processors.cache.jta.CacheJtaManagerAdapter;
import org.apache.ignite.internal.processors.cache.mvcc.DeadlockDetectionManager;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCachingManager;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DatabaseLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.RowStore;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.persistence.freelist.PagesList;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheDistributedQueryManager;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryManager;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTransactionsImpl;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionManager;
import org.apache.ignite.internal.processors.cache.warmup.WarmUpStrategy;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.compress.CompressionHandler;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheManager;
import org.apache.ignite.internal.processors.plugin.CachePluginManager;
import org.apache.ignite.internal.processors.query.QuerySchema;
import org.apache.ignite.internal.processors.query.QuerySchemaPatch;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.schema.SchemaExchangeWorkerTask;
import org.apache.ignite.internal.processors.query.schema.SchemaNodeLeaveExchangeWorkerTask;
import org.apache.ignite.internal.processors.query.schema.message.SchemaAbstractDiscoveryMessage;
import org.apache.ignite.internal.processors.query.schema.message.SchemaProposeDiscoveryMessage;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.suggestions.GridPerformanceSuggestions;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.IgniteCollectors;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.InitializationProtector;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.lang.GridPlainClosure2;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.lang.IgniteOutClosureX;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.mxbean.IgniteMBeanAware;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.systemview.view.CacheGroupIoView;
import org.apache.ignite.spi.systemview.view.CachePagesListView;
import org.apache.ignite.spi.systemview.view.PartitionStateView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCacheProcessor
extends GridProcessorAdapter {
    public static final String CLUSTER_READ_ONLY_MODE_ERROR_MSG_FORMAT = "Failed to perform %s operation (cluster is in read-only mode) [cacheGrp=%s, cache=%s]";
    private static final String CHECK_EMPTY_TRANSACTIONS_ERROR_MSG_FORMAT = "Cannot start/stop cache within lock or transaction [cacheNames=%s, operation=%s]";
    public static final String CACHE_GRP_PAGE_LIST_VIEW = "cacheGroupPageLists";
    public static final String CACHE_GRP_PAGE_LIST_VIEW_DESC = "Cache group page lists";
    public static final String PART_STATES_VIEW = "partitionStates";
    public static final String PART_STATES_VIEW_DESC = "Distribution of cache group partitions across cluster nodes";
    public static final String CACHE_GRP_IO_VIEW = MetricUtils.metricName("local", "cache", "groups", "io");
    public static final String CACHE_GRP_IO_VIEW_DESC = "Local node IO statistics for cache groups";
    public static final boolean DFLT_ALLOW_START_CACHES_IN_PARALLEL = true;
    private final boolean IGNITE_ALLOW_START_CACHES_IN_PARALLEL = IgniteSystemProperties.getBoolean("IGNITE_ALLOW_START_CACHES_IN_PARALLEL", true);
    private final boolean keepStaticCacheConfiguration = IgniteSystemProperties.getBoolean("IGNITE_KEEP_STATIC_CACHE_CONFIGURATION");
    static long TIMEOUT_OUTPUT_RESTORE_PARTITION_STATE_PROGRESS = TimeUnit.MINUTES.toMillis(5L);
    private GridCacheSharedContext<?, ?> sharedCtx;
    private final ConcurrentMap<Integer, CacheGroupContext> cacheGrps = new ConcurrentHashMap<Integer, CacheGroupContext>();
    private final Map<String, GridCacheAdapter<?, ?>> caches;
    private final Map<String, GridCacheAdapter> stoppedCaches = new ConcurrentHashMap<String, GridCacheAdapter>();
    private final ConcurrentHashMap<String, IgniteCacheProxyImpl<?, ?>> jCacheProxies;
    private IgniteTransactionsImpl transactions;
    private ConcurrentMap<UUID, IgniteInternalFuture> pendingFuts = new ConcurrentHashMap<UUID, IgniteInternalFuture>();
    private ConcurrentMap<String, IgniteInternalFuture> pendingTemplateFuts = new ConcurrentHashMap<String, IgniteInternalFuture>();
    private ConcurrentMap<UUID, EnableStatisticsFuture> manageStatisticsFuts = new ConcurrentHashMap<UUID, EnableStatisticsFuture>();
    private ClusterCachesInfo cachesInfo;
    private GridLocalConfigManager locCfgMgr;
    private IdentityHashMap<CacheStore, ThreadLocal> sesHolders = new IdentityHashMap();
    private final Marshaller marsh;
    private final CountDownLatch cacheStartedLatch = new CountDownLatch(1);
    private final Set<String> internalCaches;
    private final InitializationProtector initializationProtector = new InitializationProtector();
    private final CacheRecoveryLifecycle recovery = new CacheRecoveryLifecycle();
    private CacheConfigurationSplitter splitter;
    private CacheConfigurationEnricher enricher;
    public static final String EXPRITY_POLICY_MSG = "expiryPolicy=[type=%s, isEagerTtl=%s]";

    public GridCacheProcessor(GridKernalContext ctx) {
        super(ctx);
        this.caches = new ConcurrentHashMap();
        this.jCacheProxies = new ConcurrentHashMap();
        this.internalCaches = new HashSet<String>();
        this.marsh = MarshallerUtils.jdkMarshaller(ctx.igniteInstanceName());
        this.splitter = new CacheConfigurationSplitterImpl(ctx, this.marsh);
        this.enricher = new CacheConfigurationEnricher(ctx, this.marsh, U.resolveClassLoader(ctx.config()));
    }

    private void suggestOptimizations(CacheConfiguration cfg, boolean hasStore) {
        GridPerformanceSuggestions perf = this.ctx.performance();
        String msg = "Disable eviction policy (remove from configuration)";
        if (cfg.getEvictionPolicyFactory() != null || cfg.getEvictionPolicy() != null) {
            perf.add(msg, false);
        } else {
            perf.add(msg, true);
        }
        if (cfg.getCacheMode() == CacheMode.PARTITIONED) {
            perf.add("Disable near cache (set 'nearConfiguration' to null)", cfg.getNearConfiguration() == null);
        }
        perf.add("Enable ATOMIC mode if not using transactions (set 'atomicityMode' to ATOMIC)", cfg.getAtomicityMode() == CacheAtomicityMode.ATOMIC);
        perf.add("Disable fully synchronous writes (set 'writeSynchronizationMode' to PRIMARY_SYNC or FULL_ASYNC)", cfg.getWriteSynchronizationMode() != CacheWriteSynchronizationMode.FULL_SYNC);
        if (hasStore && cfg.isWriteThrough()) {
            perf.add("Enable write-behind to persistent store (set 'writeBehindEnabled' to true)", cfg.isWriteBehindEnabled());
        }
    }

    public CachePartitionExchangeWorkerTask exchangeTaskForCustomDiscoveryMessage(DiscoveryCustomMessage msg) {
        if (msg instanceof SchemaAbstractDiscoveryMessage) {
            SchemaAbstractDiscoveryMessage msg0 = (SchemaAbstractDiscoveryMessage)msg;
            if (msg0.exchange()) {
                return new SchemaExchangeWorkerTask(SecurityUtils.remoteSecurityContext(this.ctx), msg0);
            }
        } else {
            CacheStatisticsModeChangeMessage msg0;
            if (msg instanceof ClientCacheChangeDummyDiscoveryMessage) {
                ClientCacheChangeDummyDiscoveryMessage msg02 = (ClientCacheChangeDummyDiscoveryMessage)msg;
                return msg02;
            }
            if (msg instanceof CacheStatisticsModeChangeMessage && (msg0 = (CacheStatisticsModeChangeMessage)msg).initial()) {
                return new CacheStatisticsModeChangeTask(SecurityUtils.remoteSecurityContext(this.ctx), msg0);
            }
        }
        return null;
    }

    void processCustomExchangeTask(CachePartitionExchangeWorkerTask task) {
        if (task instanceof SchemaExchangeWorkerTask) {
            SchemaAbstractDiscoveryMessage msg = ((SchemaExchangeWorkerTask)task).message();
            if (msg instanceof SchemaProposeDiscoveryMessage) {
                SchemaProposeDiscoveryMessage msg0 = (SchemaProposeDiscoveryMessage)msg;
                this.ctx.query().onSchemaPropose(msg0);
            } else {
                U.warn(this.log, "Unsupported schema discovery message: " + msg);
            }
        } else if (task instanceof SchemaNodeLeaveExchangeWorkerTask) {
            SchemaNodeLeaveExchangeWorkerTask task0 = (SchemaNodeLeaveExchangeWorkerTask)task;
            this.ctx.query().onNodeLeave(task0.node());
        } else if (task instanceof ClientCacheChangeDummyDiscoveryMessage) {
            ClientCacheChangeDummyDiscoveryMessage task0 = (ClientCacheChangeDummyDiscoveryMessage)task;
            this.sharedCtx.affinity().processClientCachesRequests(task0);
        } else if (task instanceof ClientCacheUpdateTimeout) {
            ClientCacheUpdateTimeout task0 = (ClientCacheUpdateTimeout)task;
            this.sharedCtx.affinity().sendClientCacheChangesMessage(task0);
        } else if (task instanceof CacheStatisticsModeChangeTask) {
            CacheStatisticsModeChangeTask task0 = (CacheStatisticsModeChangeTask)task;
            this.processStatisticsModeChange(task0.message());
        } else if (task instanceof TxTimeoutOnPartitionMapExchangeChangeTask) {
            TxTimeoutOnPartitionMapExchangeChangeTask task0 = (TxTimeoutOnPartitionMapExchangeChangeTask)task;
            this.sharedCtx.tm().processTxTimeoutOnPartitionMapExchangeChange(task0.message());
        } else if (task instanceof StopCachesOnClientReconnectExchangeTask) {
            StopCachesOnClientReconnectExchangeTask task0 = (StopCachesOnClientReconnectExchangeTask)task;
            this.stopCachesOnClientReconnect(task0.stoppedCaches());
            task0.onDone();
        } else if (task instanceof WalStateNodeLeaveExchangeTask) {
            WalStateNodeLeaveExchangeTask task0 = (WalStateNodeLeaveExchangeTask)task;
            this.sharedCtx.walState().onNodeLeft(task0.node().id());
        } else if (task instanceof FinishPreloadingTask) {
            FinishPreloadingTask task0 = (FinishPreloadingTask)task;
            CacheGroupContext grp = this.cacheGroup(task0.groupId());
            if (grp != null) {
                grp.preloader().finishPreloading(task0.topologyVersion(), task0.rebalanceId());
            }
        } else {
            U.warn(this.log, "Unsupported custom exchange task: " + task);
        }
    }

    private List<GridCacheManager> dhtManagers(GridCacheContext ctx) {
        return F.asList(new GridCacheManager[]{ctx.store(), ctx.events(), ctx.evicts(), ctx.queries(), ctx.continuousQueries(), ctx.dr()});
    }

    private Collection<GridCacheManager> dhtExcludes(GridCacheContext ctx) {
        if (!GridCacheUtils.isNearEnabled(ctx)) {
            return Collections.emptyList();
        }
        return F.asList(new GridCacheManager[]{ctx.queries(), ctx.continuousQueries(), ctx.store()});
    }

    private void prepare(CacheConfiguration cfg, Collection<Object> objs) throws IgniteCheckedException {
        this.prepare(cfg, cfg.getAffinity(), false);
        this.prepare(cfg, cfg.getAffinityMapper(), false);
        this.prepare(cfg, cfg.getEvictionFilter(), false);
        this.prepare(cfg, cfg.getInterceptor(), false);
        for (Object obj : objs) {
            this.prepare(cfg, obj, false);
        }
    }

    private void prepare(CacheConfiguration cfg, @Nullable Object rsrc, boolean near) throws IgniteCheckedException {
        if (rsrc != null) {
            this.ctx.resource().injectGeneric(rsrc);
            this.ctx.resource().injectCacheName(rsrc, cfg.getName());
            this.registerMbean(rsrc, cfg.getName(), near);
        }
    }

    private void cleanup(GridCacheContext cctx) {
        CacheConfiguration cfg = cctx.config();
        this.cleanup(cfg, cfg.getAffinity(), false);
        this.cleanup(cfg, cfg.getAffinityMapper(), false);
        this.cleanup(cfg, cfg.getEvictionFilter(), false);
        this.cleanup(cfg, cfg.getInterceptor(), false);
        this.cleanup(cfg, cctx.store().configuredStore(), false);
        cctx.cleanup();
    }

    private void cleanup(CacheGroupContext grp, boolean destroy) {
        CacheConfiguration cfg = grp.config();
        for (Object obj : grp.configuredUserObjects()) {
            this.cleanup(cfg, obj, false);
        }
        grp.metrics().remove(destroy);
        grp.removeIOStatistic(destroy);
        this.sharedCtx.evict().cleanupRemovedGroup(grp.groupId());
    }

    private void cleanup(CacheConfiguration cfg, @Nullable Object rsrc, boolean near) {
        if (rsrc != null) {
            this.unregisterMbean(rsrc, cfg.getName(), near);
            try {
                this.ctx.resource().cleanupGeneric(rsrc);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to cleanup resource: " + rsrc, e);
            }
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        CacheJoinNodeDiscoveryData data;
        this.ctx.internalSubscriptionProcessor().registerMetastorageListener(this.recovery);
        this.ctx.internalSubscriptionProcessor().registerDatabaseListener(this.recovery);
        this.cachesInfo = new ClusterCachesInfo(this.ctx);
        DeploymentMode depMode = this.ctx.config().getDeploymentMode();
        if (!F.isEmpty(this.ctx.config().getCacheConfiguration()) && depMode != DeploymentMode.CONTINUOUS && depMode != DeploymentMode.SHARED) {
            U.warn(this.log, "Deployment mode for cache is not CONTINUOUS or SHARED (it is recommended that you change deployment mode and restart): " + (Object)((Object)depMode));
        }
        Collection<CacheStoreSessionListener> sessionListeners = CU.startStoreSessionListeners(this.ctx, this.ctx.config().getCacheStoreSessionListenerFactories());
        this.sharedCtx = this.createSharedContext(this.ctx, sessionListeners);
        this.locCfgMgr = new GridLocalConfigManager(this, this.ctx);
        this.transactions = new IgniteTransactionsImpl(this.sharedCtx, null, false);
        for (GridCacheSharedManager<?, ?> mgr : this.sharedCtx.managers()) {
            mgr.start(this.sharedCtx);
        }
        if ((!CU.isPersistenceEnabled(this.ctx.config()) || this.ctx.config().isClientMode().booleanValue()) && (data = this.locCfgMgr.restoreCacheConfigurations()) != null) {
            this.cachesInfo.onStart(data);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started cache processor.");
        }
        this.ctx.state().cacheProcessorStarted();
        this.ctx.systemView().registerFiltrableView(CACHE_GRP_PAGE_LIST_VIEW, CACHE_GRP_PAGE_LIST_VIEW_DESC, new CachePagesListViewWalker(), this::pagesListViewSupplier, Function.identity());
        this.ctx.systemView().registerFiltrableView(PART_STATES_VIEW, PART_STATES_VIEW_DESC, new PartitionStateViewWalker(), this::partStatesViewSupplier, Function.identity());
        this.ctx.systemView().registerView(CACHE_GRP_IO_VIEW, CACHE_GRP_IO_VIEW_DESC, new CacheGroupIoViewWalker(), () -> F.view(this.cacheGrps.values(), grp -> !grp.systemCache()), grpCtx -> {
            MetricRegistry mreg = this.ctx.metric().registry(MetricUtils.metricName(IoStatisticsType.CACHE_GROUP.metricGroupName(), grpCtx.cacheOrGroupName()));
            return new CacheGroupIoView((CacheGroupContext)grpCtx, mreg);
        });
    }

    void initialize(CacheConfiguration cfg, CacheObjectContext cacheObjCtx) throws IgniteCheckedException {
        CU.initializeConfigDefaults(this.log, cfg, cacheObjCtx);
        this.ctx.coordinators().preProcessCacheConfiguration(cfg);
    }

    @Nullable
    public CacheGroupContext cacheGroup(int grpId) {
        return (CacheGroupContext)this.cacheGrps.get(grpId);
    }

    public Collection<CacheGroupContext> cacheGroups() {
        return this.cacheGrps.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        AffinityTopologyVersion joinVer;
        try {
            boolean checkConsistency;
            boolean bl = checkConsistency = !IgniteSystemProperties.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK");
            if (checkConsistency) {
                ValidationOnNodeJoinUtils.checkConsistency(this.ctx, this.log);
            }
            this.cachesInfo.onKernalStart(checkConsistency);
            this.sharedCtx.walState().onKernalStart();
            this.ctx.query().onCacheKernalStart();
            joinVer = this.sharedCtx.exchange().onKernalStart(active, false);
        }
        finally {
            this.cacheStartedLatch.countDown();
        }
        if (!this.ctx.clientNode()) {
            this.sharedCtx.time().addTimeoutObject(new PartitionDefferedDeleteQueueCleanupTask(this.sharedCtx, Long.getLong("IGNITE_CACHE_REMOVED_ENTRIES_TTL", 10000L)));
        }
        for (GridCacheSharedManager<?, ?> mgr : this.sharedCtx.managers()) {
            mgr.onKernalStart(active);
        }
        if (!active) {
            return;
        }
        this.awaitRebalance(joinVer).get();
    }

    public void awaitStarted() throws IgniteCheckedException {
        U.await(this.cacheStartedLatch);
    }

    private GridCompoundFuture<?, ?> awaitRebalance(AffinityTopologyVersion joinVer) {
        return this.internalCaches().stream().map(GridCacheAdapter::context).filter(GridCacheContext::affinityNode).filter(ctx -> ctx.config().getRebalanceMode() == CacheRebalanceMode.SYNC).filter(ctx -> ctx.startTopologyVersion().equals(joinVer)).filter(ctx -> ctx.config().getCacheMode() == CacheMode.REPLICATED || ctx.config().getCacheMode() == CacheMode.PARTITIONED && ctx.config().getRebalanceDelay() >= 0L).map(ctx -> ctx.preloader().syncFuture()).collect(IgniteCollectors.toCompoundFuture());
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopCaches(cancel);
        List<GridCacheSharedManager<?, ?>> mgrs = this.sharedCtx.managers();
        ListIterator<GridCacheSharedManager<?, ?>> it = mgrs.listIterator(mgrs.size());
        while (it.hasPrevious()) {
            GridCacheSharedManager<?, ?> mgr = it.previous();
            mgr.stop(cancel);
        }
        CU.stopStoreSessionListeners(this.ctx, this.sharedCtx.storeSessionListeners());
        this.sharedCtx.cleanup();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped cache processor.");
        }
    }

    public void stopCaches(boolean cancel) {
        for (String cacheName : this.locCfgMgr.stopSequence()) {
            GridCacheAdapter cache = this.stoppedCaches.remove(cacheName);
            if (cache == null) continue;
            this.stopCache(cache, cancel, false, false);
        }
        for (GridCacheAdapter cache : this.stoppedCaches.values()) {
            if (cache != this.stoppedCaches.remove(cache.name())) continue;
            this.stopCache(cache, cancel, false, false);
        }
        for (CacheGroupContext grp : this.cacheGrps.values()) {
            this.stopCacheGroup(grp.groupId(), false);
        }
    }

    public void blockGateways() {
        for (IgniteCacheProxyImpl<?, ?> proxy : this.jCacheProxies.values()) {
            proxy.context0().gate().onStopped();
        }
    }

    public List<GridCacheAdapter> blockGateways(Collection<Integer> cacheGrpIds) {
        List<GridCacheAdapter> affectedCaches = this.internalCaches().stream().filter(cache -> cacheGrpIds.contains(cache.context().groupId())).collect(Collectors.toList());
        affectedCaches.forEach(cache -> {
            this.addjCacheProxy(cache.context().name(), new IgniteCacheProxyImpl(cache.context(), cache, false));
            this.blockGateway(cache.context().name(), true, false);
        });
        return affectedCaches;
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.cacheStartedLatch.countDown();
        GridCachePartitionExchangeManager exch = this.context().exchange();
        exch.onKernalStop(cancel);
        this.sharedCtx.mvcc().onStop();
        for (CacheGroupContext grp : this.cacheGrps.values()) {
            grp.onKernalStop();
        }
        this.onKernalStopCaches(cancel);
        this.cancelFutures();
        List<GridCacheSharedManager<?, ?>> sharedMgrs = this.sharedCtx.managers();
        ListIterator<GridCacheSharedManager<?, ?>> it = sharedMgrs.listIterator(sharedMgrs.size());
        while (it.hasPrevious()) {
            GridCacheSharedManager<?, ?> mgr = it.previous();
            if (mgr == exch) continue;
            mgr.onKernalStop(cancel);
        }
    }

    public void onKernalStopCaches(boolean cancel) {
        GridCacheAdapter cache;
        IgniteCheckedException affErr = new IgniteCheckedException("Failed to wait for topology update, node is stopping.");
        for (CacheGroupContext cacheGroupContext : this.cacheGrps.values()) {
            GridAffinityAssignmentCache aff = cacheGroupContext.affinity();
            aff.cancelFutures(affErr);
        }
        for (String string : this.locCfgMgr.stopSequence()) {
            cache = this.caches.remove(string);
            if (cache == null) continue;
            this.stoppedCaches.put(string, cache);
            this.onKernalStop(cache, cancel);
        }
        for (Map.Entry entry : this.caches.entrySet()) {
            cache = (GridCacheAdapter)entry.getValue();
            if (cache != this.caches.remove(entry.getKey())) continue;
            this.stoppedCaches.put((String)entry.getKey(), cache);
            this.onKernalStop((GridCacheAdapter)entry.getValue(), cancel);
        }
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to execute dynamic cache change request, client node disconnected.");
        for (IgniteInternalFuture igniteInternalFuture : this.pendingFuts.values()) {
            ((GridFutureAdapter)igniteInternalFuture).onDone(err);
        }
        for (IgniteInternalFuture igniteInternalFuture : this.pendingTemplateFuts.values()) {
            ((GridFutureAdapter)igniteInternalFuture).onDone(err);
        }
        for (EnableStatisticsFuture enableStatisticsFuture : this.manageStatisticsFuts.values()) {
            enableStatisticsFuture.onDone(err);
        }
        for (CacheGroupContext cacheGroupContext : this.cacheGrps.values()) {
            cacheGroupContext.onDisconnected(reconnectFut);
        }
        for (GridCacheAdapter gridCacheAdapter : this.caches.values()) {
            GridCacheContext cctx = gridCacheAdapter.context();
            cctx.gate().onDisconnected(reconnectFut);
            List mgrs = gridCacheAdapter.context().managers();
            ListIterator it = mgrs.listIterator(mgrs.size());
            while (it.hasPrevious()) {
                GridCacheManager mgr = it.previous();
                mgr.onDisconnected(reconnectFut);
            }
        }
        this.sharedCtx.onDisconnected(reconnectFut);
        this.cachesInfo.onDisconnected();
    }

    private void stopCacheOnReconnect(GridCacheContext cctx, List<GridCacheAdapter> stoppedCaches) {
        cctx.gate().reconnected(true);
        this.sharedCtx.removeCacheContext(cctx);
        this.caches.remove(cctx.name());
        this.completeProxyInitialize(cctx.name());
        this.jCacheProxies.remove(cctx.name());
        stoppedCaches.add(cctx.cache());
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        ArrayList<GridCacheAdapter> reconnected = new ArrayList<GridCacheAdapter>(this.caches.size());
        DiscoveryDataClusterState state = this.ctx.state().clusterState();
        boolean active = state.active() && !state.transition();
        ClusterCachesReconnectResult reconnectRes = this.cachesInfo.onReconnected(active, state.transition());
        ArrayList<GridCacheAdapter> stoppedCaches = new ArrayList<GridCacheAdapter>();
        for (String string : reconnectRes.stoppedCaches()) {
            if (this.caches.keySet().contains(string)) continue;
            this.ctx.query().onCacheStop(string);
        }
        for (GridCacheAdapter gridCacheAdapter : this.caches.values()) {
            boolean stopped;
            boolean bl = stopped = reconnectRes.stoppedCacheGroups().contains(gridCacheAdapter.context().groupId()) || reconnectRes.stoppedCaches().contains(gridCacheAdapter.name());
            if (stopped) {
                this.stopCacheOnReconnect(gridCacheAdapter.context(), stoppedCaches);
                continue;
            }
            gridCacheAdapter.onReconnected();
            reconnected.add(gridCacheAdapter);
            if (!gridCacheAdapter.context().userCache()) continue;
            DynamicCacheDescriptor desc = this.cacheDescriptor(gridCacheAdapter.name());
            assert (desc != null) : gridCacheAdapter.name();
            if (!QueryUtils.isEnabled(gridCacheAdapter.context().config()) && QueryUtils.isEnabled(desc.cacheConfiguration())) {
                CacheConfiguration newCfg = desc.cacheConfiguration();
                gridCacheAdapter.context().onSchemaAddQueryEntity(newCfg.getQueryEntities(), newCfg.getSqlSchema(), newCfg.isSqlEscapeAll(), newCfg.getQueryParallelism());
            }
            boolean rmvIdx = !gridCacheAdapter.context().group().persistenceEnabled();
            GridCacheContextInfo cacheInfo = new GridCacheContextInfo(gridCacheAdapter.context(), false);
            this.ctx.query().onCacheStop0(cacheInfo, rmvIdx, rmvIdx);
            this.ctx.query().onCacheStart0(cacheInfo, desc.schema(), desc.sql());
        }
        Set<Integer> stoppedGrps = reconnectRes.stoppedCacheGroups();
        for (CacheGroupContext grp : this.cacheGrps.values()) {
            if (stoppedGrps.contains(grp.groupId())) {
                this.cacheGrps.remove(grp.groupId());
                continue;
            }
            grp.onReconnected();
        }
        this.sharedCtx.onReconnected(active);
        for (GridCacheAdapter cache : reconnected) {
            cache.context().gate().reconnected(false);
        }
        if (!stoppedCaches.isEmpty()) {
            return this.sharedCtx.exchange().deferStopCachesOnClientReconnect(stoppedCaches);
        }
        return null;
    }

    private void stopCache(GridCacheAdapter<?, ?> cache, boolean cancel, boolean callDestroy, boolean clearCache) {
        this.stopCache(cache, cancel, callDestroy, clearCache, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopCache(GridCacheAdapter<?, ?> cache, boolean cancel, boolean callDestroy, boolean clearCache, boolean clearDbObjects) {
        GridCacheContext<?, ?> ctx = cache.context();
        try {
            GridDhtCacheAdapter<?, ?> dht;
            if (!cache.isNear() && ctx.shared().wal() != null) {
                try {
                    ctx.shared().wal().flush(null, false);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to flush write-ahead log on cache stop [cache=" + ctx.name() + "]", e);
                }
            }
            this.sharedCtx.removeCacheContext(ctx);
            cache.stop();
            cache.removeMetrics(callDestroy);
            GridCacheContextInfo cacheInfo = new GridCacheContextInfo(ctx, false);
            if (clearDbObjects) {
                boolean rmvIdx = !cache.context().group().persistenceEnabled() || callDestroy;
                boolean clearIdx = !cache.context().group().persistenceEnabled() || clearCache;
                ctx.kernalContext().query().onCacheStop(cacheInfo, rmvIdx, clearIdx);
            } else {
                ctx.kernalContext().query().onClientCacheStop(cacheInfo);
            }
            if (GridCacheUtils.isNearEnabled(ctx) && (dht = ctx.near().dht()) != null) {
                dht.stop();
                dht.removeMetrics(callDestroy);
                GridCacheContext dhtCtx = dht.context();
                List<GridCacheManager> dhtMgrs = this.dhtManagers(dhtCtx);
                ListIterator<GridCacheManager> it = dhtMgrs.listIterator(dhtMgrs.size());
                while (it.hasPrevious()) {
                    GridCacheManager mgr = it.previous();
                    mgr.stop(cancel, callDestroy);
                }
            }
            List<GridCacheManager<?, ?>> mgrs = ctx.managers();
            Collection<GridCacheManager> excludes = this.dhtExcludes(ctx);
            ListIterator<GridCacheManager<?, ?>> it = mgrs.listIterator(mgrs.size());
            while (it.hasPrevious()) {
                GridCacheManager<?, ?> mgr = it.previous();
                if (excludes.contains(mgr)) continue;
                mgr.stop(cancel, callDestroy);
            }
            ctx.kernalContext().continuous().onCacheStop(ctx);
            ctx.kernalContext().cache().context().snapshot().onCacheStop(ctx, callDestroy);
            ctx.kernalContext().coordinators().onCacheStop(ctx);
            ctx.group().stopCache(ctx, clearCache);
            U.stopLifecycleAware(this.log, this.lifecycleAwares(ctx.group(), cache.configuration(), ctx.store().configuredStore()));
            if (callDestroy && CU.storeCacheConfig(this.sharedCtx, ctx.config())) {
                try {
                    this.locCfgMgr.removeCacheData(new StoredCacheData(ctx.config()));
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to delete cache configuration data while destroying cache[cache=" + ctx.name() + "]", e);
                }
            }
            if (this.log.isInfoEnabled()) {
                if (ctx.group().sharedGroup()) {
                    this.log.info("Stopped cache [cacheName=" + cache.name() + ", group=" + ctx.group().name() + ']');
                } else {
                    this.log.info("Stopped cache [cacheName=" + cache.name() + ']');
                }
            }
        }
        finally {
            this.cleanup(ctx);
        }
    }

    private void onKernalStart(GridCacheAdapter<?, ?> cache) throws IgniteCheckedException {
        GridCacheContext<?, ?> ctx = cache.context();
        if (GridCacheUtils.isNearEnabled(ctx)) {
            GridDhtCacheAdapter<?, ?> dht = ctx.near().dht();
            GridCacheContext dhtCtx = dht.context();
            for (GridCacheManager mgr : this.dhtManagers(dhtCtx)) {
                mgr.onKernalStart();
            }
            dht.onKernalStart();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Executed onKernalStart() callback for DHT cache: " + dht.name());
            }
        }
        for (GridCacheManager<?, ?> mgr : F.view(ctx.managers(), F0.notContains(this.dhtExcludes(ctx)))) {
            mgr.onKernalStart();
        }
        cache.onKernalStart();
        if (ctx.events().isRecordable(98)) {
            ctx.events().addEvent(98);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executed onKernalStart() callback for cache [name=" + cache.name() + ", mode=" + (Object)((Object)cache.configuration().getCacheMode()) + ']');
        }
    }

    private void onKernalStop(GridCacheAdapter<?, ?> cache, boolean cancel) {
        GridDhtCacheAdapter<?, ?> dht;
        GridCacheContext<?, ?> ctx = cache.context();
        if (GridCacheUtils.isNearEnabled(ctx) && (dht = ctx.near().dht()) != null) {
            GridCacheContext dhtCtx = dht.context();
            for (GridCacheManager mgr : this.dhtManagers(dhtCtx)) {
                mgr.onKernalStop(cancel);
            }
            dht.onKernalStop();
        }
        List<GridCacheManager<?, ?>> mgrs = ctx.managers();
        Collection<GridCacheManager> excludes = this.dhtExcludes(ctx);
        ListIterator<GridCacheManager<?, ?>> it = mgrs.listIterator(mgrs.size());
        while (it.hasPrevious()) {
            GridCacheManager mgr;
            mgr = it.previous();
            if (excludes.contains(mgr)) continue;
            mgr.onKernalStop(cancel);
        }
        cache.onKernalStop();
        if (!ctx.isRecoveryMode() && ctx.events().isRecordable(99)) {
            ctx.events().addEvent(99);
        }
    }

    private GridCacheContext<?, ?> createCacheContext(CacheConfiguration<?, ?> cfg, CacheGroupContext grp, @Nullable CachePluginManager pluginMgr, DynamicCacheDescriptor desc, AffinityTopologyVersion locStartTopVer, CacheObjectContext cacheObjCtx, boolean affNode, boolean updatesAllowed, boolean disabledAfterStart, boolean recoveryMode) throws IgniteCheckedException {
        assert (cfg != null);
        if (cfg.getCacheStoreFactory() instanceof GridCacheLoaderWriterStoreFactory) {
            GridCacheLoaderWriterStoreFactory factory = (GridCacheLoaderWriterStoreFactory)cfg.getCacheStoreFactory();
            this.prepare(cfg, factory.loaderFactory(), false);
            this.prepare(cfg, factory.writerFactory(), false);
        } else {
            this.prepare(cfg, cfg.getCacheStoreFactory(), false);
        }
        CacheStore<?, ?> cfgStore = cfg.getCacheStoreFactory() != null ? cfg.getCacheStoreFactory().create() : null;
        ValidationOnNodeJoinUtils.validate(this.ctx.config(), cfg, desc.cacheType(), cfgStore, this.ctx, this.log, (x, y) -> {
            try {
                this.assertParameter((boolean)x, (String)y);
            }
            catch (IgniteCheckedException ex) {
                return ex;
            }
            return null;
        });
        if (pluginMgr == null) {
            pluginMgr = new CachePluginManager(this.ctx, cfg);
        }
        pluginMgr.validate();
        if (!recoveryMode && cfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT && grp.affinityNode()) {
            this.sharedCtx.coordinators().ensureStarted();
        }
        this.sharedCtx.jta().registerCache(cfg);
        if (desc.cacheType().userCache()) {
            this.suggestOptimizations(cfg, cfgStore != null);
        }
        ArrayList<Object> toPrepare = new ArrayList<Object>();
        if (cfgStore instanceof GridCacheLoaderWriterStore) {
            toPrepare.add(((GridCacheLoaderWriterStore)cfgStore).loader());
            toPrepare.add(((GridCacheLoaderWriterStore)cfgStore).writer());
        } else {
            toPrepare.add(cfgStore);
        }
        this.prepare(cfg, toPrepare);
        U.startLifecycleAware(this.lifecycleAwares(grp, cfg, cfgStore));
        boolean nearEnabled = GridCacheUtils.isNearEnabled(cfg);
        GridCacheAffinityManager affMgr = new GridCacheAffinityManager();
        GridCacheEventManager evtMgr = new GridCacheEventManager();
        GridCacheManagerAdapter evictMgr = nearEnabled || cfg.isOnheapCacheEnabled() ? new GridCacheEvictionManager() : new CacheOffheapEvictionManager();
        GridCacheDistributedQueryManager qryMgr = new GridCacheDistributedQueryManager();
        CacheContinuousQueryManager contQryMgr = new CacheContinuousQueryManager();
        CacheDataStructuresManager dataStructuresMgr = new CacheDataStructuresManager();
        GridCacheTtlManager ttlMgr = new GridCacheTtlManager();
        CacheConflictResolutionManager rslvrMgr = pluginMgr.createComponent(CacheConflictResolutionManager.class);
        GridCacheDrManager drMgr = pluginMgr.createComponent(GridCacheDrManager.class);
        CacheStoreManager storeMgr = pluginMgr.createComponent(CacheStoreManager.class);
        PlatformCacheManager platformMgr = this.ctx.platform().cacheManager();
        if (cfgStore == null) {
            storeMgr.initialize(cfgStore, this.sesHolders);
        } else {
            this.initializationProtector.protect(cfgStore, () -> storeMgr.initialize(cfgStore, this.sesHolders));
        }
        GridCacheContext cacheCtx = new GridCacheContext(this.ctx, this.sharedCtx, cfg, grp, desc.cacheType(), locStartTopVer, desc.deploymentId(), affNode, updatesAllowed, desc.cacheConfiguration().isStatisticsEnabled(), recoveryMode, evtMgr, storeMgr, (CacheEvictionManager)((Object)evictMgr), qryMgr, contQryMgr, dataStructuresMgr, ttlMgr, drMgr, rslvrMgr, pluginMgr, affMgr, platformMgr);
        cacheCtx.cacheObjectContext(cacheObjCtx);
        GridDistributedCacheAdapter cache = null;
        block0 : switch (cfg.getCacheMode()) {
            case PARTITIONED: 
            case REPLICATED: {
                if (nearEnabled) {
                    switch (cfg.getAtomicityMode()) {
                        case TRANSACTIONAL: 
                        case TRANSACTIONAL_SNAPSHOT: {
                            cache = new GridNearTransactionalCache(cacheCtx);
                            break block0;
                        }
                        case ATOMIC: {
                            cache = new GridNearAtomicCache(cacheCtx);
                            break block0;
                        }
                    }
                    assert (false) : "Invalid cache atomicity mode: " + (Object)((Object)cfg.getAtomicityMode());
                    break;
                }
                switch (cfg.getAtomicityMode()) {
                    case TRANSACTIONAL: 
                    case TRANSACTIONAL_SNAPSHOT: {
                        cache = cacheCtx.affinityNode() ? new GridDhtColocatedCache(cacheCtx) : new GridDhtColocatedCache(cacheCtx, new GridNoStorageCacheMap());
                        break block0;
                    }
                    case ATOMIC: {
                        cache = cacheCtx.affinityNode() ? new GridDhtAtomicCache(cacheCtx) : new GridDhtAtomicCache(cacheCtx, new GridNoStorageCacheMap());
                        break block0;
                    }
                }
                assert (false) : "Invalid cache atomicity mode: " + (Object)((Object)cfg.getAtomicityMode());
                break;
            }
            default: {
                assert (false) : "Invalid cache mode: " + (Object)((Object)cfg.getCacheMode());
                break;
            }
        }
        cache.active(!disabledAfterStart);
        cacheCtx.cache(cache);
        GridCacheContext ret = cacheCtx;
        if (nearEnabled) {
            evictMgr = cfg.isOnheapCacheEnabled() ? new GridCacheEvictionManager() : new CacheOffheapEvictionManager();
            evtMgr = new GridCacheEventManager();
            pluginMgr = new CachePluginManager(this.ctx, cfg);
            drMgr = pluginMgr.createComponent(GridCacheDrManager.class);
            cacheCtx = new GridCacheContext(this.ctx, this.sharedCtx, cfg, grp, desc.cacheType(), locStartTopVer, desc.deploymentId(), affNode, true, desc.cacheConfiguration().isStatisticsEnabled(), recoveryMode, evtMgr, storeMgr, (CacheEvictionManager)((Object)evictMgr), qryMgr, contQryMgr, dataStructuresMgr, ttlMgr, drMgr, rslvrMgr, pluginMgr, affMgr, platformMgr);
            cacheCtx.cacheObjectContext(cacheObjCtx);
            GridDhtCacheAdapter dht = null;
            switch (cfg.getAtomicityMode()) {
                case TRANSACTIONAL: 
                case TRANSACTIONAL_SNAPSHOT: {
                    assert (cache instanceof GridNearTransactionalCache);
                    GridDistributedCacheAdapter near = cache;
                    GridDhtCache dhtCache = cacheCtx.affinityNode() ? new GridDhtCache(cacheCtx) : new GridDhtCache(cacheCtx, new GridNoStorageCacheMap());
                    dhtCache.near(near);
                    ((GridNearTransactionalCache)near).dht(dhtCache);
                    dht = dhtCache;
                    break;
                }
                case ATOMIC: {
                    assert (cache instanceof GridNearAtomicCache);
                    GridNearAtomicCache near = (GridNearAtomicCache)cache;
                    GridDhtAtomicCache dhtCache = cacheCtx.affinityNode() ? new GridDhtAtomicCache(cacheCtx) : new GridDhtAtomicCache(cacheCtx, new GridNoStorageCacheMap());
                    dhtCache.near(near);
                    near.dht(dhtCache);
                    dht = dhtCache;
                    break;
                }
                default: {
                    assert (false) : "Invalid cache atomicity mode: " + (Object)((Object)cfg.getAtomicityMode());
                    break;
                }
            }
            cacheCtx.cache(dht);
        }
        return ret;
    }

    public void registrateProxyRestart(Map<String, DynamicCacheChangeRequest> reqs, GridFutureAdapter<?> fut) {
        for (IgniteCacheProxyImpl<?, ?> proxy : this.jCacheProxies.values()) {
            if (!reqs.containsKey(proxy.getName()) || !proxy.isRestarting() || reqs.get(proxy.getName()).disabledAfterStart()) continue;
            proxy.registrateFutureRestart(fut);
        }
    }

    public void completeProxyRestart(Map<String, DynamicCacheChangeRequest> reqs, AffinityTopologyVersion initVer, AffinityTopologyVersion doneVer) {
        if (initVer == null || doneVer == null) {
            return;
        }
        for (GridCacheAdapter<?, ?> cache : this.caches.values()) {
            GridCacheContext<?, ?> cacheCtx = cache.context();
            if (reqs.containsKey(cache.name()) || cacheCtx.startTopologyVersion().compareTo(initVer) <= 0 || cacheCtx.startTopologyVersion().compareTo(doneVer) <= 0) {
                this.completeProxyInitialize(cache.name());
            }
            if (cacheCtx.startTopologyVersion().compareTo(initVer) < 0 || cacheCtx.startTopologyVersion().compareTo(doneVer) > 0) continue;
            IgniteCacheProxyImpl<?, ?> proxy = this.jCacheProxies.get(cache.name());
            boolean canRestart = Optional.ofNullable(reqs.get(cache.name())).map(req -> !req.disabledAfterStart()).orElse(true);
            if (proxy == null || !proxy.isRestarting() || !canRestart) continue;
            proxy.onRestarted(cacheCtx, cache);
            if (!cacheCtx.dataStructuresCache()) continue;
            this.ctx.dataStructures().restart(cache.name(), proxy.internalProxy());
        }
    }

    public Collection<String> cacheNames() {
        return F.viewReadOnly(this.cacheDescriptors().values(), new IgniteClosure<DynamicCacheDescriptor, String>(){

            @Override
            public String apply(DynamicCacheDescriptor desc) {
                return desc.cacheConfiguration().getName();
            }
        }, new IgnitePredicate[0]);
    }

    public IgniteCacheProxy<?, ?> getOrStartPublicCache(boolean start) throws IgniteCheckedException {
        for (Map.Entry<String, GridCacheAdapter<?, ?>> entry : this.caches.entrySet()) {
            if (!entry.getValue().context().userCache()) continue;
            CacheConfiguration ccfg = entry.getValue().configuration();
            String cacheName = ccfg.getName();
            return this.publicJCache(cacheName);
        }
        if (start) {
            for (Map.Entry<String, GridCacheAdapter<Object, Object>> entry : this.cachesInfo.registeredCaches().entrySet()) {
                DynamicCacheDescriptor desc = (DynamicCacheDescriptor)((Object)entry.getValue());
                if (!desc.cacheType().userCache()) continue;
                CacheConfiguration ccfg = desc.cacheConfiguration();
                this.dynamicStartCache(null, ccfg.getName(), null, false, true, true).get();
                return this.publicJCache(ccfg.getName());
            }
        }
        return null;
    }

    public Collection<String> publicCacheNames() {
        return F.viewReadOnly(this.cacheDescriptors().values(), new IgniteClosure<DynamicCacheDescriptor, String>(){

            @Override
            public String apply(DynamicCacheDescriptor desc) {
                return desc.cacheConfiguration().getName();
            }
        }, new IgnitePredicate<DynamicCacheDescriptor>(){

            @Override
            public boolean apply(DynamicCacheDescriptor desc) {
                return desc.cacheType().userCache();
            }
        });
    }

    public Collection<String> publicAndDsCacheNames() {
        return F.viewReadOnly(this.cacheDescriptors().values(), new IgniteClosure<DynamicCacheDescriptor, String>(){

            @Override
            public String apply(DynamicCacheDescriptor desc) {
                return desc.cacheConfiguration().getName();
            }
        }, new IgnitePredicate<DynamicCacheDescriptor>(){

            @Override
            public boolean apply(DynamicCacheDescriptor desc) {
                return desc.cacheType().userCache() || desc.cacheType() == CacheType.DATA_STRUCTURES;
            }
        });
    }

    public CacheMode cacheMode(String cacheName) {
        assert (cacheName != null);
        DynamicCacheDescriptor desc = this.cacheDescriptor(cacheName);
        return desc != null ? desc.cacheConfiguration().getCacheMode() : null;
    }

    @Nullable
    public LocalJoinCachesContext localJoinCachesContext() {
        if (this.ctx.discovery().localNode().order() == 1L) {
            this.cachesInfo.filterDynamicCacheDescriptors(this.locCfgMgr.localCachesOnStart());
        }
        return this.cachesInfo.localJoinCachesContext();
    }

    public IgniteInternalFuture<?> startCachesOnLocalJoin(AffinityTopologyVersion exchTopVer, LocalJoinCachesContext locJoinCtx) throws IgniteCheckedException {
        long time = U.currentTimeMillis();
        if (locJoinCtx == null) {
            return new GridFinishedFuture();
        }
        IgniteInternalFuture<?> res = this.sharedCtx.affinity().initCachesOnLocalJoin(locJoinCtx.cacheGroupDescriptors(), locJoinCtx.cacheDescriptors());
        for (DynamicCacheDescriptor d : locJoinCtx.cacheDescriptors().values()) {
            this.ctx.coordinators().validateCacheConfiguration(d.cacheConfiguration());
        }
        List<StartCacheInfo> startCacheInfos = locJoinCtx.caches().stream().map(cacheInfo -> new StartCacheInfo((DynamicCacheDescriptor)cacheInfo.get1(), (NearCacheConfiguration)cacheInfo.get2(), exchTopVer, false)).collect(Collectors.toList());
        locJoinCtx.initCaches().forEach(cacheDesc -> {
            try {
                this.ctx.query().initQueryStructuresForNotStartedCache((DynamicCacheDescriptor)cacheDesc);
            }
            catch (Exception e) {
                this.log.error("Can't initialize query structures for not started cache [cacheName=" + cacheDesc.cacheName() + "]", e);
            }
        });
        this.prepareStartCaches(startCacheInfos);
        this.context().exchange().exchangerUpdateHeartbeat();
        if (this.log.isInfoEnabled()) {
            this.log.info("Starting caches on local join performed in " + (U.currentTimeMillis() - time) + " ms.");
        }
        return res;
    }

    public boolean hasCachesReceivedFromJoin(ClusterNode node) {
        return this.cachesInfo.hasCachesReceivedFromJoin(node.id());
    }

    public Collection<DynamicCacheDescriptor> startReceivedCaches(UUID nodeId, AffinityTopologyVersion exchTopVer) throws IgniteCheckedException {
        List<DynamicCacheDescriptor> receivedCaches = this.cachesInfo.cachesReceivedFromJoin(nodeId);
        List<StartCacheInfo> startCacheInfos = receivedCaches.stream().filter(desc -> this.isLocalAffinity(desc.groupDescriptor().config())).map(desc -> new StartCacheInfo((DynamicCacheDescriptor)desc, null, exchTopVer, false)).collect(Collectors.toList());
        this.prepareStartCaches(startCacheInfos);
        return receivedCaches;
    }

    private boolean isLocalAffinity(CacheConfiguration cacheConfiguration) {
        return CU.affinityNode(this.ctx.discovery().localNode(), cacheConfiguration.getNodeFilter());
    }

    void prepareStartCaches(Collection<StartCacheInfo> startCacheInfos) throws IgniteCheckedException {
        this.prepareStartCaches(startCacheInfos, (data, operation) -> operation.apply(data));
    }

    Map<StartCacheInfo, IgniteCheckedException> prepareStartCachesIfPossible(Collection<StartCacheInfo> startCacheInfos) throws IgniteCheckedException {
        HashMap<StartCacheInfo, IgniteCheckedException> failedCaches = new HashMap<StartCacheInfo, IgniteCheckedException>();
        this.prepareStartCaches(startCacheInfos, (data, operation) -> {
            try {
                operation.apply(data);
            }
            catch (IgniteInterruptedCheckedException e) {
                throw e;
            }
            catch (IgniteCheckedException e) {
                this.log.warning("Cache can not be started : cache=" + data.getStartedConfiguration().getName());
                failedCaches.put((StartCacheInfo)data, e);
            }
        });
        return failedCaches;
    }

    private void prepareStartCaches(Collection<StartCacheInfo> startCacheInfos, StartCacheFailHandler<StartCacheInfo, Void> cacheStartFailHandler) throws IgniteCheckedException {
        if (!this.IGNITE_ALLOW_START_CACHES_IN_PARALLEL || startCacheInfos.size() <= 1) {
            for (StartCacheInfo startCacheInfo2 : startCacheInfos) {
                cacheStartFailHandler.handle(startCacheInfo2, cacheInfo -> {
                    this.prepareCacheStart(cacheInfo.getCacheDescriptor(), cacheInfo.getReqNearCfg(), cacheInfo.getExchangeTopVer(), cacheInfo.isDisabledAfterStart(), cacheInfo.isClientCache());
                    return null;
                });
                this.context().exchange().exchangerUpdateHeartbeat();
            }
        } else {
            ConcurrentHashMap cacheContexts = new ConcurrentHashMap();
            int parallelismLvl = U.availableThreadCount(this.ctx, (byte)2, 2);
            IgniteUtils.doInParallel(parallelismLvl, this.sharedCtx.kernalContext().pools().getSystemExecutorService(), startCacheInfos, startCacheInfo -> {
                cacheStartFailHandler.handle((StartCacheInfo)startCacheInfo, cacheInfo -> {
                    GridCacheContext cacheCtx = this.prepareCacheContext(cacheInfo.getCacheDescriptor(), cacheInfo.getReqNearCfg(), cacheInfo.getExchangeTopVer(), cacheInfo.isDisabledAfterStart());
                    cacheContexts.put(cacheInfo, cacheCtx);
                    this.context().exchange().exchangerUpdateHeartbeat();
                    return null;
                });
                return null;
            });
            Set successfullyPreparedCaches = cacheContexts.keySet();
            List cacheInfosInOriginalOrder = startCacheInfos.stream().filter(successfullyPreparedCaches::contains).collect(Collectors.toList());
            for (StartCacheInfo startCacheInfo3 : cacheInfosInOriginalOrder) {
                cacheStartFailHandler.handle(startCacheInfo3, cacheInfo -> {
                    GridCacheContext cctx = (GridCacheContext)cacheContexts.get(cacheInfo);
                    if (!cctx.isRecoveryMode()) {
                        this.ctx.query().onCacheStart(new GridCacheContextInfo(cctx, cacheInfo.isClientCache()), cacheInfo.getCacheDescriptor().schema() != null ? cacheInfo.getCacheDescriptor().schema() : new QuerySchema(), cacheInfo.getCacheDescriptor().sql());
                    }
                    this.context().exchange().exchangerUpdateHeartbeat();
                    return null;
                });
            }
            IgniteUtils.doInParallel(parallelismLvl, this.sharedCtx.kernalContext().pools().getSystemExecutorService(), cacheContexts.entrySet(), cacheCtxEntry -> {
                cacheStartFailHandler.handle((StartCacheInfo)cacheCtxEntry.getKey(), cacheInfo -> {
                    GridCacheContext cacheContext = (GridCacheContext)cacheCtxEntry.getValue();
                    if (cacheContext.isRecoveryMode()) {
                        this.finishRecovery(cacheInfo.getExchangeTopVer(), cacheContext);
                    } else {
                        this.onCacheStarted((GridCacheContext)cacheCtxEntry.getValue());
                    }
                    this.context().exchange().exchangerUpdateHeartbeat();
                    return null;
                });
                return null;
            });
        }
    }

    public void prepareCacheStart(DynamicCacheDescriptor desc, @Nullable NearCacheConfiguration reqNearCfg, AffinityTopologyVersion exchTopVer, boolean disabledAfterStart, boolean clientCache) throws IgniteCheckedException {
        GridCacheContext cacheCtx = this.prepareCacheContext(desc, reqNearCfg, exchTopVer, disabledAfterStart);
        if (cacheCtx.isRecoveryMode()) {
            this.finishRecovery(exchTopVer, cacheCtx);
        } else {
            this.ctx.query().onCacheStart(new GridCacheContextInfo(cacheCtx, clientCache), desc.schema() != null ? desc.schema() : new QuerySchema(), desc.sql());
            this.onCacheStarted(cacheCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCacheContext prepareCacheContext(DynamicCacheDescriptor desc, @Nullable NearCacheConfiguration reqNearCfg, AffinityTopologyVersion exchTopVer, boolean disabledAfterStart) throws IgniteCheckedException {
        desc = this.enricher().enrich(desc, this.isLocalAffinity(desc.cacheConfiguration()));
        CacheConfiguration startCfg = desc.cacheConfiguration();
        if (this.caches.containsKey(startCfg.getName())) {
            GridCacheAdapter<?, ?> existingCache = this.caches.get(startCfg.getName());
            GridCacheContext<?, ?> cctx = existingCache.context();
            assert (cctx.isRecoveryMode());
            QuerySchema localSchema = (QuerySchema)this.recovery.querySchemas.get(desc.cacheId());
            QuerySchemaPatch localSchemaPatch = localSchema.makePatch(desc.schema().entities());
            if (!localSchemaPatch.isEmpty() || localSchemaPatch.hasConflicts()) {
                this.stopCacheSafely(cctx);
            } else {
                return existingCache.context();
            }
        }
        assert (!this.caches.containsKey(startCfg.getName())) : startCfg.getName();
        CacheConfiguration ccfg = new CacheConfiguration(startCfg);
        CacheObjectContext cacheObjCtx = this.ctx.cacheObjects().contextForCache(ccfg);
        boolean affNode = this.checkForAffinityNode(desc, reqNearCfg, ccfg);
        this.ctx.cache().context().database().checkpointReadLock();
        try {
            CacheGroupContext grp = this.getOrCreateCacheGroupContext(desc, exchTopVer, cacheObjCtx, affNode, startCfg.getGroupName(), false);
            GridCacheContext<?, ?> cacheCtx = this.createCacheContext(ccfg, grp, null, desc, exchTopVer, cacheObjCtx, affNode, true, disabledAfterStart, false);
            this.initCacheContext(cacheCtx, ccfg);
            GridCacheContext<?, ?> gridCacheContext = cacheCtx;
            return gridCacheContext;
        }
        finally {
            this.ctx.cache().context().database().checkpointReadUnlock();
        }
    }

    private void stopCacheSafely(GridCacheContext<?, ?> cctx) {
        this.stopCacheSafely(cctx, true);
    }

    private void stopCacheSafely(GridCacheContext<?, ?> cctx, boolean clearDbObjects) {
        this.sharedCtx.database().checkpointReadLock();
        try {
            this.prepareCacheStop(cctx.name(), false, false, clearDbObjects);
            if (!cctx.group().hasCaches()) {
                this.stopCacheGroup(cctx.group().groupId(), false);
            }
        }
        finally {
            this.sharedCtx.database().checkpointReadUnlock();
        }
    }

    private void finishRecovery(AffinityTopologyVersion cacheStartVer, GridCacheContext<?, ?> cacheContext) throws IgniteCheckedException {
        CacheGroupContext groupContext = cacheContext.group();
        DynamicCacheDescriptor updatedDescriptor = this.cacheDescriptor(cacheContext.cacheId());
        groupContext.finishRecovery(cacheStartVer, updatedDescriptor.receivedFrom(), this.isLocalAffinity(updatedDescriptor.cacheConfiguration()));
        cacheContext.finishRecovery(cacheStartVer, updatedDescriptor);
        if (GridCacheUtils.isNearEnabled(cacheContext)) {
            GridDhtCacheAdapter<?, ?> dht = cacheContext.near().dht();
            dht.context().finishRecovery(cacheStartVer, updatedDescriptor);
        }
        if (cacheContext.config().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT && groupContext.affinityNode()) {
            this.sharedCtx.coordinators().ensureStarted();
        }
        this.onKernalStart(cacheContext.cache());
        if (this.log.isInfoEnabled()) {
            this.log.info("Finished recovery for cache [cache=" + cacheContext.name() + ", grp=" + groupContext.cacheOrGroupName() + ", startVer=" + cacheStartVer + "]");
        }
    }

    public void shutdownNotFinishedRecoveryCaches() {
        for (GridCacheAdapter<?, ?> cacheAdapter : this.caches.values()) {
            GridCacheContext<?, ?> cacheContext = cacheAdapter.context();
            if (!cacheContext.isRecoveryMode()) continue;
            assert (!this.isLocalAffinity(cacheContext.config())) : "Cache " + cacheAdapter.context() + " is still in recovery mode after start, but not activated.";
            this.stopCacheSafely(cacheContext);
        }
    }

    private boolean checkForAffinityNode(DynamicCacheDescriptor desc, @Nullable NearCacheConfiguration reqNearCfg, CacheConfiguration ccfg) {
        if (this.isLocalAffinity(desc.cacheConfiguration())) {
            return true;
        }
        ccfg.setNearConfiguration(reqNearCfg);
        return false;
    }

    public void preparePageStore(DynamicCacheDescriptor desc, boolean affNode) throws IgniteCheckedException {
        if (this.sharedCtx.pageStore() != null && affNode) {
            this.initializationProtector.protect(desc.groupDescriptor().groupId(), () -> this.sharedCtx.pageStore().initializeForCache(desc.groupDescriptor(), desc.toStoredData(this.splitter).config()));
        }
    }

    private CacheGroupContext getOrCreateCacheGroupContext(DynamicCacheDescriptor desc, AffinityTopologyVersion exchTopVer, CacheObjectContext cacheObjCtx, boolean affNode, String grpName, boolean recoveryMode) throws IgniteCheckedException {
        if (grpName != null) {
            return this.initializationProtector.protect(desc.groupId(), () -> this.findCacheGroup(grpName), () -> this.startCacheGroup(desc.groupDescriptor(), desc.cacheType(), affNode, cacheObjCtx, exchTopVer, recoveryMode));
        }
        return this.startCacheGroup(desc.groupDescriptor(), desc.cacheType(), affNode, cacheObjCtx, exchTopVer, recoveryMode);
    }

    private void initCacheContext(GridCacheContext<?, ?> cacheCtx, CacheConfiguration cfg) throws IgniteCheckedException {
        GridCacheAdapter<?, ?> cache = cacheCtx.cache();
        this.sharedCtx.addCacheContext(cacheCtx);
        this.caches.put(cacheCtx.name(), cache);
        if (cfg.isStoreKeepBinary().booleanValue() && cfg.isStoreKeepBinary() != CacheConfiguration.DFLT_STORE_KEEP_BINARY && !(this.ctx.config().getMarshaller() instanceof BinaryMarshaller)) {
            U.warn(this.log, "CacheConfiguration.isStoreKeepBinary() configuration property will be ignored because BinaryMarshaller is not used");
        }
        for (GridCacheManager<?, ?> mgr : F.view(cacheCtx.managers(), F.notContains(this.dhtExcludes(cacheCtx)))) {
            mgr.start(cacheCtx);
        }
        cacheCtx.initConflictResolver();
        if (GridCacheUtils.isNearEnabled(cfg)) {
            GridCacheContext dhtCtx = cacheCtx.near().dht().context();
            for (GridCacheManager mgr : this.dhtManagers(dhtCtx)) {
                mgr.start(dhtCtx);
            }
            dhtCtx.initConflictResolver();
            dhtCtx.cache().start();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Started DHT cache: " + dhtCtx.cache().name());
            }
        }
        this.ctx.continuous().onCacheStart(cacheCtx);
        cacheCtx.cache().start();
    }

    private void onCacheStarted(GridCacheContext cacheCtx) throws IgniteCheckedException {
        GridCacheAdapter cache = cacheCtx.cache();
        CacheConfiguration cfg = cacheCtx.config();
        CacheGroupContext grp = (CacheGroupContext)this.cacheGrps.get(cacheCtx.groupId());
        cacheCtx.onStarted();
        String dataRegion = cfg.getDataRegionName();
        if (dataRegion == null && this.ctx.config().getDataStorageConfiguration() != null) {
            dataRegion = this.ctx.config().getDataStorageConfiguration().getDefaultDataRegionConfiguration().getName();
        }
        if (this.log.isInfoEnabled()) {
            String expPlcInfo = this.buildExpirePolicyInfo(cacheCtx);
            this.log.info("Started cache [name=" + cfg.getName() + ", id=" + cacheCtx.cacheId() + (cfg.getGroupName() != null ? ", group=" + cfg.getGroupName() : "") + ", dataRegionName=" + dataRegion + ", mode=" + (Object)((Object)cfg.getCacheMode()) + ", atomicity=" + (Object)((Object)cfg.getAtomicityMode()) + ", backups=" + cfg.getBackups() + ", mvcc=" + cacheCtx.mvccEnabled() + (expPlcInfo != null ? ", " + expPlcInfo : "") + ']');
        }
        grp.onCacheStarted(cacheCtx);
        this.onKernalStart(cache);
        if (this.ctx.performanceStatistics().enabled() && U.isLocalNodeCoordinator(this.ctx.discovery())) {
            this.ctx.performanceStatistics().cacheStart(cacheCtx.cacheId(), cfg.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridCacheContext<?, ?> startCacheInRecoveryMode(DynamicCacheDescriptor desc) throws IgniteCheckedException {
        GridCacheContext<?, ?> cacheCtx;
        CacheGroupContext grpCtx;
        desc = this.enricher().enrich(desc, true);
        CacheConfiguration cfg = desc.cacheConfiguration();
        CacheObjectContext cacheObjCtx = this.ctx.cacheObjects().contextForCache(cfg);
        this.preparePageStore(desc, true);
        this.ctx.cache().context().database().checkpointReadLock();
        try {
            grpCtx = this.getOrCreateCacheGroupContext(desc, AffinityTopologyVersion.NONE, cacheObjCtx, true, cfg.getGroupName(), true);
            cacheCtx = this.createCacheContext(cfg, grpCtx, null, desc, AffinityTopologyVersion.NONE, cacheObjCtx, true, true, false, true);
            this.initCacheContext(cacheCtx, cfg);
        }
        finally {
            this.ctx.cache().context().database().checkpointReadUnlock();
        }
        cacheCtx.onStarted();
        String dataRegion = cfg.getDataRegionName();
        if (dataRegion == null && this.ctx.config().getDataStorageConfiguration() != null) {
            dataRegion = this.ctx.config().getDataStorageConfiguration().getDefaultDataRegionConfiguration().getName();
        }
        grpCtx.onCacheStarted(cacheCtx);
        this.ctx.query().onCacheStart(new GridCacheContextInfo(cacheCtx, false), desc.schema() != null ? desc.schema() : new QuerySchema(), desc.sql());
        if (this.log.isInfoEnabled()) {
            String expPlcInfo = this.buildExpirePolicyInfo(cacheCtx);
            this.log.info("Started cache in recovery mode [name=" + cfg.getName() + ", id=" + cacheCtx.cacheId() + (cfg.getGroupName() != null ? ", group=" + cfg.getGroupName() : "") + ", dataRegionName=" + dataRegion + ", mode=" + (Object)((Object)cfg.getCacheMode()) + ", atomicity=" + (Object)((Object)cfg.getAtomicityMode()) + ", backups=" + cfg.getBackups() + ", mvcc=" + cacheCtx.mvccEnabled() + (expPlcInfo != null ? ", " + expPlcInfo : "") + ']');
        }
        return cacheCtx;
    }

    private String buildExpirePolicyInfo(@NotNull GridCacheContext cacheCtx) {
        ExpiryPolicy expPlc = cacheCtx.expiry();
        if (expPlc == null || expPlc instanceof EternalExpiryPolicy) {
            return null;
        }
        return String.format(EXPRITY_POLICY_MSG, expPlc.getClass().getName(), cacheCtx.ttl().eagerTtlEnabled());
    }

    private CacheGroupContext findCacheGroup(String grpName) {
        return this.cacheGrps.values().stream().filter(grp -> grp.sharedGroup() && grpName.equals(grp.name())).findAny().orElse(null);
    }

    public void restartProxies() {
        for (IgniteCacheProxyImpl<?, ?> proxy : this.jCacheProxies.values()) {
            GridCacheContext<?, ?> cacheCtx;
            if (proxy == null || (cacheCtx = this.sharedCtx.cacheContext(CU.cacheId(proxy.getName()))) == null || !proxy.isRestarting()) continue;
            this.caches.get(proxy.getName()).active(true);
            proxy.onRestarted(cacheCtx, cacheCtx.cache());
            if (!cacheCtx.dataStructuresCache()) continue;
            this.ctx.dataStructures().restart(proxy.getName(), proxy.internalProxy());
        }
    }

    public List<String> resetRestartingProxies() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, IgniteCacheProxyImpl<?, ?>> e : this.jCacheProxies.entrySet()) {
            IgniteCacheProxyImpl<?, ?> proxy = e.getValue();
            if (proxy == null || !proxy.isRestarting()) continue;
            String cacheName = e.getKey();
            res.add(cacheName);
            this.jCacheProxies.remove(cacheName);
            proxy.onRestarted(null, null);
            if (!DataStructuresProcessor.isDataStructureCache(cacheName)) continue;
            this.ctx.dataStructures().restart(cacheName, null);
        }
        this.cachesInfo.removeRestartingCaches();
        return res;
    }

    private CacheGroupContext startCacheGroup(CacheGroupDescriptor desc, CacheType cacheType, boolean affNode, CacheObjectContext cacheObjCtx, AffinityTopologyVersion exchTopVer, boolean recoveryMode) throws IgniteCheckedException {
        boolean needToStart;
        desc = this.enricher().enrich(desc, affNode);
        CacheConfiguration cfg = new CacheConfiguration(desc.config());
        String memPlcName = cfg.getDataRegionName();
        DataRegion dataRegion = affNode ? this.sharedCtx.database().dataRegion(memPlcName) : null;
        boolean bl = needToStart = dataRegion != null && (cacheType != CacheType.USER || this.sharedCtx.isLazyMemoryAllocation(dataRegion) && !cacheObjCtx.kernalContext().clientNode());
        if (needToStart) {
            dataRegion.pageMemory().start();
        }
        FreeList freeList = this.sharedCtx.database().freeList(memPlcName);
        ReuseList reuseList = this.sharedCtx.database().reuseList(memPlcName);
        boolean persistenceEnabled = recoveryMode || this.sharedCtx.localNode().isClient() ? desc.persistenceEnabled() : dataRegion != null && dataRegion.config().isPersistenceEnabled();
        CompressionHandler compressHandler = CompressionHandler.create(this.ctx, cfg);
        if (this.log.isInfoEnabled() && compressHandler.compressionEnabled()) {
            this.log.info("Disk page compression is enabled [cacheGrp=" + CU.cacheOrGroupName(cfg) + ", compression=" + (Object)((Object)compressHandler.diskPageCompression()) + ", level=" + compressHandler.diskPageCompressionLevel() + "]");
        }
        CacheGroupContext grp = new CacheGroupContext(this.sharedCtx, desc.groupId(), desc.receivedFrom(), cacheType, cfg, affNode, dataRegion, cacheObjCtx, freeList, reuseList, exchTopVer, persistenceEnabled, desc.walEnabled(), recoveryMode, compressHandler);
        for (Object obj : grp.configuredUserObjects()) {
            this.prepare(cfg, obj, false);
        }
        U.startLifecycleAware(grp.configuredUserObjects());
        grp.start();
        CacheGroupContext old = this.cacheGrps.put(desc.groupId(), grp);
        assert (old == null) : old.name();
        return grp;
    }

    public void blockGateway(String cacheName, boolean stop, boolean restart) {
        GridCacheAdapter<?, ?> cache;
        IgniteCacheProxyImpl<?, ?> proxy = this.jcacheProxy(cacheName, false);
        if (restart && (cache = this.caches.get(cacheName)) != null) {
            cache.active(false);
        }
        if (stop) {
            if (restart) {
                IgniteCacheProxyImpl<?, ?> oldProxy;
                if (proxy == null && (cache = this.caches.get(cacheName)) != null && (oldProxy = this.jCacheProxies.putIfAbsent(cacheName, proxy = new IgniteCacheProxyImpl(cache.context(), cache, false))) != null) {
                    proxy = oldProxy;
                }
                if (proxy != null) {
                    proxy.suspend();
                }
            }
            if (proxy != null) {
                proxy.context0().gate().stopped();
            }
        } else if (proxy != null) {
            proxy.closeProxy();
        }
    }

    private void stopGateway(DynamicCacheChangeRequest req) {
        IgniteCacheProxyImpl<?, ?> proxy;
        assert (req.stop()) : req;
        if (req.restart()) {
            GridCacheAdapter<?, ?> cache;
            if (DataStructuresProcessor.isDataStructureCache(req.cacheName())) {
                this.ctx.dataStructures().suspend(req.cacheName());
            }
            if ((cache = this.caches.get(req.cacheName())) != null) {
                cache.active(false);
            }
            if ((proxy = this.jCacheProxies.get(req.cacheName())) != null) {
                proxy.suspend();
            }
        } else {
            this.completeProxyInitialize(req.cacheName());
            proxy = this.jCacheProxies.remove(req.cacheName());
        }
        if (proxy != null) {
            proxy.context0().gate().onStopped();
        }
    }

    public void prepareCacheStop(String cacheName, boolean callDestroy, boolean clearCache) {
        this.prepareCacheStop(cacheName, callDestroy, clearCache, true);
    }

    public void prepareCacheStop(String cacheName, boolean callDestroy, boolean clearCache, boolean clearDbObjects) {
        assert (this.sharedCtx.database().checkpointLockIsHeldByThread());
        GridCacheAdapter<?, ?> cache = this.caches.remove(cacheName);
        if (cache != null) {
            GridCacheContext<?, ?> ctx = cache.context();
            this.sharedCtx.removeCacheContext(ctx);
            this.onKernalStop(cache, true);
            this.stopCache(cache, true, callDestroy, clearCache, clearDbObjects);
        } else {
            this.ctx.query().onCacheStop(cacheName);
        }
    }

    void initCacheProxies(AffinityTopologyVersion startTopVer, @Nullable Throwable err) {
        for (GridCacheAdapter<?, ?> cache : this.caches.values()) {
            GridCacheContext<?, ?> cacheCtx = cache.context();
            if (!cacheCtx.startTopologyVersion().equals(startTopVer)) continue;
            if (!this.jCacheProxies.containsKey(cacheCtx.name())) {
                IgniteCacheProxyImpl newProxy = new IgniteCacheProxyImpl(cache.context(), cache, false);
                if (!cache.active()) {
                    newProxy.suspend();
                }
                this.addjCacheProxy(cacheCtx.name(), newProxy);
            }
            if (cacheCtx.preloader() == null) continue;
            cacheCtx.preloader().onInitialExchangeComplete(err);
        }
    }

    Set<Integer> closeCaches(Set<String> cachesToClose, boolean retClientCaches) {
        HashSet ids = null;
        for (String cacheName : cachesToClose) {
            this.completeProxyInitialize(cacheName);
            this.blockGateway(cacheName, false, false);
            GridCacheContext<?, ?> ctx = this.sharedCtx.cacheContext(CU.cacheId(cacheName));
            if (ctx == null) continue;
            if (retClientCaches && !ctx.affinityNode()) {
                if (ids == null) {
                    ids = U.newHashSet(cachesToClose.size());
                }
                ids.add(ctx.cacheId());
            }
            this.closeCache(ctx);
        }
        return ids;
    }

    private void closeCache(GridCacheContext cctx) {
        if (cctx.affinityNode()) {
            GridCacheAdapter<?, ?> cache = this.caches.get(cctx.name());
            assert (cache != null) : cctx.name();
            this.jCacheProxies.put(cctx.name(), new IgniteCacheProxyImpl(cache.context(), cache, false));
            this.completeProxyInitialize(cctx.name());
        } else {
            cctx.gate().onStopped();
            this.sharedCtx.io().writeLock();
            try {
                if (!cctx.affinityNode() && cctx.transactional()) {
                    this.sharedCtx.tm().rollbackTransactionsForCache(cctx.cacheId());
                }
                this.completeProxyInitialize(cctx.name());
                this.jCacheProxies.remove(cctx.name());
                this.closeCacheOnNotAffinityNode(cctx);
            }
            finally {
                this.sharedCtx.io().writeUnlock();
            }
        }
    }

    private void closeCacheOnNotAffinityNode(GridCacheContext cctx) {
        if (this.ctx.query().moduleEnabled()) {
            this.stopCacheSafely(cctx, false);
        } else {
            this.stopCacheSafely(cctx);
        }
    }

    void forceCloseCaches(AffinityTopologyVersion topVer, ExchangeActions exchActions) {
        assert (exchActions != null && !exchActions.cacheStopRequests().isEmpty());
        this.processCacheStopRequestOnExchangeDone(topVer, exchActions);
    }

    private void processCacheStopRequestOnExchangeDone(AffinityTopologyVersion topVer, ExchangeActions exchActions) {
        int parallelismLvl = U.availableThreadCount(this.ctx, (byte)2, 2);
        List<IgniteBiTuple<CacheGroupContext, Boolean>> grpsToStop = exchActions.cacheGroupsToStop().stream().filter(a -> this.cacheGrps.containsKey(a.descriptor().groupId())).map(a -> F.t(this.cacheGrps.get(a.descriptor().groupId()), a.destroy())).collect(Collectors.toList());
        grpsToStop.forEach(t2 -> this.sharedCtx.evict().onCacheGroupStopped((CacheGroupContext)t2.get1()));
        Map<Integer, List<ExchangeActions.CacheActionData>> cachesToStop = exchActions.cacheStopRequests().stream().collect(Collectors.groupingBy(action -> action.descriptor().groupId()));
        Set grpIdToDestroy = grpsToStop.stream().filter(IgniteBiTuple::get2).map(t2 -> ((CacheGroupContext)t2.get1()).groupId()).collect(Collectors.toSet());
        try {
            IgniteUtils.doInParallel(parallelismLvl, this.sharedCtx.kernalContext().pools().getSystemExecutorService(), cachesToStop.entrySet(), cachesToStopByGrp -> {
                Integer groupId = (Integer)cachesToStopByGrp.getKey();
                CacheGroupContext gctx = (CacheGroupContext)this.cacheGrps.get(groupId);
                if (gctx != null) {
                    String msg = "Failed to wait for topology update, cache group is stopping.";
                    gctx.affinity().cancelFutures(new CacheStoppedException("Failed to wait for topology update, cache group is stopping."));
                }
                for (ExchangeActions.CacheActionData action : (List)cachesToStopByGrp.getValue()) {
                    this.context().tm().rollbackTransactionsForStoppingCache(action.descriptor().cacheId());
                    this.stopGateway(action.request());
                    this.context().tm().rollbackTransactionsForStoppingCache(action.descriptor().cacheId());
                    String cacheName = action.request().cacheName();
                    GridCacheAdapter<?, ?> cache = this.caches.get(cacheName);
                    if (cache == null) continue;
                    cache.context().ttl().unregister();
                }
                return null;
            });
            grpsToStop.forEach(g2 -> ((CacheGroupContext)g2.get1()).prepareToStop());
            if (!exchActions.cacheStopRequests().isEmpty()) {
                this.removeOffheapListenerAfterCheckpoint(grpsToStop);
            }
            IgniteUtils.doInParallel(parallelismLvl, this.sharedCtx.kernalContext().pools().getSystemExecutorService(), cachesToStop.entrySet(), cachesToStopByGrp -> {
                Integer groupId = (Integer)cachesToStopByGrp.getKey();
                CacheGroupContext gctx = (CacheGroupContext)this.cacheGrps.get(groupId);
                if (gctx != null) {
                    gctx.preloader().pause();
                }
                try {
                    for (ExchangeActions.CacheActionData action : (List)cachesToStopByGrp.getValue()) {
                        String cacheName = action.request().cacheName();
                        this.sharedCtx.database().checkpointReadLock();
                        try {
                            boolean callDestroy = action.request().destroy();
                            boolean clearCache = callDestroy && !grpIdToDestroy.contains(groupId);
                            this.prepareCacheStop(cacheName, callDestroy, clearCache);
                            if (!callDestroy && !grpIdToDestroy.contains(groupId)) continue;
                            this.ctx.query().completeRebuildIndexes(cacheName);
                        }
                        finally {
                            this.sharedCtx.database().checkpointReadUnlock();
                        }
                    }
                }
                finally {
                    if (gctx != null) {
                        gctx.preloader().resume();
                    }
                }
                return null;
            });
        }
        catch (IgniteCheckedException e) {
            String msg = "Failed to stop caches";
            this.log.error(msg, e);
            throw new IgniteException(msg, e);
        }
        finally {
            this.cachesInfo.cleanupRemovedCaches(topVer);
        }
        for (IgniteBiTuple<CacheGroupContext, Boolean> grp : grpsToStop) {
            this.stopCacheGroup(grp.get1().groupId(), (boolean)grp.get2());
        }
        if (!this.sharedCtx.kernalContext().clientNode()) {
            this.sharedCtx.database().onCacheGroupsStopped(grpsToStop);
        }
        this.cachesInfo.cleanupRemovedCacheGroups(topVer);
        if (exchActions.deactivate()) {
            this.sharedCtx.deactivate();
        }
    }

    private DataStorageConfiguration extractDataStorage(ClusterNode rmtNode) {
        return GridCacheUtils.extractDataStorage(rmtNode, this.ctx.marshallerContext().jdkMarshaller(), U.resolveClassLoader(this.ctx.config()));
    }

    private Map<String, DataRegionConfiguration> dataRegionCfgs(DataStorageConfiguration dataStorageCfg) {
        if (dataStorageCfg != null) {
            return Optional.ofNullable(dataStorageCfg.getDataRegionConfigurations()).map(Stream::of).orElseGet(Stream::empty).collect(Collectors.toMap(DataRegionConfiguration::getName, e -> e));
        }
        return Collections.emptyMap();
    }

    private void removeOffheapListenerAfterCheckpoint(List<IgniteBiTuple<CacheGroupContext, Boolean>> grpToStop) {
        try {
            this.sharedCtx.database().waitForCheckpoint("caches stop", fut -> this.removeOffheapCheckpointListener(grpToStop));
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to wait for checkpoint finish during cache stop.", e);
        }
    }

    private void removeOffheapCheckpointListener(List<IgniteBiTuple<CacheGroupContext, Boolean>> grpToStop) {
        this.sharedCtx.database().checkpointReadLock();
        try {
            grpToStop.forEach(grp -> {
                CacheGroupContext gctx = (CacheGroupContext)grp.getKey();
                if (gctx != null && gctx.persistenceEnabled() && this.sharedCtx.database() instanceof GridCacheDatabaseSharedManager) {
                    GridCacheDatabaseSharedManager mngr = (GridCacheDatabaseSharedManager)this.sharedCtx.database();
                    mngr.removeCheckpointListener((CheckpointListener)((Object)gctx.offheap()));
                }
            });
        }
        finally {
            this.sharedCtx.database().checkpointReadUnlock();
        }
    }

    public void onExchangeDone(AffinityTopologyVersion cacheStartVer, @Nullable ExchangeActions exchActions, @Nullable Throwable err) {
        this.initCacheProxies(cacheStartVer, err);
        if (exchActions == null) {
            return;
        }
        if (exchActions.systemCachesStarting() && exchActions.stateChangeRequest() == null) {
            this.ctx.dataStructures().restoreStructuresState(this.ctx);
        }
        if (err == null) {
            this.processCacheStopRequestOnExchangeDone(cacheStartVer, exchActions);
        }
    }

    private void stopCacheGroup(int grpId, boolean destroy) {
        CacheGroupContext grp = (CacheGroupContext)this.cacheGrps.remove(grpId);
        if (grp != null) {
            this.stopCacheGroup(grp, destroy);
        }
    }

    private void stopCacheGroup(CacheGroupContext grp, boolean destroy) {
        grp.stopGroup();
        U.stopLifecycleAware(this.log, grp.configuredUserObjects());
        this.cleanup(grp, destroy);
    }

    void completeTemplateAddFuture(String cacheName, IgniteUuid deploymentId) {
        TemplateConfigurationFuture fut = (TemplateConfigurationFuture)this.pendingTemplateFuts.get(cacheName);
        if (fut != null && fut.deploymentId().equals(deploymentId)) {
            fut.onDone();
        }
    }

    public void completeCacheStartFuture(DynamicCacheChangeRequest req, boolean success, @Nullable Throwable err) {
        DynamicCacheStartFuture fut;
        if (this.ctx.localNodeId().equals(req.initiatingNodeId()) && (fut = (DynamicCacheStartFuture)this.pendingFuts.get(req.requestId())) != null) {
            fut.onDone(success, err);
        }
    }

    void completeClientCacheChangeFuture(UUID reqId, @Nullable Exception err) {
        DynamicCacheStartFuture fut = (DynamicCacheStartFuture)this.pendingFuts.get(reqId);
        if (fut != null) {
            fut.onDone(false, (Throwable)err);
        }
    }

    private GridCacheSharedContext createSharedContext(GridKernalContext kernalCtx, Collection<CacheStoreSessionListener> storeSesLsnrs) throws IgniteCheckedException {
        IgniteCacheSnapshotManager snpMgr;
        IgniteCacheDatabaseSharedManager dbMgr;
        IgniteTxManager tm = new IgniteTxManager();
        GridCacheMvccManager mvccMgr = new GridCacheMvccManager();
        GridCacheVersionManager verMgr = new GridCacheVersionManager();
        GridCacheDeploymentManager depMgr = new GridCacheDeploymentManager();
        GridCachePartitionExchangeManager exchMgr = new GridCachePartitionExchangeManager();
        IgnitePageStoreManager pageStoreMgr = null;
        IgniteWriteAheadLogManager walMgr = null;
        if (CU.isPersistenceEnabled(this.ctx.config()) && !this.ctx.clientNode()) {
            dbMgr = new GridCacheDatabaseSharedManager(this.ctx);
            pageStoreMgr = this.ctx.plugins().createComponent(IgnitePageStoreManager.class);
            if (pageStoreMgr == null) {
                pageStoreMgr = new FilePageStoreManager(this.ctx);
            }
        } else {
            if (CU.isPersistenceEnabled(this.ctx.config()) && this.ctx.clientNode()) {
                U.warn(this.log, "Persistent Store is not supported on client nodes (Persistent Store's configuration will be ignored).");
            }
            dbMgr = new IgniteCacheDatabaseSharedManager(this.ctx);
        }
        if ((CU.isPersistenceEnabled(this.ctx.config()) || CU.isCdcEnabled(this.ctx.config())) && !this.ctx.clientNode() && (walMgr = this.ctx.plugins().createComponent(IgniteWriteAheadLogManager.class)) == null) {
            walMgr = new FileWriteAheadLogManager(this.ctx);
        }
        WalStateManager walStateMgr = new WalStateManager(this.ctx);
        IgniteSnapshotManager snapshotMgr = this.ctx.plugins().createComponent(IgniteSnapshotManager.class);
        if (snapshotMgr == null) {
            snapshotMgr = new IgniteSnapshotManager(this.ctx);
        }
        if ((snpMgr = this.ctx.plugins().createComponent(IgniteCacheSnapshotManager.class)) == null) {
            snpMgr = new IgniteCacheSnapshotManager();
        }
        CacheObjectTransformerManager transMgr = this.ctx.plugins().createComponent(CacheObjectTransformerManager.class);
        GridCacheIoManager ioMgr = new GridCacheIoManager();
        CacheAffinitySharedManager topMgr = new CacheAffinitySharedManager();
        GridCacheSharedTtlCleanupManager ttl = new GridCacheSharedTtlCleanupManager();
        PartitionsEvictManager evict = new PartitionsEvictManager();
        CacheJtaManagerAdapter jta = (CacheJtaManagerAdapter)IgniteComponentType.JTA.createOptional();
        MvccCachingManager mvccCachingMgr = new MvccCachingManager();
        DeadlockDetectionManager deadlockDetectionMgr = new DeadlockDetectionManager();
        CacheDiagnosticManager diagnosticMgr = new CacheDiagnosticManager();
        return new GridCacheSharedContext(kernalCtx, tm, verMgr, mvccMgr, pageStoreMgr, walMgr, walStateMgr, dbMgr, snapshotMgr, snpMgr, depMgr, exchMgr, topMgr, ioMgr, ttl, evict, jta, storeSesLsnrs, mvccCachingMgr, deadlockDetectionMgr, diagnosticMgr, transMgr);
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.CACHE_PROC;
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        this.cachesInfo.collectJoiningNodeData(dataBag);
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        this.cachesInfo.collectGridNodeData(dataBag, this.backwardCompatibleSplitter());
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        this.cachesInfo.onJoiningNodeDataReceived(data);
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        this.cachesInfo.onGridDataReceived(data);
        this.sharedCtx.walState().onCachesInfoCollected();
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        if (!this.cachesInfo.isMergeConfigSupports(node)) {
            return null;
        }
        String validationRes = this.cachesInfo.validateJoiningNodeData(discoData, node.isClient());
        if (validationRes != null) {
            return new IgniteNodeValidationResult(node.id(), validationRes, validationRes);
        }
        return ValidationOnNodeJoinUtils.validateNode(node, discoData, this.marsh, this.ctx, this::cacheDescriptor);
    }

    public void onStateChangeFinish(ChangeGlobalStateFinishMessage msg) {
        this.cachesInfo.onStateChangeFinish(msg);
    }

    public ExchangeActions onStateChangeRequest(ChangeGlobalStateMessage msg, AffinityTopologyVersion topVer, DiscoveryDataClusterState curState) throws IgniteCheckedException {
        return this.cachesInfo.onStateChangeRequest(msg, topVer, curState);
    }

    public void onCacheStatisticsModeChange(CacheStatisticsModeChangeMessage msg) {
        assert (msg != null);
        if (msg.initial()) {
            EnableStatisticsFuture fut = (EnableStatisticsFuture)this.manageStatisticsFuts.get(msg.requestId());
            if (fut != null && !this.cacheNames().containsAll(msg.caches())) {
                fut.onDone(new IgniteCheckedException("One or more cache descriptors not found [caches=" + this.caches + ']'));
                return;
            }
            for (String cacheName : msg.caches()) {
                DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.cachesInfo.registeredCaches().get(cacheName);
                if (desc != null) {
                    if (desc.cacheConfiguration().isStatisticsEnabled() == msg.enabled()) continue;
                    desc.cacheConfiguration().setStatisticsEnabled(msg.enabled());
                    try {
                        this.ctx.cache().saveCacheConfiguration(desc);
                    }
                    catch (IgniteCheckedException e) {
                        this.log.error("Error while saving cache configuration to disk, cfg = " + desc.cacheConfiguration(), e);
                    }
                    continue;
                }
                this.log.warning("Failed to change cache descriptor configuration, cache not found [cacheName=" + cacheName + ']');
            }
        } else {
            EnableStatisticsFuture fut = (EnableStatisticsFuture)this.manageStatisticsFuts.get(msg.requestId());
            if (fut != null) {
                fut.onDone();
            }
        }
    }

    private void onCacheStatisticsClear(CacheStatisticsClearMessage msg) {
        assert (msg != null);
        if (msg.initial()) {
            EnableStatisticsFuture fut = (EnableStatisticsFuture)this.manageStatisticsFuts.get(msg.requestId());
            if (fut != null && !this.cacheNames().containsAll(msg.caches())) {
                fut.onDone(new IgniteCheckedException("One or more cache descriptors not found [caches=" + this.caches + ']'));
                return;
            }
            for (String cacheName : msg.caches()) {
                GridCacheAdapter cache = this.ctx.cache().internalCache(cacheName);
                if (cache != null) {
                    cache.metrics0().clear();
                    continue;
                }
                this.log.warning("Failed to clear cache statistics, cache not found [cacheName=" + cacheName + ']');
            }
        } else {
            EnableStatisticsFuture fut = (EnableStatisticsFuture)this.manageStatisticsFuts.get(msg.requestId());
            if (fut != null) {
                fut.onDone();
            }
        }
    }

    public void processStatisticsModeChange(CacheStatisticsModeChangeMessage msg) {
        assert (msg != null);
        for (String cacheName : msg.caches()) {
            IgniteInternalCache cache = this.cache(cacheName);
            if (cache != null) {
                cache.context().statisticsEnabled(msg.enabled());
                continue;
            }
            this.log.warning("Failed to change cache configuration, cache not found [cacheName=" + cacheName + ']');
        }
    }

    private void stopCachesOnClientReconnect(Collection<GridCacheAdapter> stoppedCaches) {
        assert (this.ctx.discovery().localNode().isClient());
        for (GridCacheAdapter cache : stoppedCaches) {
            CacheGroupContext grp = cache.context().group();
            this.onKernalStop(cache, true);
            this.stopCache(cache, true, false, false);
            this.sharedCtx.affinity().stopCacheOnReconnect(cache.context());
            if (grp.hasCaches()) continue;
            this.stopCacheGroup(grp, false);
            this.sharedCtx.affinity().stopCacheGroupOnReconnect(grp);
        }
    }

    public IgniteInternalFuture<?> createFromTemplate(String cacheName) {
        try {
            CacheConfiguration cfg = this.getOrCreateConfigFromTemplate(cacheName);
            return this.dynamicStartCache(cfg, cacheName, null, true, true, true);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public IgniteInternalFuture<?> getOrCreateFromTemplate(String cacheName, boolean checkThreadTx) {
        return this.getOrCreateFromTemplate(cacheName, cacheName, null, checkThreadTx);
    }

    public IgniteInternalFuture<?> getOrCreateFromTemplate(String cacheName, String templateName, CacheConfigurationOverride cfgOverride, boolean checkThreadTx) {
        assert (cacheName != null);
        try {
            if (this.publicJCache(cacheName, false, checkThreadTx) != null) {
                return new GridFinishedFuture();
            }
            CacheConfiguration ccfg = F.isEmpty(templateName) ? this.getOrCreateConfigFromTemplate(cacheName) : this.getOrCreateConfigFromTemplate(templateName);
            ccfg.setName(cacheName);
            if (cfgOverride != null) {
                cfgOverride.apply(ccfg);
            }
            return this.dynamicStartCache(ccfg, cacheName, null, false, true, checkThreadTx);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture(e);
        }
    }

    public CacheConfiguration getConfigFromTemplate(String cacheName) throws IgniteCheckedException {
        DynamicCacheDescriptor cfgTemplate = null;
        DynamicCacheDescriptor dfltCacheCfg = null;
        ArrayList<DynamicCacheDescriptor> wildcardNameCfgs = null;
        for (DynamicCacheDescriptor desc : this.cachesInfo.registeredTemplates().values()) {
            assert (desc.template());
            CacheConfiguration cfg = desc.cacheConfiguration();
            assert (cfg != null);
            if (F.eq(cacheName, cfg.getName())) {
                cfgTemplate = desc;
                break;
            }
            if (cfg.getName() != null) {
                if (!GridCacheUtils.isCacheTemplateName(cfg.getName())) continue;
                if (cfg.getName().length() > 1) {
                    if (wildcardNameCfgs == null) {
                        wildcardNameCfgs = new ArrayList<DynamicCacheDescriptor>();
                    }
                    wildcardNameCfgs.add(desc);
                    continue;
                }
                dfltCacheCfg = desc;
                continue;
            }
            if (dfltCacheCfg != null) continue;
            dfltCacheCfg = desc;
        }
        if (cfgTemplate == null && cacheName != null && wildcardNameCfgs != null) {
            wildcardNameCfgs.sort((a, b) -> Integer.compare(b.cacheConfiguration().getName().length(), a.cacheConfiguration().getName().length()));
            for (DynamicCacheDescriptor desc : wildcardNameCfgs) {
                String wildcardCacheName = desc.cacheConfiguration().getName();
                if (!cacheName.startsWith(wildcardCacheName.substring(0, wildcardCacheName.length() - 1))) continue;
                cfgTemplate = desc;
                break;
            }
        }
        if (cfgTemplate == null) {
            cfgTemplate = dfltCacheCfg;
        }
        if (cfgTemplate == null) {
            return null;
        }
        CacheConfiguration enrichedTemplate = this.enricher().enrichFully(cfgTemplate.cacheConfiguration(), cfgTemplate.cacheConfigurationEnrichment());
        enrichedTemplate = this.cloneCheckSerializable(enrichedTemplate);
        CacheConfiguration cfg = new CacheConfiguration(enrichedTemplate);
        cfg.setName(cacheName);
        return cfg;
    }

    private CacheConfiguration getOrCreateConfigFromTemplate(String cacheName) throws IgniteCheckedException {
        CacheConfiguration cfg = this.getConfigFromTemplate(cacheName);
        return cfg != null ? cfg : new CacheConfiguration(cacheName);
    }

    public IgniteInternalFuture<Boolean> dynamicStartCache(@Nullable CacheConfiguration ccfg, String cacheName, @Nullable NearCacheConfiguration nearCfg, boolean failIfExists, boolean failIfNotStarted, boolean checkThreadTx) {
        return this.dynamicStartCache(ccfg, cacheName, nearCfg, CacheType.USER, false, failIfExists, failIfNotStarted, checkThreadTx);
    }

    public IgniteInternalFuture<Boolean> dynamicStartSqlCache(CacheConfiguration ccfg) {
        A.notNull(ccfg, "ccfg");
        return this.dynamicStartCache(ccfg, ccfg.getName(), ccfg.getNearConfiguration(), CacheType.USER, true, false, true, true);
    }

    public IgniteInternalFuture<Boolean> dynamicStartCache(@Nullable CacheConfiguration ccfg, String cacheName, @Nullable NearCacheConfiguration nearCfg, CacheType cacheType, boolean sql, boolean failIfExists, boolean failIfNotStarted, boolean checkThreadTx) {
        assert (cacheName != null);
        if (checkThreadTx) {
            this.sharedCtx.tm().checkEmptyTransactions(() -> String.format(CHECK_EMPTY_TRANSACTIONS_ERROR_MSG_FORMAT, cacheName, "dynamicStartCache"));
        }
        GridPlainClosure2<Collection<byte[]>, byte[], IgniteInternalFuture<Boolean>> startCacheClsr = (grpKeys, masterKeyDigest) -> {
            assert (ccfg == null || !ccfg.isEncryptionEnabled() || !grpKeys.isEmpty());
            DynamicCacheChangeRequest req = this.prepareCacheChangeRequest(ccfg, cacheName, nearCfg, cacheType, sql, failIfExists, failIfNotStarted, null, false, null, ccfg != null && ccfg.isEncryptionEnabled() ? (byte[])grpKeys.iterator().next() : null, null, ccfg != null && ccfg.isEncryptionEnabled() ? masterKeyDigest : null);
            if (req != null) {
                if (req.clientStartOnly()) {
                    return this.startClientCacheChange(F.asMap(req.cacheName(), req), null);
                }
                return F.first(this.initiateCacheChanges(F.asList(req)));
            }
            return new GridFinishedFuture();
        };
        try {
            if (ccfg != null && ccfg.isEncryptionEnabled()) {
                this.ctx.encryption().checkEncryptedCacheSupported();
                return this.generateEncryptionKeysAndStartCacheAfter(1, startCacheClsr);
            }
            return startCacheClsr.apply(Collections.EMPTY_SET, null);
        }
        catch (Exception e) {
            return new GridFinishedFuture<Boolean>(e);
        }
    }

    private void checkReadOnlyState(String opName, Collection<StoredCacheData> cfgs) {
        IgniteOutClosure<String> cacheNameClo = null;
        IgniteOutClosure<String> cacheGrpNameClo = null;
        if (!F.isEmpty(cfgs)) {
            if (cfgs.size() == 1) {
                CacheConfiguration<?, ?> cfg = cfgs.iterator().next().config();
                cacheNameClo = cfg::getName;
                cacheGrpNameClo = cfg::getGroupName;
            } else {
                cacheNameClo = () -> cfgs.stream().map(StoredCacheData::config).map(CacheConfiguration::getName).collect(Collectors.toList()).toString();
                cacheGrpNameClo = () -> cfgs.stream().map(StoredCacheData::config).map(CacheConfiguration::getGroupName).collect(Collectors.toList()).toString();
            }
        }
        this.checkReadOnlyState(opName, cacheGrpNameClo, cacheNameClo);
    }

    public void checkReadOnlyState(String opName, CacheConfiguration ... cfgs) {
        IgniteOutClosure<String> cacheNameClo = null;
        IgniteOutClosure<String> cacheGrpNameClo = null;
        if (!F.isEmpty(cfgs)) {
            if (cfgs.length == 1) {
                cacheNameClo = () -> cfgs[0] == null ? null : cfgs[0].getName();
                cacheGrpNameClo = () -> cfgs[0] == null ? null : cfgs[0].getGroupName();
            } else {
                cacheNameClo = () -> Stream.of(cfgs).map(CacheConfiguration::getName).collect(Collectors.toList()).toString();
                cacheGrpNameClo = () -> Stream.of(cfgs).map(CacheConfiguration::getGroupName).collect(Collectors.toList()).toString();
            }
        }
        this.checkReadOnlyState(opName, cacheGrpNameClo, cacheNameClo);
    }

    private void checkReadOnlyState(String opName, @Nullable IgniteOutClosure<String> cacheGrpNameClo, @Nullable IgniteOutClosure<String> cacheNameClo) {
        if (this.sharedCtx.readOnlyMode()) {
            String cacheName = cacheNameClo == null ? null : cacheNameClo.apply();
            String cacheGrpName = cacheGrpNameClo == null ? null : cacheGrpNameClo.apply();
            String errorMsg = String.format(CLUSTER_READ_ONLY_MODE_ERROR_MSG_FORMAT, opName, cacheGrpName, cacheName);
            throw new CacheException(new IgniteClusterReadOnlyException(errorMsg));
        }
    }

    private IgniteInternalFuture<Boolean> generateEncryptionKeysAndStartCacheAfter(final int keyCnt, final GridPlainClosure2<Collection<byte[]>, byte[], IgniteInternalFuture<Boolean>> after) {
        IgniteInternalFuture<T2<Collection<byte[]>, byte[]>> genEncKeyFut = this.ctx.encryption().generateKeys(keyCnt);
        final GridFutureAdapter<Boolean> res = new GridFutureAdapter<Boolean>();
        genEncKeyFut.listen(new IgniteInClosure<IgniteInternalFuture<T2<Collection<byte[]>, byte[]>>>(){

            @Override
            public void apply(IgniteInternalFuture<T2<Collection<byte[]>, byte[]>> fut) {
                try {
                    Collection grpKeys = (Collection)fut.result().get1();
                    byte[] masterKeyDigest = (byte[])fut.result().get2();
                    if (F.size(grpKeys, F.alwaysTrue()) != keyCnt) {
                        res.onDone(false, fut.error());
                    }
                    IgniteInternalFuture dynStartCacheFut = (IgniteInternalFuture)after.apply(grpKeys, masterKeyDigest);
                    dynStartCacheFut.listen(new IgniteInClosure<IgniteInternalFuture<Boolean>>(){

                        @Override
                        public void apply(IgniteInternalFuture<Boolean> fut) {
                            try {
                                res.onDone(fut.get(), fut.error());
                            }
                            catch (IgniteCheckedException e) {
                                res.onDone(false, e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    res.onDone(false, e);
                }
            }
        });
        return res;
    }

    private IgniteInternalFuture<Boolean> startClientCacheChange(@Nullable Map<String, DynamicCacheChangeRequest> startReqs, @Nullable Set<String> cachesToClose) {
        assert (startReqs != null ^ cachesToClose != null);
        DynamicCacheStartFuture fut = new DynamicCacheStartFuture(UUID.randomUUID());
        IgniteInternalFuture old = this.pendingFuts.put(fut.id, fut);
        assert (old == null) : old;
        this.ctx.discovery().clientCacheStartEvent(fut.id, startReqs, cachesToClose);
        IgniteCheckedException err = this.checkNodeState();
        if (err != null) {
            fut.onDone(err);
        }
        return fut;
    }

    public IgniteInternalFuture<Boolean> dynamicStartCaches(Collection<CacheConfiguration> ccfgList, boolean failIfExists, boolean checkThreadTx, boolean disabledAfterStart) {
        return this.dynamicStartCachesByStoredConf(ccfgList.stream().map(StoredCacheData::new).collect(Collectors.toList()), failIfExists, checkThreadTx, disabledAfterStart, null);
    }

    public IgniteInternalFuture<Boolean> dynamicStartCachesByStoredConf(Collection<StoredCacheData> storedCacheDataList, boolean failIfExists, boolean checkThreadTx, boolean disabledAfterStart, IgniteUuid restartId) {
        if (checkThreadTx) {
            this.sharedCtx.tm().checkEmptyTransactions(() -> {
                List cacheNames = storedCacheDataList.stream().map(StoredCacheData::config).map(CacheConfiguration::getName).collect(Collectors.toList());
                return String.format(CHECK_EMPTY_TRANSACTIONS_ERROR_MSG_FORMAT, cacheNames, "dynamicStartCachesByStoredConf");
            });
        }
        GridPlainClosure2<Collection<byte[]>, byte[], IgniteInternalFuture<Boolean>> startCacheClsr = (grpKeys, masterKeyDigest) -> {
            ArrayList<DynamicCacheChangeRequest> srvReqs = null;
            LinkedHashMap<String, DynamicCacheChangeRequest> clientReqs = null;
            Iterator grpKeysIter = grpKeys.iterator();
            for (Object ccfg : storedCacheDataList) {
                GroupKeyEncrypted encrKey;
                assert (((StoredCacheData)ccfg).groupKeyEncrypted() == null || ((StoredCacheData)ccfg).config().isEncryptionEnabled());
                GroupKeyEncrypted groupKeyEncrypted = ((StoredCacheData)ccfg).config().isEncryptionEnabled() ? (((StoredCacheData)ccfg).groupKeyEncrypted() != null ? ((StoredCacheData)ccfg).groupKeyEncrypted() : new GroupKeyEncrypted(0, (byte[])grpKeysIter.next())) : (encrKey = null);
                DynamicCacheChangeRequest req = this.prepareCacheChangeRequest(((StoredCacheData)ccfg).config(), ((StoredCacheData)ccfg).config().getName(), null, this.resolveCacheType(((StoredCacheData)ccfg).config()), ((StoredCacheData)ccfg).sql(), failIfExists, true, restartId, disabledAfterStart, ((StoredCacheData)ccfg).queryEntities(), encrKey != null ? encrKey.key() : null, encrKey != null ? Integer.valueOf(encrKey.id()) : null, (byte[])(encrKey != null ? masterKeyDigest : null));
                if (req == null) continue;
                if (req.clientStartOnly()) {
                    if (clientReqs == null) {
                        clientReqs = U.newLinkedHashMap(storedCacheDataList.size());
                    }
                    clientReqs.put(req.cacheName(), req);
                    continue;
                }
                if (srvReqs == null) {
                    srvReqs = new ArrayList<DynamicCacheChangeRequest>(storedCacheDataList.size());
                }
                srvReqs.add(req);
            }
            if (srvReqs == null && clientReqs == null) {
                return new GridFinishedFuture();
            }
            if (clientReqs != null && srvReqs == null) {
                return this.startClientCacheChange(clientReqs, null);
            }
            GridCompoundFuture compoundFut = new GridCompoundFuture();
            for (DynamicCacheStartFuture fut : this.initiateCacheChanges(srvReqs)) {
                compoundFut.add(fut);
            }
            if (clientReqs != null) {
                IgniteInternalFuture<Boolean> clientStartFut = this.startClientCacheChange(clientReqs, null);
                compoundFut.add(clientStartFut);
            }
            compoundFut.markInitialized();
            return compoundFut;
        };
        int encGrpCnt = 0;
        for (StoredCacheData ccfg : storedCacheDataList) {
            if (!ccfg.config().isEncryptionEnabled()) continue;
            ++encGrpCnt;
        }
        return this.generateEncryptionKeysAndStartCacheAfter(encGrpCnt, startCacheClsr);
    }

    @NotNull
    private CacheType resolveCacheType(CacheConfiguration ccfg) {
        if (CU.isUtilityCache(ccfg.getName())) {
            return CacheType.UTILITY;
        }
        if (this.internalCaches.contains(ccfg.getName())) {
            return CacheType.INTERNAL;
        }
        if (DataStructuresProcessor.isDataStructureCache(ccfg.getName())) {
            return CacheType.DATA_STRUCTURES;
        }
        return CacheType.USER;
    }

    public IgniteInternalFuture<Boolean> dynamicDestroyCache(String cacheName, boolean sql, boolean checkThreadTx, boolean restart, IgniteUuid restartId) {
        assert (cacheName != null);
        if (checkThreadTx) {
            this.sharedCtx.tm().checkEmptyTransactions(() -> String.format(CHECK_EMPTY_TRANSACTIONS_ERROR_MSG_FORMAT, cacheName, "dynamicDestroyCache"));
        }
        this.checkReadOnlyState("dynamic destroy cache", null, cacheName::toString);
        DynamicCacheChangeRequest req = DynamicCacheChangeRequest.stopRequest(this.ctx, cacheName, sql, true);
        req.stop(true);
        req.destroy(true);
        req.restart(restart);
        req.restartId(restartId);
        return F.first(this.initiateCacheChanges(F.asList(req)));
    }

    public IgniteInternalFuture<?> dynamicDestroyCaches(Collection<String> cacheNames, boolean checkThreadTx) {
        return this.dynamicDestroyCaches(cacheNames, checkThreadTx, true);
    }

    public IgniteInternalFuture<?> dynamicDestroyCaches(Collection<String> cacheNames, boolean checkThreadTx, boolean destroy) {
        if (checkThreadTx) {
            this.sharedCtx.tm().checkEmptyTransactions(() -> String.format(CHECK_EMPTY_TRANSACTIONS_ERROR_MSG_FORMAT, cacheNames, "dynamicDestroyCaches"));
        }
        if (!F.isEmpty(cacheNames)) {
            this.checkReadOnlyState("dynamic destroy caches", null, cacheNames::toString);
        }
        return this.dynamicChangeCaches(cacheNames.stream().map(cacheName -> this.createStopRequest((String)cacheName, false, null, destroy)).collect(Collectors.toList()));
    }

    @NotNull
    public DynamicCacheChangeRequest createStopRequest(String cacheName, boolean restart, IgniteUuid restartId, boolean destroy) {
        DynamicCacheChangeRequest req = DynamicCacheChangeRequest.stopRequest(this.ctx, cacheName, false, true);
        req.stop(true);
        req.destroy(destroy);
        req.restart(restart);
        req.restartId(restartId);
        return req;
    }

    @NotNull
    public IgniteInternalFuture<?> dynamicChangeCaches(List<DynamicCacheChangeRequest> reqs) {
        return this.initiateCacheChanges(reqs).stream().collect(IgniteCollectors.toCompoundFuture());
    }

    IgniteInternalFuture<?> dynamicCloseCache(String cacheName) {
        assert (cacheName != null);
        IgniteCacheProxyImpl<?, ?> proxy = this.jcacheProxy(cacheName, false);
        if (proxy == null || proxy.isProxyClosed()) {
            return new GridFinishedFuture();
        }
        this.sharedCtx.tm().checkEmptyTransactions(() -> String.format(CHECK_EMPTY_TRANSACTIONS_ERROR_MSG_FORMAT, cacheName, "dynamicCloseCache"));
        return this.startClientCacheChange(null, Collections.singleton(cacheName));
    }

    public IgniteInternalFuture<?> resetCacheState(Collection<String> cacheNames) throws ClusterTopologyCheckedException {
        this.sharedCtx.tm().checkEmptyTransactions(() -> String.format(CHECK_EMPTY_TRANSACTIONS_ERROR_MSG_FORMAT, cacheNames, "resetCacheState"));
        ArrayList<DynamicCacheChangeRequest> reqs = new ArrayList<DynamicCacheChangeRequest>(cacheNames.size());
        for (String cacheName : cacheNames) {
            Collection<Integer> lostParts;
            GridCacheAdapter cache0 = this.internalCache(cacheName);
            if (cache0 == null || (lostParts = cache0.lostPartitions()).isEmpty()) continue;
            for (Integer part : lostParts) {
                Collection<ClusterNode> owners = cache0.affinity().mapPartitionToPrimaryAndBackups(part);
                if (!owners.isEmpty()) continue;
                throw new ClusterTopologyCheckedException("Cannot reset lost partitions because no baseline nodes are online [cache=" + cacheName + ", partition=" + part + ']');
            }
            DynamicCacheChangeRequest req = DynamicCacheChangeRequest.resetLostPartitions(this.ctx, cacheName);
            reqs.add(req);
        }
        return this.initiateCacheChanges(reqs).stream().collect(IgniteCollectors.toCompoundFuture());
    }

    public IgniteInternalFuture<?> finalizePartitionsCounters() {
        this.sharedCtx.tm().checkEmptyTransactions(() -> String.format(CHECK_EMPTY_TRANSACTIONS_ERROR_MSG_FORMAT, null, "finalizePartitionUpdateCounters"));
        Set<DynamicCacheChangeRequest> reqs = Collections.singleton(DynamicCacheChangeRequest.finalizePartitionCounters(this.ctx));
        return this.initiateCacheChanges(reqs).stream().collect(IgniteCollectors.toCompoundFuture());
    }

    public CacheType cacheType(String cacheName) {
        if (CU.isUtilityCache(cacheName)) {
            return CacheType.UTILITY;
        }
        if (this.internalCaches.contains(cacheName)) {
            return CacheType.INTERNAL;
        }
        if (DataStructuresProcessor.isDataStructureCache(cacheName)) {
            return CacheType.DATA_STRUCTURES;
        }
        return CacheType.USER;
    }

    public boolean isEncrypted(int cacheGrpId) {
        return cacheGrpId != MetaStorage.METASTORAGE_CACHE_ID && this.cacheGroup(cacheGrpId).config().isEncryptionEnabled();
    }

    public void saveCacheConfiguration(DynamicCacheDescriptor desc) throws IgniteCheckedException {
        assert (desc != null);
        this.locCfgMgr.saveCacheConfiguration(desc.toStoredData(this.splitter), true);
    }

    public void cleanupCachesDirectories() throws IgniteCheckedException {
        if (this.sharedCtx.pageStore() == null || this.sharedCtx.kernalContext().clientNode()) {
            return;
        }
        for (DynamicCacheDescriptor desc : this.cacheDescriptors().values()) {
            if (!GridCacheUtils.isPersistentCache(desc.cacheConfiguration(), this.sharedCtx.gridConfig().getDataStorageConfiguration())) continue;
            this.sharedCtx.pageStore().cleanupPersistentSpace(desc.cacheConfiguration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<DynamicCacheStartFuture> initiateCacheChanges(Collection<DynamicCacheChangeRequest> reqs) {
        ArrayList<DynamicCacheStartFuture> res = new ArrayList<DynamicCacheStartFuture>(reqs.size());
        ArrayList<DynamicCacheChangeRequest> sndReqs = new ArrayList<DynamicCacheChangeRequest>(reqs.size());
        for (DynamicCacheChangeRequest req : reqs) {
            GridCacheProcessor.authorizeCacheChange(this.ctx.security(), req);
            DynamicCacheStartFuture fut = new DynamicCacheStartFuture(req.requestId());
            try {
                DynamicCacheDescriptor desc;
                if (req.stop() && (desc = this.cacheDescriptor(req.cacheName())) == null) {
                    fut.onDone(false);
                }
                if (req.start() && req.startCacheConfiguration() != null) {
                    CacheConfiguration ccfg = req.startCacheConfiguration();
                    try {
                        this.cachesInfo.validateStartCacheConfiguration(ccfg);
                    }
                    catch (IgniteCheckedException e) {
                        fut.onDone(e);
                    }
                }
                if (fut.isDone()) continue;
                DynamicCacheStartFuture old = (DynamicCacheStartFuture)this.pendingFuts.putIfAbsent(req.requestId(), fut);
                assert (old == null);
                if (fut.isDone()) continue;
                sndReqs.add(req);
            }
            catch (Exception e) {
                fut.onDone(e);
            }
            finally {
                res.add(fut);
            }
        }
        IgniteCheckedException err = null;
        if (!sndReqs.isEmpty()) {
            try {
                this.ctx.discovery().sendCustomEvent(new DynamicCacheChangeBatch(sndReqs));
                err = this.checkNodeState();
            }
            catch (IgniteCheckedException e) {
                err = e;
            }
        }
        if (err != null) {
            for (DynamicCacheStartFuture fut : res) {
                fut.onDone(err);
            }
        }
        return res;
    }

    static void authorizeCacheChange(IgniteSecurity security, DynamicCacheChangeRequest req) {
        if (req.cacheType() == null || req.cacheType() == CacheType.USER) {
            if (req.start()) {
                GridCacheProcessor.authorizeCacheCreate(security, req.startCacheConfiguration());
            } else if (req.stop()) {
                GridCacheProcessor.authorizeCacheDestroy(security, req.cacheName());
            }
        }
    }

    static void authorizeCacheDestroy(IgniteSecurity security, String cacheName) {
        security.authorize(cacheName, SecurityPermission.CACHE_DESTROY);
    }

    static void authorizeCacheCreate(IgniteSecurity security, @Nullable CacheConfiguration cacheCfg) {
        if (cacheCfg == null) {
            return;
        }
        security.authorize(cacheCfg.getName(), SecurityPermission.CACHE_CREATE);
        if (cacheCfg.isOnheapCacheEnabled() && IgniteSystemProperties.getBoolean("IGNITE_DISABLE_ONHEAP_CACHE")) {
            throw new SecurityException("Authorization failed for enabling on-heap cache.");
        }
    }

    @Nullable
    private IgniteCheckedException checkNodeState() {
        if (this.ctx.isStopping()) {
            return new IgniteCheckedException("Failed to execute dynamic cache change request, node is stopping.");
        }
        if (this.ctx.clientDisconnected()) {
            return new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to execute dynamic cache change request, client node disconnected.");
        }
        return null;
    }

    public void onDiscoveryEvent(int type, @Nullable DiscoveryCustomMessage customMsg, ClusterNode node, AffinityTopologyVersion topVer, DiscoveryDataClusterState state) {
        this.cachesInfo.onDiscoveryEvent(type, node, topVer);
        this.sharedCtx.affinity().onDiscoveryEvent(type, customMsg, node, topVer, state);
    }

    public boolean onCustomEvent(DiscoveryCustomMessage msg, AffinityTopologyVersion topVer, ClusterNode node) {
        if (msg instanceof SchemaAbstractDiscoveryMessage) {
            this.ctx.query().onDiscovery((SchemaAbstractDiscoveryMessage)msg);
            return false;
        }
        if (msg instanceof CacheAffinityChangeMessage) {
            return this.sharedCtx.affinity().onCustomEvent((CacheAffinityChangeMessage)msg);
        }
        if (msg instanceof SnapshotDiscoveryMessage && ((SnapshotDiscoveryMessage)msg).needExchange()) {
            return true;
        }
        if (msg instanceof WalStateAbstractMessage) {
            WalStateAbstractMessage msg0 = (WalStateAbstractMessage)msg;
            if (msg0 instanceof WalStateProposeMessage) {
                this.sharedCtx.walState().onProposeDiscovery((WalStateProposeMessage)msg);
            } else if (msg0 instanceof WalStateFinishMessage) {
                this.sharedCtx.walState().onFinishDiscovery((WalStateFinishMessage)msg);
            }
            return msg0.needExchange();
        }
        if (msg instanceof DynamicCacheChangeBatch) {
            boolean changeRequested = this.cachesInfo.onCacheChangeRequested((DynamicCacheChangeBatch)msg, topVer);
            this.ctx.query().onCacheChangeRequested((DynamicCacheChangeBatch)msg);
            return changeRequested;
        }
        if (msg instanceof DynamicCacheChangeFailureMessage) {
            this.cachesInfo.onCacheChangeRequested((DynamicCacheChangeFailureMessage)msg, topVer);
        }
        if (msg instanceof ClientCacheChangeDiscoveryMessage) {
            this.cachesInfo.onClientCacheChange((ClientCacheChangeDiscoveryMessage)msg, node);
        }
        if (msg instanceof CacheStatisticsModeChangeMessage) {
            this.onCacheStatisticsModeChange((CacheStatisticsModeChangeMessage)msg);
        }
        if (msg instanceof CacheStatisticsClearMessage) {
            this.onCacheStatisticsClear((CacheStatisticsClearMessage)msg);
        }
        if (msg instanceof TxTimeoutOnPartitionMapExchangeChangeMessage) {
            this.sharedCtx.tm().onTxTimeoutOnPartitionMapExchangeChange((TxTimeoutOnPartitionMapExchangeChangeMessage)msg);
        }
        return false;
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        IgniteNodeValidationResult res = ValidationOnNodeJoinUtils.validateHashIdResolvers(node, this.ctx, this.cacheDescriptors());
        if (res == null) {
            res = this.validateRestartingCaches(node);
        }
        if (res == null) {
            res = this.validateRestoringCaches(node);
        }
        return res;
    }

    public boolean isCacheRestarting(String cacheName) {
        return this.cachesInfo.isRestarting(cacheName);
    }

    private IgniteNodeValidationResult validateRestartingCaches(ClusterNode node) {
        if (this.cachesInfo.hasRestartingCaches()) {
            String msg = "Joining node during caches restart is not allowed [joiningNodeId=" + node.id() + ", restartingCaches=" + new HashSet<String>(this.cachesInfo.restartingCaches()) + ']';
            return new IgniteNodeValidationResult(node.id(), msg);
        }
        return null;
    }

    private IgniteNodeValidationResult validateRestoringCaches(ClusterNode node) {
        if (this.ctx.cache().context().snapshotMgr().isRestoring()) {
            String msg = "Joining node during caches restore is not allowed [joiningNodeId=" + node.id() + ']';
            return new IgniteNodeValidationResult(node.id(), msg);
        }
        return null;
    }

    public boolean keepStaticCacheConfiguration() {
        return this.keepStaticCacheConfiguration;
    }

    @Nullable
    public <K, V> IgniteInternalCache<K, V> cache(String name) {
        IgniteCacheProxyImpl<?, ?> jcache;
        assert (name != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting cache for name: " + name);
        }
        return (jcache = this.jcacheProxy(name, true)) == null ? null : jcache.internalProxy();
    }

    private void awaitInitializeProxy(IgniteCacheProxyImpl<?, ?> jcache) {
        if (jcache != null) {
            CountDownLatch initLatch = jcache.getInitLatch();
            try {
                while (initLatch.getCount() > 0L) {
                    initLatch.await(2000L, TimeUnit.MILLISECONDS);
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info("Failed to wait proxy initialization, cache=" + jcache.getName() + ", localNodeId=" + this.ctx.localNodeId());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void completeProxyInitialize(String name) {
        IgniteCacheProxyImpl<?, ?> jcache = this.jCacheProxies.get(name);
        if (jcache != null) {
            CountDownLatch proxyInitLatch = jcache.getInitLatch();
            if (proxyInitLatch.getCount() > 0L) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Finish proxy initialization, cacheName=" + name + ", localNodeId=" + this.ctx.localNodeId());
                }
                proxyInitLatch.countDown();
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Can not finish proxy initialization because proxy does not exist, cacheName=" + name + ", localNodeId=" + this.ctx.localNodeId());
        }
    }

    public <K, V> IgniteInternalCache<K, V> getOrStartCache(String name) throws IgniteCheckedException {
        return this.getOrStartCache(name, null);
    }

    public <K, V> IgniteInternalCache<K, V> getOrStartCache(String name, CacheConfiguration ccfg) throws IgniteCheckedException {
        IgniteCacheProxyImpl<?, ?> cache;
        assert (name != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting cache for name: " + name);
        }
        if ((cache = this.jcacheProxy(name, true)) == null) {
            this.dynamicStartCache(ccfg, name, null, false, ccfg == null, true).get();
            cache = this.jcacheProxy(name, true);
        }
        return cache == null ? null : cache.internalProxy();
    }

    public Collection<IgniteInternalCache<?, ?>> caches() {
        return F.viewReadOnly(this.jCacheProxies.values(), IgniteCacheProxy::internalProxy, new IgnitePredicate[0]);
    }

    public Collection<IgniteCacheProxy<?, ?>> jcaches() {
        return F.viewReadOnly(this.jCacheProxies.values(), IgniteCacheProxyImpl::gatewayWrapper, new IgnitePredicate[0]);
    }

    public <K, V> IgniteInternalCache<K, V> utilityCache() {
        return this.internalCacheEx("ignite-sys-cache");
    }

    private <K, V> IgniteInternalCache<K, V> internalCacheEx(String name) {
        if (this.ctx.discovery().localNode().isClient()) {
            GridCacheAdapter<?, ?> cacheAdapter;
            IgniteCacheProxyImpl<?, ?> proxy = this.jcacheProxy(name, true);
            if (proxy == null && (cacheAdapter = this.caches.get(name)) != null) {
                proxy = new IgniteCacheProxyImpl(cacheAdapter.context(), cacheAdapter, false);
                IgniteCacheProxyImpl<?, ?> prev = this.addjCacheProxy(name, proxy);
                if (prev != null) {
                    proxy = prev;
                }
                this.completeProxyInitialize(proxy.getName());
            }
            assert (proxy != null) : name;
            return proxy.internalProxy();
        }
        return this.internalCache(name);
    }

    public <K, V> IgniteInternalCache<K, V> publicCache(String name) {
        DynamicCacheDescriptor desc;
        assert (name != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting public cache for name: " + name);
        }
        if ((desc = this.cacheDescriptor(name)) == null) {
            throw new IllegalArgumentException("Cache is not started: " + name);
        }
        if (!desc.cacheType().userCache()) {
            throw new IllegalStateException("Failed to get cache because it is a system cache: " + name);
        }
        IgniteCacheProxyImpl<?, ?> jcache = this.jcacheProxy(name, true);
        if (jcache == null) {
            throw new IllegalArgumentException("Cache is not started: " + name);
        }
        return jcache.internalProxy();
    }

    public <K, V> IgniteCacheProxy<K, V> publicJCache(String cacheName) throws IgniteCheckedException {
        return this.publicJCache(cacheName, true, true);
    }

    @Nullable
    public <K, V> IgniteCacheProxy<K, V> publicJCache(String cacheName, boolean failIfNotStarted, boolean checkThreadTx) throws IgniteCheckedException {
        DynamicCacheDescriptor desc;
        assert (cacheName != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting public cache for name: " + cacheName);
        }
        if ((desc = this.cacheDescriptor(cacheName)) != null && !desc.cacheType().userCache()) {
            throw new IllegalStateException("Failed to get cache because it is a system cache: " + cacheName);
        }
        IgniteCacheProxyImpl<?, ?> proxy = this.jcacheProxy(cacheName, true);
        if (proxy == null) {
            this.dynamicStartCache(null, cacheName, null, false, failIfNotStarted, checkThreadTx).get();
            proxy = this.jcacheProxy(cacheName, true);
        }
        return proxy != null ? proxy.gatewayWrapper() : null;
    }

    public CacheConfiguration cacheConfiguration(String name) {
        assert (name != null);
        DynamicCacheDescriptor desc = this.cacheDescriptor(name);
        if (desc == null) {
            if (this.cachesInfo.isRestarting(name)) {
                IgniteCacheProxyImpl<?, ?> proxy = this.jCacheProxies.get(name);
                assert (proxy != null) : name;
                proxy.internalProxy();
                return this.cacheConfiguration(name);
            }
            throw new IllegalStateException("Cache doesn't exist: " + name);
        }
        return desc.cacheConfiguration();
    }

    public DynamicCacheDescriptor cacheDescriptor(String name) {
        return (DynamicCacheDescriptor)this.cachesInfo.registeredCaches().get(name);
    }

    public Map<String, DynamicCacheDescriptor> cacheDescriptors() {
        return this.cachesInfo.registeredCaches();
    }

    public Collection<DynamicCacheDescriptor> persistentCaches() {
        return this.cachesInfo.registeredCaches().values().stream().filter(desc -> GridCacheUtils.isPersistentCache(desc.cacheConfiguration(), this.ctx.config().getDataStorageConfiguration())).collect(Collectors.toList());
    }

    public Collection<CacheGroupDescriptor> persistentGroups() {
        return this.cachesInfo.registeredCacheGroups().values().stream().filter(CacheGroupDescriptor::persistenceEnabled).collect(Collectors.toList());
    }

    public Map<Integer, CacheGroupDescriptor> cacheGroupDescriptors() {
        return this.cachesInfo.registeredCacheGroups();
    }

    public CacheGroupDescriptor cacheGroupDescriptor(int grpId) {
        CacheGroupDescriptor desc = this.cacheGroupDescriptors().get(grpId);
        if (desc == null) {
            return this.cachesInfo.markedForDeletionCacheGroupDesc(grpId);
        }
        return desc;
    }

    @Nullable
    public DynamicCacheDescriptor cacheDescriptor(int cacheId) {
        return (DynamicCacheDescriptor)this.cachesInfo.registeredCachesById().get(cacheId);
    }

    public void addCacheConfiguration(CacheConfiguration cacheCfg) throws IgniteCheckedException {
        assert (cacheCfg.getName() != null);
        String name = cacheCfg.getName();
        DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.cachesInfo.registeredTemplates().get(name);
        if (desc != null) {
            return;
        }
        DynamicCacheChangeRequest req = DynamicCacheChangeRequest.addTemplateRequest(this.ctx, cacheCfg, this.backwardCompatibleSplitter().split(cacheCfg));
        TemplateConfigurationFuture fut = new TemplateConfigurationFuture(req.cacheName(), req.deploymentId());
        TemplateConfigurationFuture old = (TemplateConfigurationFuture)this.pendingTemplateFuts.putIfAbsent(cacheCfg.getName(), fut);
        if (old != null) {
            fut = old;
        }
        IgniteCheckedException err = null;
        try {
            this.ctx.discovery().sendCustomEvent(new DynamicCacheChangeBatch(Collections.singleton(req)));
            if (this.ctx.isStopping()) {
                err = new IgniteCheckedException("Failed to execute dynamic cache change request, node is stopping.");
            } else if (this.ctx.clientDisconnected()) {
                err = new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to execute dynamic cache change request, client node disconnected.");
            }
        }
        catch (IgniteCheckedException e) {
            err = e;
        }
        if (err != null) {
            fut.onDone(err);
        }
        fut.get();
    }

    public <K, V> IgniteCacheProxy<K, V> jcache(String name) {
        GridCacheAdapter<?, ?> cacheAdapter;
        assert (name != null);
        IgniteCacheProxyImpl<?, ?> cache = this.jcacheProxy(name, true);
        if (cache == null && (cacheAdapter = this.caches.get(name)) != null) {
            cache = new IgniteCacheProxyImpl(cacheAdapter.context(), cacheAdapter, false);
            IgniteCacheProxyImpl<?, ?> prev = this.addjCacheProxy(name, cache);
            if (prev != null) {
                cache = prev;
            }
            this.completeProxyInitialize(cache.getName());
        }
        if (cache == null) {
            throw new IllegalArgumentException("Cache is not configured: " + name);
        }
        return cache;
    }

    @Nullable
    public IgniteCacheProxyImpl<?, ?> jcacheProxy(String name, boolean awaitInit) {
        IgniteCacheProxyImpl<?, ?> cache = this.jCacheProxies.get(name);
        if (awaitInit) {
            this.awaitInitializeProxy(cache);
        }
        return cache;
    }

    @Nullable
    public IgniteCacheProxyImpl<?, ?> addjCacheProxy(String name, IgniteCacheProxyImpl<?, ?> proxy) {
        return this.jCacheProxies.putIfAbsent(name, proxy);
    }

    public Collection<IgniteCacheProxy<?, ?>> publicCaches() {
        ArrayList res = new ArrayList(this.jCacheProxies.size());
        for (IgniteCacheProxyImpl<?, ?> proxy : this.jCacheProxies.values()) {
            if (!proxy.context().userCache()) continue;
            res.add(proxy.gatewayWrapper());
        }
        return res;
    }

    public <K, V> GridCacheAdapter<K, V> internalCache(String name) {
        assert (name != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting internal cache adapter: " + name);
        }
        return this.caches.get(name);
    }

    private void cancelFutures() {
        this.sharedCtx.mvcc().onStop();
        IgniteCheckedException err = new IgniteCheckedException("Operation has been cancelled (node is stopping).");
        for (IgniteInternalFuture fut : this.pendingFuts.values()) {
            ((GridFutureAdapter)fut).onDone(err);
        }
        for (IgniteInternalFuture fut : this.pendingTemplateFuts.values()) {
            ((GridFutureAdapter)fut).onDone(err);
        }
        for (IgniteInternalFuture fut : this.manageStatisticsFuts.values()) {
            ((GridFutureAdapter)fut).onDone(err);
        }
    }

    public Collection<GridCacheAdapter<?, ?>> internalCaches() {
        return this.caches.values();
    }

    public boolean systemCache(String name) {
        assert (name != null);
        DynamicCacheDescriptor desc = this.cacheDescriptor(name);
        return desc != null && !desc.cacheType().userCache();
    }

    @Override
    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        for (GridCacheAdapter<?, ?> c : this.caches.values()) {
            X.println(">>> Cache memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ", cache=" + c.name() + ']', new Object[0]);
            c.context().printMemoryStats();
        }
    }

    public void onUndeployed(ClassLoader ldr) {
        if (!this.ctx.isStopping()) {
            for (GridCacheAdapter<?, ?> cache : this.caches.values()) {
                if (!cache.context().userCache() || !cache.context().deploymentEnabled()) continue;
                cache.onUndeploy(ldr);
            }
        }
    }

    public <K, V> GridCacheSharedContext<K, V> context() {
        return this.sharedCtx;
    }

    public GridLocalConfigManager configManager() {
        return this.locCfgMgr;
    }

    public IgniteTransactionsEx transactions() {
        return this.transactions;
    }

    private void registerMbean(Object obj, @Nullable String cacheName, boolean near) throws IgniteCheckedException {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        assert (obj != null);
        MBeanServer srvr = this.ctx.config().getMBeanServer();
        assert (srvr != null);
        cacheName = U.maskName(cacheName);
        cacheName = near ? cacheName + "-near" : cacheName;
        Object mbeanImpl = obj instanceof IgniteMBeanAware ? ((IgniteMBeanAware)obj).getMBean() : obj;
        for (Class<?> itf : mbeanImpl.getClass().getInterfaces()) {
            if (!itf.getName().endsWith("MBean") && !itf.getName().endsWith("MXBean")) continue;
            try {
                U.registerMBean(srvr, this.ctx.igniteInstanceName(), cacheName, obj.getClass().getName(), mbeanImpl, itf);
                break;
            }
            catch (Throwable e) {
                throw new IgniteCheckedException("Failed to register MBean for component: " + obj, e);
            }
        }
    }

    private void unregisterMbean(Object o, @Nullable String cacheName, boolean near) {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        assert (o != null);
        MBeanServer srvr = this.ctx.config().getMBeanServer();
        assert (srvr != null);
        cacheName = U.maskName(cacheName);
        cacheName = near ? cacheName + "-near" : cacheName;
        boolean needToUnregister = o instanceof IgniteMBeanAware;
        if (!needToUnregister) {
            for (Class<?> itf : o.getClass().getInterfaces()) {
                if (!itf.getName().endsWith("MBean") && !itf.getName().endsWith("MXBean")) continue;
                needToUnregister = true;
                break;
            }
        }
        if (needToUnregister) {
            try {
                srvr.unregisterMBean(U.makeMBeanName(this.ctx.igniteInstanceName(), cacheName, o.getClass().getName()));
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to unregister MBean for component: " + o, e);
            }
        }
    }

    private Iterable<Object> lifecycleAwares(CacheGroupContext grp, CacheConfiguration ccfg, Object ... objs) {
        ArrayList<Object> ret = new ArrayList<Object>(7 + objs.length);
        if (grp.affinityFunction() != ccfg.getAffinity()) {
            ret.add(ccfg.getAffinity());
        }
        ret.add(ccfg.getAffinityMapper());
        ret.add(ccfg.getEvictionFilter());
        ret.add(ccfg.getEvictionPolicyFactory());
        ret.add(ccfg.getEvictionPolicy());
        ret.add(ccfg.getInterceptor());
        NearCacheConfiguration nearCfg = ccfg.getNearConfiguration();
        if (nearCfg != null) {
            ret.add(nearCfg.getNearEvictionPolicyFactory());
            ret.add(nearCfg.getNearEvictionPolicy());
        }
        Collections.addAll(ret, objs);
        return ret;
    }

    CacheConfiguration cloneCheckSerializable(final CacheConfiguration val) throws IgniteCheckedException {
        if (val == null) {
            return null;
        }
        return this.withBinaryContext(new IgniteOutClosureX<CacheConfiguration>(){

            @Override
            public CacheConfiguration applyx() throws IgniteCheckedException {
                if (val.getCacheStoreFactory() != null) {
                    try {
                        ClassLoader ldr = GridCacheProcessor.this.ctx.config().getClassLoader();
                        if (ldr == null) {
                            ldr = val.getCacheStoreFactory().getClass().getClassLoader();
                        }
                        U.unmarshal(GridCacheProcessor.this.marsh, U.marshal(GridCacheProcessor.this.marsh, val.getCacheStoreFactory()), U.resolveClassLoader(ldr, GridCacheProcessor.this.ctx.config()));
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteCheckedException("Failed to validate cache configuration. Cache store factory is not serializable. Cache name: " + U.maskName(val.getName()), e);
                    }
                }
                try {
                    return (CacheConfiguration)U.unmarshal(GridCacheProcessor.this.marsh, U.marshal(GridCacheProcessor.this.marsh, (Object)val), U.resolveClassLoader(GridCacheProcessor.this.ctx.config()));
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteCheckedException("Failed to validate cache configuration (make sure all objects in cache configuration are serializable): " + U.maskName(val.getName()), e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withBinaryContext(IgniteOutClosureX<T> c) throws IgniteCheckedException {
        T t2;
        IgniteCacheObjectProcessor objProc = this.ctx.cacheObjects();
        BinaryContext oldCtx = null;
        if (objProc instanceof CacheObjectBinaryProcessorImpl) {
            GridBinaryMarshaller binMarsh = ((CacheObjectBinaryProcessorImpl)objProc).marshaller();
            oldCtx = binMarsh == null ? null : binMarsh.pushContext();
        }
        try {
            t2 = c.applyx();
        }
        catch (Throwable throwable) {
            if (objProc instanceof CacheObjectBinaryProcessorImpl) {
                GridBinaryMarshaller.popContext(oldCtx);
            }
            throw throwable;
        }
        if (objProc instanceof CacheObjectBinaryProcessorImpl) {
            GridBinaryMarshaller.popContext(oldCtx);
        }
        return t2;
    }

    private DynamicCacheChangeRequest prepareCacheChangeRequest(@Nullable CacheConfiguration ccfg, String cacheName, @Nullable NearCacheConfiguration nearCfg, CacheType cacheType, boolean sql, boolean failIfExists, boolean failIfNotStarted, IgniteUuid restartId, boolean disabledAfterStart, @Nullable Collection<QueryEntity> qryEntities, @Nullable byte[] encKey, @Nullable Integer encKeyId, @Nullable byte[] masterKeyDigest) throws IgniteCheckedException {
        DynamicCacheDescriptor desc = this.cacheDescriptor(cacheName);
        DynamicCacheChangeRequest req = new DynamicCacheChangeRequest(UUID.randomUUID(), cacheName, this.ctx.localNodeId());
        req.sql(sql);
        req.failIfExists(failIfExists);
        req.disabledAfterStart(disabledAfterStart);
        req.masterKeyDigest(masterKeyDigest);
        req.encryptionKey(encKey);
        req.encryptionKeyId(encKeyId);
        req.restartId(restartId);
        if (ccfg != null) {
            this.cloneCheckSerializable(ccfg);
            if (desc != null) {
                if (failIfExists) {
                    throw new CacheExistsException("Failed to start cache (a cache with the same name is already started): " + cacheName);
                }
                CacheConfiguration descCfg = desc.cacheConfiguration();
                if (nearCfg != null) {
                    if (this.isLocalAffinity(descCfg)) {
                        if (descCfg.getNearConfiguration() != null) {
                            return null;
                        }
                        throw new IgniteCheckedException("Failed to start near cache (local node is an affinity node for cache): " + cacheName);
                    }
                    req.clientStartOnly(true);
                } else if (!this.isLocalAffinity(descCfg)) {
                    req.clientStartOnly(true);
                }
                req.deploymentId(desc.deploymentId());
                T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = this.backwardCompatibleSplitter().split(desc);
                req.startCacheConfiguration((CacheConfiguration)splitCfg.get1());
                req.cacheConfigurationEnrichment((CacheConfigurationEnrichment)splitCfg.get2());
                req.schema(desc.schema());
            } else {
                CacheConfiguration cfg = new CacheConfiguration(ccfg);
                CacheObjectContext cacheObjCtx = this.ctx.cacheObjects().contextForCache(cfg);
                this.initialize(cfg, cacheObjCtx);
                req.deploymentId(IgniteUuid.randomUuid());
                T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = this.backwardCompatibleSplitter().split(cfg);
                req.startCacheConfiguration((CacheConfiguration)splitCfg.get1());
                req.cacheConfigurationEnrichment((CacheConfigurationEnrichment)splitCfg.get2());
                cfg = (CacheConfiguration)splitCfg.get1();
                if (restartId != null) {
                    req.schema(new QuerySchema(qryEntities == null ? cfg.getQueryEntities() : qryEntities));
                } else {
                    req.schema(new QuerySchema(qryEntities != null ? QueryUtils.normalizeQueryEntities(this.ctx, qryEntities, cfg) : cfg.getQueryEntities()));
                }
            }
        } else {
            req.clientStartOnly(true);
            if (desc != null) {
                ccfg = desc.cacheConfiguration();
            }
            if (ccfg == null) {
                if (failIfNotStarted) {
                    throw new CacheExistsException("Failed to start client cache (a cache with the given name is not started): " + cacheName);
                }
                return null;
            }
            req.deploymentId(desc.deploymentId());
            T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = this.backwardCompatibleSplitter().split(ccfg);
            req.startCacheConfiguration((CacheConfiguration)splitCfg.get1());
            req.cacheConfigurationEnrichment((CacheConfigurationEnrichment)splitCfg.get2());
            req.schema(desc.schema());
        }
        if (nearCfg != null) {
            req.nearCacheConfiguration(nearCfg);
        }
        req.cacheType(cacheType);
        return req;
    }

    public void enableStatistics(Collection<String> cacheNames, boolean enabled) throws IgniteCheckedException {
        Collection<IgniteInternalCache> caches = this.manageStatisticsCaches(cacheNames);
        HashSet<String> globalCaches = new HashSet<String>(U.capacity(caches.size()));
        for (IgniteInternalCache cache : caches) {
            cache.context().statisticsEnabled(enabled);
            globalCaches.add(cache.name());
        }
        if (globalCaches.isEmpty()) {
            return;
        }
        CacheStatisticsModeChangeMessage msg = new CacheStatisticsModeChangeMessage(UUID.randomUUID(), globalCaches, enabled);
        EnableStatisticsFuture fut = new EnableStatisticsFuture(msg.requestId());
        this.manageStatisticsFuts.put(msg.requestId(), fut);
        this.ctx.grid().context().discovery().sendCustomEvent(msg);
        fut.get();
    }

    public void clearStatistics(Collection<String> cacheNames) throws IgniteCheckedException {
        Collection<IgniteInternalCache> caches = this.manageStatisticsCaches(cacheNames);
        HashSet<String> globalCaches = new HashSet<String>(U.capacity(caches.size()));
        for (IgniteInternalCache cache : caches) {
            globalCaches.add(cache.name());
        }
        if (globalCaches.isEmpty()) {
            return;
        }
        CacheStatisticsClearMessage msg = new CacheStatisticsClearMessage(UUID.randomUUID(), globalCaches);
        EnableStatisticsFuture fut = new EnableStatisticsFuture(msg.requestId());
        this.manageStatisticsFuts.put(msg.requestId(), fut);
        this.ctx.grid().context().discovery().sendCustomEvent(msg);
        fut.get();
    }

    private Collection<IgniteInternalCache> manageStatisticsCaches(Collection<String> caches) throws IgniteCheckedException {
        assert (caches != null);
        ArrayList<IgniteInternalCache> res = new ArrayList<IgniteInternalCache>(caches.size());
        if (!this.cacheNames().containsAll(caches)) {
            throw new IgniteCheckedException("One or more cache descriptors not found [caches=" + caches + ']');
        }
        for (String cacheName : caches) {
            IgniteInternalCache cache = this.cache(cacheName);
            if (cache == null) {
                throw new IgniteCheckedException("Cache not found [cacheName=" + cacheName + ']');
            }
            res.add(cache);
        }
        return res;
    }

    public <T> T clone(final T obj) throws IgniteCheckedException {
        return this.withBinaryContext(new IgniteOutClosureX<T>(){

            @Override
            public T applyx() throws IgniteCheckedException {
                return U.unmarshal(GridCacheProcessor.this.marsh, U.marshal(GridCacheProcessor.this.marsh, obj), U.resolveClassLoader(GridCacheProcessor.this.ctx.config()));
            }
        });
    }

    private CacheConfigurationSplitter splitter(boolean oldFormat) {
        return oldFormat ? new CacheConfigurationSplitterOldFormat(this.enricher) : this.splitter;
    }

    public CacheConfigurationSplitter splitter() {
        return this.splitter(false);
    }

    private CacheConfigurationSplitter backwardCompatibleSplitter() {
        IgniteDiscoverySpi spi = (IgniteDiscoverySpi)this.ctx.discovery().getInjectedDiscoverySpi();
        boolean oldFormat = !spi.allNodesSupport(IgniteFeatures.SPLITTED_CACHE_CONFIGURATIONS);
        return this.splitter(oldFormat);
    }

    public CacheConfigurationEnricher enricher() {
        return this.enricher;
    }

    private Iterable<CachePagesListView> pagesListViewSupplier(Map<String, Object> filter) {
        Integer cacheGrpId = (Integer)filter.get("cacheGroupId");
        Integer partId = (Integer)filter.get("partitionId");
        Integer bucketNum = (Integer)filter.get("bucketNumber");
        GridIterator dataStores = F.flat(F.iterator(GridCacheProcessor.filteredMap(this.cacheGrps, cacheGrpId).values(), grp -> grp.offheap().cacheDataStores(), true, new IgnitePredicate[0]));
        return F.flat(F.iterator(dataStores, dataStore -> {
            RowStore rowStore = dataStore.rowStore();
            if (rowStore == null || !(dataStore instanceof GridCacheOffheapManager.GridCacheDataStore)) {
                return Collections.emptySet();
            }
            PagesList pagesList = (PagesList)((Object)rowStore.freeList());
            if (bucketNum != null) {
                return bucketNum >= 0 && bucketNum < pagesList.bucketsCount() ? Collections.singleton(new CachePagesListView(pagesList, bucketNum, dataStore.partId())) : Collections.emptyList();
            }
            return IntStream.range(0, pagesList.bucketsCount()).mapToObj(bucket -> new CachePagesListView(pagesList, bucket, dataStore.partId())).collect(Collectors.toList());
        }, true, new IgnitePredicate[]{cacheDataStore -> partId == null || cacheDataStore.partId() == partId.intValue()}));
    }

    private Iterable<PartitionStateView> partStatesViewSupplier(Map<String, Object> filter) {
        Integer cacheGrpId = (Integer)filter.get("cacheGroupId");
        UUID nodeId = (UUID)filter.get("nodeId");
        Integer partId = (Integer)filter.get("partitionId");
        return () -> F.concat(F.concat(F.iterator(GridCacheProcessor.filteredMap(this.cacheGrps, cacheGrpId).values(), grp -> F.iterator(GridCacheProcessor.filteredMap(grp.topology().partitionMap(false), nodeId).entrySet(), nodeToParts -> F.iterator(GridCacheProcessor.filteredMap(((GridDhtPartitionMap)nodeToParts.getValue()).map(), partId == null || partId < 0 ? null : partId).entrySet(), partToStates -> new PartitionStateView(grp.groupId(), (UUID)nodeToParts.getKey(), (Integer)partToStates.getKey(), (GridDhtPartitionState)((Object)((Object)((Object)((Object)((Object)partToStates.getValue()))))), GridCacheProcessor.isPrimary(grp, (UUID)nodeToParts.getKey(), (Integer)partToStates.getKey())), true, new IgnitePredicate[0]), true, new IgnitePredicate[0]), true, new IgnitePredicate[0])));
    }

    private static <K, V> Map<K, V> filteredMap(Map<K, V> map, K key) {
        if (key == null) {
            return map;
        }
        V val = map.get(key);
        return val != null ? F.asMap(key, val) : Collections.emptyMap();
    }

    private static boolean isPrimary(CacheGroupContext grp, UUID nodeId, int part) {
        List<ClusterNode> nodes = grp.affinity().lastReadyAffinity().get(part);
        if (F.isEmpty(nodes)) {
            return false;
        }
        ClusterNode primaryNode = nodes.get(0);
        return primaryNode != null && nodeId.equals(primaryNode.id());
    }

    public boolean stopWarmUp() throws IgniteCheckedException {
        if (this.recovery.stopWarmUp.compareAndSet(false, true)) {
            WarmUpStrategy strat = this.recovery.curWarmUpStrat;
            if (this.log.isInfoEnabled()) {
                this.log.info("Stopping warm-up strategy: " + strat);
            }
            if (Objects.nonNull(strat)) {
                strat.stop();
            }
            return true;
        }
        return false;
    }

    static String toStringTopProcessingPartitions(SortedSet<T3<Long, Long, GroupPartitionId>> top, Collection<CacheGroupContext> groups) {
        if (top.isEmpty()) {
            return "[]";
        }
        StringJoiner sj0 = new StringJoiner(", ", "[", "]");
        TreeMap top0 = top.stream().collect(Collectors.groupingBy(GridTuple3::get1, TreeMap::new, Collectors.mapping(GridTuple3::get3, Collectors.toList())));
        for (Map.Entry e0 : top0.descendingMap().entrySet()) {
            Map<Integer, List<GroupPartitionId>> byCacheGrpId = ((List)e0.getValue()).stream().collect(Collectors.groupingBy(GroupPartitionId::getGroupId));
            StringJoiner sj1 = new StringJoiner(", ", "[", "]");
            for (Map.Entry<Integer, List<GroupPartitionId>> e1 : byCacheGrpId.entrySet()) {
                @Nullable CacheGroupContext grp = groups.stream().filter(g2 -> g2.groupId() == ((Integer)e1.getKey()).intValue()).findAny().orElse(null);
                String parts = e1.getValue().stream().map(GroupPartitionId::getPartitionId).sorted().map(p -> grp == null ? p.toString() : p + ":" + grp.topology().localPartition((int)p).fullSize()).collect(Collectors.joining(", ", "[", "]"));
                sj1.add("[grp=" + (grp == null ? (Serializable)e1.getKey() : grp.cacheOrGroupName()) + ", part=" + parts + ']');
            }
            sj0.add("[time=" + U.humanReadableDuration((Long)e0.getKey()) + ' ' + sj1.toString() + ']');
        }
        return sj0.toString();
    }

    static <E> void trimToSize(SortedSet<E> set, int size) {
        while (set.size() > size) {
            set.remove(set.first());
        }
    }

    static Comparator<T3<Long, Long, GroupPartitionId>> processedPartitionComparator() {
        Comparator<T3> comp = Comparator.comparing(GridTuple3::get1);
        return comp.thenComparing(GridTuple3::get2, Comparator.reverseOrder()).thenComparing(GridTuple3::get3);
    }

    private static class RestorePartitionStateThreadContext {
        static final AtomicLongFieldUpdater<RestorePartitionStateThreadContext> PROCESSED_CNT_UPD = AtomicLongFieldUpdater.newUpdater(RestorePartitionStateThreadContext.class, "processedCnt");
        final AtomicReference<SortedSet<T3<Long, Long, GroupPartitionId>>> topPartRef = new AtomicReference();
        volatile long processedCnt = 0L;

        private RestorePartitionStateThreadContext() {
        }

        void incrementProcessedCnt() {
            PROCESSED_CNT_UPD.incrementAndGet(this);
        }
    }

    private class EnableStatisticsFuture
    extends GridFutureAdapter<Void> {
        private UUID id;

        private EnableStatisticsFuture(UUID id) {
            this.id = id;
        }

        @Override
        public boolean onDone(@Nullable Void res, @Nullable Throwable err) {
            GridCacheProcessor.this.manageStatisticsFuts.remove(this.id, this);
            return super.onDone(res, err);
        }

        @Override
        public String toString() {
            return S.toString(EnableStatisticsFuture.class, this);
        }
    }

    private class TemplateConfigurationFuture
    extends GridFutureAdapter<Object> {
        @GridToStringInclude
        private IgniteUuid deploymentId;
        private String cacheName;

        private TemplateConfigurationFuture(String cacheName, IgniteUuid deploymentId) {
            this.deploymentId = deploymentId;
            this.cacheName = cacheName;
        }

        public IgniteUuid deploymentId() {
            return this.deploymentId;
        }

        @Override
        public boolean onDone(@Nullable Object res, @Nullable Throwable err) {
            GridCacheProcessor.this.pendingTemplateFuts.remove(this.cacheName, this);
            return super.onDone(res, err);
        }

        @Override
        public String toString() {
            return S.toString(TemplateConfigurationFuture.class, this);
        }
    }

    private class DynamicCacheStartFuture
    extends GridFutureAdapter<Boolean> {
        private UUID id;

        private DynamicCacheStartFuture(UUID id) {
            this.id = id;
        }

        @Override
        public boolean onDone(@Nullable Boolean res, @Nullable Throwable err) {
            GridCacheProcessor.this.pendingFuts.remove(this.id, this);
            GridCacheProcessor.this.context().exchange().exchangerUpdateHeartbeat();
            return super.onDone(res, err);
        }

        @Override
        public String toString() {
            return S.toString(DynamicCacheStartFuture.class, this);
        }
    }

    private static interface StartCacheFailHandler<T, R> {
        public void handle(T var1, IgniteThrowableFunction<T, R> var2) throws IgniteCheckedException;
    }

    private class CacheRecoveryLifecycle
    implements MetastorageLifecycleListener,
    DatabaseLifecycleListener {
        private final Map<Integer, QuerySchema> querySchemas = new ConcurrentHashMap<Integer, QuerySchema>();
        private final AtomicBoolean stopWarmUp = new AtomicBoolean();
        private volatile WarmUpStrategy curWarmUpStrat;

        private CacheRecoveryLifecycle() {
        }

        @Override
        public void onBaselineChange() {
            for (GridCacheAdapter cache : GridCacheProcessor.this.caches.values()) {
                if (cache == null) continue;
                cache.context().ttl().unregister();
            }
            GridCacheProcessor.this.onKernalStopCaches(true);
            GridCacheProcessor.this.stopCaches(true);
            GridCacheProcessor.this.sharedCtx.coordinators().stopTxLog();
            GridCacheProcessor.this.sharedCtx.database().cleanupRestoredCaches();
        }

        @Override
        public void onReadyForRead(ReadOnlyMetastorage metastorage) throws IgniteCheckedException {
            CacheJoinNodeDiscoveryData data = GridCacheProcessor.this.locCfgMgr.restoreCacheConfigurations();
            GridCacheProcessor.this.cachesInfo.onStart(data);
        }

        @Override
        public void beforeBinaryMemoryRestore(IgniteCacheDatabaseSharedManager mgr) throws IgniteCheckedException {
            for (DynamicCacheDescriptor cacheDescriptor : GridCacheProcessor.this.persistentCaches()) {
                GridCacheProcessor.this.preparePageStore(cacheDescriptor, true);
            }
        }

        @Override
        public void afterBinaryMemoryRestore(IgniteCacheDatabaseSharedManager mgr, GridCacheDatabaseSharedManager.RestoreBinaryState restoreState) throws IgniteCheckedException {
            Serializable consistentId = GridCacheProcessor.this.ctx.pdsFolderResolver().resolveFolders().consistentId();
            DetachedClusterNode clusterNode = new DetachedClusterNode(consistentId, GridCacheProcessor.this.ctx.nodeAttributes());
            for (DynamicCacheDescriptor cacheDescriptor : GridCacheProcessor.this.persistentCaches()) {
                boolean affinityNode = CU.affinityNode(clusterNode, cacheDescriptor.cacheConfiguration().getNodeFilter());
                if (!affinityNode) continue;
                GridCacheProcessor.this.startCacheInRecoveryMode(cacheDescriptor);
                this.querySchemas.put(cacheDescriptor.cacheId(), cacheDescriptor.schema().copy());
            }
        }

        @Override
        public void afterLogicalUpdatesApplied(IgniteCacheDatabaseSharedManager mgr, GridCacheDatabaseSharedManager.RestoreLogicalState restoreState) throws IgniteCheckedException {
            Collection<CacheGroupContext> cacheGrps = GridCacheProcessor.this.cacheGroups();
            this.restorePartitionStates(cacheGrps, restoreState.partitionRecoveryStates());
            if (!cacheGrps.isEmpty()) {
                this.startWarmUp();
            }
        }

        private void restorePartitionStates(Collection<CacheGroupContext> forGroups, Map<GroupPartitionId, Integer> partStates) throws IgniteCheckedException {
            long startRestorePart = U.currentTimeMillis();
            if (GridCacheProcessor.this.log.isInfoEnabled()) {
                GridCacheProcessor.this.log.info("Restoring partition state for local groups.");
            }
            AtomicReference restoreStateError = new AtomicReference();
            ExecutorService sysPool = GridCacheProcessor.this.ctx.pools().getSystemExecutorService();
            int totalPart = forGroups.stream().mapToInt(grpCtx -> grpCtx.affinity().partitions()).sum();
            CountDownLatch completionLatch = new CountDownLatch(totalPart);
            ConcurrentHashMap threadCtxs = new ConcurrentHashMap();
            int topPartRefLimit = 5;
            for (CacheGroupContext grpCtx2 : forGroups) {
                int i = 0;
                while (i < grpCtx2.affinity().partitions()) {
                    int partId = i++;
                    sysPool.execute(() -> {
                        GroupPartitionId grpPartId = new GroupPartitionId(grpCtx2.groupId(), partId);
                        try {
                            long time = grpCtx2.offheap().restoreStateOfPartition(partId, (Integer)partStates.get(grpPartId));
                            if (GridCacheProcessor.this.log.isInfoEnabled()) {
                                T3<Long, Long, GroupPartitionId> curPart = new T3<Long, Long, GroupPartitionId>(time, U.currentTimeMillis(), grpPartId);
                                RestorePartitionStateThreadContext threadCtx = threadCtxs.computeIfAbsent(Thread.currentThread(), t2 -> new RestorePartitionStateThreadContext());
                                Comparator<T3<Long, Long, GroupPartitionId>> cmp = GridCacheProcessor.processedPartitionComparator();
                                threadCtx.topPartRef.updateAndGet(prev -> {
                                    if (prev == null || cmp.compare((T3<Long, Long, GroupPartitionId>)prev.last(), curPart) < 0) {
                                        TreeSet<T3> top = new TreeSet<T3>(cmp);
                                        top.add(curPart);
                                        if (prev != null) {
                                            top.addAll((Collection<T3>)prev);
                                        }
                                        GridCacheProcessor.trimToSize(top, 5);
                                        return top;
                                    }
                                    return prev;
                                });
                                threadCtx.incrementProcessedCnt();
                            }
                        }
                        catch (Error | RuntimeException | IgniteCheckedException e) {
                            IgniteCheckedException ex;
                            U.error(GridCacheProcessor.this.log, "Failed to restore partition state for groupName=" + grpCtx2.name() + " groupId=" + grpCtx2.groupId(), e);
                            IgniteCheckedException igniteCheckedException = ex = e instanceof IgniteCheckedException ? (IgniteCheckedException)e : new IgniteCheckedException(e);
                            if (!restoreStateError.compareAndSet(null, ex)) {
                                ((IgniteCheckedException)restoreStateError.get()).addSuppressed(ex);
                            }
                        }
                        finally {
                            completionLatch.countDown();
                        }
                    });
                }
            }
            boolean printTop = false;
            try {
                if (!GridCacheProcessor.this.log.isInfoEnabled()) {
                    completionLatch.await();
                } else {
                    long timeout = TIMEOUT_OUTPUT_RESTORE_PARTITION_STATE_PROGRESS;
                    while (!completionLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                        if (GridCacheProcessor.this.log.isInfoEnabled()) {
                            SortedSet<T3<Long, Long, GroupPartitionId>> top = this.collectTopProcessedParts(threadCtxs.values(), 5);
                            long totalProcessed = threadCtxs.values().stream().mapToLong(c -> c.processedCnt).sum();
                            GridCacheProcessor.this.log.info("Restore partitions state progress [grpCnt=" + ((long)forGroups.size() - completionLatch.getCount()) + '/' + forGroups.size() + ", partitionCnt=" + totalProcessed + '/' + totalPart + (top.isEmpty() ? "" : ", topProcessedPartitions=" + GridCacheProcessor.toStringTopProcessingPartitions(top, forGroups)) + ']');
                        }
                        timeout = TIMEOUT_OUTPUT_RESTORE_PARTITION_STATE_PROGRESS / 5L;
                        printTop = true;
                    }
                }
            }
            catch (InterruptedException e) {
                throw new IgniteInterruptedException(e);
            }
            for (CacheGroupContext grpCtx3 : forGroups) {
                grpCtx3.offheap().confirmPartitionStatesRestored();
            }
            if (restoreStateError.get() != null) {
                throw (IgniteCheckedException)restoreStateError.get();
            }
            if (GridCacheProcessor.this.log.isInfoEnabled()) {
                SortedSet<T3<Long, Long, GroupPartitionId>> t2 = printTop ? this.collectTopProcessedParts(threadCtxs.values(), 5) : null;
                long totalProcessed = threadCtxs.values().stream().mapToLong(c -> c.processedCnt).sum();
                GridCacheProcessor.this.log.info("Finished restoring partition state for local groups [groupsProcessed=" + forGroups.size() + ", partitionsProcessed=" + totalProcessed + ", time=" + U.humanReadableDuration(U.currentTimeMillis() - startRestorePart) + (t2 == null ? "" : ", topProcessedPartitions=" + GridCacheProcessor.toStringTopProcessingPartitions(t2, forGroups)) + "]");
            }
        }

        private SortedSet<T3<Long, Long, GroupPartitionId>> collectTopProcessedParts(Collection<RestorePartitionStateThreadContext> threadCtxs, int topPartRefLimit) {
            TreeSet<T3<Long, Long, GroupPartitionId>> top = new TreeSet<T3<Long, Long, GroupPartitionId>>(GridCacheProcessor.processedPartitionComparator());
            for (RestorePartitionStateThreadContext threadCtx : threadCtxs) {
                SortedSet<T3<Long, Long, GroupPartitionId>> threadTop = threadCtx.topPartRef.get();
                if (threadTop == null) continue;
                top.addAll(threadTop);
            }
            GridCacheProcessor.trimToSize(top, topPartRefLimit);
            return top;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startWarmUp() throws IgniteCheckedException {
            boolean start = false;
            try {
                DataStorageConfiguration dsCfg = GridCacheProcessor.this.ctx.config().getDataStorageConfiguration();
                ArrayList<DataRegionConfiguration> regCfgs = new ArrayList<DataRegionConfiguration>(Arrays.asList(dsCfg.getDefaultDataRegionConfiguration()));
                if (Objects.nonNull(dsCfg.getDataRegionConfigurations())) {
                    regCfgs.addAll(Arrays.asList(dsCfg.getDataRegionConfigurations()));
                }
                Map<Class<? extends WarmUpConfiguration>, WarmUpStrategy> warmUpStrats = CU.warmUpStrategies(GridCacheProcessor.this.ctx);
                WarmUpConfiguration dfltWarmUpCfg = dsCfg.getDefaultWarmUpConfiguration();
                for (DataRegionConfiguration regCfg : regCfgs) {
                    WarmUpConfiguration warmUpCfg;
                    if (this.stopWarmUp.get()) {
                        return;
                    }
                    if (!regCfg.isPersistenceEnabled()) continue;
                    WarmUpConfiguration warmUpConfiguration = warmUpCfg = Objects.nonNull(regCfg.getWarmUpConfiguration()) ? regCfg.getWarmUpConfiguration() : dfltWarmUpCfg;
                    if (Objects.isNull(warmUpCfg)) continue;
                    WarmUpStrategy warmUpStrat = this.curWarmUpStrat = warmUpStrats.get(warmUpCfg.getClass());
                    DataRegion region = GridCacheProcessor.this.sharedCtx.database().dataRegion(regCfg.getName());
                    if (this.stopWarmUp.get()) continue;
                    if (!start) {
                        start = true;
                        if (true && GridCacheProcessor.this.log.isInfoEnabled()) {
                            GridCacheProcessor.this.log.info("Warm-up start.");
                        }
                    }
                    if (GridCacheProcessor.this.log.isInfoEnabled()) {
                        GridCacheProcessor.this.log.info("Start warm-up for data region [name=" + regCfg.getName() + ", warmUpStrategy=" + warmUpStrat + ", warmUpConfig=" + warmUpCfg + ", isDefault=" + (warmUpCfg == dfltWarmUpCfg) + ']');
                    }
                    warmUpStrat.warmUp(warmUpCfg, region);
                    if (!GridCacheProcessor.this.log.isInfoEnabled()) continue;
                    GridCacheProcessor.this.log.info("Finish of warm-up data region: " + region.config().getName());
                }
            }
            finally {
                if (this.stopWarmUp.get() && GridCacheProcessor.this.log.isInfoEnabled()) {
                    GridCacheProcessor.this.log.info("Warm-up stop.");
                } else if (start && GridCacheProcessor.this.log.isInfoEnabled()) {
                    GridCacheProcessor.this.log.info("Warm-up finish.");
                }
                this.stopWarmUp.set(true);
                this.curWarmUpStrat = null;
            }
        }
    }
}

