/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mxbean;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParameter;
import org.apache.ignite.mxbean.MXBeanParametersDescriptions;
import org.apache.ignite.mxbean.MXBeanParametersNames;

public class IgniteStandardMXBean
extends StandardMBean {
    private static final String DESC_MUST_START_WITH_UPP_CASE = "Description must start with upper case: ";
    private static final String DESC_MUST_END_WITH_PERIOD = "Description must end with period: ";
    private static final String DESC_MUST_BE_NOT_NULL = "Description must be not null: ";
    private static final String DESC_MUST_BE_NOT_EMPTY = "Description must be not empty: ";
    private static final String NAME_MUST_BE_NOT_NULL = "Parameter name must be not null: ";
    private static final String NAME_MUST_BE_NOT_EMPTY = "Parameter name must be not empty: ";
    private static final Map<String, Class<?>> primCls = new HashMap();

    public <T> IgniteStandardMXBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String str = super.getDescription(info);
        String methodName = (info.isIs() ? "is" : "get") + info.getName();
        try {
            MXBeanDescription desc;
            Method mtd = this.findMethod(this.getMBeanInterface(), methodName, new Class[0]);
            if (mtd != null && (desc = mtd.getAnnotation(MXBeanDescription.class)) != null) {
                str = desc.value();
                assert (str != null) : "Failed to find method: " + mtd;
                assert (!str.trim().isEmpty()) : "Method description cannot be empty: " + mtd;
                assert (Character.isUpperCase(str.charAt(0))) : "Description must start with upper case: " + str;
                assert (str.charAt(str.length() - 1) == '.') : "Description must end with period: " + str;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return str;
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        String str = super.getDescription(info);
        MXBeanDescription desc = U.getAnnotation(this.getMBeanInterface(), MXBeanDescription.class);
        if (desc != null) {
            str = desc.value();
            assert (str != null);
            assert (!str.trim().isEmpty());
            assert (Character.isUpperCase(str.charAt(0))) : "Description must start with upper case: " + str;
            assert (str.charAt(str.length() - 1) == '.') : "Description must end with period: " + str;
        }
        return str;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String str = super.getDescription(info);
        try {
            Method m4 = this.getMethod(info);
            MXBeanDescription desc = m4.getAnnotation(MXBeanDescription.class);
            if (desc != null) {
                str = desc.value();
                assert (str != null);
                assert (!str.trim().isEmpty());
                assert (Character.isUpperCase(str.charAt(0))) : "Description must start with upper case: " + str;
                assert (str.charAt(str.length() - 1) == '.') : "Description must end with period: " + str;
            }
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        return str;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int seq) {
        String str = super.getDescription(op, param, seq);
        try {
            Method m4 = this.getMethod(op);
            MXBeanParametersDescriptions decsAnn = m4.getAnnotation(MXBeanParametersDescriptions.class);
            if (decsAnn != null) {
                assert (decsAnn.value() != null);
                assert (seq < decsAnn.value().length);
                str = decsAnn.value()[seq];
                assert (str != null) : "Description must be not null: " + str;
                assert (!str.trim().isEmpty()) : "Description must be not empty: " + str;
                assert (Character.isUpperCase(str.charAt(0))) : "Description must start with upper case: " + str;
                assert (str.charAt(str.length() - 1) == '.') : "Description must end with period: " + str;
            } else {
                MXBeanParameter argInfoAnnotation = this.getMXBeanParameterAnnotation(m4, seq);
                if (argInfoAnnotation != null) {
                    str = argInfoAnnotation.description();
                    assert (str != null) : "Description must be not null: " + str;
                    assert (!str.trim().isEmpty()) : "Description must be not empty: " + str;
                    assert (Character.isUpperCase(str.charAt(0))) : "Description must start with upper case: " + str;
                    assert (str.charAt(str.length() - 1) == '.') : "Description must end with period: " + str;
                }
            }
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        return str;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int seq) {
        String str = super.getParameterName(op, param, seq);
        try {
            Method m4 = this.getMethod(op);
            MXBeanParametersNames namesAnn = m4.getAnnotation(MXBeanParametersNames.class);
            if (namesAnn != null) {
                assert (namesAnn.value() != null);
                assert (seq < namesAnn.value().length);
                str = namesAnn.value()[seq];
                assert (str != null) : "Parameter name must be not null: " + str;
                assert (!str.trim().isEmpty()) : "Parameter name must be not empty: " + str;
            } else {
                MXBeanParameter argInfoAnnotation = this.getMXBeanParameterAnnotation(m4, seq);
                if (argInfoAnnotation != null) {
                    str = argInfoAnnotation.name();
                    assert (str != null) : "Parameter name must be not null: " + str;
                    assert (!str.trim().isEmpty()) : "Parameter name must be not empty: " + str;
                }
            }
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        return str;
    }

    private MXBeanParameter getMXBeanParameterAnnotation(Method m4, int seq) {
        Parameter[] params = m4.getParameters();
        if (seq < params.length) {
            return params[seq].getAnnotation(MXBeanParameter.class);
        }
        return null;
    }

    private Method getMethod(MBeanOperationInfo op) throws ClassNotFoundException, SecurityException {
        String mtdName = op.getName();
        MBeanParameterInfo[] signature = op.getSignature();
        Class[] params = new Class[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            Class<?> type = primCls.get(signature[i].getType().toLowerCase());
            if (type == null) {
                type = Class.forName(signature[i].getType());
            }
            params[i] = type;
        }
        return this.findMethod(this.getMBeanInterface(), mtdName, params);
    }

    private Method findMethod(Class itf, String methodName, Class[] params) {
        Class<?>[] superItfs;
        assert (itf.isInterface()) : itf + " must represent the interface";
        Method res = null;
        try {
            res = itf.getDeclaredMethod(methodName, params);
            if (res != null) {
                return res;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (Class<?> superItf : superItfs = itf.getInterfaces()) {
            res = this.findMethod(superItf, methodName, params);
            if (res == null) continue;
            return res;
        }
        return res;
    }

    static {
        primCls.put(Boolean.TYPE.toString().toLowerCase(), Boolean.TYPE);
        primCls.put(Character.TYPE.toString().toLowerCase(), Character.TYPE);
        primCls.put(Byte.TYPE.toString().toLowerCase(), Byte.TYPE);
        primCls.put(Short.TYPE.toString().toLowerCase(), Short.TYPE);
        primCls.put(Integer.TYPE.toString().toLowerCase(), Integer.TYPE);
        primCls.put(Long.TYPE.toString().toLowerCase(), Long.TYPE);
        primCls.put(Float.TYPE.toString().toLowerCase(), Float.TYPE);
        primCls.put(Double.TYPE.toString().toLowerCase(), Double.TYPE);
    }
}

