/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLPermission;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryCachingMetadataHandler;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryMetadataHandler;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.jdbc.thin.AffinityCache;
import org.apache.ignite.internal.jdbc.thin.ConnectionProperties;
import org.apache.ignite.internal.jdbc.thin.JdbcThinDatabaseMetadata;
import org.apache.ignite.internal.jdbc.thin.JdbcThinPartitionAwarenessMappingGroup;
import org.apache.ignite.internal.jdbc.thin.JdbcThinPartitionResultDescriptor;
import org.apache.ignite.internal.jdbc.thin.JdbcThinPreparedStatement;
import org.apache.ignite.internal.jdbc.thin.JdbcThinStatement;
import org.apache.ignite.internal.jdbc.thin.JdbcThinTcpIo;
import org.apache.ignite.internal.jdbc.thin.QualifiedSQLQuery;
import org.apache.ignite.internal.jdbc2.JdbcUtils;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeGetRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeGetResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeNameGetRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeNameGetResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypeNamePutRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBinaryTypePutRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadBatchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcCachePartitionsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcCachePartitionsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCancelRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResponse;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResultWithIo;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcStatementType;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUpdateBinarySchemaResult;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionClientContext;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.util.HostAndPortRange;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.jetbrains.annotations.Nullable;

public class JdbcThinConnection
implements Connection {
    private static final Logger LOG = Logger.getLogger(JdbcThinConnection.class.getName());
    private static final int REQUEST_TIMEOUT_PERIOD = 1000;
    public static final int RECONNECTION_DELAY = 200;
    private static final int RECONNECTION_MAX_DELAY = 300000;
    private static final String SET_NETWORK_TIMEOUT_PERM = "setNetworkTimeout";
    static final int NO_TIMEOUT = 0;
    private static final AtomicLong IDX_GEN = new AtomicLong();
    public static final int DFLT_RETRIES_CNT = 4;
    public static final int NO_RETRIES = 0;
    private final boolean partitionAwareness;
    private final Object stmtsMux = new Object();
    private String schema;
    private volatile boolean closed;
    private int txIsolation;
    private boolean autoCommit;
    private boolean readOnly;
    private volatile StreamState streamState;
    private int holdability;
    private JdbcThinDatabaseMetadata metadata;
    private final ConnectionProperties connProps;
    private final AtomicInteger connCnt = new AtomicInteger();
    private final Set<JdbcThinStatement> stmts = Collections.newSetFromMap(new IdentityHashMap());
    private AffinityCache affinityCache;
    private volatile JdbcThinTcpIo singleIo;
    private final ConcurrentSkipListMap<UUID, JdbcThinTcpIo> ios = new ConcurrentSkipListMap();
    private int srvIdx;
    private Thread ownThread;
    private final Object mux = new Object();
    private volatile JdbcThinTcpIo txIo;
    private static final Random RND = new Random(System.currentTimeMillis());
    private int netTimeout;
    @Nullable
    private final Integer qryTimeout;
    private final ScheduledExecutorService maintenanceExecutor;
    private ScheduledFuture<?> qryTimeoutScheduledFut;
    private ScheduledFuture<?> connectionsHndScheduledFut;
    private final IgniteProductVersion baseEndpointVer;
    private volatile BinaryContext ctx;
    private volatile JdbcBinaryMetadataHandler metaHnd;
    private final JdbcMarshallerContext marshCtx;

    public JdbcThinConnection(ConnectionProperties connProps) throws SQLException {
        this.connProps = connProps;
        this.metaHnd = new JdbcBinaryMetadataHandler();
        this.marshCtx = new JdbcMarshallerContext();
        this.ctx = this.createBinaryCtx(this.metaHnd, this.marshCtx);
        this.holdability = 1;
        this.autoCommit = true;
        this.txIsolation = 0;
        this.netTimeout = connProps.getConnectionTimeout();
        this.qryTimeout = connProps.getQueryTimeout();
        this.maintenanceExecutor = Executors.newScheduledThreadPool(2, new IgniteThreadFactory(this.ctx.configuration().getIgniteInstanceName(), "jdbc-maintenance"));
        this.schema = JdbcUtils.normalizeSchema(connProps.getSchema());
        this.partitionAwareness = connProps.isPartitionAwareness();
        if (this.partitionAwareness) {
            this.baseEndpointVer = this.connectInBestEffortAffinityMode(null);
            this.connectionsHndScheduledFut = this.maintenanceExecutor.scheduleWithFixedDelay(new ConnectionHandlerTask(), 0L, 200L, TimeUnit.MILLISECONDS);
        } else {
            this.connectInCommonMode();
            this.baseEndpointVer = null;
        }
    }

    private BinaryContext createBinaryCtx(JdbcBinaryMetadataHandler metaHnd, JdbcMarshallerContext marshCtx) {
        BinaryMarshaller marsh = new BinaryMarshaller();
        marsh.setContext(marshCtx);
        BinaryConfiguration binCfg = new BinaryConfiguration().setCompactFooter(true);
        BinaryContext ctx = new BinaryContext(metaHnd, new IgniteConfiguration(), new NullLogger());
        ctx.configure(marsh, binCfg);
        ctx.registerUserTypesSchema();
        return ctx;
    }

    private void ensureConnected() throws SQLException {
        if (this.connCnt.get() > 0) {
            return;
        }
        assert (!this.closed);
        assert (this.ios.isEmpty());
        if (this.partitionAwareness) {
            this.connectInBestEffortAffinityMode(this.baseEndpointVer);
        } else {
            this.connectInCommonMode();
        }
    }

    boolean isStream() {
        return this.streamState != null;
    }

    void executeNative(String sql, SqlCommand cmd, JdbcThinStatement stmt) throws SQLException {
        if (cmd instanceof SqlSetStreamingCommand) {
            SqlSetStreamingCommand cmd0 = (SqlSetStreamingCommand)cmd;
            if (this.streamState != null) {
                this.streamState.close();
                this.streamState = null;
            }
            boolean newVal = ((SqlSetStreamingCommand)cmd).isTurnOn();
            this.ensureConnected();
            JdbcThinTcpIo cliIo = this.cliIo(null);
            if (newVal) {
                if (!cmd0.isOrdered() && !cliIo.isUnorderedStreamSupported()) {
                    throw new SQLException("Streaming without order doesn't supported by server [remoteNodeVer=" + cliIo.igniteVersion() + ']', "50000");
                }
                this.streamState = new StreamState((SqlSetStreamingCommand)cmd, cliIo);
                this.sendRequest(new JdbcQueryExecuteRequest(JdbcStatementType.ANY_STATEMENT_TYPE, this.schema, 1, 1, this.autoCommit, stmt.explicitTimeout, sql, null), stmt, cliIo);
                this.streamState.start();
            }
        } else {
            throw IgniteQueryErrorCode.createJdbcSqlException("Unsupported native statement: " + sql, 1002);
        }
    }

    void addBatch(String sql, List<Object> args) throws SQLException {
        assert (this.isStream());
        this.streamState.addBatch(sql, args);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency) throws SQLException {
        return this.createStatement(resSetType, resSetConcurrency, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        this.checkCursorOptions(resSetType, resSetConcurrency);
        JdbcThinStatement stmt = new JdbcThinStatement(this, resSetHoldability, this.schema);
        if (this.qryTimeout != null) {
            stmt.setQueryTimeout(this.qryTimeout);
        }
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.add(stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resSetType, resSetConcurrency, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        this.checkCursorOptions(resSetType, resSetConcurrency);
        if (sql == null) {
            throw new SQLException("SQL string cannot be null.");
        }
        JdbcThinPreparedStatement stmt = new JdbcThinPreparedStatement(this, sql, resSetHoldability, this.schema);
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.add(stmt);
        }
        return stmt;
    }

    private void checkCursorOptions(int resSetType, int resSetConcurrency) throws SQLException {
        if (resSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Invalid result set type (only forward is supported).");
        }
        if (resSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Invalid concurrency (updates are not supported).");
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureNotClosed();
        if (sql == null) {
            throw new SQLException("SQL string cannot be null.");
        }
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureNotClosed();
        if (autoCommit != this.autoCommit) {
            this.doCommit();
            this.autoCommit = autoCommit;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureNotClosed();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Transaction cannot be committed explicitly in auto-commit mode.");
        }
        this.doCommit();
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Transaction cannot be rolled back explicitly in auto-commit mode.");
        }
        try (Statement s2 = this.createStatement();){
            s2.execute("ROLLBACK");
        }
    }

    private void doCommit() throws SQLException {
        try (Statement s2 = this.createStatement();){
            s2.execute("COMMIT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.maintenanceExecutor.shutdown();
        if (this.streamState != null) {
            this.streamState.close();
            this.streamState = null;
        }
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.clear();
        }
        Object err = null;
        if (this.partitionAwareness) {
            for (JdbcThinTcpIo clioIo : this.ios.values()) {
                clioIo.close();
            }
            this.ios.clear();
        } else if (this.singleIo != null) {
            this.singleIo.close();
        }
        if (err != null) {
            throw err;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        if (this.metadata == null) {
            this.metadata = new JdbcThinDatabaseMetadata(this);
        }
        return this.metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureNotClosed();
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureNotClosed();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureNotClosed();
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new SQLException("Invalid transaction isolation level.", "0700E");
            }
        }
        this.txIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureNotClosed();
        return this.txIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureNotClosed();
        if (holdability != 1 && holdability != 2) {
            throw new SQLException("Invalid result set holdability value.");
        }
        this.holdability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureNotClosed();
        return this.holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Savepoint cannot be set in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureNotClosed();
        if (name == null) {
            throw new SQLException("Savepoint name cannot be null.");
        }
        if (this.autoCommit) {
            throw new SQLException("Savepoint cannot be set in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        if (savepoint == null) {
            throw new SQLException("Invalid savepoint.");
        }
        if (this.autoCommit) {
            throw new SQLException("Auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        if (savepoint == null) {
            throw new SQLException("Savepoint cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public Clob createClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Invalid timeout: " + timeout);
        }
        return !this.closed;
    }

    @Override
    public void setClientInfo(String name, String val) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("Connection is closed.", null);
        }
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("Connection is closed.", null);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureNotClosed();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.ensureNotClosed();
        if (typeName == null) {
            throw new SQLException("Type name cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attrs) throws SQLException {
        this.ensureNotClosed();
        if (typeName == null) {
            throw new SQLException("Type name cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Connection is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcThinConnection.class);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.ensureNotClosed();
        this.schema = JdbcUtils.normalizeSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.ensureNotClosed();
        return this.schema;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("Executor cannot be null.");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int ms) throws SQLException {
        this.ensureNotClosed();
        if (ms < 0) {
            throw new SQLException("Network timeout cannot be negative.");
        }
        SecurityManager secMgr = System.getSecurityManager();
        if (secMgr != null) {
            secMgr.checkPermission(new SQLPermission(SET_NETWORK_TIMEOUT_PERM));
        }
        this.netTimeout = ms;
        if (this.partitionAwareness) {
            for (JdbcThinTcpIo clioIo : this.ios.values()) {
                clioIo.timeout(ms);
            }
        } else {
            this.singleIo.timeout(ms);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.ensureNotClosed();
        return this.netTimeout;
    }

    public void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed.", "08003");
        }
    }

    IgniteProductVersion igniteVersion() {
        if (this.partitionAwareness) {
            return this.ios.values().stream().map(JdbcThinTcpIo::igniteVersion).min(IgniteProductVersion::compareTo).orElse(this.baseEndpointVer);
        }
        return this.singleIo.igniteVersion();
    }

    boolean autoCloseServerCursor() {
        return this.connProps.isAutoCloseServerCursor();
    }

    JdbcResultWithIo sendRequest(JdbcRequest req) throws SQLException {
        return this.sendRequest(req, null, null);
    }

    JdbcResultWithIo sendRequest(JdbcRequest req, JdbcThinStatement stmt, @Nullable JdbcThinTcpIo stickyIo) throws SQLException {
        RequestTimeoutTask reqTimeoutTask = null;
        this.acquireMutex();
        try {
            int retryAttemptsLeft = 1;
            Exception lastE = null;
            while (retryAttemptsLeft > 0) {
                JdbcThinTcpIo cliIo = null;
                this.ensureConnected();
                try {
                    JdbcResponse res;
                    JdbcThinTcpIo jdbcThinTcpIo = cliIo = stickyIo == null || !stickyIo.connected() ? this.cliIo(this.calculateNodeIds(req)) : stickyIo;
                    if (stmt != null && stmt.requestTimeout() != 0) {
                        reqTimeoutTask = new RequestTimeoutTask(req instanceof JdbcBulkLoadBatchRequest ? stmt.currentRequestId() : req.requestId(), cliIo, stmt.requestTimeout());
                        this.qryTimeoutScheduledFut = this.maintenanceExecutor.scheduleAtFixedRate(reqTimeoutTask, 0L, 1000L, TimeUnit.MILLISECONDS);
                    }
                    JdbcQueryExecuteRequest qryReq = null;
                    if (req instanceof JdbcQueryExecuteRequest) {
                        qryReq = (JdbcQueryExecuteRequest)req;
                    }
                    JdbcThinTcpIo jdbcThinTcpIo2 = this.txIo = (res = cliIo.sendRequest(req, stmt)).activeTransaction() ? cliIo : null;
                    if (res.status() == 3014 && stmt != null && stmt.requestTimeout() != 0 && reqTimeoutTask != null && reqTimeoutTask.expired.get()) {
                        int qryTimeout = stmt.getQueryTimeout();
                        throw new SQLTimeoutException(this.getTimeoutDescription(qryTimeout, cliIo), "57014", 3014);
                    }
                    if (res.status() != 0) {
                        throw new SQLException(res.error(), IgniteQueryErrorCode.codeToSqlState(res.status()), res.status());
                    }
                    this.updateAffinityCache(qryReq, res);
                    JdbcResultWithIo jdbcResultWithIo = new JdbcResultWithIo(res.response(), cliIo);
                    return jdbcResultWithIo;
                }
                catch (SQLException e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Exception during sending an sql request.", e);
                    }
                    throw e;
                }
                catch (BinaryObjectException e) {
                    String err = "Serialization error during sending an sql request. The error can be caused by the fact that the classes used on the node are missing on the client. Try to use JDBC connection option 'keepBinary=true' to to avoid deserialization. Also you can use system property IGNITE_SENSITIVE_DATA_LOGGING=\"plain\" to readable print content of a BinaryObject";
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, err, e);
                    }
                    throw new SQLException(err, "22000", e);
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Exception during sending an sql request.", e);
                    }
                    if (cliIo != null && cliIo.connected()) {
                        this.onDisconnect(cliIo);
                    }
                    if (e instanceof SocketTimeoutException) {
                        throw new SQLException("Connection timed out.", "08006", e);
                    }
                    if (lastE == null) {
                        retryAttemptsLeft = this.calculateRetryAttemptsCount(stickyIo, req);
                        lastE = e;
                        continue;
                    }
                    --retryAttemptsLeft;
                }
            }
            throw new SQLException("Failed to communicate with Ignite cluster.", "08006", lastE);
        }
        finally {
            if (stmt != null && stmt.requestTimeout() != 0 && reqTimeoutTask != null) {
                this.qryTimeoutScheduledFut.cancel(false);
            }
            this.releaseMutex();
        }
    }

    private String getTimeoutDescription(int timeout, JdbcThinTcpIo cliIo) {
        String cliIoInfo = "";
        if (cliIo != null) {
            cliIoInfo = " [";
            if (cliIo.nodeId() != null) {
                cliIoInfo = cliIoInfo + "[Node UUID: " + cliIo.nodeId().toString() + "]";
            }
            if (cliIo.igniteVersion() != null) {
                cliIoInfo = cliIoInfo + "[Ignite version: " + cliIo.igniteVersion().toString() + "]";
            }
            cliIoInfo = cliIoInfo + "]";
        }
        return "The query was cancelled while executing due to timeout. Query timeout was : " + timeout + "." + cliIoInfo;
    }

    @Nullable
    private List<UUID> calculateNodeIds(JdbcRequest req) throws IOException, SQLException {
        if (!this.partitionAwareness || !(req instanceof JdbcQueryExecuteRequest)) {
            return null;
        }
        JdbcQueryExecuteRequest qry = (JdbcQueryExecuteRequest)req;
        if (this.affinityCache == null) {
            qry.partitionResponseRequest(true);
            return null;
        }
        JdbcThinPartitionResultDescriptor partResDesc = this.affinityCache.partitionResult(new QualifiedSQLQuery(qry.schemaName(), qry.sqlQuery()));
        if (partResDesc == JdbcThinPartitionResultDescriptor.EMPTY_DESCRIPTOR) {
            return null;
        }
        if (partResDesc == null) {
            qry.partitionResponseRequest(true);
            return null;
        }
        Collection<Integer> parts = JdbcThinConnection.calculatePartitions(partResDesc, qry.arguments());
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        UUID[] cacheDistr = this.retrieveCacheDistribution(partResDesc.cacheId(), partResDesc.partitionResult().partitionsCount());
        if (parts.size() == 1) {
            return Collections.singletonList(cacheDistr[parts.iterator().next()]);
        }
        ArrayList<UUID> partitionAwarenessNodeIds = new ArrayList<UUID>();
        for (int part : parts) {
            partitionAwarenessNodeIds.add(cacheDistr[part]);
        }
        return partitionAwarenessNodeIds;
    }

    private UUID[] retrieveCacheDistribution(int cacheId, int partCnt) throws IOException {
        UUID[] cacheDistr = this.affinityCache.cacheDistribution(cacheId);
        if (cacheDistr != null) {
            return cacheDistr;
        }
        JdbcResponse res = this.cliIo(null).sendRequest(new JdbcCachePartitionsRequest(Collections.singleton(cacheId)), null);
        assert (res.status() == 0);
        AffinityTopologyVersion resAffinityVer = res.affinityVersion();
        if (this.affinityCache.version().compareTo(resAffinityVer) < 0) {
            this.affinityCache = new AffinityCache(resAffinityVer, this.connProps.getPartitionAwarenessPartitionDistributionsCacheSize(), this.connProps.getPartitionAwarenessSqlCacheSize());
        } else if (this.affinityCache.version().compareTo(resAffinityVer) > 0) {
            return null;
        }
        List<JdbcThinPartitionAwarenessMappingGroup> mappings = ((JdbcCachePartitionsResult)res.response()).getMappings();
        assert (mappings.size() == 1);
        JdbcThinPartitionAwarenessMappingGroup mappingGrp = mappings.get(0);
        cacheDistr = mappingGrp.revertMappings(partCnt);
        for (int mpCacheId : mappingGrp.cacheIds()) {
            this.affinityCache.addCacheDistribution(mpCacheId, cacheDistr);
        }
        return cacheDistr;
    }

    public static Collection<Integer> calculatePartitions(JdbcThinPartitionResultDescriptor partResDesc, Object[] args) throws SQLException {
        PartitionResult derivedParts = partResDesc.partitionResult();
        if (derivedParts != null) {
            try {
                return derivedParts.tree().apply(partResDesc.partitionClientContext(), args);
            }
            catch (IgniteCheckedException e) {
                throw new SQLException("Failed to calculate derived partitions for query.", "50000");
            }
        }
        return null;
    }

    void sendQueryCancelRequest(JdbcQueryCancelRequest req, JdbcThinTcpIo cliIo) throws SQLException {
        if (this.connCnt.get() == 0) {
            throw new SQLException("Failed to communicate with Ignite cluster.", "08006");
        }
        assert (cliIo != null);
        try {
            cliIo.sendCancelRequest(req);
        }
        catch (Exception e) {
            throw new SQLException("Failed to communicate with Ignite cluster.", "08006", e);
        }
    }

    private void sendRequestNotWaitResponse(JdbcRequest req, JdbcThinTcpIo stickyIO) throws SQLException {
        this.ensureConnected();
        this.acquireMutex();
        try {
            stickyIO.sendRequestNoWaitResponse(req);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            this.onDisconnect(stickyIO);
            if (e instanceof SocketTimeoutException) {
                throw new SQLException("Connection timed out.", "08006", e);
            }
            throw new SQLException("Failed to communicate with Ignite cluster.", "08006", e);
        }
        finally {
            this.releaseMutex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireMutex() throws SQLException {
        Object object = this.mux;
        synchronized (object) {
            Thread curr = Thread.currentThread();
            if (this.ownThread != null && this.ownThread != curr) {
                throw new SQLException("Concurrent access to JDBC connection is not allowed [ownThread=" + this.ownThread.getName() + ", curThread=" + curr.getName(), "08006");
            }
            this.ownThread = curr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseMutex() {
        Object object = this.mux;
        synchronized (object) {
            Thread curr = Thread.currentThread();
            if (this.ownThread != null && this.ownThread != curr) {
                throw new IllegalStateException("Mutex is owned by another thread");
            }
            this.ownThread = null;
        }
    }

    public String url() {
        return this.connProps.getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDisconnect(JdbcThinTcpIo cliIo) {
        assert (this.connCnt.get() > 0);
        if (this.partitionAwareness) {
            cliIo.close();
            this.ios.remove(cliIo.nodeId());
        } else if (this.singleIo != null) {
            this.singleIo.close();
        }
        this.connCnt.decrementAndGet();
        if (this.streamState != null) {
            this.streamState.close0();
            this.streamState = null;
        }
        Object object = this.stmtsMux;
        synchronized (object) {
            for (JdbcThinStatement s2 : this.stmts) {
                s2.closeOnDisconnect();
            }
            this.stmts.clear();
        }
        this.metaHnd = new JdbcBinaryMetadataHandler();
        this.ctx = this.createBinaryCtx(this.metaHnd, this.marshCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeStatement(JdbcThinStatement stmt) {
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.remove(stmt);
        }
    }

    boolean isQueryCancellationSupported() {
        return this.partitionAwareness || this.singleIo.isQueryCancellationSupported();
    }

    boolean isCustomObjectSupported() {
        return this.singleIo.isCustomObjectSupported();
    }

    private JdbcThinTcpIo cliIo(List<UUID> nodeIds) {
        if (!this.partitionAwareness) {
            return this.singleIo;
        }
        if (this.txIo != null) {
            return this.txIo;
        }
        if (nodeIds == null || nodeIds.isEmpty()) {
            return this.randomIo();
        }
        JdbcThinTcpIo io = null;
        if (nodeIds.size() == 1) {
            io = this.ios.get(nodeIds.get(0));
        } else {
            int initNodeId = RND.nextInt(nodeIds.size());
            int iterCnt = 0;
            while (io == null) {
                io = this.ios.get(nodeIds.get(initNodeId));
                int n = initNodeId = initNodeId == nodeIds.size() ? 0 : initNodeId + 1;
                if (++iterCnt != nodeIds.size()) continue;
            }
        }
        return io != null ? io : this.randomIo();
    }

    private JdbcThinTcpIo randomIo() {
        int i;
        byte[] randomBytes = new byte[16];
        RND.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        UUID randomUUID = new UUID(msb, lsb);
        Map.Entry<UUID, JdbcThinTcpIo> entry = this.ios.ceilingEntry(randomUUID);
        return entry != null ? entry.getValue() : this.ios.floorEntry(randomUUID).getValue();
    }

    public int serverIndex() {
        return this.srvIdx;
    }

    private static int nextServerIndex(int len) {
        if (len == 1) {
            return 0;
        }
        long nextIdx = IDX_GEN.getAndIncrement();
        return (int)(nextIdx % (long)len);
    }

    private void connectInCommonMode() throws SQLException {
        HostAndPortRange[] srvs = this.connProps.getAddresses();
        ArrayList<Exception> exceptions = null;
        for (int i = 0; i < srvs.length; ++i) {
            this.srvIdx = JdbcThinConnection.nextServerIndex(srvs.length);
            HostAndPortRange srv = srvs[this.srvIdx];
            try {
                InetAddress[] addrs;
                for (InetAddress addr : addrs = InetAddress.getAllByName(srv.host())) {
                    for (int port = srv.portFrom(); port <= srv.portTo(); ++port) {
                        try {
                            JdbcThinTcpIo cliIo = new JdbcThinTcpIo(this.connProps, new InetSocketAddress(addr, port), this.ctx, 0);
                            cliIo.timeout(this.netTimeout);
                            this.singleIo = cliIo;
                            this.connCnt.incrementAndGet();
                            return;
                        }
                        catch (Exception exception) {
                            if (exceptions == null) {
                                exceptions = new ArrayList();
                            }
                            exceptions.add(exception);
                            continue;
                        }
                    }
                }
                continue;
            }
            catch (Exception exception) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(exception);
            }
        }
        this.handleConnectExceptions(exceptions);
    }

    private void handleConnectExceptions(List<Exception> exceptions) throws SQLException {
        if (this.connCnt.get() == 0 && exceptions != null) {
            this.close();
            if (exceptions.size() == 1) {
                Exception ex = exceptions.get(0);
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                if (ex instanceof IOException) {
                    throw new SQLException("Failed to connect to Ignite cluster [url=" + this.connProps.getUrl() + ']', "08001", ex);
                }
            }
            SQLException e = new SQLException("Failed to connect to server [url=" + this.connProps.getUrl() + ']', "08001");
            for (Exception ex : exceptions) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    private IgniteProductVersion connectInBestEffortAffinityMode(IgniteProductVersion baseEndpointVer) throws SQLException {
        ArrayList<Exception> exceptions = null;
        for (int i = 0; i < this.connProps.getAddresses().length; ++i) {
            HostAndPortRange srv = this.connProps.getAddresses()[i];
            try {
                InetAddress[] addrs;
                for (InetAddress addr : addrs = InetAddress.getAllByName(srv.host())) {
                    for (int port = srv.portFrom(); port <= srv.portTo(); ++port) {
                        try {
                            JdbcThinTcpIo cliIo = new JdbcThinTcpIo(this.connProps, new InetSocketAddress(addr, port), this.ctx, 0);
                            if (!cliIo.isPartitionAwarenessSupported()) {
                                cliIo.close();
                                throw new SQLException("Failed to connect to Ignite node [url=" + this.connProps.getUrl() + "]. address = [" + addr + ':' + port + "].Node doesn't support partition awareness mode.", "50000");
                            }
                            IgniteProductVersion endpointVer = cliIo.igniteVersion();
                            if (baseEndpointVer != null && baseEndpointVer.compareTo(endpointVer) > 0) {
                                cliIo.close();
                                throw new SQLException("Failed to connect to Ignite node [url=" + this.connProps.getUrl() + "], address = [" + addr + ':' + port + "],the node version [" + endpointVer + "] is smaller than the base one [" + baseEndpointVer + "].", "50000");
                            }
                            cliIo.timeout(this.netTimeout);
                            JdbcThinTcpIo ioToSameNode = this.ios.putIfAbsent(cliIo.nodeId(), cliIo);
                            if (ioToSameNode != null) {
                                cliIo.close();
                            } else {
                                this.connCnt.incrementAndGet();
                            }
                            return cliIo.igniteVersion();
                        }
                        catch (Exception exception) {
                            if (exceptions == null) {
                                exceptions = new ArrayList();
                            }
                            exceptions.add(exception);
                            continue;
                        }
                    }
                }
                continue;
            }
            catch (Exception exception) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(exception);
            }
        }
        this.handleConnectExceptions(exceptions);
        return null;
    }

    private void updateAffinityCache(JdbcQueryExecuteRequest qryReq, JdbcResponse res) {
        if (this.partitionAwareness) {
            PartitionResult partRes;
            AffinityTopologyVersion resAffVer = res.affinityVersion();
            if (resAffVer != null && (this.affinityCache == null || this.affinityCache.version().compareTo(resAffVer) < 0)) {
                this.affinityCache = new AffinityCache(resAffVer, this.connProps.getPartitionAwarenessPartitionDistributionsCacheSize(), this.connProps.getPartitionAwarenessSqlCacheSize());
            }
            if (res.response() instanceof JdbcQueryExecuteResult && qryReq.partitionResponseRequest() && ((partRes = ((JdbcQueryExecuteResult)res.response()).partitionResult()) == null || this.affinityCache.version().equals(partRes.topologyVersion()))) {
                int cacheId = partRes != null && partRes.tree() != null ? GridCacheUtils.cacheId(partRes.cacheName()) : -1;
                PartitionClientContext partClientCtx = partRes != null ? new PartitionClientContext(partRes.partitionsCount()) : null;
                QualifiedSQLQuery qry = new QualifiedSQLQuery(qryReq.schemaName(), qryReq.sqlQuery());
                JdbcThinPartitionResultDescriptor partResDescr = new JdbcThinPartitionResultDescriptor(partRes, cacheId, partClientCtx);
                this.affinityCache.addSqlQuery(qry, partResDescr);
            }
        }
    }

    private int calculateRetryAttemptsCount(JdbcThinTcpIo stickyIo, JdbcRequest req) {
        if (!this.partitionAwareness) {
            return 0;
        }
        if (stickyIo != null) {
            return 0;
        }
        if (req.type() == 7 || req.type() == 8 || req.type() == 9 || req.type() == 10 || req.type() == 11 || req.type() == 12 || req.type() == 16) {
            return 4;
        }
        if (req.type() == 2) {
            JdbcQueryExecuteRequest qryExecReq = (JdbcQueryExecuteRequest)req;
            String trimmedQry = qryExecReq.sqlQuery().trim();
            for (int i = 0; i < trimmedQry.length() - 1; ++i) {
                if (trimmedQry.charAt(i) != ';') continue;
                return 0;
            }
            return trimmedQry.toUpperCase().startsWith("SELECT") ? 4 : 0;
        }
        return 0;
    }

    private abstract class BlockingJdbcChannel {
        private Map<Long, CompletableFuture<JdbcResult>> results = new ConcurrentHashMap<Long, CompletableFuture<JdbcResult>>();

        private BlockingJdbcChannel() {
        }

        <R extends JdbcResult> R doRequest(JdbcRequest req) throws SQLException, InterruptedException, ExecutionException {
            Object res;
            if (JdbcThinConnection.this.isStream()) {
                CompletableFuture resFut = new CompletableFuture();
                CompletableFuture oldFut = this.results.put(req.requestId(), resFut);
                assert (oldFut == null) : "Another request with the same id is waiting for result.";
                JdbcThinConnection.this.sendRequestNotWaitResponse(req, JdbcThinConnection.this.streamState.streamingStickyIo);
                res = (JdbcResult)resFut.get();
            } else {
                res = JdbcThinConnection.this.sendRequest(req).response();
            }
            return res;
        }

        boolean handleResult(long reqId, JdbcResult res) {
            boolean handled = false;
            CompletableFuture<JdbcResult> fut = this.results.remove(reqId);
            if (fut != null) {
                fut.complete(res);
                handled = true;
            }
            return handled;
        }
    }

    private class JdbcBinaryMetadataHandler
    extends BlockingJdbcChannel
    implements BinaryMetadataHandler {
        private final BinaryMetadataHandler cache = BinaryCachingMetadataHandler.create();

        private JdbcBinaryMetadataHandler() {
        }

        @Override
        public void addMeta(int typeId, BinaryType meta, boolean failIfUnregistered) throws BinaryObjectException {
            try {
                this.doRequest(new JdbcBinaryTypePutRequest(((BinaryTypeImpl)meta).metadata()));
            }
            catch (InterruptedException | SQLException | ExecutionException | ClientException e) {
                throw new BinaryObjectException(e);
            }
            this.cache.addMeta(typeId, meta, failIfUnregistered);
        }

        @Override
        public void addMetaLocally(int typeId, BinaryType meta, boolean failIfUnregistered) throws BinaryObjectException {
            throw new UnsupportedOperationException("Can't register metadata locally for thin client.");
        }

        @Override
        public BinaryType metadata(int typeId) throws BinaryObjectException {
            BinaryType meta = this.cache.metadata(typeId);
            if (meta == null) {
                meta = this.getBinaryType(typeId);
            }
            return meta;
        }

        @Override
        public BinaryMetadata metadata0(int typeId) throws BinaryObjectException {
            BinaryTypeImpl binType;
            BinaryMetadata meta = this.cache.metadata0(typeId);
            if (meta == null && (binType = (BinaryTypeImpl)this.getBinaryType(typeId)) != null) {
                meta = binType.metadata();
            }
            return meta;
        }

        @Nullable
        private BinaryType getBinaryType(int typeId) throws BinaryObjectException {
            BinaryTypeImpl binType = null;
            try {
                JdbcBinaryTypeGetResult res = (JdbcBinaryTypeGetResult)this.doRequest(new JdbcBinaryTypeGetRequest(typeId));
                BinaryMetadata meta = res.meta();
                if (meta != null) {
                    binType = new BinaryTypeImpl(JdbcThinConnection.this.ctx, meta);
                    this.cache.addMeta(typeId, binType, false);
                }
            }
            catch (InterruptedException | SQLException | ExecutionException | ClientException e) {
                throw new BinaryObjectException(e);
            }
            return binType;
        }

        public boolean handleResult(JdbcUpdateBinarySchemaResult res) {
            return this.handleResult(res.reqId(), res);
        }

        public boolean handleResult(JdbcBinaryTypeGetResult res) {
            return this.handleResult(res.reqId(), res);
        }

        @Override
        public BinaryType metadata(int typeId, int schemaId) throws BinaryObjectException {
            BinaryType type = this.metadata(typeId);
            return type != null && ((BinaryTypeImpl)type).metadata().hasSchema(schemaId) ? type : null;
        }

        @Override
        public Collection<BinaryType> metadata() throws BinaryObjectException {
            return this.cache.metadata();
        }
    }

    private class JdbcMarshallerContext
    extends BlockingJdbcChannel
    implements MarshallerContext {
        private final Map<Integer, String> cache = new ConcurrentHashMap<Integer, String>();
        private final Set<String> sysTypes = new HashSet<String>();

        public JdbcMarshallerContext() {
            try {
                MarshallerUtils.processSystemClasses(U.gridClassLoader(), null, this.sysTypes::add);
            }
            catch (IOException e) {
                throw new IgniteException("Unable to initialize marshaller context", e);
            }
        }

        @Override
        public boolean registerClassName(byte platformId, int typeId, String clsName, boolean failIfUnregistered) throws IgniteCheckedException {
            assert (platformId == 0) : String.format("Only Java platform is supported [expPlatformId=%d, actualPlatformId=%d].", (byte)0, platformId);
            boolean res = true;
            if (!this.cache.containsKey(typeId)) {
                try {
                    JdbcUpdateBinarySchemaResult updateRes = (JdbcUpdateBinarySchemaResult)this.doRequest(new JdbcBinaryTypeNamePutRequest(typeId, platformId, clsName));
                    res = updateRes.success();
                }
                catch (InterruptedException | SQLException | ExecutionException | ClientException e) {
                    throw new IgniteCheckedException(e);
                }
                if (res) {
                    this.cache.put(typeId, clsName);
                }
            }
            return res;
        }

        @Override
        @Deprecated
        public boolean registerClassName(byte platformId, int typeId, String clsName) throws IgniteCheckedException {
            return this.registerClassName(platformId, typeId, clsName, false);
        }

        @Override
        public boolean registerClassNameLocally(byte platformId, int typeId, String clsName) {
            throw new UnsupportedOperationException("registerClassNameLocally not supported by " + this.getClass().getSimpleName());
        }

        @Override
        public Class getClass(int typeId, ClassLoader ldr) throws ClassNotFoundException, IgniteCheckedException {
            return U.forName(this.getClassName((byte)0, typeId), ldr, null);
        }

        @Override
        public String getClassName(byte platformId, int typeId) throws ClassNotFoundException, IgniteCheckedException {
            assert (platformId == 0) : String.format("Only Java platform is supported [expPlatformId=%d, actualPlatformId=%d].", (byte)0, platformId);
            String clsName = this.cache.get(typeId);
            if (clsName == null) {
                try {
                    JdbcBinaryTypeNameGetResult res = (JdbcBinaryTypeNameGetResult)this.doRequest(new JdbcBinaryTypeNameGetRequest(typeId, platformId));
                    clsName = res.typeName();
                }
                catch (InterruptedException | SQLException | ExecutionException | ClientException e) {
                    throw new IgniteCheckedException(e);
                }
            }
            if (clsName == null) {
                throw new ClassNotFoundException(String.format("Unknown type id [%s]", typeId));
            }
            return clsName;
        }

        public boolean handleResult(JdbcUpdateBinarySchemaResult res) {
            return this.handleResult(res.reqId(), res);
        }

        public boolean handleResult(JdbcBinaryTypeNameGetResult res) {
            return this.handleResult(res.reqId(), res);
        }

        @Override
        public boolean isSystemType(String typeName) {
            return this.sysTypes.contains(typeName);
        }

        @Override
        public IgnitePredicate<String> classNameFilter() {
            return null;
        }

        @Override
        public JdkMarshaller jdkMarshaller() {
            return new JdkMarshaller();
        }
    }

    private class ConnectionHandlerTask
    implements Runnable {
        private Map<InetSocketAddress, Integer> reconnectionDelays = new HashMap<InetSocketAddress, Integer>();
        private Map<InetSocketAddress, Integer> reconnectionDelaysRemainder = new HashMap<InetSocketAddress, Integer>();

        private ConnectionHandlerTask() {
        }

        @Override
        public void run() {
            try {
                for (Map.Entry<InetSocketAddress, Integer> delayEntry : this.reconnectionDelaysRemainder.entrySet()) {
                    this.reconnectionDelaysRemainder.put(delayEntry.getKey(), delayEntry.getValue() - 200);
                }
                Set aliveSockAddrs = JdbcThinConnection.this.ios.values().stream().map(JdbcThinTcpIo::socketAddress).collect(Collectors.toSet());
                IgniteProductVersion prevIgniteEndpointVer = null;
                for (int i = 0; i < JdbcThinConnection.this.connProps.getAddresses().length; ++i) {
                    HostAndPortRange srv = JdbcThinConnection.this.connProps.getAddresses()[i];
                    try {
                        InetAddress[] addrs;
                        for (InetAddress addr : addrs = InetAddress.getAllByName(srv.host())) {
                            for (int port = srv.portFrom(); port <= srv.portTo(); ++port) {
                                InetSocketAddress sockAddr = null;
                                try {
                                    sockAddr = new InetSocketAddress(addr, port);
                                    if (aliveSockAddrs.contains(sockAddr)) {
                                        this.reconnectionDelaysRemainder.remove(sockAddr);
                                        this.reconnectionDelays.remove(sockAddr);
                                        continue;
                                    }
                                    Integer delayRemainder = this.reconnectionDelaysRemainder.get(sockAddr);
                                    if (delayRemainder != null && delayRemainder != 0) continue;
                                    if (JdbcThinConnection.this.closed) {
                                        JdbcThinConnection.this.maintenanceExecutor.shutdown();
                                        return;
                                    }
                                    JdbcThinTcpIo cliIo = new JdbcThinTcpIo(JdbcThinConnection.this.connProps, new InetSocketAddress(addr, port), JdbcThinConnection.this.ctx, 0);
                                    if (!cliIo.isPartitionAwarenessSupported()) {
                                        this.processDelay(sockAddr);
                                        LOG.log(Level.WARNING, "Failed to connect to Ignite node [url=" + JdbcThinConnection.this.connProps.getUrl() + "]. address = [" + addr + ':' + port + "].Node doesn't support best effort affinity mode.");
                                        cliIo.close();
                                        continue;
                                    }
                                    if (prevIgniteEndpointVer != null && !prevIgniteEndpointVer.equals(cliIo.igniteVersion())) {
                                        this.processDelay(sockAddr);
                                        LOG.log(Level.WARNING, "Failed to connect to Ignite node [url=" + JdbcThinConnection.this.connProps.getUrl() + "]. address = [" + addr + ':' + port + "].Different versions of nodes are not supported in best effort affinity mode.");
                                        cliIo.close();
                                        continue;
                                    }
                                    cliIo.timeout(JdbcThinConnection.this.netTimeout);
                                    JdbcThinTcpIo ioToSameNode = JdbcThinConnection.this.ios.putIfAbsent(cliIo.nodeId(), cliIo);
                                    if (ioToSameNode != null) {
                                        cliIo.close();
                                    } else {
                                        JdbcThinConnection.this.connCnt.incrementAndGet();
                                    }
                                    prevIgniteEndpointVer = cliIo.igniteVersion();
                                    if (!JdbcThinConnection.this.closed) continue;
                                    JdbcThinConnection.this.maintenanceExecutor.shutdown();
                                    cliIo.close();
                                    JdbcThinConnection.this.ios.remove(cliIo.nodeId());
                                    return;
                                }
                                catch (Exception exception) {
                                    if (sockAddr != null) {
                                        this.processDelay(sockAddr);
                                    }
                                    LOG.log(Level.WARNING, "Failed to connect to Ignite node [url=" + JdbcThinConnection.this.connProps.getUrl() + "]. address = [" + addr + ':' + port + "].");
                                }
                            }
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        LOG.log(Level.WARNING, "Failed to connect to Ignite node [url=" + JdbcThinConnection.this.connProps.getUrl() + "]. server = [" + srv + "].");
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Connection handler processing failure. Reconnection processes was stopped.", e);
                JdbcThinConnection.this.connectionsHndScheduledFut.cancel(false);
            }
        }

        private void processDelay(InetSocketAddress sockAddr) {
            Integer delay = this.reconnectionDelays.get(sockAddr);
            delay = delay == null ? 200 : delay * 2;
            if (delay > 300000) {
                delay = 300000;
            }
            this.reconnectionDelays.put(sockAddr, delay);
            this.reconnectionDelaysRemainder.put(sockAddr, delay);
        }
    }

    private class RequestTimeoutTask
    implements Runnable {
        private final long reqId;
        private final JdbcThinTcpIo stickyIO;
        private int remainingQryTimeout;
        private AtomicBoolean expired;

        RequestTimeoutTask(long reqId, JdbcThinTcpIo stickyIO, int initReqTimeout) {
            this.reqId = reqId;
            this.stickyIO = stickyIO;
            this.remainingQryTimeout = initReqTimeout;
            this.expired = new AtomicBoolean(false);
        }

        @Override
        public void run() {
            try {
                if (this.remainingQryTimeout <= 0) {
                    this.expired.set(true);
                    JdbcThinConnection.this.sendQueryCancelRequest(new JdbcQueryCancelRequest(this.reqId), this.stickyIO);
                    JdbcThinConnection.this.qryTimeoutScheduledFut.cancel(false);
                    return;
                }
                this.remainingQryTimeout -= 1000;
            }
            catch (SQLException e) {
                LOG.log(Level.WARNING, "Request timeout processing failure: unable to cancel request [reqId=" + this.reqId + ']', e);
                JdbcThinConnection.this.qryTimeoutScheduledFut.cancel(false);
            }
        }
    }

    private class StreamState {
        private static final int MAX_REQUESTS_BEFORE_RESPONSE = 10;
        private int streamBatchSize;
        private List<JdbcQuery> streamBatch;
        private String lastStreamQry;
        private long order;
        private Thread asyncRespReaderThread;
        private volatile Exception err;
        private long lastRespOrder = -1L;
        private final GridFutureAdapter<Void> lastRespFut = new GridFutureAdapter();
        private Semaphore respSem = new Semaphore(10);
        private final JdbcThinTcpIo streamingStickyIo;

        StreamState(SqlSetStreamingCommand cmd, JdbcThinTcpIo stickyIo) {
            this.streamBatchSize = cmd.batchSize();
            this.asyncRespReaderThread = new Thread(this::readResponses);
            this.streamingStickyIo = stickyIo;
        }

        void start() {
            this.asyncRespReaderThread.start();
        }

        void addBatch(String sql, List<Object> args) throws SQLException {
            this.checkError();
            boolean newQry = args == null || !F.eq(this.lastStreamQry, sql);
            JdbcQuery q = new JdbcQuery(newQry ? sql : null, args != null ? args.toArray() : null);
            if (this.streamBatch == null) {
                this.streamBatch = new ArrayList<JdbcQuery>(this.streamBatchSize);
            }
            this.streamBatch.add(q);
            String string = this.lastStreamQry = args != null ? sql : null;
            if (this.streamBatch.size() == this.streamBatchSize) {
                this.executeBatch(false);
            }
        }

        private void executeBatch(boolean lastBatch) throws SQLException {
            block6: {
                this.checkError();
                if (lastBatch) {
                    this.lastRespOrder = this.order;
                }
                try {
                    this.respSem.acquire();
                    JdbcThinConnection.this.sendRequestNotWaitResponse(new JdbcOrderedBatchExecuteRequest(JdbcThinConnection.this.schema, this.streamBatch, JdbcThinConnection.this.autoCommit, lastBatch, this.order), this.streamingStickyIo);
                    this.streamBatch = null;
                    this.lastStreamQry = null;
                    if (lastBatch) {
                        try {
                            this.lastRespFut.get();
                        }
                        catch (IgniteCheckedException igniteCheckedException) {
                            // empty catch block
                        }
                        this.checkError();
                        break block6;
                    }
                    ++this.order;
                }
                catch (InterruptedException e) {
                    throw new SQLException("Streaming operation was interrupted", "50000", e);
                }
            }
        }

        void checkError() throws SQLException {
            if (this.err != null) {
                Exception err0 = this.err;
                this.err = null;
                if (err0 instanceof SQLException) {
                    throw (SQLException)err0;
                }
                JdbcThinConnection.this.onDisconnect(this.streamingStickyIo);
                if (err0 instanceof SocketTimeoutException) {
                    throw new SQLException("Connection timed out.", "08006", err0);
                }
                throw new SQLException("Failed to communicate with Ignite cluster on JDBC streaming.", "08006", err0);
            }
        }

        void close() throws SQLException {
            this.close0();
            this.checkError();
        }

        void close0() {
            if (JdbcThinConnection.this.connCnt.get() > 0) {
                try {
                    this.executeBatch(true);
                }
                catch (SQLException e) {
                    this.err = e;
                    LOG.log(Level.WARNING, "Exception during batch send on streamed connection close", e);
                }
            }
            if (this.asyncRespReaderThread != null) {
                this.asyncRespReaderThread.interrupt();
            }
        }

        void readResponses() {
            try {
                block9: {
                    JdbcResponse resp;
                    while (true) {
                        if ((resp = this.streamingStickyIo.readResponse()).response() instanceof JdbcOrderedBatchExecuteResult) {
                            JdbcOrderedBatchExecuteResult res = (JdbcOrderedBatchExecuteResult)resp.response();
                            this.respSem.release();
                            if (res.errorCode() != 0) {
                                this.err = new BatchUpdateException(res.errorMessage(), IgniteQueryErrorCode.codeToSqlState(res.errorCode()), res.errorCode(), res.updateCounts());
                            }
                            if (res.order() != this.lastRespOrder) continue;
                            break block9;
                        }
                        if (resp.response() instanceof JdbcBinaryTypeGetResult) {
                            JdbcThinConnection.this.metaHnd.handleResult((JdbcBinaryTypeGetResult)resp.response());
                            continue;
                        }
                        if (resp.response() instanceof JdbcBinaryTypeNameGetResult) {
                            JdbcThinConnection.this.marshCtx.handleResult((JdbcBinaryTypeNameGetResult)resp.response());
                            continue;
                        }
                        if (resp.response() instanceof JdbcUpdateBinarySchemaResult) {
                            JdbcUpdateBinarySchemaResult binarySchemaRes = (JdbcUpdateBinarySchemaResult)resp.response();
                            if (JdbcThinConnection.this.marshCtx.handleResult(binarySchemaRes) || JdbcThinConnection.this.metaHnd.handleResult(binarySchemaRes)) continue;
                            LOG.log(Level.WARNING, "Neither marshaller context nor metadata handler wait for update binary schema result (req=" + binarySchemaRes + ")");
                            continue;
                        }
                        if (resp.status() != 0) {
                            this.err = new SQLException(resp.error(), IgniteQueryErrorCode.codeToSqlState(resp.status()));
                            continue;
                        }
                        if (!$assertionsDisabled) break;
                    }
                    throw new AssertionError((Object)("Invalid response: " + resp));
                }
                this.lastRespFut.onDone();
            }
            catch (Exception e) {
                this.err = e;
            }
        }
    }
}

