/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin.io.gridnioserver;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.client.thin.io.ClientConnection;
import org.apache.ignite.internal.client.thin.io.ClientConnectionStateHandler;
import org.apache.ignite.internal.client.thin.io.ClientMessageHandler;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.jetbrains.annotations.Nullable;

class GridNioClientConnection
implements ClientConnection {
    static final int SES_META_CONN = GridNioSessionMetaKey.nextUniqueKey();
    private final GridNioSession ses;
    private final ClientMessageHandler msgHnd;
    private final ClientConnectionStateHandler stateHnd;

    public GridNioClientConnection(GridNioSession ses, ClientMessageHandler msgHnd, ClientConnectionStateHandler stateHnd) {
        assert (ses != null);
        assert (msgHnd != null);
        assert (stateHnd != null);
        this.ses = ses;
        this.msgHnd = msgHnd;
        this.stateHnd = stateHnd;
        ses.addMeta(SES_META_CONN, this);
    }

    @Override
    @Nullable
    public InetSocketAddress localAddress() {
        return this.ses.localAddress();
    }

    @Override
    @Nullable
    public InetSocketAddress remoteAddress() {
        return this.ses.remoteAddress();
    }

    @Override
    public void send(ByteBuffer msg, @Nullable Runnable onDone) throws IgniteCheckedException {
        if (onDone != null) {
            this.ses.send(msg).listen(f -> onDone.run());
        } else {
            this.ses.sendNoFuture(msg, null);
        }
    }

    @Override
    public void close() {
        this.ses.close();
    }

    void onMessage(ByteBuffer msg) {
        assert (msg != null);
        this.msgHnd.onMessage(msg);
    }

    void onDisconnected(Exception e) {
        this.stateHnd.onDisconnected(e);
    }
}

