/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.client.ClientPartitionAwarenessMapper;
import org.apache.ignite.client.ClientPartitionAwarenessMapperFactory;
import org.apache.ignite.internal.client.thin.ClientCacheAffinityMapping;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class ClientCacheAffinityContext {
    private static final long REMOVED_TS = 0L;
    final Map<Integer, ClientPartitionAwarenessMapperHolder> cacheKeyMapperFactoryMap = new HashMap<Integer, ClientPartitionAwarenessMapperHolder>();
    private final IgniteBinary binary;
    private final ClientPartitionAwarenessMapperFactory paMapFactory;
    private final AtomicReference<TopologyNodes> lastTop = new AtomicReference();
    private final Set<Integer> pendingCacheIds = new GridConcurrentHashSet<Integer>();
    private volatile ClientCacheAffinityMapping affinityMapping;
    private volatile CacheMappingRequest rq;

    public ClientCacheAffinityContext(IgniteBinary binary, @Nullable ClientPartitionAwarenessMapperFactory factory) {
        this.paMapFactory = factory;
        this.binary = binary;
    }

    public boolean updateLastTopologyVersion(AffinityTopologyVersion topVer, UUID nodeId) {
        TopologyNodes lastTop;
        while ((lastTop = this.lastTop.get()) == null || topVer.compareTo(lastTop.topVer) > 0) {
            if (!this.lastTop.compareAndSet(lastTop, new TopologyNodes(topVer, nodeId))) continue;
            return true;
        }
        if (topVer.equals(lastTop.topVer)) {
            lastTop.nodes.add(nodeId);
            return false;
        }
        return false;
    }

    public boolean affinityUpdateRequired(int cacheId) {
        ClientCacheAffinityMapping mapping = this.currentMapping();
        if (mapping == null || !mapping.cacheIds().contains(cacheId)) {
            this.pendingCacheIds.add(cacheId);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePartitionsUpdateRequest(PayloadOutputChannel ch) {
        long lastAccessed;
        HashSet<Integer> cacheIds;
        Map<Integer, ClientPartitionAwarenessMapperHolder> map = this.cacheKeyMapperFactoryMap;
        synchronized (map) {
            cacheIds = new HashSet<Integer>(this.pendingCacheIds);
            lastAccessed = cacheIds.stream().map(this.cacheKeyMapperFactoryMap::get).filter(Objects::nonNull).mapToLong(h2 -> ((ClientPartitionAwarenessMapperHolder)h2).ts).reduce(Math::max).orElse(0L);
        }
        this.rq = new CacheMappingRequest(cacheIds, lastAccessed);
        ClientCacheAffinityMapping.writeRequest(ch, this.rq.caches, this.rq.ts > 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean readPartitionsUpdateResponse(PayloadInputChannel ch) {
        if (this.lastTop.get() == null) {
            return false;
        }
        CacheMappingRequest rq0 = this.rq;
        ClientCacheAffinityMapping newMapping = ClientCacheAffinityMapping.readResponse(ch, new Function<Integer, Function<Integer, ClientPartitionAwarenessMapper>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Function<Integer, ClientPartitionAwarenessMapper> apply(Integer cacheId) {
                Map<Integer, ClientPartitionAwarenessMapperHolder> map = ClientCacheAffinityContext.this.cacheKeyMapperFactoryMap;
                synchronized (map) {
                    ClientPartitionAwarenessMapperHolder hld = ClientCacheAffinityContext.this.cacheKeyMapperFactoryMap.get(cacheId);
                    if (ClientCacheAffinityContext.this.paMapFactory == null || hld == null || hld.ts == 0L) {
                        return null;
                    }
                    if (hld.factory == null) {
                        hld.factory = parts -> ClientCacheAffinityContext.this.paMapFactory.create(hld.cacheName, (int)parts);
                    }
                    return hld.factory;
                }
            }
        });
        Map<Integer, ClientPartitionAwarenessMapperHolder> map = this.cacheKeyMapperFactoryMap;
        synchronized (map) {
            this.cacheKeyMapperFactoryMap.entrySet().removeIf(e -> {
                if (!rq0.caches.contains(e.getKey())) {
                    return false;
                }
                if (newMapping.cacheIds().contains(e.getKey())) {
                    return ((ClientPartitionAwarenessMapperHolder)e.getValue()).factory == null;
                }
                return ((ClientPartitionAwarenessMapperHolder)e.getValue()).ts <= rq0.ts;
            });
        }
        this.rq = null;
        ClientCacheAffinityMapping oldMapping = this.affinityMapping;
        if (oldMapping == null || newMapping.topologyVersion().compareTo(oldMapping.topologyVersion()) > 0) {
            this.affinityMapping = newMapping;
            if (oldMapping != null) {
                this.pendingCacheIds.addAll(oldMapping.cacheIds());
            }
        } else if (newMapping.topologyVersion().equals(oldMapping.topologyVersion())) {
            this.affinityMapping = ClientCacheAffinityMapping.merge(oldMapping, newMapping);
        }
        this.pendingCacheIds.removeAll(newMapping.cacheIds());
        this.pendingCacheIds.removeAll(rq0.caches);
        return true;
    }

    public TopologyNodes lastTopology() {
        return this.lastTop.get();
    }

    public synchronized void reset(TopologyNodes top) {
        if (this.lastTop.compareAndSet(top, null)) {
            this.affinityMapping = null;
            this.pendingCacheIds.clear();
        }
    }

    public UUID affinityNode(int cacheId, Object key) {
        ClientCacheAffinityMapping mapping = this.currentMapping();
        return mapping == null ? null : mapping.affinityNode(this.binary, cacheId, key);
    }

    public UUID affinityNode(int cacheId, int part) {
        ClientCacheAffinityMapping mapping = this.currentMapping();
        return mapping == null ? null : mapping.affinityNode(cacheId, part);
    }

    protected ClientCacheAffinityMapping currentMapping() {
        TopologyNodes top = this.lastTop.get();
        if (top == null) {
            return null;
        }
        ClientCacheAffinityMapping mapping = this.affinityMapping;
        if (mapping == null) {
            return null;
        }
        if (top.topVer.compareTo(mapping.topologyVersion()) > 0) {
            return null;
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCache(String cacheName) {
        Map<Integer, ClientPartitionAwarenessMapperHolder> map = this.cacheKeyMapperFactoryMap;
        synchronized (map) {
            ClientPartitionAwarenessMapperHolder hld = this.cacheKeyMapperFactoryMap.computeIfAbsent(ClientUtils.cacheId(cacheName), id -> new ClientPartitionAwarenessMapperHolder(cacheName));
            hld.ts = U.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCache(String cacheName) {
        Map<Integer, ClientPartitionAwarenessMapperHolder> map = this.cacheKeyMapperFactoryMap;
        synchronized (map) {
            ClientPartitionAwarenessMapperHolder hld = this.cacheKeyMapperFactoryMap.get(ClientUtils.cacheId(cacheName));
            if (hld == null) {
                return;
            }
            hld.ts = 0L;
        }
    }

    private static class CacheMappingRequest {
        private final Set<Integer> caches;
        private final long ts;

        public CacheMappingRequest(Set<Integer> caches, long ts) {
            this.caches = caches;
            this.ts = ts;
        }

        public String toString() {
            return "CacheMappingRequest{caches=" + this.caches + ", ts=" + this.ts + '}';
        }
    }

    private static class ClientPartitionAwarenessMapperHolder {
        private final String cacheName;
        @Nullable
        private Function<Integer, ClientPartitionAwarenessMapper> factory;
        private long ts;

        public ClientPartitionAwarenessMapperHolder(String cacheName) {
            this.cacheName = cacheName;
        }
    }

    static class TopologyNodes {
        private final AffinityTopologyVersion topVer;
        private final Collection<UUID> nodes = new ConcurrentLinkedQueue<UUID>();

        private TopologyNodes(AffinityTopologyVersion topVer, UUID nodeId) {
            this.topVer = topVer;
            this.nodes.add(nodeId);
        }

        public Iterable<UUID> nodes() {
            return Collections.unmodifiableCollection(this.nodes);
        }
    }
}

