/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.internal.cache.query.RangeIndexQueryCriterion;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.IndexDefinition;
import org.apache.ignite.internal.cache.query.index.IndexKeyQueryCondition;
import org.apache.ignite.internal.cache.query.index.IndexMultipleRangeQuery;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.cache.query.index.IndexQueryResult;
import org.apache.ignite.internal.cache.query.index.IndexQueryResultMeta;
import org.apache.ignite.internal.cache.query.index.IndexSingleRangeQuery;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.SortedSegmentedIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.query.IndexQueryDesc;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.jetbrains.annotations.Nullable;

public class IndexQueryProcessor {
    private final IndexProcessor idxProc;

    public IndexQueryProcessor(IndexProcessor idxProc) {
        this.idxProc = idxProc;
    }

    public <K, V> IndexQueryResult<K, V> queryLocal(final GridCacheContext<K, V> cctx, IndexQueryDesc idxQryDesc, final @Nullable IgniteBiPredicate<K, V> filter, IndexingQueryFilter cacheFilter, final boolean keepBinary) throws IgniteCheckedException {
        InlineIndexImpl idx = (InlineIndexImpl)this.findSortedIndex(cctx, idxQryDesc);
        IndexMultipleRangeQuery qry = this.prepareQuery(idx, idxQryDesc);
        final GridCursor<IndexRow> cursor = this.queryMultipleRanges(idx, cacheFilter, qry);
        SortedIndexDefinition def = (SortedIndexDefinition)this.idxProc.indexDefinition(idx.id());
        IndexQueryResultMeta meta = new IndexQueryResultMeta(def, qry.critSize());
        return new IndexQueryResult(meta, new GridCloseableIteratorAdapter<IgniteBiTuple<K, V>>(){
            private IgniteBiTuple<K, V> currVal;
            private final CacheObjectContext coctx;
            {
                this.coctx = cctx.cacheObjectContext();
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.currVal != null) {
                    return true;
                }
                while (this.currVal == null && cursor.next()) {
                    IndexRow r = (IndexRow)cursor.get();
                    Object k = this.unwrap(r.cacheDataRow().key(), true);
                    Object v = this.unwrap(r.cacheDataRow().value(), true);
                    if (filter != null) {
                        Object v0;
                        Object k0 = keepBinary ? k : this.unwrap(r.cacheDataRow().key(), false);
                        Object t2 = v0 = keepBinary ? v : this.unwrap(r.cacheDataRow().value(), false);
                        if (!filter.apply(k0, v0)) continue;
                    }
                    this.currVal = new IgniteBiTuple(k, v);
                }
                return this.currVal != null;
            }

            @Override
            protected IgniteBiTuple<K, V> onNext() {
                if (this.currVal == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IgniteBiTuple row = this.currVal;
                this.currVal = null;
                return row;
            }

            private <T> T unwrap(CacheObject o, boolean keepBinary2) {
                return (T)CacheObjectUtils.unwrapBinaryIfNeeded(this.coctx, o, keepBinary2, false);
            }
        });
    }

    private SortedSegmentedIndex findSortedIndex(GridCacheContext<?, ?> cctx, IndexQueryDesc idxQryDesc) throws IgniteCheckedException {
        String tableName = cctx.kernalContext().query().tableName(cctx.name(), idxQryDesc.valType());
        if (tableName == null) {
            throw new IgniteCheckedException("No table found for type: " + idxQryDesc.valType());
        }
        Map<String, String> critFlds = !F.isEmpty(idxQryDesc.criteria()) ? idxQryDesc.criteria().stream().map(IndexQueryCriterion::field).flatMap(f -> {
            String norm = QueryUtils.normalizeObjectName(f, false);
            if (f.equals(norm)) {
                return Stream.of(new T2<String, String>((String)f, (String)f));
            }
            return Stream.of(new T2<String, String>((String)f, norm), new T2<String, String>(norm, (String)f));
        }).collect(Collectors.toMap(IgniteBiTuple::get1, IgniteBiTuple::get2, (l, r) -> l)) : Collections.emptyMap();
        if (idxQryDesc.idxName() == null && !critFlds.isEmpty()) {
            return this.indexByCriteria(cctx, critFlds, tableName);
        }
        String name = idxQryDesc.idxName() == null ? "_key_PK" : idxQryDesc.idxName();
        IndexName idxName = new IndexName(cctx.name(), cctx.kernalContext().query().schemaName(cctx), tableName, name);
        return this.indexByName(idxName, critFlds);
    }

    private SortedSegmentedIndex indexByName(IndexName idxName, Map<String, String> criteriaFlds) throws IgniteCheckedException {
        SortedSegmentedIndex idx = this.assertSortedIndex(this.idxProc.index(idxName));
        if (idx == null && !"_key_PK".equals(idxName.idxName())) {
            String normIdxName = QueryUtils.normalizeObjectName(idxName.idxName(), false);
            idxName = new IndexName(idxName.cacheName(), idxName.schemaName(), idxName.tableName(), normIdxName);
            idx = this.assertSortedIndex(this.idxProc.index(idxName));
        }
        if (idx == null) {
            throw new IgniteCheckedException("No index found for name: " + idxName.idxName());
        }
        if (!this.checkIndex(idx, idxName.tableName(), criteriaFlds)) {
            throw new IgniteCheckedException("Index doesn't match criteria. Index " + idxName.idxName());
        }
        return idx;
    }

    private SortedSegmentedIndex indexByCriteria(GridCacheContext<?, ?> cctx, Map<String, String> criteriaFlds, String tableName) throws IgniteCheckedException {
        Collection<Index> idxs = this.idxProc.indexes(cctx.name());
        for (Index idx : idxs) {
            SortedSegmentedIndex sortedIdx = this.assertSortedIndex(idx);
            if (!this.checkIndex(sortedIdx, tableName, criteriaFlds)) continue;
            return sortedIdx;
        }
        throw new IgniteCheckedException("No index found for criteria.");
    }

    private SortedSegmentedIndex assertSortedIndex(Index idx) throws IgniteCheckedException {
        if (idx == null) {
            return null;
        }
        if (!(idx instanceof SortedSegmentedIndex)) {
            throw new IgniteCheckedException("IndexQuery is not supported for index: " + idx.name());
        }
        return (SortedSegmentedIndex)idx;
    }

    private boolean checkIndex(SortedSegmentedIndex idx, String tblName, Map<String, String> criteriaFlds) {
        IndexDefinition idxDef = this.idxProc.indexDefinition(idx.id());
        if (!tblName.equals(idxDef.idxName().tableName())) {
            return false;
        }
        if (F.isEmpty(criteriaFlds)) {
            return true;
        }
        HashMap<String, String> flds = new HashMap<String, String>(criteriaFlds);
        for (String idxFldName : idxDef.indexKeyDefinitions().keySet()) {
            String alias = (String)flds.remove(idxFldName);
            if (alias == null) {
                return false;
            }
            flds.remove(alias);
            if (!flds.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private IndexMultipleRangeQuery mergeIndexQueryCriteria(InlineIndexImpl idx, IndexQueryDesc idxQryDesc) throws IgniteCheckedException {
        IndexKeyQueryCondition keyCond;
        Object keyDef;
        HashMap<String, IndexKeyQueryCondition> mergedCriteria = new HashMap<String, IndexKeyQueryCondition>();
        SortedIndexDefinition idxDef = idx.indexDefinition();
        LinkedHashMap<String, IndexKeyDefinition> idxFlds = idxDef.indexKeyDefinitions();
        for (IndexQueryCriterion crit : idxQryDesc.criteria()) {
            String fldName = idxFlds.containsKey(crit.field()) ? crit.field() : QueryUtils.normalizeObjectName(crit.field(), false);
            keyDef = (IndexKeyDefinition)idxFlds.get(fldName);
            if (keyDef == null) {
                throw new IgniteCheckedException("Index doesn't match criteria. Index " + idxDef + ", criterion field=" + fldName);
            }
            mergedCriteria.putIfAbsent(fldName, new IndexKeyQueryCondition(fldName, idx));
            IndexKeyQueryCondition idxKeyCond = (IndexKeyQueryCondition)mergedCriteria.get(fldName);
            idxKeyCond.accumulate(crit);
        }
        int i = 0;
        IndexMultipleRangeQuery multipleQry = new IndexMultipleRangeQuery(idxFlds.size(), mergedCriteria.size());
        Iterator iterator = idxFlds.entrySet().iterator();
        while (iterator.hasNext() && (keyCond = (IndexKeyQueryCondition)mergedCriteria.remove((keyDef = iterator.next()).getKey())) != null) {
            multipleQry.addIndexKeyCondition(i++, keyCond);
        }
        return multipleQry;
    }

    private IndexMultipleRangeQuery prepareQuery(InlineIndexImpl idx, IndexQueryDesc idxQryDesc) throws IgniteCheckedException {
        if (F.isEmpty(idxQryDesc.criteria())) {
            IndexMultipleRangeQuery multQry = new IndexMultipleRangeQuery(idx.indexDefinition().indexKeyDefinitions().size(), 1);
            multQry.addIndexKeyCondition(0, new IndexKeyQueryCondition("_KEY", idx));
            return multQry;
        }
        return this.mergeIndexQueryCriteria(idx, idxQryDesc);
    }

    private GridCursor<IndexRow> queryMultipleRanges(final InlineIndexImpl idx, final IndexingQueryFilter cacheFilter, IndexMultipleRangeQuery qry) throws IgniteCheckedException {
        final List<IndexSingleRangeQuery> queries = qry.queries();
        if (queries.size() == 1) {
            return this.querySortedIndex(idx, cacheFilter, queries.get(0));
        }
        return new GridCursor<IndexRow>(){
            private GridCursor<IndexRow> currCursor;
            private int qryNum;

            @Override
            public boolean next() throws IgniteCheckedException {
                while (this.currCursor == null || !this.currCursor.next()) {
                    if (this.qryNum == queries.size()) {
                        return false;
                    }
                    IndexSingleRangeQuery q = (IndexSingleRangeQuery)queries.get(this.qryNum++);
                    this.currCursor = IndexQueryProcessor.this.querySortedIndex(idx, cacheFilter, q);
                }
                return true;
            }

            @Override
            public IndexRow get() throws IgniteCheckedException {
                return this.currCursor.get();
            }
        };
    }

    private GridCursor<IndexRow> querySortedIndex(SortedSegmentedIndex idx, IndexingQueryFilter cacheFilter, IndexSingleRangeQuery qry) throws IgniteCheckedException {
        IndexRowComparator rowCmp = ((SortedIndexDefinition)this.idxProc.indexDefinition(idx.id())).rowComparator();
        BPlusTree.TreeRowClosure<IndexRow, IndexRow> treeFilter = qry.filter(rowCmp);
        IndexQueryContext qryCtx = new IndexQueryContext(cacheFilter, treeFilter, null);
        return this.treeIndexRange(idx, qry, qryCtx);
    }

    private GridCursor<IndexRow> treeIndexRange(SortedSegmentedIndex idx, IndexSingleRangeQuery qry, IndexQueryContext qryCtx) throws IgniteCheckedException {
        boolean lowIncl = qry.inclBoundary(true);
        boolean upIncl = qry.inclBoundary(false);
        return idx.find(qry.lower(), qry.upper(), lowIncl, upIncl, qryCtx);
    }

    public static String rangeDesc(RangeIndexQueryCriterion c, String fldName, Object lower, Object upper) {
        String fld = fldName == null ? c.field() : fldName;
        Object l = lower == null ? c.lower() : lower;
        Object u = upper == null ? c.upper() : upper;
        RangeIndexQueryCriterion r = new RangeIndexQueryCriterion(fld, l, u);
        r.lowerIncl(c.lowerIncl());
        r.upperIncl(c.upperIncl());
        return r.toString();
    }
}

