/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.SqlDecimal;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingNames;
import java.math.BigDecimal;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveWriteUtils {
    private static final HdfsContext CONTEXT = new HdfsContext(TestingConnectorSession.SESSION);
    private static final String RANDOM_SUFFIX = TestingNames.randomNameSuffix();

    @Test
    public void testIsS3FileSystem() {
        Assert.assertTrue((boolean)HiveWriteUtils.isS3FileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)HiveTestUtils.HDFS_ENVIRONMENT, (Path)new Path("s3://test-bucket-%s/test-folder".formatted(RANDOM_SUFFIX))));
        Assert.assertFalse((boolean)HiveWriteUtils.isS3FileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)HiveTestUtils.HDFS_ENVIRONMENT, (Path)new Path("/test-dir-%s/test-folder".formatted(RANDOM_SUFFIX))));
    }

    @Test
    public void testIsViewFileSystem() {
        Path viewfsPath = new Path("viewfs://ns-default-%s/test-folder".formatted(RANDOM_SUFFIX));
        Path nonViewfsPath = new Path("hdfs://localhost/test-dir/test-folder");
        HiveTestUtils.HDFS_ENVIRONMENT.getConfiguration(CONTEXT, viewfsPath).set("fs.viewfs.mounttable.ns-default-%s.link./test-folder".formatted(RANDOM_SUFFIX), "hdfs://localhost/app");
        Assert.assertTrue((boolean)HiveWriteUtils.isViewFileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)HiveTestUtils.HDFS_ENVIRONMENT, (Path)viewfsPath));
        Assert.assertFalse((boolean)HiveWriteUtils.isViewFileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)HiveTestUtils.HDFS_ENVIRONMENT, (Path)nonViewfsPath));
    }

    @Test
    public void testCreatePartitionValuesDecimal() {
        TestHiveWriteUtils.assertCreatePartitionValuesDecimal(10, 0, "12345", "12345");
        TestHiveWriteUtils.assertCreatePartitionValuesDecimal(10, 2, "123.45", "123.45");
        TestHiveWriteUtils.assertCreatePartitionValuesDecimal(10, 2, "12345.00", "12345");
        TestHiveWriteUtils.assertCreatePartitionValuesDecimal(5, 0, "12345", "12345");
        TestHiveWriteUtils.assertCreatePartitionValuesDecimal(38, 2, "12345.00", "12345");
        TestHiveWriteUtils.assertCreatePartitionValuesDecimal(38, 20, "12345.00000000000000000000", "12345");
        TestHiveWriteUtils.assertCreatePartitionValuesDecimal(38, 20, "12345.67898000000000000000", "12345.67898");
    }

    private static void assertCreatePartitionValuesDecimal(int precision, int scale, String decimalValue, String expectedValue) {
        DecimalType decimalType = DecimalType.createDecimalType((int)precision, (int)scale);
        List<DecimalType> types = List.of(decimalType);
        SqlDecimal decimal = SqlDecimal.decimal((String)decimalValue, (DecimalType)decimalType);
        Assertions.assertThat((String)decimal.toString()).isEqualTo(decimalValue);
        Assertions.assertThat((String)decimal.toBigDecimal().toString()).isEqualTo(decimalValue);
        PageBuilder pageBuilder = new PageBuilder(types);
        pageBuilder.declarePosition();
        TestHiveWriteUtils.writeDecimal(decimalType, decimal, pageBuilder.getBlockBuilder(0));
        Page page = pageBuilder.build();
        Assertions.assertThat((String)HiveDecimal.create((BigDecimal)decimal.toBigDecimal()).toString()).isEqualTo(expectedValue);
        Assertions.assertThat((List)HiveWriteUtils.createPartitionValues(types, (Page)page, (int)0)).isEqualTo(List.of(expectedValue));
    }

    private static void writeDecimal(DecimalType decimalType, SqlDecimal decimal, BlockBuilder blockBuilder) {
        if (decimalType.isShort()) {
            Decimals.writeShortDecimal((BlockBuilder)blockBuilder, (long)decimal.toBigDecimal().unscaledValue().longValue());
        } else {
            Decimals.writeBigDecimal((DecimalType)decimalType, (BlockBuilder)blockBuilder, (BigDecimal)decimal.toBigDecimal());
        }
    }
}

