/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.plugin.hive.util.HiveUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveUtil {
    @Test
    public void testParseHiveTimestamp() {
        DateTime time = new DateTime(2011, 5, 6, 7, 8, 9, 123, DateTimeZone.UTC);
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss"), (long)TestHiveUtil.unixTime(time, 0));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.S"), (long)TestHiveUtil.unixTime(time, 1));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSS"), (long)TestHiveUtil.unixTime(time, 3));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSSSSSS"), (long)TestHiveUtil.unixTime(time, 6));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSSSSSSSS"), (long)TestHiveUtil.unixTime(time, 7));
    }

    @Test
    public void testToPartitionValues() throws MetaException {
        TestHiveUtil.assertToPartitionValues("ds=2015-12-30/event_type=QueryCompletion");
        TestHiveUtil.assertToPartitionValues("ds=2015-12-30");
        TestHiveUtil.assertToPartitionValues("a=1/b=2/c=3");
        TestHiveUtil.assertToPartitionValues("a=1");
        TestHiveUtil.assertToPartitionValues("pk=!@%23$%25%5E&%2A()%2F%3D");
        TestHiveUtil.assertToPartitionValues("pk=__HIVE_DEFAULT_PARTITION__");
    }

    @Test
    public void testUnescapePathName() {
        TestHiveUtil.assertUnescapePathName("", "");
        TestHiveUtil.assertUnescapePathName("x", "x");
        TestHiveUtil.assertUnescapePathName("abc", "abc");
        TestHiveUtil.assertUnescapePathName("abc%", "abc%");
        TestHiveUtil.assertUnescapePathName("%", "%");
        TestHiveUtil.assertUnescapePathName("%41", "A");
        TestHiveUtil.assertUnescapePathName("%41%x", "A%x");
        TestHiveUtil.assertUnescapePathName("%41%xxZ", "A%xxZ");
        TestHiveUtil.assertUnescapePathName("%41%%Z", "A%%Z");
        TestHiveUtil.assertUnescapePathName("%41%25%25Z", "A%%Z");
        TestHiveUtil.assertUnescapePathName("abc%41%42%43", "abcABC");
        TestHiveUtil.assertUnescapePathName("abc%3Axyz", "abc:xyz");
        TestHiveUtil.assertUnescapePathName("abc%3axyz", "abc:xyz");
        TestHiveUtil.assertUnescapePathName("abc%BBxyz", "abc\u00bbxyz");
    }

    private static void assertUnescapePathName(String value, String expected) {
        Assertions.assertThat((String)FileUtils.unescapePathName((String)value)).isEqualTo(expected);
        Assertions.assertThat((String)HiveUtil.unescapePathName((String)value)).isEqualTo(expected);
    }

    @Test
    public void testEscapeDatabaseName() {
        Assertions.assertThat((String)HiveUtil.escapeSchemaName((String)"schema1")).isEqualTo("schema1");
        Assertions.assertThatThrownBy(() -> HiveUtil.escapeSchemaName(null)).hasMessage("The provided schemaName cannot be null or empty");
        Assertions.assertThatThrownBy(() -> HiveUtil.escapeSchemaName((String)"")).hasMessage("The provided schemaName cannot be null or empty");
        Assertions.assertThat((String)HiveUtil.escapeSchemaName((String)"../schema1")).isEqualTo("..%2Fschema1");
        Assertions.assertThat((String)HiveUtil.escapeSchemaName((String)"../../schema1")).isEqualTo("..%2F..%2Fschema1");
    }

    @Test
    public void testEscapeTableName() {
        Assertions.assertThat((String)HiveUtil.escapeTableName((String)"table1")).isEqualTo("table1");
        Assertions.assertThatThrownBy(() -> HiveUtil.escapeTableName(null)).hasMessage("The provided tableName cannot be null or empty");
        Assertions.assertThatThrownBy(() -> HiveUtil.escapeTableName((String)"")).hasMessage("The provided tableName cannot be null or empty");
        Assertions.assertThat((String)HiveUtil.escapeTableName((String)"../table1")).isEqualTo("..%2Ftable1");
        Assertions.assertThat((String)HiveUtil.escapeTableName((String)"../../table1")).isEqualTo("..%2F..%2Ftable1");
    }

    @Test
    public void testEscapePathName() {
        TestHiveUtil.assertEscapePathName(null, "__HIVE_DEFAULT_PARTITION__");
        TestHiveUtil.assertEscapePathName("", "__HIVE_DEFAULT_PARTITION__");
        TestHiveUtil.assertEscapePathName("x", "x");
        TestHiveUtil.assertEscapePathName("abc", "abc");
        TestHiveUtil.assertEscapePathName("%", "%25");
        TestHiveUtil.assertEscapePathName("A", "A");
        TestHiveUtil.assertEscapePathName("A%x", "A%25x");
        TestHiveUtil.assertEscapePathName("A%xxZ", "A%25xxZ");
        TestHiveUtil.assertEscapePathName("A%%Z", "A%25%25Z");
        TestHiveUtil.assertEscapePathName("abcABC", "abcABC");
        TestHiveUtil.assertEscapePathName("abc:xyz", "abc%3Axyz");
        TestHiveUtil.assertEscapePathName("abc\u00bbxyz", "abc\u00bbxyz");
        TestHiveUtil.assertEscapePathName("\u0000\t\b\r\n\u001f", "%00%09%08%0D%0A%1F");
        TestHiveUtil.assertEscapePathName("#%^&*=[]{\\:'\"/?", "%23%25%5E&%2A%3D%5B%5D%7B%5C%3A%27%22%2F%3F");
        TestHiveUtil.assertEscapePathName("~`!@$()-_+}|;,.<>", "~`!@$()-_+}|;,.<>");
    }

    private static void assertEscapePathName(String value, String expected) {
        Assertions.assertThat((String)FileUtils.escapePathName((String)value)).isEqualTo(expected);
        Assertions.assertThat((String)HiveUtil.escapePathName((String)value)).isEqualTo(expected);
    }

    @Test
    public void testMakePartName() {
        TestHiveUtil.assertMakePartName(List.of("abc"), List.of("xyz"), "abc=xyz");
        TestHiveUtil.assertMakePartName(List.of("abc:qqq"), List.of("xyz/yyy=zzz"), "abc%3Aqqq=xyz%2Fyyy%3Dzzz");
        TestHiveUtil.assertMakePartName(List.of("abc", "def", "xyz"), List.of("qqq", "rrr", "sss"), "abc=qqq/def=rrr/xyz=sss");
    }

    private static void assertMakePartName(List<String> columns, List<String> values, String expected) {
        Assertions.assertThat((String)FileUtils.makePartName(columns, values)).isEqualTo(expected);
        Assertions.assertThat((String)HiveUtil.makePartName(columns, values)).isEqualTo(expected);
    }

    private static void assertToPartitionValues(String partitionName) throws MetaException {
        List actual = HiveUtil.toPartitionValues((String)partitionName);
        ArrayList expected = new ArrayList();
        actual.forEach(s -> expected.add(null));
        Warehouse.makeValsFromName((String)partitionName, expected);
        Assert.assertEquals((Collection)actual, expected);
    }

    private static long parse(DateTime time, String pattern) {
        return HiveUtil.parseHiveTimestamp((String)DateTimeFormat.forPattern((String)pattern).print((ReadableInstant)time));
    }

    private static long unixTime(DateTime time, int factionalDigits) {
        int factor = (int)Math.pow(10.0, Math.max(0, 3 - factionalDigits));
        return time.getMillis() / (long)factor * (long)factor * 1000L;
    }

    public static DateTimeZone nonDefaultTimeZone() {
        String defaultId = DateTimeZone.getDefault().getID();
        for (String id : DateTimeZone.getAvailableIDs()) {
            DateTimeZone zone;
            if (id.equals(defaultId) || (zone = DateTimeZone.forID((String)id)).getStandardOffset(0L) == 0) continue;
            return zone;
        }
        throw new IllegalStateException("no non-default timezone");
    }
}

