/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.type;

import io.trino.plugin.hive.type.PrimitiveTypeInfo;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.plugin.hive.type.TypeInfoFactory;
import io.trino.plugin.hive.type.TypeInfoUtils;
import java.util.List;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.testng.annotations.Test;

public class TestTypeInfoUtils {
    @Test
    public void testBasicPrimitive() {
        TestTypeInfoUtils.assertTypeInfo("void").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"void"));
        TestTypeInfoUtils.assertTypeInfo("tinyint").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"tinyint"));
        TestTypeInfoUtils.assertTypeInfo("smallint").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"smallint"));
        TestTypeInfoUtils.assertTypeInfo("int").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        TestTypeInfoUtils.assertTypeInfo("bigint").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        TestTypeInfoUtils.assertTypeInfo("float").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"float"));
        TestTypeInfoUtils.assertTypeInfo("double").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"double"));
        TestTypeInfoUtils.assertTypeInfo("boolean").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"));
        TestTypeInfoUtils.assertTypeInfo("string").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        TestTypeInfoUtils.assertTypeInfo("binary").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"binary"));
        TestTypeInfoUtils.assertTypeInfo("date").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"date"));
        TestTypeInfoUtils.assertTypeInfo("timestamp").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"timestamp"));
        TestTypeInfoUtils.assertTypeInfo("interval_year_month").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"interval_year_month"));
        TestTypeInfoUtils.assertTypeInfo("interval_day_time").isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"interval_day_time"));
    }

    @Test
    public void testChar() {
        TestTypeInfoUtils.assertTypeInfo("char(1)").isEqualTo((Object)TypeInfoFactory.getCharTypeInfo((int)1));
        TestTypeInfoUtils.assertTypeInfo("char(50)").isEqualTo((Object)TypeInfoFactory.getCharTypeInfo((int)50));
        TestTypeInfoUtils.assertTypeInfo("char(255)").isEqualTo((Object)TypeInfoFactory.getCharTypeInfo((int)255));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeInfoUtils.getTypeInfoFromTypeString((String)"char")).isInstanceOf(IllegalArgumentException.class)).hasMessage("char type is specified without length: char");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeInfoUtils.getTypeInfoFromTypeString((String)"char(0)")).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid char length: 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeInfoUtils.getTypeInfoFromTypeString((String)"char(256)")).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid char length: 256");
    }

    @Test
    public void testVarchar() {
        TestTypeInfoUtils.assertTypeInfo("varchar(1)").isEqualTo((Object)TypeInfoFactory.getVarcharTypeInfo((int)1));
        TestTypeInfoUtils.assertTypeInfo("varchar(42)").isEqualTo((Object)TypeInfoFactory.getVarcharTypeInfo((int)42));
        TestTypeInfoUtils.assertTypeInfo("varchar(65535)").isEqualTo((Object)TypeInfoFactory.getVarcharTypeInfo((int)65535));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeInfoUtils.getTypeInfoFromTypeString((String)"varchar")).isInstanceOf(IllegalArgumentException.class)).hasMessage("varchar type is specified without length: varchar");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeInfoUtils.getTypeInfoFromTypeString((String)"varchar(0)")).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid varchar length: 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeInfoUtils.getTypeInfoFromTypeString((String)"varchar(65536)")).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid varchar length: 65536");
    }

    @Test
    public void testDecimal() {
        TestTypeInfoUtils.assertTypeInfo("decimal", "decimal(10,0)").isEqualTo((Object)TypeInfoFactory.getDecimalTypeInfo((int)10, (int)0));
        TestTypeInfoUtils.assertTypeInfo("decimal(1)", "decimal(1,0)").isEqualTo((Object)TypeInfoFactory.getDecimalTypeInfo((int)1, (int)0));
        TestTypeInfoUtils.assertTypeInfo("decimal(5)", "decimal(5,0)").isEqualTo((Object)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)0));
        TestTypeInfoUtils.assertTypeInfo("decimal(38)", "decimal(38,0)").isEqualTo((Object)TypeInfoFactory.getDecimalTypeInfo((int)38, (int)0));
        TestTypeInfoUtils.assertTypeInfo("decimal(1,1)", "decimal(1,1)").isEqualTo((Object)TypeInfoFactory.getDecimalTypeInfo((int)1, (int)1));
        TestTypeInfoUtils.assertTypeInfo("decimal(10,5)", "decimal(10,5)").isEqualTo((Object)TypeInfoFactory.getDecimalTypeInfo((int)10, (int)5));
        TestTypeInfoUtils.assertTypeInfo("decimal(38,38)", "decimal(38,38)").isEqualTo((Object)TypeInfoFactory.getDecimalTypeInfo((int)38, (int)38));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeInfoUtils.getTypeInfoFromTypeString((String)"decimal(0)")).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid decimal precision: 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeInfoUtils.getTypeInfoFromTypeString((String)"decimal(39)")).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid decimal precision: 39");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeInfoUtils.getTypeInfoFromTypeString((String)"decimal(38,39)")).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid decimal scale: 39");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeInfoUtils.getTypeInfoFromTypeString((String)"decimal(4,5)")).isInstanceOf(IllegalArgumentException.class)).hasMessage("decimal precision (4) is greater than scale (5)");
    }

    @Test
    public void testTimestampLocalTZ() {
        Assertions.assertThat((Object)TestTypeInfoUtils.getHiveTypeInfo("timestamp with local time zone")).isInstanceOf(TimestampLocalTZTypeInfo.class);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)TypeInfoUtils.getTypeInfoFromTypeString((String)"timestamp with local time zone")).isInstanceOf(PrimitiveTypeInfo.class)).hasToString("timestamp with local time zone")).isEqualTo((Object)TypeInfoFactory.getPrimitiveTypeInfo((String)"timestamp with local time zone"));
    }

    @Test
    public void testArray() {
        TestTypeInfoUtils.assertTypeInfo("array<int>").isEqualTo((Object)TypeInfoFactory.getListTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int")));
    }

    @Test
    public void testMap() {
        TestTypeInfoUtils.assertTypeInfo("map<int,string>").isEqualTo((Object)TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string")));
    }

    @Test
    public void testStruct() {
        TestTypeInfoUtils.assertTypeInfo("struct<x:int,y:bigint>").isEqualTo((Object)TypeInfoFactory.getStructTypeInfo(List.of("x", "y"), List.of(TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"))));
        TestTypeInfoUtils.assertTypeInfo("struct<x:int,y:array<string>>").isEqualTo((Object)TypeInfoFactory.getStructTypeInfo(List.of("x", "y"), List.of(TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), TypeInfoFactory.getListTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string")))));
    }

    private static ObjectAssert<TypeInfo> assertTypeInfo(String typeString) {
        Assertions.assertThat((Object)TestTypeInfoUtils.getHiveTypeInfo(typeString)).hasToString(typeString);
        return (ObjectAssert)Assertions.assertThat((Object)TypeInfoUtils.getTypeInfoFromTypeString((String)typeString)).hasToString(typeString);
    }

    private static ObjectAssert<TypeInfo> assertTypeInfo(String typeString, String toString) {
        Assertions.assertThat((Object)TestTypeInfoUtils.getHiveTypeInfo(typeString)).hasToString(toString);
        return (ObjectAssert)Assertions.assertThat((Object)TypeInfoUtils.getTypeInfoFromTypeString((String)typeString)).hasToString(toString);
    }

    private static org.apache.hadoop.hive.serde2.typeinfo.TypeInfo getHiveTypeInfo(String typeString) {
        return org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils.getTypeInfoFromTypeString((String)typeString);
    }
}

