/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.statistics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.statistics.MetastoreHiveStatisticsProvider;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkGetPartitionsSample {
    private static final int TOTAL_SIZE = 10000;
    private static final int SAMPLE_SIZE = 100;

    @Benchmark
    public List<HivePartition> selectSample(BenchmarkData data) {
        return MetastoreHiveStatisticsProvider.getPartitionsSample(data.partitions, (int)100);
    }

    public static void main(String[] args) throws Exception {
        Benchmarks.benchmark(BenchmarkGetPartitionsSample.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        public List<HivePartition> partitions;

        @Setup
        public void setup() {
            ImmutableList.Builder partitions = ImmutableList.builder();
            SchemaTableName table = new SchemaTableName("schema", "table");
            for (int i = 0; i < 10000; ++i) {
                partitions.add((Object)new HivePartition(table, "partition_" + i, (Map)ImmutableMap.of()));
            }
            this.partitions = partitions.build();
        }
    }
}

