/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.benchmark.StandardFileFormats;
import io.trino.plugin.hive.parquet.ParquetTester;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.testing.DataProviders;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestTimestamp {
    @DataProvider
    public static Object[][] timestampPrecisionProvider() {
        return (Object[][])Arrays.stream(HiveTimestampPrecision.values()).collect(DataProviders.toDataProvider());
    }

    @Test(dataProvider="timestampPrecisionProvider")
    public void testTimestampBackedByInt64(HiveTimestampPrecision timestamp) throws Exception {
        String logicalAnnotation = switch (timestamp) {
            default -> throw new IncompatibleClassChangeError();
            case HiveTimestampPrecision.MILLISECONDS -> "TIMESTAMP(MILLIS,true)";
            case HiveTimestampPrecision.MICROSECONDS -> "TIMESTAMP(MICROS,true)";
            case HiveTimestampPrecision.NANOSECONDS -> "TIMESTAMP(NANOS,true)";
        };
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)("message hive_timestamp { optional int64 test (" + logicalAnnotation + "); }"));
        Iterable writeNullableDictionaryValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1L, null, 3L, 5L, null, null, null, 7L, 11L, null, 13L, 17L)), (int)30000);
        TestTimestamp.testRoundTrip(parquetSchema, writeNullableDictionaryValues, timestamp);
        Iterable writeDictionaryValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1L, 3L, 5L, 7L, 11L, 13L, 17L)), (int)30000);
        TestTimestamp.testRoundTrip(parquetSchema, writeDictionaryValues, timestamp);
        ContiguousSet writeValues = ContiguousSet.create((Range)Range.closedOpen((Comparable)Long.valueOf(-1000L), (Comparable)Long.valueOf(1000L)), (DiscreteDomain)DiscreteDomain.longs());
        TestTimestamp.testRoundTrip(parquetSchema, (Iterable<Long>)writeValues, timestamp);
    }

    private static void testRoundTrip(MessageType parquetSchema, Iterable<Long> writeValues, HiveTimestampPrecision timestamp) throws Exception {
        Iterable timestampReadValues = Iterables.transform(writeValues, value -> {
            if (value == null) {
                return null;
            }
            return switch (timestamp) {
                default -> throw new IncompatibleClassChangeError();
                case HiveTimestampPrecision.MILLISECONDS -> SqlTimestamp.fromMillis((int)timestamp.getPrecision(), (long)value);
                case HiveTimestampPrecision.MICROSECONDS -> SqlTimestamp.newInstance((int)timestamp.getPrecision(), (long)value, (int)0);
                case HiveTimestampPrecision.NANOSECONDS -> SqlTimestamp.newInstance((int)timestamp.getPrecision(), (long)Math.floorDiv((long)value, 1000), (int)(Math.floorMod((long)value, 1000) * 1000));
            };
        });
        List<JavaLongObjectInspector> objectInspectors = Collections.singletonList(PrimitiveObjectInspectorFactory.javaLongObjectInspector);
        ImmutableList columnNames = ImmutableList.of((Object)"test");
        try (ParquetTester.TempFile tempFile = new ParquetTester.TempFile("test", "parquet");){
            JobConf jobConf = new JobConf(ConfigurationInstantiator.newEmptyConfiguration());
            jobConf.setEnum("parquet.writer.version", (Enum)ParquetProperties.WriterVersion.PARQUET_1_0);
            ParquetTester.writeParquetColumn(jobConf, tempFile.getFile(), CompressionCodec.SNAPPY, ParquetTester.createTableProperties((List<String>)columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)columnNames, objectInspectors), new Iterator[]{writeValues.iterator()}, Optional.of(parquetSchema), false, DateTimeZone.getDefault());
            ConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig());
            TestTimestamp.testReadingAs((Type)TimestampType.createTimestampType((int)timestamp.getPrecision()), session, tempFile, (List<String>)columnNames, timestampReadValues);
            TestTimestamp.testReadingAs((Type)BigintType.BIGINT, session, tempFile, (List<String>)columnNames, writeValues);
        }
    }

    private static void testReadingAs(Type type, ConnectorSession session, ParquetTester.TempFile tempFile, List<String> columnNames, Iterable<?> expectedValues) throws IOException {
        Iterator<?> expected = expectedValues.iterator();
        try (ConnectorPageSource pageSource = StandardFileFormats.TRINO_PARQUET.createFileFormatReader(session, HiveTestUtils.HDFS_ENVIRONMENT, tempFile.getFile(), columnNames, (List<Type>)ImmutableList.of((Object)type));){
            Page firstPage = pageSource.getNextPage();
            Assert.assertTrue((firstPage.getPositionCount() > 0 ? 1 : 0) != 0, (String)"Expected first page to have at least 1 row");
            for (int i = 0; i < firstPage.getPositionCount(); ++i) {
                expected.next();
            }
            int pageCount = 1;
            while (!pageSource.isFinished()) {
                Page page = pageSource.getNextPage();
                if (page == null) continue;
                ++pageCount;
                Block block = page.getBlock(0);
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    Assertions.assertThat((Object)type.getObjectValue(session, block, i)).isEqualTo(expected.next());
                }
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)pageCount).withFailMessage("Expected more than one page but processed %s", new Object[]{pageCount})).isGreaterThan(1);
            Assert.assertFalse((boolean)expected.hasNext(), (String)"Read fewer values than expected");
        }
    }
}

