/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ImmutableList;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.parquet.ParquetTester;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.testing.BaseTestParquetWithBloomFilters;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.format.CompressionCodec;
import org.joda.time.DateTimeZone;

public class TestHiveParquetWithBloomFilters
extends BaseTestParquetWithBloomFilters {
    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = HiveQueryRunner.builder().build();
        this.dataDirectory = queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data");
        return queryRunner;
    }

    protected CatalogSchemaTableName createParquetTableWithBloomFilter(String columnName, List<Integer> testValues) {
        String tableName = "parquet_with_bloom_filters_" + TestingNames.randomNameSuffix();
        CatalogSchemaTableName catalogSchemaTableName = new CatalogSchemaTableName("hive", new SchemaTableName("tpch", tableName));
        this.assertUpdate(String.format("CREATE TABLE %s (%s INT) WITH (format = 'PARQUET')", catalogSchemaTableName, columnName));
        Path tableLocation = Path.of("%s/tpch/%s".formatted(this.dataDirectory, tableName), new String[0]);
        Path fileLocation = tableLocation.resolve("bloomFilterFile.parquet");
        TestHiveParquetWithBloomFilters.writeParquetFileWithBloomFilter(fileLocation.toFile(), columnName, testValues);
        return catalogSchemaTableName;
    }

    public static void writeParquetFileWithBloomFilter(File tempFile, String columnName, List<Integer> testValues) {
        List<JavaIntObjectInspector> objectInspectors = Collections.singletonList(PrimitiveObjectInspectorFactory.javaIntObjectInspector);
        ImmutableList columnNames = ImmutableList.of((Object)columnName);
        JobConf jobConf = new JobConf(ConfigurationInstantiator.newEmptyConfiguration());
        jobConf.setEnum("parquet.writer.version", (Enum)ParquetProperties.WriterVersion.PARQUET_1_0);
        jobConf.setBoolean("parquet.bloom.filter.enabled", true);
        try {
            ParquetTester.writeParquetColumn(jobConf, tempFile, CompressionCodec.SNAPPY, ParquetTester.createTableProperties((List<String>)columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)columnNames, objectInspectors), new Iterator[]{testValues.iterator()}, Optional.empty(), false, DateTimeZone.getDefault());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

