/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.containers.TestContainers;
import io.trino.testing.sql.TestTable;
import java.util.List;
import org.testng.annotations.Test;

public class TestHiveOrcWithShortZoneId
extends AbstractTestQueryFramework {
    private String resourceLocation;

    protected QueryRunner createQueryRunner() throws Exception {
        this.resourceLocation = TestContainers.getPathFromClassPathResource((String)"with_short_zone_id/data");
        return HiveQueryRunner.builder().addHiveProperty("hive.orc.read-legacy-short-zone-id", "true").build();
    }

    @Test
    public void testSelectWithShortZoneId() {
        try (TestTable testTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_select_with_short_zone_id_", "(id INT, firstName VARCHAR, lastName VARCHAR) WITH (external_location = '%s')".formatted(this.resourceLocation));){
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES (1, 'John', 'Doe')");
        }
    }

    @Test
    public void testSelectWithoutShortZoneId() {
        try (TestTable testTable = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_select_without_short_zone_id_", "(id INT, firstName VARCHAR, lastName VARCHAR)", (List)ImmutableList.of((Object)"2, 'Alice', 'Doe'"));){
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES (2, 'Alice', 'Doe')");
        }
    }
}

