/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.TestHiveReaderProjectionsUtil;
import io.trino.plugin.hive.TestingHiveConnectorFactory;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.assertions.BasePushdownPlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.testng.Assert;

public class TestHiveProjectionPushdownIntoTableScan
extends BasePushdownPlanTest {
    private static final String HIVE_CATALOG_NAME = "hive";
    private static final String SCHEMA_NAME = "test_schema";
    private static final Session HIVE_SESSION = TestingSession.testSessionBuilder().setCatalog("hive").setSchema("test_schema").build();
    private File baseDir;

    protected LocalQueryRunner createLocalQueryRunner() {
        try {
            this.baseDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        FileHiveMetastore metastore = TestingFileHiveMetastore.createTestingFileHiveMetastore(this.baseDir);
        Database database = Database.builder().setDatabaseName(SCHEMA_NAME).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
        metastore.createDatabase(database);
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)HIVE_SESSION);
        queryRunner.createCatalog(HIVE_CATALOG_NAME, (ConnectorFactory)new TestingHiveConnectorFactory((HiveMetastore)metastore), (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testPushdownDisabled() {
        String testTable = "test_disabled_pushdown";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty(HIVE_CATALOG_NAME, "projection_pushdown_enabled", "false").build();
        this.getQueryRunner().execute(String.format("CREATE TABLE %s (col0) AS SELECT cast(row(5, 6) as row(a bigint, b bigint)) AS col0 WHERE false", testTable));
        this.assertPlan(String.format("SELECT col0.a expr_a, col0.b expr_b FROM %s", testTable), session, PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((String)"col0[1]"), (Object)"expr_2", (Object)PlanMatchPattern.expression((String)"col0[2]")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)testTable, (Map)ImmutableMap.of((Object)"col0", (Object)"col0")))}));
    }

    @Test
    public void testDereferencePushdown() {
        String testTable = "test_simple_projection_pushdown";
        QualifiedObjectName completeTableName = new QualifiedObjectName(HIVE_CATALOG_NAME, SCHEMA_NAME, testTable);
        this.getQueryRunner().execute(String.format("CREATE TABLE %s (col0, col1) AS SELECT cast(row(5, 6) as row(x bigint, y bigint)) AS col0, 5 AS col1 WHERE false", testTable));
        Session session = this.getQueryRunner().getDefaultSession();
        Optional tableHandle = this.getTableHandle(session, completeTableName);
        Assert.assertTrue((boolean)tableHandle.isPresent(), (String)"expected the table handle to be present");
        Map columns = this.getColumnHandles(session, completeTableName);
        HiveColumnHandle column0Handle = (HiveColumnHandle)columns.get("col0");
        HiveColumnHandle column1Handle = (HiveColumnHandle)columns.get("col1");
        HiveColumnHandle columnX = TestHiveReaderProjectionsUtil.createProjectedColumnHandle(column0Handle, (List<Integer>)ImmutableList.of((Object)0));
        HiveColumnHandle columnY = TestHiveReaderProjectionsUtil.createProjectedColumnHandle(column0Handle, (List<Integer>)ImmutableList.of((Object)1));
        PlanMatchPattern[] planMatchPatternArray = new PlanMatchPattern[1];
        planMatchPatternArray[0] = PlanMatchPattern.tableScan(arg_0 -> ((HiveTableHandle)((HiveTableHandle)((TableHandle)tableHandle.get()).getConnectorHandle()).withProjectedColumns((Set)ImmutableSet.of((Object)columnX, (Object)columnY))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0#x", arg_0 -> ((HiveColumnHandle)columnX).equals(arg_0), (Object)"col0#y", arg_0 -> ((HiveColumnHandle)columnY).equals(arg_0)));
        this.assertPlan("SELECT col0.x expr_x, col0.y expr_y FROM " + testTable, PlanMatchPattern.any((PlanMatchPattern[])planMatchPatternArray));
        PlanMatchPattern[] planMatchPatternArray2 = new PlanMatchPattern[1];
        planMatchPatternArray2[0] = PlanMatchPattern.filter((String)"col0_y = BIGINT '2' AND (col0_x =  cast((col1 + 3) as BIGINT))", (PlanMatchPattern)PlanMatchPattern.tableScan(table -> {
            HiveTableHandle hiveTableHandle = (HiveTableHandle)table;
            return hiveTableHandle.getCompactEffectivePredicate().equals((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnY, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)))) && hiveTableHandle.getProjectedColumns().equals(ImmutableSet.of((Object)column1Handle, (Object)columnX, (Object)columnY));
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0_y", arg_0 -> ((HiveColumnHandle)columnY).equals(arg_0), (Object)"col0_x", arg_0 -> ((HiveColumnHandle)columnX).equals(arg_0), (Object)"col1", arg_0 -> ((HiveColumnHandle)column1Handle).equals(arg_0))));
        this.assertPlan(String.format("SELECT col0.x FROM %s WHERE col0.x = col1 + 3 and col0.y = 2", testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])planMatchPatternArray2));
        PlanMatchPattern[] planMatchPatternArray3 = new PlanMatchPattern[1];
        planMatchPatternArray3[0] = PlanMatchPattern.filter((String)"col0_x = BIGINT '5'", (PlanMatchPattern)PlanMatchPattern.tableScan(table -> {
            HiveTableHandle hiveTableHandle = (HiveTableHandle)table;
            return hiveTableHandle.getCompactEffectivePredicate().equals((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnX, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L)))) && hiveTableHandle.getProjectedColumns().equals(ImmutableSet.of((Object)column0Handle, (Object)columnX));
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0", arg_0 -> ((HiveColumnHandle)column0Handle).equals(arg_0), (Object)"col0_x", arg_0 -> ((HiveColumnHandle)columnX).equals(arg_0))));
        this.assertPlan(String.format("SELECT col0, col0.y expr_y FROM %s WHERE col0.x = 5", testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])planMatchPatternArray3));
        this.assertPlan(String.format("SELECT T.col0.x, T.col0, T.col0.y FROM %s T join %s S on T.col1 = S.col1 WHERE (T.col0.x = 2)", testTable, testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr_0_x", (Object)PlanMatchPattern.expression((String)"expr_0[1]"), (Object)"expr_0", (Object)PlanMatchPattern.expression((String)"expr_0"), (Object)"expr_0_y", (Object)PlanMatchPattern.expression((String)"expr_0[2]")), (PlanMatchPattern)PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, builder -> {
            PlanMatchPattern[] planMatchPatternArray = new PlanMatchPattern[1];
            planMatchPatternArray[0] = PlanMatchPattern.filter((String)"expr_0_x = BIGINT '2'", (PlanMatchPattern)PlanMatchPattern.tableScan(table -> ((Map)((HiveTableHandle)table).getCompactEffectivePredicate().getDomains().get()).equals(ImmutableMap.of((Object)columnX, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"expr_0_x", arg_0 -> ((HiveColumnHandle)columnX).equals(arg_0), (Object)"expr_0", arg_0 -> ((HiveColumnHandle)column0Handle).equals(arg_0), (Object)"t_expr_1", arg_0 -> ((HiveColumnHandle)column1Handle).equals(arg_0))));
            PlanMatchPattern[] planMatchPatternArray2 = new PlanMatchPattern[1];
            planMatchPatternArray2[0] = PlanMatchPattern.tableScan(arg_0 -> ((HiveTableHandle)((HiveTableHandle)((TableHandle)tableHandle.get()).getConnectorHandle()).withProjectedColumns((Set)ImmutableSet.of((Object)column1Handle))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"s_expr_1", arg_0 -> ((HiveColumnHandle)column1Handle).equals(arg_0)));
            builder.equiCriteria("t_expr_1", "s_expr_1").left(PlanMatchPattern.anyTree((PlanMatchPattern[])planMatchPatternArray)).right(PlanMatchPattern.anyTree((PlanMatchPattern[])planMatchPatternArray2));
        }))}));
    }

    @AfterAll
    public void cleanup() throws Exception {
        if (this.baseDir != null) {
            MoreFiles.deleteRecursively((Path)this.baseDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }
}

