/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.optimizer;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.plugin.hive.TestingHiveConnectorFactory;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.security.PrincipalType;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestHivePlans
extends BasePlanTest {
    private static final String HIVE_CATALOG_NAME = "hive";
    private static final String SCHEMA_NAME = "test_schema";
    private static final Session HIVE_SESSION = TestingSession.testSessionBuilder().setCatalog("hive").setSchema("test_schema").build();
    private File baseDir;

    protected LocalQueryRunner createLocalQueryRunner() {
        try {
            this.baseDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        FileHiveMetastore metastore = TestingFileHiveMetastore.createTestingFileHiveMetastore(this.baseDir);
        Database database = Database.builder().setDatabaseName(SCHEMA_NAME).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
        metastore.createDatabase(database);
        return this.createQueryRunner(HIVE_SESSION, (HiveMetastore)metastore);
    }

    protected LocalQueryRunner createQueryRunner(Session session, HiveMetastore metastore) {
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)session);
        queryRunner.createCatalog(HIVE_CATALOG_NAME, (ConnectorFactory)new TestingHiveConnectorFactory(metastore), Map.of("hive.max-partitions-for-eager-load", "5"));
        return queryRunner;
    }

    @BeforeAll
    public void setUp() {
        LocalQueryRunner queryRunner = this.getQueryRunner();
        String values = "VALUES ('one', 1), ('two', 2), ('three', 3), ('four', 4), ('five', 5)";
        queryRunner.execute("CREATE TABLE table_int_partitioned WITH (partitioned_by = ARRAY['int_part']) AS SELECT str_col, int_part FROM (" + values + ") t(str_col, int_part)");
        queryRunner.execute("CREATE TABLE table_str_partitioned WITH (partitioned_by = ARRAY['str_part']) AS SELECT int_col, str_part FROM (" + values + ") t(str_part, int_col)");
        queryRunner.execute("CREATE TABLE table_int_with_too_many_partitions WITH (partitioned_by = ARRAY['int_part']) AS SELECT str_col, int_part FROM (" + values + ", ('six', 6)) t(str_col, int_part)");
        queryRunner.execute("CREATE TABLE table_unpartitioned AS SELECT str_col, int_col FROM (" + values + ") t(str_col, int_col)");
    }

    @AfterAll
    public void cleanup() throws Exception {
        if (this.baseDir != null) {
            MoreFiles.deleteRecursively((Path)this.baseDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }

    @Test
    public void testPruneSimplePartitionLikeFilter() {
        this.assertDistributedPlan("SELECT * FROM table_str_partitioned WHERE str_part LIKE 't%'", PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.filter((String)"\"$like\"(STR_PART, \"$literal$\"(from_base64('DgAAAFZBUklBQkxFX1dJRFRIAQAAAAEAAAAHAAAAAAcAAAACAAAAdCUA')))", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_str_partitioned", Map.of("INT_COL", "int_col", "STR_PART", "str_part")))));
    }

    @Test
    public void testPrunePartitionLikeFilter() {
        this.assertDistributedPlan("SELECT l.int_col, r.int_col FROM table_str_partitioned l JOIN table_unpartitioned r ON l.str_part = r.str_col WHERE l.str_part LIKE 't%'", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, builder -> builder.equiCriteria("L_STR_PART", "R_STR_COL").left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"\"$like\"(L_STR_PART, \"$literal$\"(from_base64('DgAAAFZBUklBQkxFX1dJRFRIAQAAAAEAAAAHAAAAAAcAAAACAAAAdCUA')))", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_str_partitioned", Map.of("L_INT_COL", "int_col", "L_STR_PART", "str_part")))})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"R_STR_COL IN ('three', CAST('two' AS varchar(5))) AND \"$like\"(R_STR_COL, \"$literal$\"(from_base64('DgAAAFZBUklBQkxFX1dJRFRIAQAAAAEAAAAHAAAAAAcAAAACAAAAdCUA')))", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testSubsumePartitionFilter() {
        this.assertDistributedPlan("SELECT l.str_col, r.str_col FROM table_int_partitioned l JOIN table_unpartitioned r ON l.int_part = r.int_col WHERE l.int_part BETWEEN 2 AND 4", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"true", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_int_partitioned", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col")))})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"R_INT_COL IN (2, 3, 4)", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testSubsumePartitionPartOfAFilter() {
        this.assertDistributedPlan("SELECT l.str_col, r.str_col FROM table_int_partitioned l JOIN table_unpartitioned r ON l.int_part = r.int_col WHERE l.int_part BETWEEN 2 AND 4 AND l.str_col != 'three'", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"L_STR_COL != 'three'", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_int_partitioned", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col")))})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"R_INT_COL IN (2, 3, 4) AND R_INT_COL BETWEEN 2 AND 4", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testSubsumePartitionPartWhenOtherFilterNotConvertibleToTupleDomain() {
        this.assertDistributedPlan("SELECT l.str_col, r.str_col FROM table_int_partitioned l JOIN table_unpartitioned r ON l.int_part = r.int_col WHERE l.int_part BETWEEN 2 AND 4 AND substring(l.str_col, 2) != 'hree'", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"substring(L_STR_COL, BIGINT '2') != CAST('hree' AS varchar(5))", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_int_partitioned", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col")))})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"R_INT_COL IN (2, 3, 4) AND R_INT_COL BETWEEN 2 AND 4", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testSubsumePartitionFilterNotConvertibleToTupleDomain() {
        this.assertDistributedPlan("SELECT l.str_col, r.str_col FROM table_int_partitioned l JOIN table_unpartitioned r ON l.int_part = r.int_col WHERE l.int_part BETWEEN 2 AND 4 AND l.int_part % 2 = 0", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"L_INT_PART % 2 = 0", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_int_partitioned", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col")))})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"R_INT_COL IN (2, 4) AND R_INT_COL % 2 = 0", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testFilterDerivedFromTableProperties() {
        this.assertDistributedPlan("SELECT l.str_col, r.str_col FROM table_int_partitioned l JOIN table_unpartitioned r ON l.int_part = r.int_col", this.noJoinReordering(), PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").left(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"true", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_int_partitioned", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col")))})).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPARTITION, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"R_INT_COL IN (1, 2, 3, 4, 5)", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col")))})})))));
    }

    @Test
    public void testQueryScanningForTooManyPartitions() {
        String query = "SELECT l.str_col, r.str_col FROM table_int_with_too_many_partitions l JOIN table_unpartitioned r ON l.int_part = r.int_col";
        this.assertDistributedPlan(query, PlanMatchPattern.output((PlanMatchPattern)PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, builder -> builder.equiCriteria("L_INT_PART", "R_INT_COL").left(PlanMatchPattern.filter((String)"true", (PlanMatchPattern)PlanMatchPattern.tableScan((String)"table_int_with_too_many_partitions", Map.of("L_INT_PART", "int_part", "L_STR_COL", "str_col")))).right(PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.exchange((ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (ExchangeNode.Type)ExchangeNode.Type.REPLICATE, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"table_unpartitioned", Map.of("R_STR_COL", "str_col", "R_INT_COL", "int_col"))})})))));
    }

    private Session noJoinReordering() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).build();
    }
}

