/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.metadata.TableHandle;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.TestingHiveConnectorFactory;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneTableScanColumns;
import io.trino.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushProjectionIntoTableScan;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public class TestConnectorPushdownRulesWithHive
extends BaseRuleTest {
    private static final String SCHEMA_NAME = "test_schema";
    private static final Type ROW_TYPE = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BigintType.BIGINT)));
    private File baseDir;
    private HiveMetastore metastore;
    private CatalogHandle catalogHandle;
    private static final Session HIVE_SESSION = TestingSession.testSessionBuilder().setCatalog("test-catalog").setSchema("test_schema").build();

    public TestConnectorPushdownRulesWithHive() {
        super(new Plugin[0]);
    }

    protected Optional<LocalQueryRunner> createLocalQueryRunner() {
        try {
            this.baseDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.metastore = TestingFileHiveMetastore.createTestingFileHiveMetastore(this.baseDir);
        Database database = Database.builder().setDatabaseName(SCHEMA_NAME).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
        this.metastore.createDatabase(database);
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)HIVE_SESSION);
        queryRunner.createCatalog("test-catalog", (ConnectorFactory)new TestingHiveConnectorFactory(this.metastore), (Map)ImmutableMap.of());
        this.catalogHandle = queryRunner.getCatalogHandle("test-catalog");
        return Optional.of(queryRunner);
    }

    @Test
    public void testProjectionPushdown() {
        String tableName = "projection_test";
        PushProjectionIntoTableScan pushProjectionIntoTableScan = new PushProjectionIntoTableScan(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer(), new ScalarStatsCalculator(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer()));
        this.tester().getQueryRunner().execute(String.format("CREATE TABLE  %s (struct_of_int) AS SELECT cast(row(5, 6) as row(a bigint, b bigint)) as struct_of_int where false", tableName));
        Type baseType = ROW_TYPE;
        HiveColumnHandle partialColumn = new HiveColumnHandle("struct_of_int", 0, HiveType.toHiveType((Type)baseType), baseType, Optional.of(new HiveColumnProjectionInfo((List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)"a"), HiveType.toHiveType((Type)BigintType.BIGINT), (Type)BigintType.BIGINT)), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        HiveTableHandle hiveTable = new HiveTableHandle(SCHEMA_NAME, tableName, (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        TableHandle table = new TableHandle(this.catalogHandle, (ConnectorTableHandle)hiveTable, (ConnectorTransactionHandle)new HiveTransactionHandle(false));
        HiveColumnHandle fullColumn = partialColumn.getBaseColumn();
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> p.project(Assignments.of((Symbol)p.symbol("struct_of_int", baseType), (Expression)p.symbol("struct_of_int", baseType).toSymbolReference()), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("struct_of_int", baseType)), (Map)ImmutableMap.of((Object)p.symbol("struct_of_int", baseType), (Object)fullColumn)))).matches(PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((String)"col")), (PlanMatchPattern)PlanMatchPattern.tableScan(arg_0 -> ((HiveTableHandle)hiveTable.withProjectedColumns((Set)ImmutableSet.of((Object)fullColumn))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col", arg_0 -> ((HiveColumnHandle)fullColumn).equals(arg_0)))));
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> p.project(Assignments.of((Symbol)p.symbol("struct_of_int", baseType), (Expression)p.symbol("struct_of_int", baseType).toSymbolReference()), (PlanNode)p.tableScan(new TableHandle(this.catalogHandle, (ConnectorTableHandle)hiveTable.withProjectedColumns((Set)ImmutableSet.of((Object)fullColumn)), (ConnectorTransactionHandle)new HiveTransactionHandle(false)), (List)ImmutableList.of((Object)p.symbol("struct_of_int", baseType)), (Map)ImmutableMap.of((Object)p.symbol("struct_of_int", baseType), (Object)fullColumn)))).doesNotFire();
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr_deref", (Type)BigintType.BIGINT), (Expression)new SubscriptExpression((Expression)p.symbol("struct_of_int", baseType).toSymbolReference(), (Expression)new LongLiteral("1"))), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("struct_of_int", baseType)), (Map)ImmutableMap.of((Object)p.symbol("struct_of_int", baseType), (Object)fullColumn)))).matches(PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr_deref", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("struct_of_int#a"))), (PlanMatchPattern)PlanMatchPattern.tableScan(arg_0 -> ((HiveTableHandle)hiveTable.withProjectedColumns((Set)ImmutableSet.of((Object)partialColumn))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"struct_of_int#a", arg_0 -> ((HiveColumnHandle)partialColumn).equals(arg_0)))));
        this.metastore.dropTable(SCHEMA_NAME, tableName, true);
    }

    @Test
    public void testPredicatePushdown() {
        String tableName = "predicate_test";
        this.tester().getQueryRunner().execute(String.format("CREATE TABLE %s (a, b) AS SELECT 5, 6", tableName));
        PushPredicateIntoTableScan pushPredicateIntoTableScan = new PushPredicateIntoTableScan(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer(), false);
        HiveTableHandle hiveTable = new HiveTableHandle(SCHEMA_NAME, tableName, (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        TableHandle table = new TableHandle(this.catalogHandle, (ConnectorTableHandle)hiveTable, (ConnectorTransactionHandle)new HiveTransactionHandle(false));
        HiveColumnHandle column = HiveColumnHandle.createBaseColumn((String)"a", (int)0, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        this.tester().assertThat((Rule)pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression((String)"a = 5"), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("a", (Type)IntegerType.INTEGER)), (Map)ImmutableMap.of((Object)p.symbol("a", (Type)IntegerType.INTEGER), (Object)column)))).matches(PlanMatchPattern.filter((String)"a = 5", (PlanMatchPattern)PlanMatchPattern.tableScan(tableHandle -> ((Map)((HiveTableHandle)tableHandle).getCompactEffectivePredicate().getDomains().get()).equals(ImmutableMap.of((Object)column, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)5L))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"a", arg_0 -> ((HiveColumnHandle)column).equals(arg_0)))));
        this.metastore.dropTable(SCHEMA_NAME, tableName, true);
    }

    @Test
    public void testColumnPruningProjectionPushdown() {
        String tableName = "column_pruning_projection_test";
        this.tester().getQueryRunner().execute(String.format("CREATE TABLE %s (a, b) AS SELECT 5, 6", tableName));
        PruneTableScanColumns pruneTableScanColumns = new PruneTableScanColumns(this.tester().getMetadata());
        HiveTableHandle hiveTable = new HiveTableHandle(SCHEMA_NAME, tableName, (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        TableHandle table = new TableHandle(this.catalogHandle, (ConnectorTableHandle)hiveTable, (ConnectorTransactionHandle)new HiveTransactionHandle(false));
        HiveColumnHandle columnA = HiveColumnHandle.createBaseColumn((String)"a", (int)0, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        HiveColumnHandle columnB = HiveColumnHandle.createBaseColumn((String)"b", (int)1, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        this.tester().assertThat((Rule)pruneTableScanColumns).on(p -> {
            Symbol symbolA = p.symbol("a", (Type)IntegerType.INTEGER);
            Symbol symbolB = p.symbol("b", (Type)IntegerType.INTEGER);
            return p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)symbolA.toSymbolReference()), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)symbolA, (Object)symbolB), (Map)ImmutableMap.of((Object)symbolA, (Object)columnA, (Object)symbolB, (Object)columnB)));
        }).matches(PlanMatchPattern.strictProject((Map)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((String)"COLA")), (PlanMatchPattern)PlanMatchPattern.tableScan(arg_0 -> ((HiveTableHandle)hiveTable.withProjectedColumns((Set)ImmutableSet.of((Object)columnA))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"COLA", arg_0 -> ((HiveColumnHandle)columnA).equals(arg_0)))));
        this.metastore.dropTable(SCHEMA_NAME, tableName, true);
    }

    @Test
    public void testPushdownWithDuplicateExpressions() {
        String tableName = "duplicate_expressions";
        this.tester().getQueryRunner().execute(String.format("CREATE TABLE  %s (struct_of_bigint, just_bigint) AS SELECT cast(row(5, 6) AS row(a bigint, b bigint)) AS struct_of_int, 5 AS just_bigint WHERE false", tableName));
        PushProjectionIntoTableScan pushProjectionIntoTableScan = new PushProjectionIntoTableScan(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer(), new ScalarStatsCalculator(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer()));
        HiveTableHandle hiveTable = new HiveTableHandle(SCHEMA_NAME, tableName, (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        TableHandle table = new TableHandle(this.catalogHandle, (ConnectorTableHandle)hiveTable, (ConnectorTransactionHandle)new HiveTransactionHandle(false));
        HiveColumnHandle bigintColumn = HiveColumnHandle.createBaseColumn((String)"just_bigint", (int)1, (HiveType)HiveType.toHiveType((Type)BigintType.BIGINT), (Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        HiveColumnHandle partialColumn = new HiveColumnHandle("struct_of_bigint", 0, HiveType.toHiveType((Type)ROW_TYPE), ROW_TYPE, Optional.of(new HiveColumnProjectionInfo((List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)"a"), HiveType.toHiveType((Type)BigintType.BIGINT), (Type)BigintType.BIGINT)), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> {
            SymbolReference column = p.symbol("just_bigint", (Type)BigintType.BIGINT).toSymbolReference();
            ArithmeticUnaryExpression negation = new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)column);
            return p.project(Assignments.of((Symbol)p.symbol("column_ref", (Type)BigintType.BIGINT), (Expression)column, (Symbol)p.symbol("negated_column_ref", (Type)BigintType.BIGINT), (Expression)negation), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("just_bigint", (Type)BigintType.BIGINT)), (Map)ImmutableMap.of((Object)p.symbol("just_bigint", (Type)BigintType.BIGINT), (Object)bigintColumn)));
        }).matches(PlanMatchPattern.project((Map)ImmutableMap.of((Object)"column_ref", (Object)PlanMatchPattern.expression((String)"just_bigint_0"), (Object)"negated_column_ref", (Object)PlanMatchPattern.expression((String)"- just_bigint_0")), (PlanMatchPattern)PlanMatchPattern.tableScan(arg_0 -> ((HiveTableHandle)hiveTable.withProjectedColumns((Set)ImmutableSet.of((Object)bigintColumn))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"just_bigint_0", arg_0 -> ((HiveColumnHandle)bigintColumn).equals(arg_0)))));
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> {
            SubscriptExpression subscript = new SubscriptExpression((Expression)p.symbol("struct_of_bigint", ROW_TYPE).toSymbolReference(), (Expression)new LongLiteral("1"));
            ArithmeticBinaryExpression sum = new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)subscript, (Expression)new LongLiteral("2"));
            return p.project(Assignments.of((Symbol)p.symbol("expr_deref", (Type)BigintType.BIGINT), (Expression)subscript, (Symbol)p.symbol("expr_deref_2", (Type)BigintType.BIGINT), (Expression)sum), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("struct_of_bigint", ROW_TYPE)), (Map)ImmutableMap.of((Object)p.symbol("struct_of_bigint", ROW_TYPE), (Object)partialColumn.getBaseColumn())));
        }).matches(PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr_deref", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("struct_of_bigint#a")), (Object)"expr_deref_2", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("struct_of_bigint#a"), (Expression)new LongLiteral("2")))), (PlanMatchPattern)PlanMatchPattern.tableScan(arg_0 -> ((HiveTableHandle)hiveTable.withProjectedColumns((Set)ImmutableSet.of((Object)partialColumn))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"struct_of_bigint#a", arg_0 -> ((HiveColumnHandle)partialColumn).equals(arg_0)))));
        this.metastore.dropTable(SCHEMA_NAME, tableName, true);
    }

    @AfterAll
    public void cleanup() throws IOException {
        if (this.baseDir != null) {
            MoreFiles.deleteRecursively((Path)this.baseDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }
}

