/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.trino.plugin.hive.metastore.thrift.DefaultThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.HiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.NoHiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.TokenAwareMetastoreClientFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;

public class TestingTokenAwareMetastoreClientFactory
implements TokenAwareMetastoreClientFactory {
    private static final HiveMetastoreAuthentication AUTHENTICATION = new NoHiveMetastoreAuthentication();
    public static final Duration TIMEOUT = new Duration(20.0, TimeUnit.SECONDS);
    private final DefaultThriftMetastoreClientFactory factory;
    private final HostAndPort address;

    public TestingTokenAwareMetastoreClientFactory(Optional<HostAndPort> socksProxy, HostAndPort address) {
        this(socksProxy, address, TIMEOUT);
    }

    public TestingTokenAwareMetastoreClientFactory(Optional<HostAndPort> socksProxy, HostAndPort address, Duration timeout) {
        this.factory = new DefaultThriftMetastoreClientFactory(Optional.empty(), socksProxy, timeout, AUTHENTICATION, "localhost");
        this.address = Objects.requireNonNull(address, "address is null");
    }

    public ThriftMetastoreClient createMetastoreClient(Optional<String> delegationToken) throws TException {
        return this.factory.create(this.address, delegationToken);
    }
}

