/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.metastore.thrift.MockThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Optional;
import org.apache.thrift.transport.TTransportException;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveWithDisabledBatchFetch {
    @Test
    public void testBatchEnabled() {
        ThriftMetastore thriftMetastore = TestHiveWithDisabledBatchFetch.prepareThriftMetastore(true);
        Assertions.assertThat((Optional)thriftMetastore.getAllTables()).isPresent();
        Assertions.assertThat((Optional)thriftMetastore.getAllViews()).isPresent();
    }

    @Test
    public void testBatchDisabled() {
        ThriftMetastore thriftMetastore = TestHiveWithDisabledBatchFetch.prepareThriftMetastore(false);
        Assertions.assertThat((Optional)thriftMetastore.getAllTables()).isEmpty();
        Assertions.assertThat((Optional)thriftMetastore.getAllViews()).isEmpty();
    }

    @Test
    public void testFallbackInCaseOfMetastoreFailure() {
        ThriftMetastore thriftMetastore = TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().thriftMetastoreConfig(new ThriftMetastoreConfig().setBatchMetadataFetchEnabled(true)).metastoreClient(TestHiveWithDisabledBatchFetch.createFailingMetastoreClient()).hiveConfig(new HiveConfig().setTranslateHiveViews(true)).build();
        Assertions.assertThat((Optional)thriftMetastore.getAllTables()).isEmpty();
        Assertions.assertThat((Optional)thriftMetastore.getAllViews()).isEmpty();
    }

    private static ThriftMetastore prepareThriftMetastore(boolean enabled) {
        return TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().thriftMetastoreConfig(new ThriftMetastoreConfig().setBatchMetadataFetchEnabled(enabled)).metastoreClient(TestHiveWithDisabledBatchFetch.createFakeMetastoreClient()).hiveConfig(new HiveConfig().setTranslateHiveViews(true)).build();
    }

    private static ThriftMetastoreClient createFakeMetastoreClient() {
        return new MockThriftMetastoreClient(){

            @Override
            public Optional<List<SchemaTableName>> getAllTables() {
                return Optional.of(ImmutableList.of((Object)new SchemaTableName("test_schema", "test_table")));
            }

            @Override
            public Optional<List<SchemaTableName>> getAllViews() {
                return Optional.of(ImmutableList.of((Object)new SchemaTableName("test_schema", "test_view")));
            }
        };
    }

    private static ThriftMetastoreClient createFailingMetastoreClient() {
        return new MockThriftMetastoreClient(){

            @Override
            public Optional<List<SchemaTableName>> getAllTables() throws TTransportException {
                throw new TTransportException();
            }

            @Override
            public Optional<List<SchemaTableName>> getAllViews() throws TTransportException {
                throw new TTransportException();
            }
        };
    }
}

