/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.trino.Session;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.metastore.CountingAccessHiveMetastore;
import io.trino.plugin.hive.metastore.CountingAccessHiveMetastoreUtil;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.io.File;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveMetastoreAccessOperations
extends AbstractTestQueryFramework {
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().setCatalog("hive").setSchema("test_schema").build();
    private CountingAccessHiveMetastore metastore;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TEST_SESSION).build();
        File baseDir = queryRunner.getCoordinator().getBaseDataDir().resolve("hive").toFile();
        this.metastore = new CountingAccessHiveMetastore((HiveMetastore)TestingFileHiveMetastore.createTestingFileHiveMetastore(baseDir));
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(this.metastore));
        queryRunner.createCatalog("hive", "hive", (Map)ImmutableMap.of());
        queryRunner.execute("CREATE SCHEMA test_schema");
        return queryRunner;
    }

    @Test
    public void testUse() {
        this.assertMetastoreInvocations("USE " + (String)this.getSession().getSchema().orElseThrow(), (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_DATABASE).build());
    }

    @Test
    public void testCreateTable() {
        this.assertMetastoreInvocations("CREATE TABLE test_create(id VARCHAR, age INT)", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.CREATE_TABLE).add((Object)CountingAccessHiveMetastore.Method.GET_DATABASE).add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).add((Object)CountingAccessHiveMetastore.Method.UPDATE_TABLE_STATISTICS).build());
    }

    @Test
    public void testCreateTableAsSelect() {
        this.assertMetastoreInvocations("CREATE TABLE test_ctas AS SELECT 1 AS age", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_DATABASE).add((Object)CountingAccessHiveMetastore.Method.CREATE_TABLE).add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).add((Object)CountingAccessHiveMetastore.Method.UPDATE_TABLE_STATISTICS).build());
    }

    @Test
    public void testSelect() {
        this.assertUpdate("CREATE TABLE test_select_from(id VARCHAR, age INT)");
        this.assertMetastoreInvocations("SELECT * FROM test_select_from", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).build());
    }

    @Test
    public void testSelectPartitionedTable() {
        this.assertUpdate("CREATE TABLE test_select_partition WITH (partitioned_by = ARRAY['part']) AS SELECT 1 AS data, 10 AS part", 1L);
        this.assertMetastoreInvocations("SELECT * FROM test_select_partition", (Multiset<?>)ImmutableMultiset.builder().addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 2).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITION_NAMES_BY_FILTER).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITIONS_BY_NAMES).build());
        this.assertUpdate("INSERT INTO test_select_partition SELECT 2 AS data, 20 AS part", 1L);
        this.assertMetastoreInvocations("SELECT * FROM test_select_partition", (Multiset<?>)ImmutableMultiset.builder().addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 2).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITION_NAMES_BY_FILTER).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITIONS_BY_NAMES).build());
        this.assertMetastoreInvocations("SELECT * FROM test_select_partition WHERE part = 10", (Multiset<?>)ImmutableMultiset.builder().addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 2).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITION_NAMES_BY_FILTER).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITIONS_BY_NAMES).build());
    }

    @Test
    public void testSelectWithFilter() {
        this.assertUpdate("CREATE TABLE test_select_from_where AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("SELECT * FROM test_select_from_where WHERE age = 2", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).build());
    }

    @Test
    public void testSelectFromView() {
        this.assertUpdate("CREATE TABLE test_select_view_table(id VARCHAR, age INT)");
        this.assertUpdate("CREATE VIEW test_select_view_view AS SELECT id, age FROM test_select_view_table");
        this.assertMetastoreInvocations("SELECT * FROM test_select_view_view", (Multiset<?>)ImmutableMultiset.builder().addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 2).build());
    }

    @Test
    public void testSelectFromViewWithFilter() {
        this.assertUpdate("CREATE TABLE test_select_view_where_table AS SELECT 2 AS age", 1L);
        this.assertUpdate("CREATE VIEW test_select_view_where_view AS SELECT age FROM test_select_view_where_table");
        this.assertMetastoreInvocations("SELECT * FROM test_select_view_where_view WHERE age = 2", (Multiset<?>)ImmutableMultiset.builder().addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 2).build());
    }

    @Test
    public void testJoin() {
        this.assertUpdate("CREATE TABLE test_join_t1 AS SELECT 2 AS age, 'id1' AS id", 1L);
        this.assertUpdate("CREATE TABLE test_join_t2 AS SELECT 'name1' AS name, 'id1' AS id", 1L);
        this.assertMetastoreInvocations("SELECT name, age FROM test_join_t1 JOIN test_join_t2 ON test_join_t2.id = test_join_t1.id", (Multiset<?>)ImmutableMultiset.builder().addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 2).addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE_STATISTICS, 2).build());
    }

    @Test
    public void testSelfJoin() {
        this.assertUpdate("CREATE TABLE test_self_join_table AS SELECT 2 AS age, 0 parent, 3 AS id", 1L);
        this.assertMetastoreInvocations("SELECT child.age, parent.age FROM test_self_join_table child JOIN test_self_join_table parent ON child.parent = parent.id", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).add((Object)CountingAccessHiveMetastore.Method.GET_TABLE_STATISTICS).build());
    }

    @Test
    public void testExplainSelect() {
        this.assertUpdate("CREATE TABLE test_explain AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("EXPLAIN SELECT * FROM test_explain", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).add((Object)CountingAccessHiveMetastore.Method.GET_TABLE_STATISTICS).build());
    }

    @Test
    public void testDescribe() {
        this.assertUpdate("CREATE TABLE test_describe(id VARCHAR, age INT)");
        this.assertMetastoreInvocations("DESCRIBE test_describe", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_DATABASE).add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).build());
    }

    @Test
    public void testShowStatsForTable() {
        this.assertUpdate("CREATE TABLE test_show_stats AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("SHOW STATS FOR test_show_stats", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).add((Object)CountingAccessHiveMetastore.Method.GET_TABLE_STATISTICS).build());
    }

    @Test
    public void testShowStatsForTableWithFilter() {
        this.assertUpdate("CREATE TABLE test_show_stats_with_filter AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("SHOW STATS FOR (SELECT * FROM test_show_stats_with_filter where age >= 2)", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).add((Object)CountingAccessHiveMetastore.Method.GET_TABLE_STATISTICS).build());
    }

    @Test
    public void testAnalyze() {
        this.assertUpdate("CREATE TABLE test_analyze AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("ANALYZE test_analyze", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).add((Object)CountingAccessHiveMetastore.Method.UPDATE_TABLE_STATISTICS).build());
    }

    @Test
    public void testAnalyzePartitionedTable() {
        this.assertUpdate("CREATE TABLE test_analyze_partition WITH (partitioned_by = ARRAY['part']) AS SELECT 1 AS data, 10 AS part", 1L);
        this.assertMetastoreInvocations("ANALYZE test_analyze_partition", (Multiset<?>)ImmutableMultiset.builder().addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 2).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITION_NAMES_BY_FILTER).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITIONS_BY_NAMES).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITION_STATISTICS).add((Object)CountingAccessHiveMetastore.Method.UPDATE_PARTITION_STATISTICS).build());
        this.assertUpdate("INSERT INTO test_analyze_partition SELECT 2 AS data, 20 AS part", 1L);
        this.assertMetastoreInvocations("ANALYZE test_analyze_partition", (Multiset<?>)ImmutableMultiset.builder().addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 2).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITION_NAMES_BY_FILTER).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITIONS_BY_NAMES).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITION_STATISTICS).add((Object)CountingAccessHiveMetastore.Method.UPDATE_PARTITION_STATISTICS).build());
    }

    @Test
    public void testDropStats() {
        this.assertUpdate("CREATE TABLE drop_stats AS SELECT 2 AS age", 1L);
        this.assertMetastoreInvocations("CALL system.drop_stats('test_schema', 'drop_stats')", (Multiset<?>)ImmutableMultiset.builder().add((Object)CountingAccessHiveMetastore.Method.GET_TABLE).add((Object)CountingAccessHiveMetastore.Method.UPDATE_TABLE_STATISTICS).build());
    }

    @Test
    public void testDropStatsPartitionedTable() {
        this.assertUpdate("CREATE TABLE drop_stats_partition WITH (partitioned_by = ARRAY['part']) AS SELECT 1 AS data, 10 AS part", 1L);
        this.assertMetastoreInvocations("CALL system.drop_stats('test_schema', 'drop_stats_partition')", (Multiset<?>)ImmutableMultiset.builder().addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 2).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITION_NAMES_BY_FILTER).add((Object)CountingAccessHiveMetastore.Method.UPDATE_PARTITION_STATISTICS).build());
        this.assertUpdate("INSERT INTO drop_stats_partition SELECT 2 AS data, 20 AS part", 1L);
        this.assertMetastoreInvocations("CALL system.drop_stats('test_schema', 'drop_stats_partition')", (Multiset<?>)ImmutableMultiset.builder().addCopies((Object)CountingAccessHiveMetastore.Method.GET_TABLE, 2).add((Object)CountingAccessHiveMetastore.Method.GET_PARTITION_NAMES_BY_FILTER).addCopies((Object)CountingAccessHiveMetastore.Method.UPDATE_PARTITION_STATISTICS, 2).build());
    }

    private void assertMetastoreInvocations(@Language(value="SQL") String query, Multiset<?> expectedInvocations) {
        CountingAccessHiveMetastoreUtil.assertMetastoreInvocations(this.metastore, this.getQueryRunner(), this.getQueryRunner().getDefaultSession(), query, expectedInvocations);
    }
}

