/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.util.CollectionUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.glue.TestingMetastoreObjects;
import io.trino.plugin.hive.metastore.glue.converter.GlueToTrinoConverter;
import io.trino.spi.security.PrincipalType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hive.metastore.TableType;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestGlueToTrinoConverter {
    private static final String PUBLIC_OWNER = "PUBLIC";
    private com.amazonaws.services.glue.model.Database testDatabase;
    private com.amazonaws.services.glue.model.Table testTable;
    private com.amazonaws.services.glue.model.Partition testPartition;

    @BeforeMethod
    public void setup() {
        this.testDatabase = TestingMetastoreObjects.getGlueTestDatabase();
        this.testTable = TestingMetastoreObjects.getGlueTestTable(this.testDatabase.getName());
        this.testPartition = TestingMetastoreObjects.getGlueTestPartition(this.testDatabase.getName(), this.testTable.getName(), (List<String>)ImmutableList.of((Object)"val1"));
    }

    private static GlueToTrinoConverter.GluePartitionConverter createPartitionConverter(com.amazonaws.services.glue.model.Table table) {
        return new GlueToTrinoConverter.GluePartitionConverter(GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)table, (String)table.getDatabaseName()));
    }

    @Test
    public void testConvertDatabase() {
        Database trinoDatabase = GlueToTrinoConverter.convertDatabase((com.amazonaws.services.glue.model.Database)this.testDatabase);
        Assert.assertEquals((String)trinoDatabase.getDatabaseName(), (String)this.testDatabase.getName());
        Assert.assertEquals((String)((String)trinoDatabase.getLocation().get()), (String)this.testDatabase.getLocationUri());
        Assert.assertEquals((String)((String)trinoDatabase.getComment().get()), (String)this.testDatabase.getDescription());
        Assert.assertEquals((Map)trinoDatabase.getParameters(), (Map)this.testDatabase.getParameters());
        Assert.assertEquals((Object)trinoDatabase.getOwnerName(), Optional.of(PUBLIC_OWNER));
        Assert.assertEquals((Object)trinoDatabase.getOwnerType(), Optional.of(PrincipalType.ROLE));
    }

    @Test
    public void testConvertTable() {
        Table trinoTable = GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
        Assert.assertEquals((String)trinoTable.getTableName(), (String)this.testTable.getName());
        Assert.assertEquals((String)trinoTable.getDatabaseName(), (String)this.testDatabase.getName());
        Assert.assertEquals((String)trinoTable.getTableType(), (String)GlueToTrinoConverter.getTableTypeNullable((com.amazonaws.services.glue.model.Table)this.testTable));
        Assert.assertEquals((String)trinoTable.getOwner().orElse(null), (String)this.testTable.getOwner());
        Assert.assertEquals((Map)trinoTable.getParameters(), (Map)GlueToTrinoConverter.getTableParameters((com.amazonaws.services.glue.model.Table)this.testTable));
        TestGlueToTrinoConverter.assertColumnList(trinoTable.getDataColumns(), this.testTable.getStorageDescriptor().getColumns());
        TestGlueToTrinoConverter.assertColumnList(trinoTable.getPartitionColumns(), this.testTable.getPartitionKeys());
        TestGlueToTrinoConverter.assertStorage(trinoTable.getStorage(), this.testTable.getStorageDescriptor());
        Assert.assertEquals((String)((String)trinoTable.getViewOriginalText().get()), (String)this.testTable.getViewOriginalText());
        Assert.assertEquals((String)((String)trinoTable.getViewExpandedText().get()), (String)this.testTable.getViewExpandedText());
    }

    @Test
    public void testConvertTableWithOpenCSVSerDe() {
        com.amazonaws.services.glue.model.Table glueTable = TestingMetastoreObjects.getGlueTestTable(this.testDatabase.getName());
        glueTable.setStorageDescriptor(TestingMetastoreObjects.getGlueTestStorageDescriptor((List<com.amazonaws.services.glue.model.Column>)ImmutableList.of((Object)TestingMetastoreObjects.getGlueTestColumn("int")), "org.apache.hadoop.hive.serde2.OpenCSVSerde"));
        Table trinoTable = GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)glueTable, (String)this.testDatabase.getName());
        Assert.assertEquals((String)trinoTable.getTableName(), (String)glueTable.getName());
        Assert.assertEquals((String)trinoTable.getDatabaseName(), (String)this.testDatabase.getName());
        Assert.assertEquals((String)trinoTable.getTableType(), (String)GlueToTrinoConverter.getTableTypeNullable((com.amazonaws.services.glue.model.Table)glueTable));
        Assert.assertEquals((String)trinoTable.getOwner().orElse(null), (String)glueTable.getOwner());
        Assert.assertEquals((Map)trinoTable.getParameters(), (Map)GlueToTrinoConverter.getTableParameters((com.amazonaws.services.glue.model.Table)glueTable));
        Assert.assertEquals((int)trinoTable.getDataColumns().size(), (int)1);
        Assert.assertEquals((Object)((Column)trinoTable.getDataColumns().get(0)).getType(), (Object)HiveType.HIVE_STRING);
        TestGlueToTrinoConverter.assertColumnList(trinoTable.getPartitionColumns(), glueTable.getPartitionKeys());
        TestGlueToTrinoConverter.assertStorage(trinoTable.getStorage(), glueTable.getStorageDescriptor());
        Assert.assertEquals((String)((String)trinoTable.getViewOriginalText().get()), (String)glueTable.getViewOriginalText());
        Assert.assertEquals((String)((String)trinoTable.getViewExpandedText().get()), (String)glueTable.getViewExpandedText());
    }

    @Test
    public void testConvertTableWithoutTableType() {
        com.amazonaws.services.glue.model.Table table = TestingMetastoreObjects.getGlueTestTable(this.testDatabase.getName());
        table.setTableType(null);
        Table trinoTable = GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)table, (String)this.testDatabase.getName());
        Assert.assertEquals((String)trinoTable.getTableType(), (String)TableType.EXTERNAL_TABLE.name());
    }

    @Test
    public void testConvertTableNullPartitions() {
        this.testTable.setPartitionKeys(null);
        Table trinoTable = GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
        Assert.assertTrue((boolean)trinoTable.getPartitionColumns().isEmpty());
    }

    @Test
    public void testConvertTableUppercaseColumnType() {
        com.amazonaws.services.glue.model.Column uppercaseColumn = TestingMetastoreObjects.getGlueTestColumn().withType("String");
        this.testTable.getStorageDescriptor().setColumns((Collection)ImmutableList.of((Object)uppercaseColumn));
        GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
    }

    @Test
    public void testConvertPartition() {
        GlueToTrinoConverter.GluePartitionConverter converter = TestGlueToTrinoConverter.createPartitionConverter(this.testTable);
        Partition trinoPartition = converter.apply(this.testPartition);
        Assert.assertEquals((String)trinoPartition.getDatabaseName(), (String)this.testPartition.getDatabaseName());
        Assert.assertEquals((String)trinoPartition.getTableName(), (String)this.testPartition.getTableName());
        TestGlueToTrinoConverter.assertColumnList(trinoPartition.getColumns(), this.testPartition.getStorageDescriptor().getColumns());
        Assert.assertEquals((Collection)trinoPartition.getValues(), (Collection)this.testPartition.getValues());
        TestGlueToTrinoConverter.assertStorage(trinoPartition.getStorage(), this.testPartition.getStorageDescriptor());
        Assert.assertEquals((Map)trinoPartition.getParameters(), (Map)GlueToTrinoConverter.getPartitionParameters((com.amazonaws.services.glue.model.Partition)this.testPartition));
    }

    @Test
    public void testPartitionConversionMemoization() {
        String fakeS3Location = "s3://some-fake-location";
        this.testPartition.getStorageDescriptor().setLocation(fakeS3Location);
        com.amazonaws.services.glue.model.Partition partitionTwo = TestingMetastoreObjects.getGlueTestPartition(this.testDatabase.getName(), this.testTable.getName(), new ArrayList<String>(this.testPartition.getValues()));
        partitionTwo.getStorageDescriptor().setColumns(new ArrayList(this.testPartition.getStorageDescriptor().getColumns()));
        partitionTwo.getStorageDescriptor().setBucketColumns(new ArrayList(this.testPartition.getStorageDescriptor().getBucketColumns()));
        partitionTwo.getStorageDescriptor().setLocation(fakeS3Location);
        partitionTwo.getStorageDescriptor().setInputFormat(this.testPartition.getStorageDescriptor().getInputFormat());
        partitionTwo.getStorageDescriptor().setOutputFormat(this.testPartition.getStorageDescriptor().getOutputFormat());
        partitionTwo.getStorageDescriptor().setParameters(new HashMap(this.testPartition.getStorageDescriptor().getParameters()));
        GlueToTrinoConverter.GluePartitionConverter converter = TestGlueToTrinoConverter.createPartitionConverter(this.testTable);
        Partition trinoPartition = converter.apply(this.testPartition);
        Partition trinoPartition2 = converter.apply(partitionTwo);
        Assert.assertNotSame((Object)trinoPartition, (Object)trinoPartition2);
        Assert.assertSame((Object)trinoPartition2.getDatabaseName(), (Object)trinoPartition.getDatabaseName());
        Assert.assertSame((Object)trinoPartition2.getTableName(), (Object)trinoPartition.getTableName());
        Assert.assertSame((Object)trinoPartition2.getColumns(), (Object)trinoPartition.getColumns());
        Assert.assertSame((Object)trinoPartition2.getParameters(), (Object)trinoPartition.getParameters());
        Assert.assertNotSame((Object)trinoPartition2.getValues(), (Object)trinoPartition.getValues());
        Storage storage = trinoPartition.getStorage();
        Storage storage2 = trinoPartition2.getStorage();
        Assert.assertSame((Object)storage2.getStorageFormat(), (Object)storage.getStorageFormat());
        Assert.assertSame((Object)storage2.getBucketProperty(), (Object)storage.getBucketProperty());
        Assert.assertSame((Object)storage2.getSerdeParameters(), (Object)storage.getSerdeParameters());
        Assert.assertNotSame((Object)storage2.getLocation(), (Object)storage.getLocation());
    }

    @Test
    public void testDatabaseNullParameters() {
        this.testDatabase.setParameters(null);
        Assert.assertNotNull((Object)GlueToTrinoConverter.convertDatabase((com.amazonaws.services.glue.model.Database)this.testDatabase).getParameters());
    }

    @Test
    public void testTableNullParameters() {
        this.testTable.setParameters(null);
        this.testTable.getStorageDescriptor().getSerdeInfo().setParameters(null);
        Table trinoTable = GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
        Assert.assertNotNull((Object)trinoTable.getParameters());
        Assert.assertNotNull((Object)trinoTable.getStorage().getSerdeParameters());
    }

    @Test
    public void testIcebergTableNullStorageDescriptor() {
        this.testTable.setParameters((Map)ImmutableMap.of((Object)"table_type", (Object)"iceberg"));
        this.testTable.setStorageDescriptor(null);
        Table trinoTable = GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
        Assert.assertEquals((int)trinoTable.getDataColumns().size(), (int)1);
    }

    @Test
    public void testIcebergTableNonNullStorageDescriptor() {
        this.testTable.setParameters((Map)ImmutableMap.of((Object)"table_type", (Object)"iceberg"));
        Assert.assertNotNull((Object)this.testTable.getStorageDescriptor());
        Table trinoTable = GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
        Assert.assertEquals((int)trinoTable.getDataColumns().size(), (int)1);
    }

    @Test
    public void testDeltaTableNullStorageDescriptor() {
        this.testTable.setParameters((Map)ImmutableMap.of((Object)"spark.sql.sources.provider", (Object)"delta"));
        this.testTable.setStorageDescriptor(null);
        Table trinoTable = GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
        Assert.assertEquals((int)trinoTable.getDataColumns().size(), (int)1);
    }

    @Test
    public void testDeltaTableNonNullStorageDescriptor() {
        this.testTable.setParameters((Map)ImmutableMap.of((Object)"spark.sql.sources.provider", (Object)"delta"));
        Assert.assertNotNull((Object)this.testTable.getStorageDescriptor());
        Table trinoTable = GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
        Assert.assertEquals((Set)((Set)trinoTable.getDataColumns().stream().map(Column::getName).collect(ImmutableSet.toImmutableSet())), (Set)((Set)this.testTable.getStorageDescriptor().getColumns().stream().map(com.amazonaws.services.glue.model.Column::getName).collect(ImmutableSet.toImmutableSet())));
    }

    @Test
    public void testIcebergMaterializedViewNullStorageDescriptor() {
        com.amazonaws.services.glue.model.Table testMaterializedView = TestingMetastoreObjects.getGlueTestTrinoMaterializedView(this.testDatabase.getName());
        Assert.assertNull((Object)testMaterializedView.getStorageDescriptor());
        Table trinoTable = GlueToTrinoConverter.convertTable((com.amazonaws.services.glue.model.Table)testMaterializedView, (String)this.testDatabase.getName());
        Assert.assertEquals((int)trinoTable.getDataColumns().size(), (int)1);
    }

    @Test
    public void testPartitionNullParameters() {
        this.testPartition.setParameters(null);
        Assert.assertNotNull((Object)TestGlueToTrinoConverter.createPartitionConverter(this.testTable).apply(this.testPartition).getParameters());
    }

    private static void assertColumnList(List<Column> actual, List<com.amazonaws.services.glue.model.Column> expected) {
        if (expected == null) {
            Assert.assertNull(actual);
        }
        Assert.assertEquals((int)actual.size(), (int)expected.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestGlueToTrinoConverter.assertColumn(actual.get(i), expected.get(i));
        }
    }

    private static void assertColumn(Column actual, com.amazonaws.services.glue.model.Column expected) {
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((String)actual.getType().getHiveTypeName().toString(), (String)expected.getType());
        Assert.assertEquals((String)((String)actual.getComment().get()), (String)expected.getComment());
    }

    private static void assertStorage(Storage actual, StorageDescriptor expected) {
        Assert.assertEquals((String)actual.getLocation(), (String)expected.getLocation());
        Assert.assertEquals((String)actual.getStorageFormat().getSerde(), (String)expected.getSerdeInfo().getSerializationLibrary());
        Assert.assertEquals((String)actual.getStorageFormat().getInputFormat(), (String)expected.getInputFormat());
        Assert.assertEquals((String)actual.getStorageFormat().getOutputFormat(), (String)expected.getOutputFormat());
        if (!CollectionUtils.isNullOrEmpty((Collection)expected.getBucketColumns())) {
            HiveBucketProperty bucketProperty = (HiveBucketProperty)actual.getBucketProperty().get();
            Assert.assertEquals((Collection)bucketProperty.getBucketedBy(), (Collection)expected.getBucketColumns());
            Assert.assertEquals((int)bucketProperty.getBucketCount(), (int)expected.getNumberOfBuckets());
        }
    }
}

