/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import java.util.Map;
import org.testng.annotations.Test;

public class TestGlueHiveMetastoreConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((GlueHiveMetastoreConfig)ConfigAssertions.recordDefaults(GlueHiveMetastoreConfig.class)).setGlueRegion(null).setGlueEndpointUrl(null).setGlueStsRegion(null).setGlueStsEndpointUrl(null).setGlueProxyApiId(null).setPinGlueClientToCurrentRegion(false).setMaxGlueConnections(30).setMaxGlueErrorRetries(10).setDefaultWarehouseDir(null).setIamRole(null).setExternalId(null).setAwsAccessKey(null).setAwsSecretKey(null).setAwsCredentialsProvider(null).setCatalogId(null).setPartitionSegments(5).setGetPartitionThreads(20).setAssumeCanonicalPartitionKeys(false).setReadStatisticsThreads(5).setWriteStatisticsThreads(20));
    }

    @Test
    public void testExplicitPropertyMapping() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.metastore.glue.region", (Object)"us-east-1").put((Object)"hive.metastore.glue.endpoint-url", (Object)"http://foo.bar").put((Object)"hive.metastore.glue.sts.region", (Object)"us-east-3").put((Object)"hive.metastore.glue.sts.endpoint", (Object)"http://sts.foo.bar").put((Object)"hive.metastore.glue.proxy-api-id", (Object)"abc123").put((Object)"hive.metastore.glue.pin-client-to-current-region", (Object)"true").put((Object)"hive.metastore.glue.max-connections", (Object)"10").put((Object)"hive.metastore.glue.max-error-retries", (Object)"20").put((Object)"hive.metastore.glue.default-warehouse-dir", (Object)"/location").put((Object)"hive.metastore.glue.iam-role", (Object)"role").put((Object)"hive.metastore.glue.external-id", (Object)"external-id").put((Object)"hive.metastore.glue.aws-access-key", (Object)"ABC").put((Object)"hive.metastore.glue.aws-secret-key", (Object)"DEF").put((Object)"hive.metastore.glue.aws-credentials-provider", (Object)"custom").put((Object)"hive.metastore.glue.catalogid", (Object)"0123456789").put((Object)"hive.metastore.glue.partitions-segments", (Object)"10").put((Object)"hive.metastore.glue.get-partition-threads", (Object)"42").put((Object)"hive.metastore.glue.assume-canonical-partition-keys", (Object)"true").put((Object)"hive.metastore.glue.read-statistics-threads", (Object)"42").put((Object)"hive.metastore.glue.write-statistics-threads", (Object)"43").buildOrThrow();
        GlueHiveMetastoreConfig expected = new GlueHiveMetastoreConfig().setGlueRegion("us-east-1").setGlueEndpointUrl("http://foo.bar").setGlueStsRegion("us-east-3").setGlueStsEndpointUrl("http://sts.foo.bar").setGlueProxyApiId("abc123").setPinGlueClientToCurrentRegion(true).setMaxGlueConnections(10).setMaxGlueErrorRetries(20).setDefaultWarehouseDir("/location").setIamRole("role").setExternalId("external-id").setAwsAccessKey("ABC").setAwsSecretKey("DEF").setAwsCredentialsProvider("custom").setCatalogId("0123456789").setPartitionSegments(10).setGetPartitionThreads(42).setAssumeCanonicalPartitionKeys(true).setReadStatisticsThreads(42).setWriteStatisticsThreads(43);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

