/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.Order;
import io.trino.hive.thrift.metastore.PrincipalPrivilegeSet;
import io.trino.hive.thrift.metastore.SerDeInfo;
import io.trino.hive.thrift.metastore.SkewedInfo;
import io.trino.hive.thrift.metastore.StorageDescriptor;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMetastoreUtil {
    private static final List<FieldSchema> TEST_SCHEMA = ImmutableList.of((Object)new FieldSchema("col1", "bigint", "comment1"), (Object)new FieldSchema("col2", "binary", null), (Object)new FieldSchema("col3", "string", null));
    private static final StorageDescriptor TEST_STORAGE_DESCRIPTOR = new StorageDescriptor(TEST_SCHEMA, "hdfs://VOL1:9000/db_name/table_name", "com.facebook.hive.orc.OrcInputFormat", "com.facebook.hive.orc.OrcOutputFormat", false, 100, new SerDeInfo("table_name", "com.facebook.hive.orc.OrcSerde", (Map)ImmutableMap.of((Object)"sdk1", (Object)"sdv1", (Object)"sdk2", (Object)"sdv2")), (List)ImmutableList.of((Object)"col2", (Object)"col3"), (List)ImmutableList.of((Object)new Order("col2", 1)), (Map)ImmutableMap.of());
    private static final io.trino.hive.thrift.metastore.Table TEST_TABLE = new io.trino.hive.thrift.metastore.Table("table_name", "db_name", "owner_name", 0, 0, 0, TEST_STORAGE_DESCRIPTOR, (List)ImmutableList.of((Object)new FieldSchema("pk1", "string", "comment pk1"), (Object)new FieldSchema("pk2", "string", null)), (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"), "view original text", "view extended text", "MANAGED_TABLE");
    private static final io.trino.hive.thrift.metastore.Partition TEST_PARTITION;
    private static final StorageDescriptor TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS;
    private static final io.trino.hive.thrift.metastore.Table TEST_TABLE_WITH_UNSUPPORTED_FIELDS;
    private static final io.trino.hive.thrift.metastore.Partition TEST_PARTITION_WITH_UNSUPPORTED_FIELDS;
    private static final Map<String, String> TEST_TABLE_METADATA;

    @Test
    public void testTableRoundTrip() {
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable((io.trino.hive.thrift.metastore.Table)TEST_TABLE, TEST_SCHEMA);
        io.trino.hive.thrift.metastore.Table metastoreApiTable = ThriftMetastoreUtil.toMetastoreApiTable((Table)table, (PrincipalPrivileges)PrincipalPrivileges.NO_PRIVILEGES);
        Assert.assertEquals((Object)metastoreApiTable, (Object)TEST_TABLE);
    }

    @Test
    public void testPartitionRoundTrip() {
        Partition partition = ThriftMetastoreUtil.fromMetastoreApiPartition((io.trino.hive.thrift.metastore.Partition)TEST_PARTITION);
        io.trino.hive.thrift.metastore.Partition metastoreApiPartition = ThriftMetastoreUtil.toMetastoreApiPartition((Partition)partition);
        Assert.assertEquals((Object)metastoreApiPartition, (Object)TEST_PARTITION);
    }

    @Test
    public void testHiveSchemaTable() {
        Properties actual = MetastoreUtil.getHiveSchema((Table)ThriftMetastoreUtil.fromMetastoreApiTable((io.trino.hive.thrift.metastore.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS, TEST_SCHEMA));
        Assert.assertEquals((Map)actual, TEST_TABLE_METADATA);
    }

    @Test
    public void testHiveSchemaPartition() {
        Properties actual = MetastoreUtil.getHiveSchema((Partition)ThriftMetastoreUtil.fromMetastoreApiPartition((io.trino.hive.thrift.metastore.Partition)TEST_PARTITION_WITH_UNSUPPORTED_FIELDS), (Table)ThriftMetastoreUtil.fromMetastoreApiTable((io.trino.hive.thrift.metastore.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS, TEST_SCHEMA));
        Assert.assertEquals((Map)actual, TEST_TABLE_METADATA);
    }

    @Test
    public void testComputePartitionKeyFilter() {
        HiveColumnHandle dsColumn = TestMetastoreUtil.partitionColumn("ds");
        HiveColumnHandle typeColumn = TestMetastoreUtil.partitionColumn("type");
        ImmutableList partitionKeys = ImmutableList.of((Object)dsColumn, (Object)typeColumn);
        Domain dsDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2018-05-06")), (Range[])new Range[0]), (boolean)false);
        Domain typeDomain = Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"fruit"), (Object[])new Object[0]), (boolean)false);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)HiveColumnHandle.bucketColumnHandle(), (Object)Domain.create((ValueSet)ValueSet.of((Type)IntegerType.INTEGER, (Object)123L, (Object[])new Object[0]), (boolean)false)).put((Object)dsColumn, (Object)dsDomain).put((Object)typeColumn, (Object)typeDomain).buildOrThrow());
        TupleDomain filter = MetastoreUtil.computePartitionKeyFilter((List)partitionKeys, (TupleDomain)tupleDomain);
        ((OptionalAssert)Assertions.assertThat((Optional)filter.getDomains()).as("output contains only the partition keys", new Object[0])).contains((Object)ImmutableMap.builder().put((Object)"ds", (Object)dsDomain).put((Object)"type", (Object)typeDomain).buildOrThrow());
    }

    private static HiveColumnHandle partitionColumn(String name) {
        return new HiveColumnHandle(name, 0, HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, Optional.empty(), HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
    }

    static {
        TEST_TABLE.setPrivileges(new PrincipalPrivilegeSet((Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
        TEST_PARTITION = new io.trino.hive.thrift.metastore.Partition((List)ImmutableList.of((Object)"pk1v", (Object)"pk2v"), "db_name", "table_name", 0, 0, TEST_STORAGE_DESCRIPTOR, (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"));
        TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS = new StorageDescriptor(TEST_SCHEMA, "hdfs://VOL1:9000/db_name/table_name", "com.facebook.hive.orc.OrcInputFormat", "com.facebook.hive.orc.OrcOutputFormat", false, 100, new SerDeInfo("table_name", "com.facebook.hive.orc.OrcSerde", (Map)ImmutableMap.of((Object)"sdk1", (Object)"sdv1", (Object)"sdk2", (Object)"sdv2")), (List)ImmutableList.of((Object)"col2", (Object)"col3"), (List)ImmutableList.of((Object)new Order("col2", 0), (Object)new Order("col3", 1)), (Map)ImmutableMap.of((Object)"sk1", (Object)"sv1"));
        TEST_TABLE_WITH_UNSUPPORTED_FIELDS = new io.trino.hive.thrift.metastore.Table("table_name", "db_name", "owner_name", 1234567890, 1234567891, 34, TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS, (List)ImmutableList.of((Object)new FieldSchema("pk1", "string", "comment pk1"), (Object)new FieldSchema("pk2", "string", null)), (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"), "view original text", "view extended text", "MANAGED_TABLE");
        TEST_PARTITION_WITH_UNSUPPORTED_FIELDS = new io.trino.hive.thrift.metastore.Partition((List)ImmutableList.of((Object)"pk1v", (Object)"pk2v"), "db_name", "table_name", 1234567892, 1234567893, TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS, (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"));
        TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS.setSkewedInfo(new SkewedInfo((List)ImmutableList.of((Object)"col1"), (List)ImmutableList.of((Object)ImmutableList.of((Object)"val1")), (Map)ImmutableMap.of((Object)ImmutableList.of((Object)"val1"), (Object)"loc1")));
        TEST_TABLE_METADATA = ImmutableMap.builder().put((Object)"bucket_count", (Object)"100").put((Object)"bucket_field_name", (Object)"col2,col3").put((Object)"columns", (Object)"col1,col2,col3").put((Object)"columns.comments", (Object)"comment1\u0000\u0000").put((Object)"columns.types", (Object)"bigint:binary:string").put((Object)"file.inputformat", (Object)"com.facebook.hive.orc.OrcInputFormat").put((Object)"file.outputformat", (Object)"com.facebook.hive.orc.OrcOutputFormat").put((Object)"k1", (Object)"v1").put((Object)"k2", (Object)"v2").put((Object)"k3", (Object)"v3").put((Object)"location", (Object)"hdfs://VOL1:9000/db_name/table_name").put((Object)"name", (Object)"db_name.table_name").put((Object)"partition_columns", (Object)"pk1/pk2").put((Object)"partition_columns.types", (Object)"string:string").put((Object)"sdk1", (Object)"sdv1").put((Object)"sdk2", (Object)"sdv2").put((Object)"serialization.lib", (Object)"com.facebook.hive.orc.OrcSerde").buildOrThrow();
    }
}

