/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.hive.RecordingMetastoreConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestRecordingMetastoreConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((RecordingMetastoreConfig)ConfigAssertions.recordDefaults(RecordingMetastoreConfig.class)).setRecordingPath(null).setRecordingDuration(new Duration(10.0, TimeUnit.MINUTES)).setReplay(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.metastore-recording-path", (Object)"/foo/bar").put((Object)"hive.metastore-recording-duration", (Object)"42s").put((Object)"hive.replay-metastore-recording", (Object)"true").buildOrThrow();
        RecordingMetastoreConfig expected = new RecordingMetastoreConfig().setRecordingPath("/foo/bar").setRecordingDuration(new Duration(42.0, TimeUnit.SECONDS)).setReplay(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

