/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.block.BlockAssertions;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.hive.TestHiveReaderProjectionsUtil;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestReaderProjectionsAdapter {
    private static final String TEST_COLUMN_NAME = "col";
    private static final Type TEST_COLUMN_TYPE = TestHiveReaderProjectionsUtil.ROWTYPE_OF_ROW_AND_PRIMITIVES;
    private static final Map<String, HiveColumnHandle> TEST_FULL_COLUMNS = TestHiveReaderProjectionsUtil.createTestFullColumns((List<String>)ImmutableList.of((Object)"col"), (Map<String, Type>)ImmutableMap.of((Object)"col", (Object)TEST_COLUMN_TYPE));

    @Test
    public void testAdaptPage() {
        ImmutableList columns = ImmutableList.of((Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get(TEST_COLUMN_NAME), (List<Integer>)ImmutableList.of((Object)0, (Object)0)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get(TEST_COLUMN_NAME), (List<Integer>)ImmutableList.of((Object)0)));
        Optional readerProjections = HivePageSourceProvider.projectBaseColumns((List)columns);
        ArrayList<RowData> inputBlockData = new ArrayList<RowData>();
        inputBlockData.add(RowData.rowData(RowData.rowData(11L, 12L, 13L), 1L));
        inputBlockData.add(RowData.rowData(null, 2L));
        inputBlockData.add(null);
        inputBlockData.add(RowData.rowData(RowData.rowData(31L, 32L, 33L), 3L));
        ReaderProjectionsAdapter adapter = new ReaderProjectionsAdapter((List)columns.stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), (ReaderColumns)readerProjections.get(), column -> ((HiveColumnHandle)column).getType(), HivePageSourceProvider::getProjection);
        this.verifyPageAdaptation(adapter, (List<List<Object>>)ImmutableList.of(inputBlockData));
    }

    @Test
    public void testLazyDereferenceProjectionLoading() {
        ImmutableList columns = ImmutableList.of((Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get(TEST_COLUMN_NAME), (List<Integer>)ImmutableList.of((Object)0, (Object)0)));
        ArrayList<RowData> inputBlockData = new ArrayList<RowData>();
        inputBlockData.add(RowData.rowData(RowData.rowData(11L, 12L, 13L), 1L));
        inputBlockData.add(RowData.rowData(null, 2L));
        inputBlockData.add(null);
        inputBlockData.add(RowData.rowData(RowData.rowData(31L, 32L, 33L), 3L));
        Optional readerProjections = HivePageSourceProvider.projectBaseColumns((List)columns);
        ReaderProjectionsAdapter adapter = new ReaderProjectionsAdapter((List)columns.stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), (ReaderColumns)readerProjections.get(), column -> ((HiveColumnHandle)column).getType(), HivePageSourceProvider::getProjection);
        Page inputPage = TestReaderProjectionsAdapter.createPage((List<List<Object>>)ImmutableList.of(inputBlockData), adapter.getInputTypes());
        adapter.adaptPage(inputPage).getLoadedPage();
        Block lazyBlockLevel1 = inputPage.getBlock(0);
        Assert.assertTrue((boolean)(lazyBlockLevel1 instanceof LazyBlock));
        Assert.assertFalse((boolean)lazyBlockLevel1.isLoaded());
        RowBlock rowBlockLevel1 = (RowBlock)((LazyBlock)lazyBlockLevel1).getBlock();
        Assert.assertFalse((boolean)rowBlockLevel1.isLoaded());
        ColumnarRow columnarRowLevel1 = ColumnarRow.toColumnarRow((Block)rowBlockLevel1);
        Assert.assertFalse((boolean)columnarRowLevel1.getField(0).isLoaded());
        Assert.assertFalse((boolean)columnarRowLevel1.getField(1).isLoaded());
        Block lazyBlockLevel2 = columnarRowLevel1.getField(0);
        Assert.assertTrue((boolean)(lazyBlockLevel2 instanceof LazyBlock));
        RowBlock rowBlockLevel2 = (RowBlock)((LazyBlock)lazyBlockLevel2).getBlock();
        Assert.assertFalse((boolean)rowBlockLevel2.isLoaded());
        ColumnarRow columnarRowLevel2 = ColumnarRow.toColumnarRow((Block)rowBlockLevel2);
        Assert.assertTrue((boolean)columnarRowLevel2.getField(0).isLoaded());
        Assert.assertFalse((boolean)columnarRowLevel2.getField(1).isLoaded());
    }

    private void verifyPageAdaptation(ReaderProjectionsAdapter adapter, List<List<Object>> inputPageData) {
        List columnMapping = adapter.getOutputToInputMapping();
        List outputTypes = adapter.getOutputTypes();
        List inputTypes = adapter.getInputTypes();
        Page inputPage = TestReaderProjectionsAdapter.createPage(inputPageData, inputTypes);
        Page outputPage = adapter.adaptPage(inputPage).getLoadedPage();
        for (int i = 0; i < columnMapping.size(); ++i) {
            ReaderProjectionsAdapter.ChannelMapping mapping = (ReaderProjectionsAdapter.ChannelMapping)columnMapping.get(i);
            int inputBlockIndex = mapping.getInputChannelIndex();
            TestReaderProjectionsAdapter.verifyBlock(outputPage.getBlock(i), (Type)outputTypes.get(i), inputPage.getBlock(inputBlockIndex), (Type)inputTypes.get(inputBlockIndex), mapping.getDereferenceSequence());
        }
    }

    private static Page createPage(List<List<Object>> pageData, List<Type> types) {
        Block[] inputPageBlocks = new Block[pageData.size()];
        for (int i = 0; i < inputPageBlocks.length; ++i) {
            inputPageBlocks[i] = TestReaderProjectionsAdapter.createInputBlock(pageData.get(i), types.get(i));
        }
        return new Page(inputPageBlocks);
    }

    private static Block createInputBlock(List<Object> data, Type type) {
        int positionCount = data.size();
        if (type instanceof RowType) {
            return new LazyBlock(data.size(), () -> TestReaderProjectionsAdapter.createRowBlockWithLazyNestedBlocks(data, (RowType)type));
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return new LazyBlock(positionCount, () -> TestReaderProjectionsAdapter.createLongArrayBlock(data));
        }
        throw new UnsupportedOperationException();
    }

    private static Block createRowBlockWithLazyNestedBlocks(List<Object> data, RowType rowType) {
        int positionCount = data.size();
        boolean[] isNull = new boolean[positionCount];
        int fieldCount = rowType.getFields().size();
        ArrayList fieldsData = new ArrayList();
        for (int i = 0; i < fieldCount; ++i) {
            fieldsData.add(new ArrayList());
        }
        for (int position = 0; position < data.size(); ++position) {
            RowData row = (RowData)data.get(position);
            if (row == null) {
                isNull[position] = true;
                continue;
            }
            for (int field = 0; field < fieldCount; ++field) {
                ((List)fieldsData.get(field)).add(row.getField(field));
            }
        }
        Block[] fieldBlocks = new Block[fieldCount];
        for (int field = 0; field < fieldCount; ++field) {
            fieldBlocks[field] = TestReaderProjectionsAdapter.createInputBlock((List)fieldsData.get(field), ((RowType.Field)rowType.getFields().get(field)).getType());
        }
        return RowBlock.fromFieldBlocks((int)positionCount, Optional.of(isNull), (Block[])fieldBlocks);
    }

    private static Block createLongArrayBlock(List<Object> data) {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, data.size());
        for (int i = 0; i < data.size(); ++i) {
            Long value = (Long)data.get(i);
            if (value == null) {
                builder.appendNull();
                continue;
            }
            BigintType.BIGINT.writeLong(builder, value.longValue());
        }
        return builder.build();
    }

    private static void verifyBlock(Block actualBlock, Type outputType, Block input, Type inputType, List<Integer> dereferences) {
        Block expectedOutputBlock = TestReaderProjectionsAdapter.createProjectedColumnBlock(input, outputType, inputType, dereferences);
        BlockAssertions.assertBlockEquals((Type)outputType, (Block)actualBlock, (Block)expectedOutputBlock);
    }

    private static Block createProjectedColumnBlock(Block data, Type finalType, Type blockType, List<Integer> dereferences) {
        if (dereferences.size() == 0) {
            return data;
        }
        BlockBuilder builder = finalType.createBlockBuilder(null, data.getPositionCount());
        for (int i = 0; i < data.getPositionCount(); ++i) {
            Type sourceType = blockType;
            Block currentData = null;
            boolean isNull = data.isNull(i);
            if (!isNull) {
                currentData = (Block)data.getObject(i, Block.class);
            }
            for (int j = 0; j < dereferences.size() - 1 && !isNull; ++j) {
                Preconditions.checkArgument((boolean)(sourceType instanceof RowType));
                if (currentData.isNull(dereferences.get(j).intValue())) {
                    currentData = null;
                } else {
                    sourceType = ((RowType.Field)((RowType)sourceType).getFields().get(dereferences.get(j))).getType();
                    currentData = (Block)currentData.getObject(dereferences.get(j).intValue(), Block.class);
                }
                isNull = isNull || currentData == null;
            }
            if (isNull) {
                builder.appendNull();
                continue;
            }
            int lastDereference = dereferences.get(dereferences.size() - 1);
            finalType.appendTo(currentData, lastDereference, builder);
        }
        return builder.build();
    }

    static class RowData {
        private final List<? extends Object> data;

        private RowData(Object ... data) {
            this.data = Arrays.asList(Objects.requireNonNull(data, "data is null"));
        }

        static RowData rowData(Object ... data) {
            return new RowData(data);
        }

        List<? extends Object> getData() {
            return this.data;
        }

        Object getField(int field) {
            Preconditions.checkArgument((field >= 0 && field < this.data.size() ? 1 : 0) != 0);
            return this.data.get(field);
        }
    }
}

