/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.TestHiveReaderProjectionsUtil;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestReaderColumns {
    private static final List<String> TEST_COLUMN_NAMES = ImmutableList.of((Object)"col_bigint", (Object)"col_struct_of_primitives", (Object)"col_struct_of_non_primitives", (Object)"col_partition_key_1", (Object)"col_partition_key_2");
    private static final Map<String, Type> TEST_COLUMN_TYPES = ImmutableMap.builder().put((Object)"col_bigint", (Object)BigintType.BIGINT).put((Object)"col_struct_of_primitives", (Object)TestHiveReaderProjectionsUtil.ROWTYPE_OF_PRIMITIVES).put((Object)"col_struct_of_non_primitives", (Object)TestHiveReaderProjectionsUtil.ROWTYPE_OF_ROW_AND_PRIMITIVES).put((Object)"col_partition_key_1", (Object)BigintType.BIGINT).put((Object)"col_partition_key_2", (Object)BigintType.BIGINT).buildOrThrow();
    private static final Map<String, HiveColumnHandle> TEST_FULL_COLUMNS = TestHiveReaderProjectionsUtil.createTestFullColumns(TEST_COLUMN_NAMES, TEST_COLUMN_TYPES);

    @Test
    public void testNoProjections() {
        ArrayList<HiveColumnHandle> columns = new ArrayList<HiveColumnHandle>(TEST_FULL_COLUMNS.values());
        Optional mapping = HivePageSourceProvider.projectBaseColumns(columns);
        Assert.assertTrue((boolean)mapping.isEmpty(), (String)"Full columns should not require any adaptation");
        mapping = HivePageSourceProvider.projectSufficientColumns(columns);
        Assert.assertTrue((boolean)mapping.isEmpty(), (String)"Full columns should not require any adaptation");
    }

    @Test
    public void testBaseColumnsProjection() {
        ImmutableList columns = ImmutableList.of((Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_primitives"), (List<Integer>)ImmutableList.of((Object)0)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_primitives"), (List<Integer>)ImmutableList.of((Object)1)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_bigint"), (List<Integer>)ImmutableList.of()), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_non_primitives"), (List<Integer>)ImmutableList.of((Object)0, (Object)1)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_non_primitives"), (List<Integer>)ImmutableList.of((Object)0)));
        Optional mapping = HivePageSourceProvider.projectBaseColumns((List)columns);
        Assert.assertTrue((boolean)mapping.isPresent(), (String)"Full columns should be created for corresponding projected columns");
        List readerColumns = (List)((ReaderColumns)mapping.get()).get().stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        for (int i = 0; i < columns.size(); ++i) {
            HiveColumnHandle column = (HiveColumnHandle)columns.get(i);
            int readerIndex = ((ReaderColumns)mapping.get()).getPositionForColumnAt(i);
            HiveColumnHandle readerColumn = (HiveColumnHandle)((ReaderColumns)mapping.get()).getForColumnAt(i);
            Assert.assertEquals((Object)column.getBaseColumn(), (Object)readerColumn);
            Assert.assertEquals(readerColumns.get(readerIndex), (Object)readerColumn);
        }
    }

    @Test
    public void testProjectSufficientColumns() {
        ImmutableList columns = ImmutableList.of((Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_primitives"), (List<Integer>)ImmutableList.of((Object)0)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_primitives"), (List<Integer>)ImmutableList.of((Object)1)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_bigint"), (List<Integer>)ImmutableList.of()), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_non_primitives"), (List<Integer>)ImmutableList.of((Object)0, (Object)1)), (Object)TestHiveReaderProjectionsUtil.createProjectedColumnHandle(TEST_FULL_COLUMNS.get("col_struct_of_non_primitives"), (List<Integer>)ImmutableList.of((Object)0)));
        Optional readerProjections = HivePageSourceProvider.projectSufficientColumns((List)columns);
        Assert.assertTrue((boolean)readerProjections.isPresent(), (String)"expected readerProjections to be present");
        Assert.assertEquals((Object)((ReaderColumns)readerProjections.get()).getForColumnAt(0), columns.get(0));
        Assert.assertEquals((Object)((ReaderColumns)readerProjections.get()).getForColumnAt(1), columns.get(1));
        Assert.assertEquals((Object)((ReaderColumns)readerProjections.get()).getForColumnAt(2), columns.get(2));
        Assert.assertEquals((Object)((ReaderColumns)readerProjections.get()).getForColumnAt(3), columns.get(4));
        Assert.assertEquals((Object)((ReaderColumns)readerProjections.get()).getForColumnAt(4), columns.get(4));
        Assert.assertEquals((int)((ReaderColumns)readerProjections.get()).getPositionForColumnAt(0), (int)0);
        Assert.assertEquals((int)((ReaderColumns)readerProjections.get()).getPositionForColumnAt(1), (int)1);
        Assert.assertEquals((int)((ReaderColumns)readerProjections.get()).getPositionForColumnAt(2), (int)2);
        Assert.assertEquals((int)((ReaderColumns)readerProjections.get()).getPositionForColumnAt(3), (int)3);
        Assert.assertEquals((int)((ReaderColumns)readerProjections.get()).getPositionForColumnAt(4), (int)3);
        List readerColumns = (List)((ReaderColumns)readerProjections.get()).get().stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        Assert.assertEquals(readerColumns.get(0), columns.get(0));
        Assert.assertEquals(readerColumns.get(1), columns.get(1));
        Assert.assertEquals(readerColumns.get(2), columns.get(2));
        Assert.assertEquals(readerColumns.get(3), columns.get(4));
    }
}

