/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.filesystem.Location;
import io.trino.plugin.hive.HiveWriterFactory;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveWriterFactory {
    @Test
    public void testComputeBucketedFileName() {
        String name = HiveWriterFactory.computeNonTransactionalBucketedFilename((String)"20180102_030405_00641_x1y2z", (int)1234);
        Assertions.assertThat((String)name).matches((CharSequence)"001234_0_.*_20180102_030405_00641_x1y2z");
        Assert.assertEquals((int)Utilities.getBucketIdFromFile((String)name), (int)1234);
        name = HiveWriterFactory.computeTransactionalBucketedFilename((int)1234);
        Assert.assertEquals((String)name, (String)"001234_0");
        Assert.assertEquals((int)Utilities.getBucketIdFromFile((String)name), (int)1234);
    }

    @Test
    public void testSetsSchemeToFile() {
        String pathWithoutScheme = "/simple/file/path";
        String result = HiveWriterFactory.setSchemeToFileIfAbsent((Location)Location.of((String)pathWithoutScheme)).toString();
        Assertions.assertThat((String)result).isEqualTo("file:///simple/file/path");
        URI resultUri = new Path(result).toUri();
        Assertions.assertThat((String)resultUri.getScheme()).isEqualTo("file");
        Assertions.assertThat((String)resultUri.getPath()).isEqualTo("/simple/file/path");
        String pathWithScheme = "s3://simple/file/path";
        result = HiveWriterFactory.setSchemeToFileIfAbsent((Location)Location.of((String)pathWithScheme)).toString();
        Assertions.assertThat((String)result).isEqualTo(pathWithScheme);
        resultUri = new Path(result).toUri();
        Assertions.assertThat((String)resultUri.getScheme()).isEqualTo("s3");
        Assertions.assertThat((String)resultUri.getPath()).isEqualTo("/file/path");
        String pathWithEmptySpaces = "/simple/file 1/path";
        result = HiveWriterFactory.setSchemeToFileIfAbsent((Location)Location.of((String)pathWithEmptySpaces)).toString();
        Assertions.assertThat((String)result).isEqualTo("file:///simple/file 1/path");
        resultUri = new Path(result).toUri();
        Assertions.assertThat((String)resultUri.getScheme()).isEqualTo("file");
        Assertions.assertThat((String)resultUri.getPath()).isEqualTo("/simple/file 1/path");
        String pathWithEmptySpacesAndScheme = "s3://simple/file 1/path";
        result = HiveWriterFactory.setSchemeToFileIfAbsent((Location)Location.of((String)pathWithEmptySpacesAndScheme)).toString();
        Assertions.assertThat((String)result).isEqualTo(pathWithEmptySpacesAndScheme);
        resultUri = new Path(result).toUri();
        Assertions.assertThat((String)resultUri.getScheme()).isEqualTo("s3");
        Assertions.assertThat((String)resultUri.getPath()).isEqualTo("/file 1/path");
        String pathWithAtSign = "/tmp/user@example.com";
        result = HiveWriterFactory.setSchemeToFileIfAbsent((Location)Location.of((String)pathWithAtSign)).toString();
        Assertions.assertThat((String)result).isEqualTo("file:///tmp/user@example.com");
        resultUri = new Path(result).toUri();
        Assertions.assertThat((String)resultUri.getScheme()).isEqualTo("file");
        Assertions.assertThat((String)resultUri.getPath()).isEqualTo("/tmp/user@example.com");
    }
}

