/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.NamedTypeSignature;
import io.trino.spi.type.RowFieldName;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.type.InternalTypeManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TestHiveReaderProjectionsUtil {
    public static final RowType ROWTYPE_OF_PRIMITIVES = HiveTestUtils.rowType((List<NamedTypeSignature>)ImmutableList.of((Object)new NamedTypeSignature(Optional.of(new RowFieldName("f_bigint_0")), BigintType.BIGINT.getTypeSignature()), (Object)new NamedTypeSignature(Optional.of(new RowFieldName("f_bigint_1")), BigintType.BIGINT.getTypeSignature())));
    public static final RowType ROWTYPE_OF_ROW_AND_PRIMITIVES = HiveTestUtils.rowType((List<NamedTypeSignature>)ImmutableList.of((Object)new NamedTypeSignature(Optional.of(new RowFieldName("f_row_0")), ROWTYPE_OF_PRIMITIVES.getTypeSignature()), (Object)new NamedTypeSignature(Optional.of(new RowFieldName("f_bigint_0")), BigintType.BIGINT.getTypeSignature())));

    private TestHiveReaderProjectionsUtil() {
    }

    public static Map<String, HiveColumnHandle> createTestFullColumns(List<String> names, Map<String, Type> types) {
        Preconditions.checkArgument((names.size() == types.size() ? 1 : 0) != 0);
        ImmutableMap.Builder hiveColumns = ImmutableMap.builder();
        int regularColumnHiveIndex = 0;
        for (String name : names) {
            HiveType hiveType = HiveType.toHiveType((Type)types.get(name));
            hiveColumns.put((Object)name, (Object)HiveColumnHandle.createBaseColumn((String)name, (int)regularColumnHiveIndex, (HiveType)hiveType, (Type)types.get(name), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
            ++regularColumnHiveIndex;
        }
        return hiveColumns.buildOrThrow();
    }

    public static HiveColumnHandle createProjectedColumnHandle(HiveColumnHandle column, List<Integer> indices) {
        Preconditions.checkArgument((boolean)column.isBaseColumn(), (Object)"base column is expected here");
        if (indices.size() == 0) {
            return column;
        }
        HiveType baseHiveType = column.getHiveType();
        List names = baseHiveType.getHiveDereferenceNames(indices);
        HiveType hiveType = (HiveType)baseHiveType.getHiveTypeForDereferences(indices).get();
        HiveColumnProjectionInfo columnProjection = new HiveColumnProjectionInfo(indices, names, hiveType, hiveType.getType(InternalTypeManager.TESTING_TYPE_MANAGER));
        return new HiveColumnHandle(column.getBaseColumnName(), column.getBaseHiveColumnIndex(), column.getBaseHiveType(), column.getBaseType(), Optional.of(columnProjection), column.getColumnType(), column.getComment());
    }
}

