/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveToTrinoTranslator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveQlTranslation {
    private final SqlParser parser = new SqlParser();
    private static Map<String, String> simpleColumnNames = ImmutableMap.builder().put((Object)"unquoted", (Object)"unquoted").put((Object)"`backquoted`", (Object)"\"backquoted\"").put((Object)"`sometable`.`backquoted`", (Object)"\"sometable\".\"backquoted\"").put((Object)"'single quoted'", (Object)"'single quoted'").put((Object)"\"double quoted\"", (Object)"'double quoted'").put((Object)"''", (Object)"''").put((Object)"\"\"", (Object)"''").put((Object)"'\\''", (Object)"''''").put((Object)"\"\\\"\"", (Object)"'\"'").buildOrThrow();
    private static Map<String, String> extendedColumnNames = ImmutableMap.builder().putAll(simpleColumnNames).put((Object)"`id: ``back`", (Object)"\"id: `back\"").put((Object)"`id: \"double`", (Object)"\"id: \"\"double\"").put((Object)"`id: \"\"two double`", (Object)"\"id: \"\"\"\"two double\"").put((Object)"`id: two back`````", (Object)"\"id: two back``\"").put((Object)"'single: \"double'", (Object)"'single: \"double'").put((Object)"'single: \\'single'", (Object)"'single: ''single'").put((Object)"'single: \\'\\'two singles'", (Object)"'single: ''''two singles'").put((Object)"\"double: double\\\"\"", (Object)"'double: double\"'").put((Object)"\"double: single'\"", (Object)"'double: single'''").put((Object)"\"double: two singles''\"", (Object)"'double: two singles'''''").buildOrThrow();

    private static Iterator<Object[]> getNColumns(int n, Map<String, String> columns) {
        Stream<String> hiveNames = Sets.cartesianProduct(Collections.nCopies(n, columns.keySet())).stream().map(names -> String.join((CharSequence)", ", names));
        Stream<String> trinoNames = Lists.cartesianProduct(Collections.nCopies(n, List.copyOf(columns.values()))).stream().map(names -> String.join((CharSequence)", ", names));
        return Streams.zip(hiveNames, trinoNames, (h, p) -> new Object[]{h, p}).iterator();
    }

    @DataProvider(name="simple_hive_translation_columns")
    public Iterator<Object[]> getSimpleColumns() {
        return Iterators.concat(TestHiveQlTranslation.getNColumns(1, simpleColumnNames), TestHiveQlTranslation.getNColumns(3, simpleColumnNames));
    }

    @DataProvider(name="extended_hive_translation_columns")
    public Iterator<Object[]> getExtendedColumns() {
        return Iterators.concat(TestHiveQlTranslation.getNColumns(1, extendedColumnNames), TestHiveQlTranslation.getNColumns(2, extendedColumnNames));
    }

    @Test
    public void testIdentifiers() {
        this.assertTranslation("SELECT * FROM nation", "SELECT * FROM nation");
        this.assertTranslation("SELECT * FROM `nation`", "SELECT * FROM \"nation\"");
        this.assertTranslation("SELECT `nation`.`nationkey` FROM `nation`", "SELECT \"nation\".\"nationkey\" FROM \"nation\"");
        this.assertTranslation("SELECT * FROM `it's a table`", "SELECT * FROM \"it's a table\"");
    }

    @Test
    public void testNumberLiterals() {
        this.assertTranslation("SELECT 1", "SELECT 1");
    }

    @Test
    public void testStringLiterals() {
        this.assertTranslation("SELECT '`'", "SELECT '`'");
        this.assertTranslation("SELECT 'it\\'s an \"apple\"'", "SELECT 'it''s an \"apple\"'");
        this.assertTranslation("SELECT \"it's an \\\"apple\\\"\"", "SELECT 'it''s an \"apple\"'");
        this.assertTranslation("SELECT \"`\"", "SELECT '`'");
        this.assertTranslation("SELECT '\"'", "SELECT '\"'");
        this.assertTranslation("SELECT \"'\"", "SELECT ''''");
        this.assertTranslation("SELECT '\\'`'", "SELECT '''`'");
        this.assertTranslation("SELECT '\\\\\\''", "SELECT '\\'''");
        this.assertTranslation("SELECT \"\\'`\"", "SELECT '''`'");
    }

    @Test
    public void testStringLiteralsWithNewLine() {
        this.assertTranslation("SELECT \"'\n'\"", "SELECT '''\n'''");
        this.assertTranslation("SELECT '\\'\n`'", "SELECT '''\n`'");
        this.assertTranslation("SELECT \"\\\n'`\"", "SELECT '\n''`'");
    }

    @Test
    public void testPredicates() {
        this.assertTranslation("SELECT \"'\" = \"'\" OR false", "SELECT '''' = '''' OR false");
    }

    @Test(dataProvider="simple_hive_translation_columns")
    public void testSimpleColumns(String hiveColumn, String trinoColumn) {
        this.assertTranslation(String.format("SELECT %s FROM sometable", hiveColumn), String.format("SELECT %s FROM sometable", trinoColumn));
    }

    @Test(dataProvider="extended_hive_translation_columns")
    public void testExtendedColumns(String hiveColumn, String trinoColumn) {
        this.assertTranslation(String.format("SELECT %s FROM sometable", hiveColumn), String.format("SELECT %s FROM sometable", trinoColumn));
    }

    @Test
    public void testEarlyEndOfInput() {
        String inString = "unexpected end of input in string";
        String inIdentifier = "unexpected end of input in identifier";
        this.assertViewTranslationError("SELECT \"open", inString);
        this.assertViewTranslationError("SELECT 'open", inString);
        this.assertViewTranslationError("SELECT `open", inIdentifier);
        this.assertViewTranslationError("SELECT \"open\\\"", inString);
        this.assertViewTranslationError("SELECT 'open\\'", inString);
        this.assertViewTranslationError("SELECT `open``", inIdentifier);
    }

    @Test
    public void testStringEscapes() {
        this.assertTranslation("SELECT '\\n' FROM sometable", "SELECT '\n' FROM sometable");
        this.assertTranslation("SELECT 'abc\\u03B5xyz' FROM sometable", "SELECT 'abc\u03b5xyz' FROM sometable");
    }

    private void assertTranslation(String hiveSql, String expectedTrinoSql) {
        String actualTrinoSql = HiveToTrinoTranslator.translateHiveViewToTrino((String)hiveSql);
        Assert.assertEquals((String)actualTrinoSql, (String)expectedTrinoSql);
        this.assertTrinoSqlIsParsable(expectedTrinoSql);
        this.assertTrinoSqlIsParsable(actualTrinoSql);
    }

    private void assertTrinoSqlIsParsable(String actualTrinoSql) {
        this.parser.createStatement(actualTrinoSql, new ParsingOptions());
    }

    private void assertViewTranslationError(String badHiveQl, String expectMessage) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> HiveToTrinoTranslator.translateHiveViewToTrino((String)badHiveQl)).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_VIEW_TRANSLATION_ERROR}).hasMessageContaining(expectMessage);
    }
}

