/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.concurrent.MoreFutures;
import io.airlift.event.client.EventClient;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.operator.GroupByHashPageIndexerFactory;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveCompressionOption;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveEventClient;
import io.trino.plugin.hive.HiveLocationService;
import io.trino.plugin.hive.HiveOutputTableHandle;
import io.trino.plugin.hive.HivePageSinkProvider;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveWriterStats;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.SortingFileWriterConfig;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.HivePageSinkMetadata;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.spi.NodeManager;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.SplitWeight;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinCompiler;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingNodeManager;
import io.trino.testing.TestingPageSinkId;
import io.trino.tpch.LineItem;
import io.trino.tpch.LineItemColumn;
import io.trino.tpch.LineItemGenerator;
import io.trino.tpch.TpchColumnType;
import io.trino.tpch.TpchColumnTypes;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHivePageSink {
    private static final int NUM_ROWS = 1000;
    private static final String SCHEMA_NAME = "test";
    private static final String TABLE_NAME = "test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllFormats() throws Exception {
        HiveConfig config = new HiveConfig();
        SortingFileWriterConfig sortingFileWriterConfig = new SortingFileWriterConfig();
        File tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        try {
            FileHiveMetastore metastore = TestingFileHiveMetastore.createTestingFileHiveMetastore(new File(tempDir, "metastore"));
            for (HiveStorageFormat format : HiveStorageFormat.values()) {
                if (format == HiveStorageFormat.CSV || format == HiveStorageFormat.REGEX) continue;
                config.setHiveStorageFormat(format);
                config.setHiveCompressionCodec(HiveCompressionOption.NONE);
                long uncompressedLength = TestHivePageSink.writeTestFile(config, sortingFileWriterConfig, (HiveMetastore)metastore, TestHivePageSink.makeFileName(tempDir, config));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(uncompressedLength), (Comparable)Long.valueOf(0L));
                for (HiveCompressionOption codec : HiveCompressionOption.values()) {
                    if (codec == HiveCompressionOption.NONE || format == HiveStorageFormat.PARQUET && codec == HiveCompressionOption.LZ4) continue;
                    config.setHiveCompressionCodec(codec);
                    if (!this.isSupportedCodec(format, codec)) {
                        org.assertj.core.api.Assertions.assertThatThrownBy(() -> TestHivePageSink.lambda$testAllFormats$0(config, sortingFileWriterConfig, (HiveMetastore)metastore, tempDir)).hasMessage("Compression codec " + codec + " not supported for " + format);
                        continue;
                    }
                    long length = TestHivePageSink.writeTestFile(config, sortingFileWriterConfig, (HiveMetastore)metastore, TestHivePageSink.makeFileName(tempDir, config));
                    Assert.assertTrue((uncompressedLength > length ? 1 : 0) != 0, (String)String.format("%s with %s compressed to %s which is not less than %s", format, codec, length, uncompressedLength));
                }
            }
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    private boolean isSupportedCodec(HiveStorageFormat storageFormat, HiveCompressionOption compressionOption) {
        return storageFormat != HiveStorageFormat.AVRO || compressionOption != HiveCompressionOption.LZ4;
    }

    private static String makeFileName(File tempDir, HiveConfig config) {
        return tempDir.getAbsolutePath() + "/" + config.getHiveStorageFormat().name() + "." + config.getHiveCompressionCodec().name();
    }

    private static long writeTestFile(HiveConfig config, SortingFileWriterConfig sortingFileWriterConfig, HiveMetastore metastore, String outputPath) {
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        HiveWriterStats stats = new HiveWriterStats();
        ConnectorPageSink pageSink = TestHivePageSink.createPageSink(transaction, config, sortingFileWriterConfig, metastore, Location.of((String)("file:///" + outputPath)), stats);
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        List<Type> columnTypes = columns.stream().map(LineItemColumn::getType).map(TestHivePageSink::getHiveType).map(hiveType -> hiveType.getType(InternalTypeManager.TESTING_TYPE_MANAGER)).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(columnTypes);
        int rows = 0;
        for (LineItem lineItem : new LineItemGenerator(0.01, 1, 1)) {
            if (++rows >= 1000) break;
            pageBuilder.declarePosition();
            block8: for (int i = 0; i < columns.size(); ++i) {
                LineItemColumn column = columns.get(i);
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                switch (column.getType().getBase()) {
                    case IDENTIFIER: {
                        BigintType.BIGINT.writeLong(blockBuilder, column.getIdentifier(lineItem));
                        continue block8;
                    }
                    case INTEGER: {
                        IntegerType.INTEGER.writeLong(blockBuilder, (long)column.getInteger(lineItem));
                        continue block8;
                    }
                    case DATE: {
                        DateType.DATE.writeLong(blockBuilder, (long)column.getDate(lineItem));
                        continue block8;
                    }
                    case DOUBLE: {
                        DoubleType.DOUBLE.writeDouble(blockBuilder, column.getDouble(lineItem));
                        continue block8;
                    }
                    case VARCHAR: {
                        VarcharType.createUnboundedVarcharType().writeSlice(blockBuilder, Slices.utf8Slice((String)column.getString(lineItem)));
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type " + column.getType());
                    }
                }
            }
        }
        Page page = pageBuilder.build();
        pageSink.appendPage(page);
        MoreFutures.getFutureValue((Future)pageSink.finish());
        File outputDir = new File(outputPath);
        ImmutableList files = ImmutableList.copyOf((Object[])outputDir.listFiles((dir, name) -> !name.endsWith(".crc")));
        File outputFile = (File)Iterables.getOnlyElement((Iterable)files);
        long length = outputFile.length();
        ConnectorPageSource pageSource = TestHivePageSink.createPageSource(transaction, config, outputFile);
        ArrayList<Page> pages = new ArrayList<Page>();
        while (!pageSource.isFinished()) {
            Page nextPage = pageSource.getNextPage();
            if (nextPage == null) continue;
            pages.add(nextPage.getLoadedPage());
        }
        MaterializedResult expectedResults = TestHivePageSink.toMaterializedResult(HiveTestUtils.getHiveSession(config), columnTypes, (List<Page>)ImmutableList.of((Object)page));
        MaterializedResult results = TestHivePageSink.toMaterializedResult(HiveTestUtils.getHiveSession(config), columnTypes, pages);
        org.assertj.core.api.Assertions.assertThat((Iterable)results).containsExactlyElementsOf((Iterable)expectedResults);
        Assert.assertEquals((long)Math.round(stats.getInputPageSizeInBytes().getAllTime().getMax()), (long)page.getRetainedSizeInBytes());
        return length;
    }

    public static MaterializedResult toMaterializedResult(ConnectorSession session, List<Type> types, List<Page> pages) {
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((ConnectorSession)session, types);
        for (Page outputPage : pages) {
            resultBuilder.page(outputPage);
        }
        return resultBuilder.build();
    }

    private static ConnectorPageSource createPageSource(HiveTransactionHandle transaction, HiveConfig config, File outputFile) {
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", config.getHiveStorageFormat().getInputFormat());
        splitProperties.setProperty("serialization.lib", config.getHiveStorageFormat().getSerde());
        splitProperties.setProperty("columns", Joiner.on((char)',').join((Iterable)TestHivePageSink.getColumnHandles().stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList())));
        splitProperties.setProperty("columns.types", Joiner.on((char)',').join((Iterable)TestHivePageSink.getColumnHandles().stream().map(HiveColumnHandle::getHiveType).map(hiveType -> hiveType.getHiveTypeName().toString()).collect(ImmutableList.toImmutableList())));
        HiveSplit split = new HiveSplit("", "file:///" + outputFile.getAbsolutePath(), 0L, outputFile.length(), outputFile.length(), outputFile.lastModified(), splitProperties, (List)ImmutableList.of(), (List)ImmutableList.of(), OptionalInt.empty(), OptionalInt.empty(), false, TableToPartitionMapping.empty(), Optional.empty(), Optional.empty(), Optional.empty(), SplitWeight.standard());
        HiveTableHandle table = new HiveTableHandle("test", "test", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        HivePageSourceProvider provider = new HivePageSourceProvider(InternalTypeManager.TESTING_TYPE_MANAGER, config, HiveTestUtils.getDefaultHivePageSourceFactories(HiveTestUtils.HDFS_ENVIRONMENT, config));
        return provider.createPageSource((ConnectorTransactionHandle)transaction, HiveTestUtils.getHiveSession(config), (ConnectorSplit)split, (ConnectorTableHandle)table, (List)ImmutableList.copyOf(TestHivePageSink.getColumnHandles()), DynamicFilter.EMPTY);
    }

    private static ConnectorPageSink createPageSink(HiveTransactionHandle transaction, HiveConfig config, SortingFileWriterConfig sortingFileWriterConfig, HiveMetastore metastore, Location outputPath, HiveWriterStats stats) {
        LocationHandle locationHandle = new LocationHandle(outputPath, outputPath, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
        HiveOutputTableHandle handle = new HiveOutputTableHandle("test", "test", TestHivePageSink.getColumnHandles(), new HivePageSinkMetadata(new SchemaTableName("test", "test"), metastore.getTable("test", "test"), (Map)ImmutableMap.of()), locationHandle, config.getHiveStorageFormat(), config.getHiveStorageFormat(), (List)ImmutableList.of(), Optional.empty(), "test", (Map)ImmutableMap.of(), AcidTransaction.NO_ACID_TRANSACTION, false, false);
        JsonCodec partitionUpdateCodec = JsonCodec.jsonCodec(PartitionUpdate.class);
        TypeOperators typeOperators = new TypeOperators();
        HivePageSinkProvider provider = new HivePageSinkProvider(HiveTestUtils.getDefaultHiveFileWriterFactories(config, HiveTestUtils.HDFS_ENVIRONMENT), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, HiveTestUtils.PAGE_SORTER, HiveMetastoreFactory.ofInstance((HiveMetastore)metastore), (PageIndexerFactory)new GroupByHashPageIndexerFactory(new JoinCompiler(typeOperators), typeOperators), InternalTypeManager.TESTING_TYPE_MANAGER, config, sortingFileWriterConfig, (LocationService)new HiveLocationService(HiveTestUtils.HDFS_ENVIRONMENT, config), partitionUpdateCodec, (NodeManager)new TestingNodeManager("fake-environment"), (EventClient)new HiveEventClient(), HiveTestUtils.getHiveSessionProperties(config), stats);
        return provider.createPageSink((ConnectorTransactionHandle)transaction, HiveTestUtils.getHiveSession(config), (ConnectorOutputTableHandle)handle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
    }

    private static List<HiveColumnHandle> getColumnHandles() {
        ImmutableList.Builder handles = ImmutableList.builder();
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        for (int i = 0; i < columns.size(); ++i) {
            LineItemColumn column = columns.get(i);
            HiveType hiveType = TestHivePageSink.getHiveType(column.getType());
            handles.add((Object)HiveColumnHandle.createBaseColumn((String)column.getColumnName(), (int)i, (HiveType)hiveType, (Type)hiveType.getType(InternalTypeManager.TESTING_TYPE_MANAGER), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        }
        return handles.build();
    }

    private static List<LineItemColumn> getTestColumns() {
        return Stream.of(LineItemColumn.values()).filter(column -> !column.getType().equals((Object)TpchColumnTypes.DATE)).collect(Collectors.toList());
    }

    private static HiveType getHiveType(TpchColumnType type) {
        switch (type.getBase()) {
            case IDENTIFIER: {
                return HiveType.HIVE_LONG;
            }
            case INTEGER: {
                return HiveType.HIVE_INT;
            }
            case DATE: {
                return HiveType.HIVE_DATE;
            }
            case DOUBLE: {
                return HiveType.HIVE_DOUBLE;
            }
            case VARCHAR: {
                return HiveType.HIVE_STRING;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void lambda$testAllFormats$0(HiveConfig config, SortingFileWriterConfig sortingFileWriterConfig, HiveMetastore metastore, File tempDir) throws Throwable {
        TestHivePageSink.writeTestFile(config, sortingFileWriterConfig, metastore, TestHivePageSink.makeFileName(tempDir, config));
    }
}

