/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.trino.filesystem.Location;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveLocationService;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.TestBackgroundHiveSplitLoader;
import io.trino.spi.TrinoException;
import java.util.List;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveLocationService {
    @Test
    public void testGetTableWriteInfoAppend() {
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY), false).producesWriteInfo(TestHiveLocationService.writeInfo("/target", "/write", LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY));
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY, "/target", "/target"), false).producesWriteInfo(TestHiveLocationService.writeInfo("/target", "/target", LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY));
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY, "/target", "/target"), false).producesWriteInfo(TestHiveLocationService.writeInfo("/target", "/target", LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY));
    }

    @Test
    public void testGetTableWriteInfoOverwriteSuccess() {
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY), true).producesWriteInfo(TestHiveLocationService.writeInfo("/target", "/write", LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY));
    }

    @Test(expectedExceptions={TrinoException.class}, expectedExceptionsMessageRegExp="Overwriting unpartitioned table not supported when writing directly to target directory")
    public void testGetTableWriteInfoOverwriteFailDirectNew() {
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY, "/target", "/target"), true);
    }

    @Test(expectedExceptions={TrinoException.class}, expectedExceptionsMessageRegExp="Overwriting unpartitioned table not supported when writing directly to target directory")
    public void testGetTableWriteInfoOverwriteFailDirectExisting() {
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY, "/target", "/target"), true);
    }

    private static Assertion assertThat(LocationHandle locationHandle, boolean overwrite) {
        return new Assertion(locationHandle, overwrite);
    }

    private static LocationHandle locationHandle(LocationHandle.WriteMode writeMode) {
        return TestHiveLocationService.locationHandle(writeMode, "/target", "/write");
    }

    private static LocationHandle locationHandle(LocationHandle.WriteMode writeMode, String targetPath, String writePath) {
        return new LocationHandle(Location.of((String)targetPath), Location.of((String)writePath), writeMode);
    }

    private static LocationService.WriteInfo writeInfo(String targetPath, String writePath, LocationHandle.WriteMode writeMode) {
        return new LocationService.WriteInfo(Location.of((String)targetPath), Location.of((String)writePath), writeMode);
    }

    public static class Assertion {
        private final LocationService.WriteInfo actual;

        public Assertion(LocationHandle locationHandle, boolean overwrite) {
            TestBackgroundHiveSplitLoader.TestingHdfsEnvironment hdfsEnvironment = new TestBackgroundHiveSplitLoader.TestingHdfsEnvironment((List<LocatedFileStatus>)ImmutableList.of());
            HiveLocationService service = new HiveLocationService((HdfsEnvironment)hdfsEnvironment, new HiveConfig());
            this.actual = service.getTableWriteInfo(locationHandle, overwrite);
        }

        public void producesWriteInfo(LocationService.WriteInfo expected) {
            Assert.assertEquals((Object)this.actual.writePath(), (Object)expected.writePath());
            Assert.assertEquals((Object)this.actual.targetPath(), (Object)expected.targetPath());
            Assert.assertEquals((Object)this.actual.writeMode(), (Object)expected.writeMode());
        }
    }
}

