/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hive.formats.compression.CompressionKind;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcWriterOptions;
import io.trino.plugin.hive.AbstractTestHiveFileFormats;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.RcFileFileWriterFactory;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.avro.AvroFileWriterFactory;
import io.trino.plugin.hive.avro.AvroPageSourceFactory;
import io.trino.plugin.hive.line.CsvFileWriterFactory;
import io.trino.plugin.hive.line.CsvPageSourceFactory;
import io.trino.plugin.hive.line.JsonFileWriterFactory;
import io.trino.plugin.hive.line.JsonPageSourceFactory;
import io.trino.plugin.hive.line.OpenXJsonFileWriterFactory;
import io.trino.plugin.hive.line.OpenXJsonPageSourceFactory;
import io.trino.plugin.hive.line.SimpleSequenceFilePageSourceFactory;
import io.trino.plugin.hive.line.SimpleSequenceFileWriterFactory;
import io.trino.plugin.hive.line.SimpleTextFilePageSourceFactory;
import io.trino.plugin.hive.line.SimpleTextFileWriterFactory;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetFileWriterFactory;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.testing.StructuralTestUtil;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.mapred.FileSplit;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveFileFormats
extends AbstractTestHiveFileFormats {
    private static final FileFormatDataSourceStats STATS = new FileFormatDataSourceStats();
    private static final ConnectorSession PARQUET_SESSION = HiveTestUtils.getHiveSession(TestHiveFileFormats.createParquetHiveConfig(false));
    private static final ConnectorSession PARQUET_SESSION_USE_NAME = HiveTestUtils.getHiveSession(TestHiveFileFormats.createParquetHiveConfig(true));
    private static final TrinoFileSystemFactory FILE_SYSTEM_FACTORY = new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS);
    private static final HivePageSourceFactory PARQUET_PAGE_SOURCE_FACTORY = new ParquetPageSourceFactory(FILE_SYSTEM_FACTORY, STATS, new ParquetReaderConfig(), new HiveConfig());

    @DataProvider(name="rowCount")
    public static Object[][] rowCountProvider() {
        return new Object[][]{{0}, {1000}};
    }

    @DataProvider(name="validRowAndFileSizePadding")
    public static Object[][] validFileSizePaddingProvider() {
        return new Object[][]{{0, 0L}, {0, 16L}, {10, 1L}, {1000, 64L}};
    }

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        Assert.assertEquals((String)TimeZone.getDefault().getID(), (String)"America/Bahia_Banderas", (String)"Timezone not configured correctly. Add -Duser.timezone=America/Bahia_Banderas to your JVM arguments");
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testTextFile(int rowCount, long fileSizePadding) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withFileWriterFactory((HiveFileWriterFactory)new SimpleTextFileWriterFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource((HivePageSourceFactory)new SimpleTextFilePageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testSequenceFile(int rowCount, long fileSizePadding) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withFileWriterFactory((HiveFileWriterFactory)new SimpleSequenceFileWriterFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"))).isReadableByPageSource((HivePageSourceFactory)new SimpleSequenceFilePageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testCsvFile(int rowCount, long fileSizePadding) throws Exception {
        List testColumns = (List)TEST_COLUMNS.stream().filter(column -> column.isPartitionKey() || "string".equals(column.getType()) && !column.getName().contains("_null_")).collect(ImmutableList.toImmutableList());
        Assert.assertTrue((testColumns.size() > 5 ? 1 : 0) != 0);
        this.assertThatFileFormat(HiveStorageFormat.CSV).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withFileWriterFactory((HiveFileWriterFactory)new CsvFileWriterFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource((HivePageSourceFactory)new CsvPageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test
    public void testCsvFileWithNullAndValue() throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.CSV).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)new AbstractTestHiveFileFormats.TestColumn("t_null_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, null, Slices.utf8Slice((String)"")), (Object)new AbstractTestHiveFileFormats.TestColumn("t_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, "test", Slices.utf8Slice((String)"test")))).withRowsCount(2).withFileWriterFactory((HiveFileWriterFactory)new CsvFileWriterFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource((HivePageSourceFactory)new CsvPageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testJson(int rowCount, long fileSizePadding) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(column -> !column.getName().equals("t_binary")).filter(column -> !column.getName().equals("t_map_tinyint")).filter(column -> !column.getName().equals("t_map_smallint")).filter(column -> !column.getName().equals("t_map_int")).filter(column -> !column.getName().equals("t_map_bigint")).filter(column -> !column.getName().equals("t_map_float")).filter(column -> !column.getName().equals("t_map_double")).filter(TestHiveFileFormats::withoutNullMapKeyTests).filter(column -> !column.getName().equals("t_decimal_precision_38")).filter(column -> !column.getName().equals("t_map_decimal_precision_38")).filter(column -> !column.getName().equals("t_array_decimal_precision_38")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.JSON).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withFileWriterFactory((HiveFileWriterFactory)new JsonFileWriterFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource((HivePageSourceFactory)new JsonPageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testOpenXJson(int rowCount, long fileSizePadding) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.OPENX_JSON).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withSkipGenericWriterTest().withFileWriterFactory((HiveFileWriterFactory)new OpenXJsonFileWriterFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource((HivePageSourceFactory)new OpenXJsonPageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testRcTextPageSource(int rowCount, long fileSizePadding) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns(TEST_COLUMNS).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRcTextOptimizedWriter(int rowCount) throws Exception {
        List testColumns = (List)TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(ImmutableList.toImmutableList());
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns(testColumns).withRowsCount(rowCount).withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRcBinaryPageSource(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_empty_varchar")).filter(TestHiveFileFormats::withoutTimestamps).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRcBinaryOptimizedWriter(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_empty_varchar")).filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        List<AbstractTestHiveFileFormats.TestColumn> testColumnsNoTimestamps = testColumns.stream().filter(TestHiveFileFormats::withoutTimestamps).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).withSkipGenericWriterTest().withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(FILE_SYSTEM_FACTORY, new HiveConfig())).withColumns(testColumnsNoTimestamps);
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testOrc(int rowCount, long fileSizePadding) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns(TEST_COLUMNS).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testOrcOptimizedWriter(int rowCount, long fileSizePadding) throws Exception {
        HiveSessionProperties hiveSessionProperties = new HiveSessionProperties(new HiveConfig(), new OrcReaderConfig(), new OrcWriterConfig().setValidationPercentage(100.0), new ParquetReaderConfig(), new ParquetWriterConfig());
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(hiveSessionProperties.getSessionProperties()).build();
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).withFileSizePadding(fileSizePadding).withFileWriterFactory((HiveFileWriterFactory)new OrcFileWriterFactory(InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), STATS, new OrcWriterOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY)).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="rowCount")
    public void testOrcUseColumnNames(int rowCount) throws Exception {
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setUseColumnNames(true));
        List testColumns = (List)TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutTimestamps).collect(ImmutableList.toImmutableList());
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns(testColumns).withRowsCount(rowCount).withReadColumns(Lists.reverse((List)testColumns)).withSession((ConnectorSession)session).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="rowCount")
    public void testOrcUseColumnNameLowerCaseConversion(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumnsUpperCase = TEST_COLUMNS.stream().map(testColumn -> new AbstractTestHiveFileFormats.TestColumn(testColumn.getName().toUpperCase(Locale.ENGLISH), testColumn.getObjectInspector(), testColumn.getWriteValue(), testColumn.getExpectedValue(), testColumn.isPartitionKey())).collect(Collectors.toList());
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setUseColumnNames(true));
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns(testColumnsUpperCase).withRowsCount(rowCount).withReadColumns(TEST_COLUMNS).withSession((ConnectorSession)session).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testAvro(int rowCount, long fileSizePadding) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.AVRO).withColumns(TestHiveFileFormats.getTestColumnsSupportedByAvro()).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withFileWriterFactory((HiveFileWriterFactory)new AvroFileWriterFactory(FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test_version"))).isReadableByPageSource((HivePageSourceFactory)new AvroPageSourceFactory(FILE_SYSTEM_FACTORY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="rowCount")
    public void testAvroFileInSymlinkTable(int rowCount) throws Exception {
        File file = File.createTempFile("trino_test", HiveStorageFormat.AVRO.name());
        file.delete();
        try {
            FileSplit split = TestHiveFileFormats.createTestFileHive(file.getAbsolutePath(), HiveStorageFormat.AVRO, HiveCompressionCodec.NONE, TestHiveFileFormats.getTestColumnsSupportedByAvro(), rowCount);
            Properties splitProperties = new Properties();
            splitProperties.setProperty("file.inputformat", SymlinkTextInputFormat.class.getName());
            splitProperties.setProperty("serialization.lib", HiveStorageFormat.AVRO.getSerde());
            this.testPageSourceFactory((HivePageSourceFactory)new AvroPageSourceFactory(FILE_SYSTEM_FACTORY), split, HiveStorageFormat.AVRO, TestHiveFileFormats.getTestColumnsSupportedByAvro(), HiveTestUtils.SESSION, file.length(), rowCount);
        }
        finally {
            file.delete();
        }
    }

    private static List<AbstractTestHiveFileFormats.TestColumn> getTestColumnsSupportedByAvro() {
        return TEST_COLUMNS.stream().filter(column -> !column.getName().startsWith("t_map_") || column.getName().equals("t_map_string")).filter(column -> !column.getName().endsWith("_smallint")).filter(column -> !column.getName().endsWith("_tinyint")).collect(Collectors.toList());
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testParquetPageSource(int rowCount, long fileSizePadding) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withSession(PARQUET_SESSION).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByPageSource(PARQUET_PAGE_SOURCE_FACTORY);
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testParquetPageSourceGzip(int rowCount, long fileSizePadding) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withSession(PARQUET_SESSION).withCompressionCodec(HiveCompressionCodec.GZIP).withFileSizePadding(fileSizePadding).withRowsCount(rowCount).isReadableByPageSource(PARQUET_PAGE_SOURCE_FACTORY);
    }

    @Test(dataProvider="rowCount")
    public void testParquetWriter(int rowCount) throws Exception {
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new ParquetWriterConfig().setValidationPercentage(100.0));
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withSession((ConnectorSession)session).withColumns(testColumns).withRowsCount(rowCount).withFileWriterFactory((HiveFileWriterFactory)new ParquetFileWriterFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new NodeVersion("test-version"), InternalTypeManager.TESTING_TYPE_MANAGER, new HiveConfig(), STATS)).isReadableByPageSource(PARQUET_PAGE_SOURCE_FACTORY);
    }

    @Test(dataProvider="rowCount")
    public void testParquetPageSourceSchemaEvolution(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> writeColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        List readColumns = writeColumns.stream().map(column -> new AbstractTestHiveFileFormats.TestColumn(column.getName() + "_new", column.getObjectInspector(), column.getWriteValue(), column.getExpectedValue(), column.isPartitionKey())).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns(readColumns).withSession(PARQUET_SESSION).withRowsCount(rowCount).isReadableByPageSource(PARQUET_PAGE_SOURCE_FACTORY);
        readColumns = Lists.reverse(writeColumns);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns(readColumns).withSession(PARQUET_SESSION_USE_NAME).isReadableByPageSource(PARQUET_PAGE_SOURCE_FACTORY);
    }

    private static List<AbstractTestHiveFileFormats.TestColumn> getTestColumnsSupportedByParquet() {
        return TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutTimestamps).filter(TestHiveFileFormats::withoutNullMapKeyTests).filter(column -> !column.getName().equals("t_null_array_int")).filter(column -> !column.getName().equals("t_array_empty")).filter(column -> column.isPartitionKey() || !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.DATE) && !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.SHORT) && !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.BYTE)).collect(Collectors.toList());
    }

    @Test
    public void testTruncateVarcharColumn() throws Exception {
        AbstractTestHiveFileFormats.TestColumn writeColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(4)), new HiveVarchar("test", 4), Slices.utf8Slice((String)"test"));
        AbstractTestHiveFileFormats.TestColumn readColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), new HiveVarchar("tes", 3), Slices.utf8Slice((String)"tes"));
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(FILE_SYSTEM_FACTORY, new HiveConfig()));
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(FILE_SYSTEM_FACTORY, new HiveConfig()));
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, STATS, DateTimeZone.UTC));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withSession(PARQUET_SESSION).isReadableByPageSource(PARQUET_PAGE_SOURCE_FACTORY);
        this.assertThatFileFormat(HiveStorageFormat.AVRO).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withFileWriterFactory((HiveFileWriterFactory)new AvroFileWriterFactory(FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test_version"))).isReadableByPageSource((HivePageSourceFactory)new AvroPageSourceFactory(FILE_SYSTEM_FACTORY));
        this.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withFileWriterFactory((HiveFileWriterFactory)new SimpleSequenceFileWriterFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"))).isReadableByPageSource((HivePageSourceFactory)new SimpleSequenceFilePageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig()));
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withFileWriterFactory((HiveFileWriterFactory)new SimpleTextFileWriterFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource((HivePageSourceFactory)new SimpleTextFilePageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testAvroProjectedColumns(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TestHiveFileFormats.getTestColumnsSupportedByAvro();
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.AVRO).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withFileWriterFactory((HiveFileWriterFactory)new AvroFileWriterFactory(FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test_version"))).isReadableByPageSource((HivePageSourceFactory)new AvroPageSourceFactory(FILE_SYSTEM_FACTORY));
    }

    @Test(dataProvider="rowCount")
    public void testParquetProjectedColumns(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withSession(PARQUET_SESSION).isReadableByPageSource(PARQUET_PAGE_SOURCE_FACTORY);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withSession(PARQUET_SESSION_USE_NAME).isReadableByPageSource(PARQUET_PAGE_SOURCE_FACTORY);
    }

    @Test(dataProvider="rowCount")
    public void testORCProjectedColumns(int rowCount) throws Exception {
        List supportedColumns = TEST_COLUMNS;
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setUseColumnNames(true));
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, STATS, DateTimeZone.UTC));
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="rowCount")
    public void testSequenceFileProjectedColumns(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(column -> !column.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withFileWriterFactory((HiveFileWriterFactory)new SimpleSequenceFileWriterFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"))).isReadableByPageSource((HivePageSourceFactory)new SimpleSequenceFilePageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testTextFileProjectedColumns(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withFileWriterFactory((HiveFileWriterFactory)new SimpleTextFileWriterFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource((HivePageSourceFactory)new SimpleTextFilePageSourceFactory((TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRCTextProjectedColumnsPageSource(int rowCount) throws Exception {
        List supportedColumns = TEST_COLUMNS;
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRCBinaryProjectedColumns(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(testColumn -> {
            String name = testColumn.getName();
            return !name.equals("t_map_null_key_complex_key_value") && !name.equals("t_empty_varchar");
        }).collect(Collectors.toList());
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withSkipGenericWriterTest().withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRCBinaryProjectedColumnsPageSource(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_empty_varchar")).collect(Collectors.toList());
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withSkipGenericWriterTest().withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(FILE_SYSTEM_FACTORY, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(FILE_SYSTEM_FACTORY, new HiveConfig()));
    }

    @Test
    public void testFailForLongVarcharPartitionColumn() throws Exception {
        AbstractTestHiveFileFormats.TestColumn partitionColumn = new AbstractTestHiveFileFormats.TestColumn("partition_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), "test", Slices.utf8Slice((String)"tes"), true);
        AbstractTestHiveFileFormats.TestColumn varcharColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), new HiveVarchar("tes", 3), Slices.utf8Slice((String)"tes"));
        ImmutableList columns = ImmutableList.of((Object)partitionColumn, (Object)varcharColumn);
        HiveErrorCode expectedErrorCode = HiveErrorCode.HIVE_INVALID_PARTITION_VALUE;
        String expectedMessage = "Invalid partition value 'test' for varchar(3) partition key: partition_column";
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(FILE_SYSTEM_FACTORY, new HiveConfig()), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(FILE_SYSTEM_FACTORY, new HiveConfig()), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, STATS, DateTimeZone.UTC), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).withSession(PARQUET_SESSION).isFailingForPageSource(PARQUET_PAGE_SOURCE_FACTORY, expectedErrorCode, expectedMessage);
    }

    private void testPageSourceFactory(HivePageSourceFactory sourceFactory, FileSplit split, HiveStorageFormat storageFormat, List<AbstractTestHiveFileFormats.TestColumn> testReadColumns, ConnectorSession session, long fileSize, int rowCount) throws IOException {
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", storageFormat.getInputFormat());
        splitProperties.setProperty("serialization.lib", storageFormat.getSerde());
        ImmutableList.Builder splitPropertiesColumnNames = ImmutableList.builder();
        ImmutableList.Builder splitPropertiesColumnTypes = ImmutableList.builder();
        HashSet<String> baseColumnNames = new HashSet<String>();
        for (AbstractTestHiveFileFormats.TestColumn testReadColumn : testReadColumns) {
            String name = testReadColumn.getBaseName();
            if (baseColumnNames.contains(name) || testReadColumn.isPartitionKey()) continue;
            baseColumnNames.add(name);
            splitPropertiesColumnNames.add((Object)name);
            splitPropertiesColumnTypes.add((Object)testReadColumn.getBaseObjectInspector().getTypeName());
        }
        splitProperties.setProperty("columns", splitPropertiesColumnNames.build().stream().collect(Collectors.joining(",")));
        splitProperties.setProperty("columns.types", splitPropertiesColumnTypes.build().stream().collect(Collectors.joining(",")));
        List partitionKeys = testReadColumns.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).map(input -> new HivePartitionKey(input.getName(), (String)input.getWriteValue())).collect(Collectors.toList());
        String partitionName = String.join((CharSequence)"/", (Iterable)partitionKeys.stream().map(partitionKey -> String.format("%s=%s", partitionKey.getName(), partitionKey.getValue())).collect(ImmutableList.toImmutableList()));
        List<HiveColumnHandle> columnHandles = this.getColumnHandles(testReadColumns);
        List columnMappings = HivePageSourceProvider.ColumnMapping.buildColumnMappings((String)partitionName, partitionKeys, columnHandles, (List)ImmutableList.of(), (TableToPartitionMapping)TableToPartitionMapping.empty(), (String)split.getPath().toString(), (OptionalInt)OptionalInt.empty(), (long)fileSize, (long)Instant.now().toEpochMilli());
        Optional pageSource = HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of((Object)sourceFactory), (ConnectorSession)session, (Location)Location.of((String)split.getPath().toString()), (OptionalInt)OptionalInt.empty(), (long)split.getStart(), (long)split.getLength(), (long)fileSize, (Properties)splitProperties, (TupleDomain)TupleDomain.all(), (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, Optional.empty(), Optional.empty(), Optional.empty(), (boolean)false, (AcidTransaction)AcidTransaction.NO_ACID_TRANSACTION, (List)columnMappings);
        Assert.assertTrue((boolean)pageSource.isPresent());
        this.checkPageSource((ConnectorPageSource)pageSource.get(), testReadColumns, HiveTestUtils.getTypes(columnHandles), rowCount);
    }

    public static boolean hasType(ObjectInspector objectInspector, PrimitiveObjectInspector.PrimitiveCategory ... types) {
        if (objectInspector instanceof PrimitiveObjectInspector) {
            PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)objectInspector;
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveInspector.getPrimitiveCategory();
            for (PrimitiveObjectInspector.PrimitiveCategory type : types) {
                if (primitiveCategory != type) continue;
                return true;
            }
            return false;
        }
        if (objectInspector instanceof ListObjectInspector) {
            ListObjectInspector listInspector = (ListObjectInspector)objectInspector;
            return TestHiveFileFormats.hasType(listInspector.getListElementObjectInspector(), types);
        }
        if (objectInspector instanceof MapObjectInspector) {
            MapObjectInspector mapInspector = (MapObjectInspector)objectInspector;
            return TestHiveFileFormats.hasType(mapInspector.getMapKeyObjectInspector(), types) || TestHiveFileFormats.hasType(mapInspector.getMapValueObjectInspector(), types);
        }
        if (objectInspector instanceof StructObjectInspector) {
            StructObjectInspector structObjectInspector = (StructObjectInspector)objectInspector;
            for (StructField field : structObjectInspector.getAllStructFieldRefs()) {
                if (!TestHiveFileFormats.hasType(field.getFieldObjectInspector(), types)) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Unknown object inspector type " + objectInspector);
    }

    private static boolean withoutNullMapKeyTests(AbstractTestHiveFileFormats.TestColumn testColumn) {
        String name = testColumn.getName();
        return !name.equals("t_map_null_key") && !name.equals("t_map_null_key_complex_key_value") && !name.equals("t_map_null_key_complex_value");
    }

    private static boolean withoutTimestamps(AbstractTestHiveFileFormats.TestColumn testColumn) {
        String name = testColumn.getName();
        return !name.equals("t_timestamp") && !name.equals("t_map_timestamp") && !name.equals("t_array_timestamp");
    }

    private FileFormatAssertion assertThatFileFormat(HiveStorageFormat hiveStorageFormat) {
        return new FileFormatAssertion(hiveStorageFormat.name()).withStorageFormat(hiveStorageFormat);
    }

    private static HiveConfig createParquetHiveConfig(boolean useParquetColumnNames) {
        return new HiveConfig().setUseParquetColumnNames(useParquetColumnNames);
    }

    private void generateProjectedColumns(List<AbstractTestHiveFileFormats.TestColumn> childColumns, ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn> testFullColumnsBuilder, ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn> testDereferencedColumnsBuilder) {
        for (int i = 0; i < childColumns.size(); ++i) {
            AbstractTestHiveFileFormats.TestColumn childColumn = childColumns.get(i);
            Preconditions.checkState((childColumn.getDereferenceIndices().size() == 0 ? 1 : 0) != 0);
            StandardStructObjectInspector newObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"field0"), (List)ImmutableList.of((Object)childColumn.getObjectInspector()));
            HiveType hiveType = HiveType.valueOf((String)childColumn.getObjectInspector().getTypeName());
            Type trinoType = hiveType.getType(InternalTypeManager.TESTING_TYPE_MANAGER);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(childColumn.getWriteValue());
            AbstractTestHiveFileFormats.TestColumn newProjectedColumn = new AbstractTestHiveFileFormats.TestColumn("new_col" + i, (ObjectInspector)newObjectInspector, (List<String>)ImmutableList.of((Object)"field0"), (List<Integer>)ImmutableList.of((Object)0), childColumn.getObjectInspector(), childColumn.getWriteValue(), childColumn.getExpectedValue(), false);
            AbstractTestHiveFileFormats.TestColumn newFullColumn = new AbstractTestHiveFileFormats.TestColumn("new_col" + i, (ObjectInspector)newObjectInspector, list, StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)trinoType), (Object[])new Object[]{childColumn.getExpectedValue()}));
            testFullColumnsBuilder.add((Object)newFullColumn);
            testDereferencedColumnsBuilder.add((Object)newProjectedColumn);
        }
    }

    private List<AbstractTestHiveFileFormats.TestColumn> getRegularColumns(List<AbstractTestHiveFileFormats.TestColumn> columns) {
        return (List)columns.stream().filter(column -> !column.isPartitionKey()).collect(ImmutableList.toImmutableList());
    }

    private List<AbstractTestHiveFileFormats.TestColumn> getPartitionColumns(List<AbstractTestHiveFileFormats.TestColumn> columns) {
        return (List)columns.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).collect(ImmutableList.toImmutableList());
    }

    private class FileFormatAssertion {
        private final String formatName;
        private HiveStorageFormat storageFormat;
        private HiveCompressionCodec compressionCodec = HiveCompressionCodec.NONE;
        private List<AbstractTestHiveFileFormats.TestColumn> writeColumns;
        private List<AbstractTestHiveFileFormats.TestColumn> readColumns;
        private ConnectorSession session = HiveTestUtils.SESSION;
        private int rowsCount = 1000;
        private boolean skipGenericWrite;
        private HiveFileWriterFactory fileWriterFactory;
        private long fileSizePadding;

        private FileFormatAssertion(String formatName) {
            this.formatName = Objects.requireNonNull(formatName, "formatName is null");
        }

        public FileFormatAssertion withStorageFormat(HiveStorageFormat storageFormat) {
            this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
            return this;
        }

        public FileFormatAssertion withCompressionCodec(HiveCompressionCodec compressionCodec) {
            this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
            return this;
        }

        public FileFormatAssertion withSkipGenericWriterTest() {
            this.skipGenericWrite = true;
            return this;
        }

        public FileFormatAssertion withFileWriterFactory(HiveFileWriterFactory fileWriterFactory) {
            this.fileWriterFactory = Objects.requireNonNull(fileWriterFactory, "fileWriterFactory is null");
            return this;
        }

        public FileFormatAssertion withColumns(List<AbstractTestHiveFileFormats.TestColumn> inputColumns) {
            this.withWriteColumns(inputColumns);
            this.withReadColumns(inputColumns);
            return this;
        }

        public FileFormatAssertion withWriteColumns(List<AbstractTestHiveFileFormats.TestColumn> writeColumns) {
            this.writeColumns = Objects.requireNonNull(writeColumns, "writeColumns is null");
            return this;
        }

        public FileFormatAssertion withReadColumns(List<AbstractTestHiveFileFormats.TestColumn> readColumns) {
            this.readColumns = Objects.requireNonNull(readColumns, "readColumns is null");
            return this;
        }

        public FileFormatAssertion withRowsCount(int rowsCount) {
            this.rowsCount = rowsCount;
            return this;
        }

        public FileFormatAssertion withSession(ConnectorSession session) {
            this.session = Objects.requireNonNull(session, "session is null");
            return this;
        }

        public FileFormatAssertion withFileSizePadding(long fileSizePadding) {
            this.fileSizePadding = fileSizePadding;
            return this;
        }

        public FileFormatAssertion isReadableByPageSource(HivePageSourceFactory pageSourceFactory) throws Exception {
            this.assertRead(Optional.of(pageSourceFactory));
            return this;
        }

        public FileFormatAssertion isFailingForPageSource(HivePageSourceFactory pageSourceFactory, HiveErrorCode expectedErrorCode, String expectedMessage) throws Exception {
            this.assertFailure(Optional.of(pageSourceFactory), expectedErrorCode, expectedMessage);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void assertRead(Optional<HivePageSourceFactory> pageSourceFactory) throws Exception {
            Assert.assertNotNull((Object)this.storageFormat, (String)"storageFormat must be specified");
            Assert.assertNotNull(this.writeColumns, (String)"writeColumns must be specified");
            Assert.assertNotNull(this.readColumns, (String)"readColumns must be specified");
            Assert.assertNotNull((Object)this.session, (String)"session must be specified");
            Assert.assertTrue((this.rowsCount >= 0 ? 1 : 0) != 0, (String)"rowsCount must be non-negative");
            String compressionSuffix = this.compressionCodec.getHiveCompressionKind().map(CompressionKind::getFileExtension).orElse("");
            File file = File.createTempFile("trino_test", this.formatName + compressionSuffix);
            file.delete();
            UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
            while (unmodifiableIterator.hasNext()) {
                boolean testFileWriter = (Boolean)unmodifiableIterator.next();
                try {
                    FileSplit split;
                    if (testFileWriter) {
                        if (this.fileWriterFactory == null) continue;
                        split = AbstractTestHiveFileFormats.createTestFileTrino(file.getAbsolutePath(), this.storageFormat, this.compressionCodec, this.writeColumns, this.session, this.rowsCount, this.fileWriterFactory);
                    } else {
                        if (this.skipGenericWrite) continue;
                        split = AbstractTestHiveFileFormats.createTestFileHive(file.getAbsolutePath(), this.storageFormat, this.compressionCodec, this.writeColumns, this.rowsCount);
                    }
                    long fileSize = split.getLength() + this.fileSizePadding;
                    if (!pageSourceFactory.isPresent()) continue;
                    TestHiveFileFormats.this.testPageSourceFactory(pageSourceFactory.get(), split, this.storageFormat, this.readColumns, this.session, fileSize, this.rowsCount);
                }
                finally {
                    file.delete();
                }
            }
        }

        private void assertFailure(Optional<HivePageSourceFactory> pageSourceFactory, HiveErrorCode expectedErrorCode, String expectedMessage) {
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertRead(pageSourceFactory)).hasErrorCode(new ErrorCodeSupplier[]{expectedErrorCode}).hasMessage(expectedMessage);
        }
    }
}

