/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.SchemaAlreadyExistsException;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.util.Map;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestHiveCreateSchemaInternalRetry
extends AbstractTestQueryFramework {
    private static final String TEST_SCHEMA_TIMEOUT = "test_hive_schema_" + TestingNames.randomNameSuffix();
    private static final String TEST_SCHEMA_DIFFERENT_SESSION = "test_hive_schema_" + TestingNames.randomNameSuffix();
    private HiveMetastore metastore;

    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setCreateTpchSchemas(false).setMetastore(distributedQueryRunner -> {
            this.metastore = this.createMetastore(distributedQueryRunner.getCoordinator().getBaseDataDir().resolve("hive_data").toString());
            return this.metastore;
        }))).build();
    }

    private FileHiveMetastore createMetastore(String dataDirectory) {
        return new FileHiveMetastore(new NodeVersion("testversion"), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new HiveMetastoreConfig().isHideDeltaLakeTables(), new FileHiveMetastoreConfig().setCatalogDirectory(dataDirectory).setMetastoreUser("test")){

            public synchronized void createDatabase(Database database) {
                if (database.getDatabaseName().equals(TEST_SCHEMA_DIFFERENT_SESSION)) {
                    database = Database.builder((Database)database).setParameters((Map)ImmutableMap.of((Object)"presto_query_id", (Object)"new_query_id")).build();
                }
                super.createDatabase(database);
                throw new SchemaAlreadyExistsException(database.getDatabaseName());
            }
        };
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws IOException {
        if (this.metastore != null) {
            this.metastore.dropDatabase(TEST_SCHEMA_TIMEOUT, false);
            this.metastore.dropDatabase(TEST_SCHEMA_DIFFERENT_SESSION, false);
        }
    }

    @Test
    public void testSchemaCreationWithTimeout() {
        this.assertQuerySucceeds("CREATE SCHEMA " + TEST_SCHEMA_TIMEOUT);
        this.assertQuery("SHOW SCHEMAS LIKE '" + TEST_SCHEMA_TIMEOUT + "'", "VALUES ('" + TEST_SCHEMA_TIMEOUT + "')");
    }

    @Test
    public void testSchemaCreationFailsWhenCreatedWithDifferentSession() {
        this.assertQueryFails("CREATE SCHEMA " + TEST_SCHEMA_DIFFERENT_SESSION, "Schema already exists: '" + TEST_SCHEMA_DIFFERENT_SESSION + "'");
        this.assertQuery("SHOW SCHEMAS LIKE '" + TEST_SCHEMA_DIFFERENT_SESSION + "'", "VALUES ('" + TEST_SCHEMA_DIFFERENT_SESSION + "')");
    }
}

