/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.amazonaws.services.s3.AmazonS3;
import com.google.common.base.Verify;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CanIgnoreReturnValue;

public class S3Assert {
    private final AmazonS3 s3;
    private final String path;
    private final String bucket;
    private final String key;

    public S3Assert(AmazonS3 s3, String path) {
        this(s3, path, S3Assert.regexpExtract(path, "s3://([^/]+)/(.+)", 1), S3Assert.regexpExtract(path, "s3://([^/]+)/(.+)", 2));
    }

    public S3Assert(AmazonS3 s3, String path, String bucket, String key) {
        this.s3 = Objects.requireNonNull(s3, "s3 is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.bucket = Objects.requireNonNull(bucket, "bucket is null");
        this.key = Objects.requireNonNull(key, "key is null");
    }

    public static AssertProvider<S3Assert> s3Path(AmazonS3 s3, String path) {
        return () -> new S3Assert(s3, path);
    }

    private static String regexpExtract(String input, String regex, int group) {
        Matcher matcher = Pattern.compile(regex).matcher(input);
        Verify.verify((boolean)matcher.matches(), (String)"Does not match [%s]: [%s]", (Object)matcher.pattern(), (Object)input);
        return matcher.group(group);
    }

    @CanIgnoreReturnValue
    public S3Assert exists() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.s3.doesObjectExist(this.bucket, this.key)).as("Existence of %s", new Object[]{this.path})).isTrue();
        return this;
    }
}

