/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.AbstractTestHive;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.stream.IntStream;

public class HiveFileSystemTestUtils {
    private HiveFileSystemTestUtils() {
    }

    /*
     * Loose catch block
     */
    public static MaterializedResult readTable(SchemaTableName tableName, HiveTransactionManager transactionManager, HiveConfig config, ConnectorPageSourceProvider pageSourceProvider, ConnectorSplitManager splitManager) throws IOException {
        MaterializedResult materializedResult;
        AbstractTestHive.Transaction transaction;
        ConnectorSplitSource splitSource;
        ConnectorSession session;
        ConnectorMetadata metadata;
        block15: {
            metadata = null;
            session = null;
            splitSource = null;
            transaction = HiveFileSystemTestUtils.newTransaction(transactionManager);
            metadata = transaction.getMetadata();
            session = HiveFileSystemTestUtils.newSession(config);
            ConnectorTableHandle table = HiveFileSystemTestUtils.getTableHandle(metadata, tableName, session);
            ImmutableList columnHandles = ImmutableList.copyOf(metadata.getColumnHandles(session, table).values());
            metadata.beginQuery(session);
            splitSource = AbstractTestHive.getSplits(splitManager, transaction, session, table);
            List<Type> allTypes = HiveTestUtils.getTypes((List<? extends ColumnHandle>)columnHandles);
            List<Type> dataTypes = HiveTestUtils.getTypes((List)columnHandles.stream().filter(columnHandle -> !((HiveColumnHandle)columnHandle).isHidden()).collect(ImmutableList.toImmutableList()));
            MaterializedResult.Builder result = MaterializedResult.resultBuilder((ConnectorSession)session, dataTypes);
            List<ConnectorSplit> splits = AbstractTestHive.getAllSplits(splitSource);
            for (ConnectorSplit split : splits) {
                ConnectorPageSource pageSource = pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, table, (List)columnHandles, DynamicFilter.EMPTY);
                try {
                    MaterializedResult pageSourceResult = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, allTypes);
                    for (MaterializedRow row : pageSourceResult.getMaterializedRows()) {
                        Object[] dataValues = IntStream.range(0, row.getFieldCount()).filter(arg_0 -> HiveFileSystemTestUtils.lambda$readTable$1((List)columnHandles, arg_0)).mapToObj(arg_0 -> ((MaterializedRow)row).getField(arg_0)).toArray();
                        result.row(dataValues);
                    }
                }
                finally {
                    if (pageSource == null) continue;
                    pageSource.close();
                }
            }
            materializedResult = result.build();
            if (transaction == null) break block15;
            transaction.close();
        }
        HiveFileSystemTestUtils.cleanUpQuery(metadata, session);
        HiveFileSystemTestUtils.closeQuietly((Closeable)splitSource);
        return materializedResult;
        {
            catch (Throwable throwable) {
                try {
                    if (transaction != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    HiveFileSystemTestUtils.cleanUpQuery(metadata, session);
                    HiveFileSystemTestUtils.closeQuietly(splitSource);
                    throw throwable3;
                }
            }
        }
    }

    public static ConnectorTableHandle getTableHandle(ConnectorMetadata metadata, SchemaTableName tableName, ConnectorSession session) {
        ConnectorTableHandle handle = metadata.getTableHandle(session, tableName);
        Preconditions.checkArgument((handle != null ? 1 : 0) != 0, (String)"table not found: %s", (Object)tableName);
        return handle;
    }

    public static ConnectorSession newSession(HiveConfig config) {
        return HiveTestUtils.getHiveSession(config);
    }

    public static AbstractTestHive.Transaction newTransaction(HiveTransactionManager transactionManager) {
        return new AbstractTestHive.HiveTransaction(transactionManager);
    }

    /*
     * Loose catch block
     */
    public static MaterializedResult filterTable(SchemaTableName tableName, List<ColumnHandle> projectedColumns, HiveTransactionManager transactionManager, HiveConfig config, ConnectorPageSourceProvider pageSourceProvider, ConnectorSplitManager splitManager) throws IOException {
        MaterializedResult materializedResult;
        AbstractTestHive.Transaction transaction;
        ConnectorSplitSource splitSource;
        ConnectorSession session;
        ConnectorMetadata metadata;
        block15: {
            metadata = null;
            session = null;
            splitSource = null;
            transaction = HiveFileSystemTestUtils.newTransaction(transactionManager);
            metadata = transaction.getMetadata();
            session = HiveFileSystemTestUtils.newSession(config);
            ConnectorTableHandle table = HiveFileSystemTestUtils.getTableHandle(metadata, tableName, session);
            metadata.beginQuery(session);
            splitSource = AbstractTestHive.getSplits(splitManager, transaction, session, table);
            List<Type> allTypes = HiveTestUtils.getTypes(projectedColumns);
            List<Type> dataTypes = HiveTestUtils.getTypes((List)projectedColumns.stream().filter(columnHandle -> !((HiveColumnHandle)columnHandle).isHidden()).collect(ImmutableList.toImmutableList()));
            MaterializedResult.Builder result = MaterializedResult.resultBuilder((ConnectorSession)session, dataTypes);
            List<ConnectorSplit> splits = AbstractTestHive.getAllSplits(splitSource);
            for (ConnectorSplit split : splits) {
                ConnectorPageSource pageSource = pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, table, projectedColumns, DynamicFilter.EMPTY);
                try {
                    MaterializedResult pageSourceResult = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, allTypes);
                    for (MaterializedRow row : pageSourceResult.getMaterializedRows()) {
                        Object[] dataValues = IntStream.range(0, row.getFieldCount()).filter(channel -> !((HiveColumnHandle)projectedColumns.get(channel)).isHidden()).mapToObj(arg_0 -> ((MaterializedRow)row).getField(arg_0)).toArray();
                        result.row(dataValues);
                    }
                }
                finally {
                    if (pageSource == null) continue;
                    pageSource.close();
                }
            }
            materializedResult = result.build();
            if (transaction == null) break block15;
            transaction.close();
        }
        HiveFileSystemTestUtils.cleanUpQuery(metadata, session);
        HiveFileSystemTestUtils.closeQuietly((Closeable)splitSource);
        return materializedResult;
        {
            catch (Throwable throwable) {
                try {
                    if (transaction != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    HiveFileSystemTestUtils.cleanUpQuery(metadata, session);
                    HiveFileSystemTestUtils.closeQuietly(splitSource);
                    throw throwable3;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public static int getSplitsCount(SchemaTableName tableName, HiveTransactionManager transactionManager, HiveConfig config, ConnectorSplitManager splitManager) {
        int n;
        AbstractTestHive.Transaction transaction;
        ConnectorSplitSource splitSource;
        ConnectorSession session;
        ConnectorMetadata metadata;
        block8: {
            metadata = null;
            session = null;
            splitSource = null;
            transaction = HiveFileSystemTestUtils.newTransaction(transactionManager);
            metadata = transaction.getMetadata();
            session = HiveFileSystemTestUtils.newSession(config);
            ConnectorTableHandle table = HiveFileSystemTestUtils.getTableHandle(metadata, tableName, session);
            metadata.beginQuery(session);
            splitSource = AbstractTestHive.getSplits(splitManager, transaction, session, table);
            n = AbstractTestHive.getAllSplits(splitSource).size();
            if (transaction == null) break block8;
            transaction.close();
        }
        HiveFileSystemTestUtils.cleanUpQuery(metadata, session);
        HiveFileSystemTestUtils.closeQuietly((Closeable)splitSource);
        return n;
        {
            catch (Throwable throwable) {
                try {
                    if (transaction != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    HiveFileSystemTestUtils.cleanUpQuery(metadata, session);
                    HiveFileSystemTestUtils.closeQuietly(splitSource);
                    throw throwable3;
                }
            }
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void cleanUpQuery(ConnectorMetadata metadata, ConnectorSession session) {
        if (metadata != null && session != null) {
            metadata.cleanupQuery(session);
        }
    }

    private static /* synthetic */ boolean lambda$readTable$1(List columnHandles, int channel) {
        return !((HiveColumnHandle)columnHandles.get(channel)).isHidden();
    }
}

