/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.benchmark.BenchmarkSuite;
import io.trino.plugin.hive.TestingHiveConnectorFactory;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.security.PrincipalType;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class HiveBenchmarkQueryRunner {
    private HiveBenchmarkQueryRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String outputDirectory = Objects.requireNonNull(System.getProperty("outputDirectory"), "Must specify -DoutputDirectory=...");
        File tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        try (LocalQueryRunner localQueryRunner = HiveBenchmarkQueryRunner.createLocalQueryRunner(tempDir);){
            new BenchmarkSuite(localQueryRunner, outputDirectory).runAllBenchmarks();
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    public static LocalQueryRunner createLocalQueryRunner(File tempDir) {
        Session session = TestingSession.testSessionBuilder().setCatalog("hive").setSchema("tpch").build();
        LocalQueryRunner localQueryRunner = LocalQueryRunner.create((Session)session);
        localQueryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        File hiveDir = new File(tempDir, "hive_data");
        FileHiveMetastore metastore = TestingFileHiveMetastore.createTestingFileHiveMetastore(hiveDir);
        metastore.createDatabase(Database.builder().setDatabaseName("tpch").setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build());
        ImmutableMap hiveCatalogConfig = ImmutableMap.of((Object)"hive.max-split-size", (Object)"10GB");
        localQueryRunner.createCatalog("hive", (ConnectorFactory)new TestingHiveConnectorFactory((HiveMetastore)metastore), (Map)hiveCatalogConfig);
        localQueryRunner.execute("CREATE TABLE orders AS SELECT * FROM tpch.sf1.orders");
        localQueryRunner.execute("CREATE TABLE lineitem AS SELECT * FROM tpch.sf1.lineitem");
        return localQueryRunner;
    }
}

