/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.Session;
import io.trino.operator.RetryPolicy;
import io.trino.testing.ExtendedFailureRecoveryTest;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;

public abstract class BaseHiveFailureRecoveryTest
extends ExtendedFailureRecoveryTest {
    protected BaseHiveFailureRecoveryTest(RetryPolicy retryPolicy) {
        super(retryPolicy);
    }

    protected boolean areWriteRetriesSupported() {
        return true;
    }

    protected void createPartitionedLineitemTable(String tableName, List<String> columns, String partitionColumn) {
        String sql = String.format("CREATE TABLE %s WITH (format = 'TEXTFILE', partitioned_by=array['%s']) AS SELECT %s FROM tpch.tiny.lineitem", tableName, partitionColumn, String.join((CharSequence)",", columns));
        this.getQueryRunner().execute(sql);
    }

    @DataProvider(name="parallelTests", parallel=true)
    public Object[][] parallelTests() {
        return this.moreParallelTests(super.parallelTests(), new Object[][]{this.parallelTest("testCreatePartitionedTable", this::testCreatePartitionedTable), this.parallelTest("testInsertIntoNewPartition", this::testInsertIntoNewPartition), this.parallelTest("testInsertIntoExistingPartition", this::testInsertIntoExistingPartition), this.parallelTest("testInsertIntoNewPartitionBucketed", this::testInsertIntoNewPartitionBucketed), this.parallelTest("testInsertIntoExistingPartitionBucketed", this::testInsertIntoExistingPartitionBucketed), this.parallelTest("testReplaceExistingPartition", this::testReplaceExistingPartition), this.parallelTest("testDeletePartitionWithSubquery", this::testDeletePartitionWithSubquery)});
    }

    protected void testDelete() {
        Assertions.assertThatThrownBy(() -> super.testDelete()).hasMessageContaining("Modifying Hive table rows is only supported for transactional tables");
    }

    protected void testDeleteWithSubquery() {
        Assertions.assertThatThrownBy(() -> super.testDelete()).hasMessageContaining("Modifying Hive table rows is only supported for transactional tables");
    }

    protected void testUpdate() {
        Assertions.assertThatThrownBy(() -> super.testUpdate()).hasMessageContaining("Modifying Hive table rows is only supported for transactional tables");
    }

    protected void testUpdateWithSubquery() {
        Assertions.assertThatThrownBy(() -> super.testUpdateWithSubquery()).hasMessageContaining("Modifying Hive table rows is only supported for transactional tables");
    }

    protected void testMerge() {
        Assertions.assertThatThrownBy(() -> super.testMerge()).hasMessageContaining("Modifying Hive table rows is only supported for transactional tables");
    }

    protected void testRefreshMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testRefreshMaterializedView()).hasMessageContaining("This connector does not support creating materialized views");
    }

    protected void testCreatePartitionedTable() {
        this.testTableModification(Optional.empty(), "CREATE TABLE <table> WITH (partitioned_by = ARRAY['p']) AS SELECT *, 'partition1' p FROM orders", Optional.of("DROP TABLE <table>"));
    }

    protected void testInsertIntoNewPartition() {
        this.testTableModification(Optional.of("CREATE TABLE <table> WITH (partitioned_by = ARRAY['p']) AS SELECT *, 'partition1' p FROM orders"), "INSERT INTO <table> SELECT *, 'partition2' p FROM orders", Optional.of("DROP TABLE <table>"));
    }

    protected void testInsertIntoExistingPartition() {
        this.testTableModification(Optional.of("CREATE TABLE <table> WITH (partitioned_by = ARRAY['p']) AS SELECT *, 'partition1' p FROM orders"), "INSERT INTO <table> SELECT *, 'partition1' p FROM orders", Optional.of("DROP TABLE <table>"));
    }

    protected void testInsertIntoNewPartitionBucketed() {
        this.testTableModification(Optional.of("CREATE TABLE <table> WITH (partitioned_by = ARRAY['p'], bucketed_by = ARRAY['orderkey'], bucket_count = 4) AS SELECT *, 'partition1' p FROM orders"), "INSERT INTO <table> SELECT *, 'partition2' p FROM orders", Optional.of("DROP TABLE <table>"));
    }

    protected void testInsertIntoExistingPartitionBucketed() {
        this.testTableModification(Optional.of("CREATE TABLE <table> WITH (partitioned_by = ARRAY['p'], bucketed_by = ARRAY['orderkey'], bucket_count = 4) AS SELECT *, 'partition1' p FROM orders"), "INSERT INTO <table> SELECT *, 'partition1' p FROM orders", Optional.of("DROP TABLE <table>"));
    }

    protected void testReplaceExistingPartition() {
        this.testTableModification(Optional.of(Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "insert_existing_partitions_behavior", "OVERWRITE").build()), Optional.of("CREATE TABLE <table> WITH (partitioned_by = ARRAY['p']) AS SELECT *, 'partition1' p FROM orders"), "INSERT INTO <table> SELECT *, 'partition1' p FROM orders", Optional.of("DROP TABLE <table>"));
    }

    protected void testDeletePartitionWithSubquery() {
        Assertions.assertThatThrownBy(() -> this.testTableModification(Optional.of("CREATE TABLE <table> WITH (partitioned_by = ARRAY['p']) AS SELECT *, 0 p FROM orders"), "DELETE FROM <table> WHERE p = (SELECT min(nationkey) FROM nation)", Optional.of("DROP TABLE <table>"))).hasMessageContaining("Modifying Hive table rows is only supported for transactional tables");
    }
}

