/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpResponseException;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.httpjson.HttpJsonStatusRuntimeException;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.CancellationException;

class HttpJsonApiExceptionFactory {
    private final Set<StatusCode.Code> retryableCodes;

    HttpJsonApiExceptionFactory(Set<StatusCode.Code> retryableCodes) {
        this.retryableCodes = ImmutableSet.copyOf(retryableCodes);
    }

    ApiException create(Throwable throwable) {
        if (throwable instanceof HttpResponseException) {
            HttpResponseException e = (HttpResponseException)throwable;
            HttpJsonStatusCode statusCode = HttpJsonStatusCode.of(e.getStatusCode());
            boolean canRetry = this.retryableCodes.contains(statusCode.getCode());
            String message = e.getStatusMessage();
            return this.createApiException(throwable, statusCode, message, canRetry);
        }
        if (throwable instanceof HttpJsonStatusRuntimeException) {
            HttpJsonStatusRuntimeException e = (HttpJsonStatusRuntimeException)throwable;
            HttpJsonStatusCode statusCode = HttpJsonStatusCode.of(e.getStatusCode());
            return this.createApiException(throwable, statusCode, e.getMessage(), this.retryableCodes.contains(statusCode.getCode()));
        }
        if (throwable instanceof CancellationException) {
            return ApiExceptionFactory.createException((Throwable)throwable, (StatusCode)HttpJsonStatusCode.of(StatusCode.Code.CANCELLED), (boolean)false);
        }
        if (throwable instanceof ApiException) {
            return (ApiException)throwable;
        }
        return ApiExceptionFactory.createException((Throwable)throwable, (StatusCode)HttpJsonStatusCode.of(StatusCode.Code.UNKNOWN), (boolean)false);
    }

    private ApiException createApiException(Throwable throwable, StatusCode statusCode, String message, boolean canRetry) {
        return message == null ? ApiExceptionFactory.createException((Throwable)throwable, (StatusCode)statusCode, (boolean)canRetry) : ApiExceptionFactory.createException((String)message, (Throwable)throwable, (StatusCode)statusCode, (boolean)canRetry);
    }
}

