/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkInstrumenterFactory;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkRequestType;
import io.opentelemetry.instrumentation.awssdk.v2_2.FieldMapper;
import io.opentelemetry.instrumentation.awssdk.v2_2.RequestHeaderSetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.SnsAccess;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsAccess;
import io.opentelemetry.semconv.SemanticAttributes;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;

final class TracingExecutionInterceptor
implements ExecutionInterceptor {
    static final ExecutionAttribute<Context> CONTEXT_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".Context");
    static final ExecutionAttribute<Scope> SCOPE_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".Scope");
    static final ExecutionAttribute<AwsSdkRequest> AWS_SDK_REQUEST_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".AwsSdkRequest");
    static final ExecutionAttribute<SdkHttpRequest> SDK_HTTP_REQUEST_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".SdkHttpRequest");
    static final ExecutionAttribute<SdkRequest> SDK_REQUEST_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".SdkRequest");
    private final Instrumenter<ExecutionAttributes, SdkHttpResponse> requestInstrumenter;
    private final Instrumenter<ExecutionAttributes, SdkHttpResponse> consumerInstrumenter;
    private final boolean captureExperimentalSpanAttributes;
    static final AttributeKey<String> HTTP_ERROR_MSG = AttributeKey.stringKey((String)"aws.http.error_message");
    static final String HTTP_FAILURE_EVENT = "HTTP request failure";
    @Nullable
    private final TextMapPropagator messagingPropagator;
    private final boolean useXrayPropagator;
    private final boolean recordIndividualHttpError;
    private final FieldMapper fieldMapper;

    Instrumenter<ExecutionAttributes, SdkHttpResponse> getConsumerInstrumenter() {
        return this.consumerInstrumenter;
    }

    @Nullable
    TextMapPropagator getMessagingPropagator() {
        return this.messagingPropagator;
    }

    boolean shouldUseXrayPropagator() {
        return this.useXrayPropagator;
    }

    TracingExecutionInterceptor(Instrumenter<ExecutionAttributes, SdkHttpResponse> requestInstrumenter, Instrumenter<ExecutionAttributes, SdkHttpResponse> consumerInstrumenter, boolean captureExperimentalSpanAttributes, TextMapPropagator messagingPropagator, boolean useXrayPropagator, boolean recordIndividualHttpError) {
        this.requestInstrumenter = requestInstrumenter;
        this.consumerInstrumenter = consumerInstrumenter;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        this.messagingPropagator = messagingPropagator;
        this.useXrayPropagator = useXrayPropagator;
        this.recordIndividualHttpError = recordIndividualHttpError;
        this.fieldMapper = new FieldMapper();
    }

    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        Context parentOtelContext = Context.current();
        SdkRequest request = context.request();
        if (executionAttributes.getAttribute(AwsSignerExecutionAttribute.PRESIGNER_EXPIRATION) != null) {
            return request;
        }
        executionAttributes.putAttribute(SDK_REQUEST_ATTRIBUTE, (Object)request);
        if (!this.requestInstrumenter.shouldStart(parentOtelContext, (Object)executionAttributes)) {
            return request;
        }
        Context otelContext = this.requestInstrumenter.start(parentOtelContext, (Object)executionAttributes);
        executionAttributes.putAttribute(CONTEXT_ATTRIBUTE, (Object)otelContext);
        if (((ClientType)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_TYPE)).equals((Object)ClientType.SYNC)) {
            executionAttributes.putAttribute(SCOPE_ATTRIBUTE, (Object)otelContext.makeCurrent());
        }
        Span span = Span.fromContext((Context)otelContext);
        try {
            AwsSdkRequest awsSdkRequest = AwsSdkRequest.ofSdkRequest(context.request());
            if (awsSdkRequest != null) {
                executionAttributes.putAttribute(AWS_SDK_REQUEST_ATTRIBUTE, (Object)awsSdkRequest);
                this.populateRequestAttributes(span, awsSdkRequest, context.request(), executionAttributes);
            }
        }
        catch (Throwable throwable) {
            this.requestInstrumenter.end(otelContext, (Object)executionAttributes, null, throwable);
            TracingExecutionInterceptor.clearAttributes(executionAttributes);
            throw throwable;
        }
        SdkRequest modifiedRequest = SqsAccess.modifyRequest(request, otelContext, this.useXrayPropagator, this.messagingPropagator);
        if (modifiedRequest != null) {
            return modifiedRequest;
        }
        modifiedRequest = SnsAccess.modifyRequest(request, otelContext, this.messagingPropagator);
        if (modifiedRequest != null) {
            return modifiedRequest;
        }
        return request;
    }

    public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes executionAttributes) {
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext == null) {
            return;
        }
        SdkHttpRequest httpRequest = context.httpRequest();
        executionAttributes.putAttribute(SDK_HTTP_REQUEST_ATTRIBUTE, (Object)httpRequest);
        TracingExecutionInterceptor.onHttpRequestAvailable(executionAttributes, otelContext, Span.fromContext((Context)otelContext));
    }

    private static void onHttpResponseAvailable(ExecutionAttributes executionAttributes, Context otelContext, Span span, SdkHttpResponse httpResponse) {
        AttributesBuilder builder = Attributes.builder();
        AwsSdkInstrumenterFactory.httpAttributesExtractor.onEnd(builder, otelContext, (Object)executionAttributes, (Object)httpResponse, null);
        span.setAllAttributes(builder.build());
    }

    private static void onHttpRequestAvailable(ExecutionAttributes executionAttributes, Context parentContext, Span span) {
        AttributesBuilder builder = Attributes.builder();
        AwsSdkInstrumenterFactory.httpAttributesExtractor.onStart(builder, parentContext, (Object)executionAttributes);
        span.setAllAttributes(builder.build());
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest httpRequest = context.httpRequest();
        if (!this.useXrayPropagator) {
            return httpRequest;
        }
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext == null) {
            return httpRequest;
        }
        SdkHttpRequest.Builder builder = (SdkHttpRequest.Builder)httpRequest.toBuilder();
        AwsXrayPropagator.getInstance().inject(otelContext, (Object)builder, (TextMapSetter)RequestHeaderSetter.INSTANCE);
        return (SdkHttpRequest)builder.build();
    }

    public Optional<InputStream> modifyHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        String errorMsg;
        Optional responseBody = context.responseBody();
        if (this.recordIndividualHttpError && (errorMsg = TracingExecutionInterceptor.extractHttpErrorAsEvent((Context.AfterTransmission)context, executionAttributes)) != null) {
            return Optional.of(new ByteArrayInputStream(errorMsg.getBytes(Charset.defaultCharset())));
        }
        return responseBody;
    }

    private void populateRequestAttributes(Span span, AwsSdkRequest awsSdkRequest, SdkRequest sdkRequest, ExecutionAttributes attributes) {
        this.fieldMapper.mapToAttributes(sdkRequest, awsSdkRequest, span);
        if (awsSdkRequest.type() == AwsSdkRequestType.DYNAMODB) {
            span.setAttribute(SemanticAttributes.DB_SYSTEM, (Object)"dynamodb");
            String operation = (String)attributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
            if (operation != null) {
                span.setAttribute(SemanticAttributes.DB_OPERATION, (Object)operation);
            }
        }
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        Context otelContext;
        if (executionAttributes.getAttribute(SDK_HTTP_REQUEST_ATTRIBUTE) != null) {
            SqsAccess.afterReceiveMessageExecution(context, executionAttributes, this);
        }
        if ((otelContext = TracingExecutionInterceptor.getContext(executionAttributes)) != null) {
            executionAttributes.putAttribute(SDK_HTTP_REQUEST_ATTRIBUTE, (Object)context.httpRequest());
            Span span = Span.fromContext((Context)otelContext);
            TracingExecutionInterceptor.onUserAgentHeaderAvailable(span, executionAttributes);
            this.onSdkResponse(span, context.response(), executionAttributes);
            SdkHttpResponse httpResponse = context.httpResponse();
            TracingExecutionInterceptor.onHttpResponseAvailable(executionAttributes, otelContext, Span.fromContext((Context)otelContext), httpResponse);
            this.requestInstrumenter.end(otelContext, (Object)executionAttributes, (Object)httpResponse, null);
        }
        TracingExecutionInterceptor.clearAttributes(executionAttributes);
    }

    private static void onUserAgentHeaderAvailable(Span span, ExecutionAttributes request) {
        List<String> userAgent = AwsSdkInstrumenterFactory.httpAttributesGetter.getHttpRequestHeader(request, "User-Agent");
        if (!userAgent.isEmpty()) {
            span.setAttribute(SemanticAttributes.USER_AGENT_ORIGINAL, (Object)userAgent.get(0));
        }
    }

    private void onSdkResponse(Span span, SdkResponse response, ExecutionAttributes executionAttributes) {
        if (this.captureExperimentalSpanAttributes) {
            AwsSdkRequest sdkRequest;
            if (response instanceof AwsResponse) {
                span.setAttribute("aws.requestId", ((AwsResponse)response).responseMetadata().requestId());
            }
            if ((sdkRequest = (AwsSdkRequest)((Object)executionAttributes.getAttribute(AWS_SDK_REQUEST_ATTRIBUTE))) != null) {
                this.fieldMapper.mapToAttributes(response, sdkRequest, span);
            }
        }
    }

    private static String extractHttpErrorAsEvent(Context.AfterTransmission context, ExecutionAttributes executionAttributes) {
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext != null) {
            Span span = Span.fromContext((Context)otelContext);
            SdkHttpResponse response = context.httpResponse();
            if (response != null && !response.isSuccessful()) {
                int errorCode = response.statusCode();
                Optional responseBody = context.responseBody();
                if (responseBody.isPresent()) {
                    String errorMsg = new BufferedReader(new InputStreamReader((InputStream)responseBody.get(), Charset.defaultCharset())).lines().collect(Collectors.joining("\n"));
                    Attributes attributes = Attributes.of((AttributeKey)SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, (Object)errorCode, HTTP_ERROR_MSG, (Object)errorMsg);
                    span.addEvent(HTTP_FAILURE_EVENT, attributes);
                    return errorMsg;
                }
            }
        }
        return null;
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext != null) {
            this.requestInstrumenter.end(otelContext, (Object)executionAttributes, null, context.exception());
        }
        TracingExecutionInterceptor.clearAttributes(executionAttributes);
    }

    private static void clearAttributes(ExecutionAttributes executionAttributes) {
        Scope scope = (Scope)executionAttributes.getAttribute(SCOPE_ATTRIBUTE);
        if (scope != null) {
            scope.close();
        }
        executionAttributes.putAttribute(CONTEXT_ATTRIBUTE, null);
        executionAttributes.putAttribute(AWS_SDK_REQUEST_ATTRIBUTE, null);
        executionAttributes.putAttribute(SDK_HTTP_REQUEST_ATTRIBUTE, null);
    }

    static Context getContext(ExecutionAttributes attributes) {
        return (Context)attributes.getAttribute(CONTEXT_ATTRIBUTE);
    }
}

